/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd;

import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class PluginInstallEvent
implements InitializingBean,
DisposableBean {
    private static final Log LOGGER = LogFactory.getLog(PluginInstallEvent.class);
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public PluginInstallEvent(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.debug("Plugin installed");
        if (StringUtils.isBlank((CharSequence)this.pluginSettings.getLicenseVerifiedWithoutDefaultValue())) {
            this.generateTrial();
        }
    }

    public void destroy() throws Exception {
    }

    private void generateTrial() {
        try {
            LOGGER.debug("Generating freemium trial");
            Date expiry = DateUtils.addMonths((Date)new Date(), (int)1);
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS");
            this.pluginSettings.setCustomerAPIKey("NA");
            this.pluginSettings.setCustomerEmail("-");
            this.pluginSettings.setCustomerId("NA");
            this.pluginSettings.setCustomerTokenKey("NYFz3WIfBEn3DUHx");
            this.pluginSettings.setLicenseVerified(Boolean.TRUE);
            this.pluginSettings.setLicenseType("TRIAL");
            this.pluginSettings.setLicencedUsers(10);
            this.pluginSettings.setLicenseExpireDate(dateFormatter.format(expiry));
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while creating freemium license", e);
        }
    }
}

