/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorValidateWebAuthnHardwareToken
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorValidateWebAuthnHardwareToken.class);
    private static final String VM_PATH = "/templates/com/miniorange/twofactor/crowd/validate_webauthnhardwareToken.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorValidateWebAuthnHardwareToken(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorValidateWebAuthnHardwareToken doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        List<String> enabled2faMethods = this.settings.get2FAMethodForUserList();
        List<String> enabledBackupMethods = this.settings.getBackupMethodForUserList();
        if (!enabled2faMethods.contains("YubikeyHardwareTokenAsU2F") && !enabledBackupMethods.contains("YubikeyHardwareTokenAsU2F")) {
            String redirectToAnotherMethodUrl = this.pluginHandler.findValidUrlToRedirect(username, request);
            LOGGER.debug("Redirecting to another enabled and configured method = " + redirectToAnotherMethodUrl);
            response.sendRedirect(redirectToAnotherMethodUrl);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)username) && this.pluginHandler.isPageAllowed("YubikeyHardwareTokenAsU2F", username).booleanValue() && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "Validate_U2FHardwareToken").booleanValue()) {
            LOGGER.debug("Valid User");
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            List<String> configuredMethodList = twoFactorUserClass.getConfigured2FAMethodsByUser();
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("errorMessage", new ArrayList());
            context.put("successMessage", "");
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextPath", this.pluginConfiguration.getBaseUrl());
            context.put("baseUrl", this.pluginConfiguration.getBaseUrl());
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            Boolean enableRememberMeDevice = BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice()) && !BooleanUtils.toBoolean((Boolean)this.isInternetExplorer(request));
            context.put("enableRememberMeDevice", enableRememberMeDevice);
            Boolean allowUserSpecificRememberMeDeviceDuration = BooleanUtils.toBoolean((Boolean)this.settings.getAllowUserSpecificRememberMeDeviceDuration()) && !BooleanUtils.toBoolean((Boolean)this.isInternetExplorer(request));
            context.put("allowUserSpecificRememberMeDeviceDuration", allowUserSpecificRememberMeDeviceDuration);
            int userSpecificRememberMeDeviceDuration = twoFactorUserClass.getUserSpecificRememberMeDeviceDuration();
            if (userSpecificRememberMeDeviceDuration == NumberUtils.INTEGER_ZERO) {
                context.put("userSpecificRememberMeDeviceDuration", this.settings.getRememberMeDeviceDuration());
            } else {
                context.put("userSpecificRememberMeDeviceDuration", userSpecificRememberMeDeviceDuration);
            }
            configuredMethodList.removeAll(Collections.singleton("YubikeyHardwareTokenAsU2F"));
            int enabledAndConfiguredPrimaryAndBackupMethods = 0;
            for (String configuredMethod : configuredMethodList) {
                if ((!this.pluginHandler.isPageAllowed(configuredMethod, username).booleanValue() || !enabled2faMethods.contains(configuredMethod)) && !enabledBackupMethods.contains(configuredMethod)) continue;
                ++enabledAndConfiguredPrimaryAndBackupMethods;
            }
            Boolean shouldShowLinkToListMethod = Boolean.FALSE;
            if (enabledAndConfiguredPrimaryAndBackupMethods >= 1) {
                shouldShowLinkToListMethod = Boolean.TRUE;
                context.put("validate2faMethodListUrl", this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist"));
            }
            context.put("shouldShowLinkToValidateListMethod", shouldShowLinkToListMethod);
            String template = this.pluginSettings.getValidateWebAuthnHardwareTokenTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorValidateWebAuthnHardwareToken doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && this.pluginHandler.isPageAllowed("YubikeyHardwareTokenAsU2F", username).booleanValue()) {
            LOGGER.debug("User is valid user");
            ArrayList<String> errorMessage = new ArrayList<String>();
            String deviceValidated = request.getParameter("deviceValidated");
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            HttpSession session = request.getSession();
            if (StringUtils.equalsIgnoreCase((CharSequence)((String)session.getAttribute("validate_WebAuthn_successfully")), (CharSequence)"TRUE")) {
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Login Successful", "Yubikey Hardware Token");
                Boolean rememberMeOnThisDevice = Boolean.parseBoolean(request.getParameter("rememberMeOnThisDevice"));
                if (BooleanUtils.toBoolean((Boolean)rememberMeOnThisDevice)) {
                    String deviceDetails = MoTwoFactorUtility.getDeviceDetails(request);
                    LOGGER.debug("Current Device Details : " + deviceDetails);
                    List<String> rememberMeDeviceDetails = twoFactorUserClass.getRememberMeDeviceDetails();
                    if (StringUtils.isNotBlank((CharSequence)deviceDetails)) {
                        LOGGER.debug("Device details is not a blank");
                        LOGGER.debug("Stored Device Details : " + rememberMeDeviceDetails);
                        int rememberDeviceDuration = this.settings.getRememberMeDeviceDuration();
                        Calendar calendar = Calendar.getInstance();
                        if (this.settings.getAllowUserSpecificRememberMeDeviceDuration().booleanValue()) {
                            LOGGER.debug("Inside AllowUserSpecificRememberMeDeviceDuration");
                            String userSpecificRememberMeDeviceDurationString = request.getParameter("userSpecificRememberMeDeviceDuration");
                            LOGGER.debug("userSpecificRememberMeDeviceDurationString" + userSpecificRememberMeDeviceDurationString);
                            if (StringUtils.isNotBlank((CharSequence)userSpecificRememberMeDeviceDurationString)) {
                                try {
                                    int userSpecificRememberMeDeviceDuration = Integer.parseInt(userSpecificRememberMeDeviceDurationString);
                                    calendar.add(5, userSpecificRememberMeDeviceDuration);
                                    twoFactorUserClass.setUserSpecificRememberMeDeviceDuration(userSpecificRememberMeDeviceDuration);
                                }
                                catch (NumberFormatException e) {
                                    calendar.add(5, rememberDeviceDuration);
                                }
                            } else {
                                calendar.add(5, rememberDeviceDuration);
                            }
                        } else {
                            calendar.add(5, rememberDeviceDuration);
                        }
                        Date date = calendar.getTime();
                        long newTimeInMili = date.getTime();
                        Boolean containsDeviceInList = Boolean.FALSE;
                        for (int i = 0; i < rememberMeDeviceDetails.size(); ++i) {
                            String device = rememberMeDeviceDetails.get(i);
                            if (!StringUtils.containsIgnoreCase((CharSequence)device, (CharSequence)deviceDetails)) continue;
                            LOGGER.debug("Changing device details time : " + newTimeInMili);
                            containsDeviceInList = Boolean.TRUE;
                            rememberMeDeviceDetails.add(i, deviceDetails.concat("=====" + newTimeInMili));
                            break;
                        }
                        if (!BooleanUtils.toBoolean((Boolean)containsDeviceInList)) {
                            if (deviceDetails.split("\\|\\|").length > 2) {
                                LOGGER.debug("Adding device details with time : " + newTimeInMili);
                                rememberMeDeviceDetails.add(deviceDetails.concat("=====" + newTimeInMili));
                            } else {
                                LOGGER.debug("Invalid Device Details : " + deviceDetails);
                            }
                        }
                        twoFactorUserClass.setRememberMeDeviceDetails(rememberMeDeviceDetails);
                        LOGGER.debug("After change Device Details : " + rememberMeDeviceDetails);
                        this.settings.setUserSettings(username, twoFactorUserClass);
                    }
                }
                session.setAttribute("2fa_verification", (Object)true);
                session.removeAttribute("executing_2fa_flow");
                session.removeAttribute("validate_U2F_successfully");
                session.removeAttribute("validate_WebAuthn_successfully");
                this.settings.addTo2FAConfiguredUsersList(username);
                this.pluginHandler.redirectToValidUrl(request, response);
                return;
            }
            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Login Failed", "Yubikey Hardware Token");
            if (!BooleanUtils.toBoolean((Boolean)this.pluginHandler.checkBruteForceInvalidAttemptAction(request)) && BooleanUtils.toBoolean((Boolean)this.pluginHandler.shouldLockedOutUser(username))) {
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Temporarily Locked", "Yubikey Hardware Token");
                LOGGER.debug("User has exceeded number of invalid attempts");
                this.pluginHandler.performBruteForceUserLockAction(username, request);
                this.pluginHandler.performUserLogout(request, response, username);
                return;
            }
            errorMessage.add("Invalid Hardware Token Key. Please add valid one.");
            LOGGER.debug("Invalid Hardware Token Key. Please add valid one.");
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("errorMessage", errorMessage);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextPath", this.pluginConfiguration.getBaseUrl());
            context.put("baseUrl", this.pluginConfiguration.getBaseUrl());
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            Boolean enableRememberMeDevice = BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice()) && !BooleanUtils.toBoolean((Boolean)this.isInternetExplorer(request));
            context.put("enableRememberMeDevice", enableRememberMeDevice);
            Boolean allowUserSpecificRememberMeDeviceDuration = BooleanUtils.toBoolean((Boolean)this.settings.getAllowUserSpecificRememberMeDeviceDuration()) && !BooleanUtils.toBoolean((Boolean)this.isInternetExplorer(request));
            context.put("allowUserSpecificRememberMeDeviceDuration", allowUserSpecificRememberMeDeviceDuration);
            int userSpecificRememberMeDeviceDuration = twoFactorUserClass.getUserSpecificRememberMeDeviceDuration();
            if (userSpecificRememberMeDeviceDuration == NumberUtils.INTEGER_ZERO) {
                context.put("userSpecificRememberMeDeviceDuration", this.settings.getRememberMeDeviceDuration());
            } else {
                context.put("userSpecificRememberMeDeviceDuration", userSpecificRememberMeDeviceDuration);
            }
            List<String> configuredMethodList = twoFactorUserClass.getConfigured2FAMethodsByUser();
            configuredMethodList.removeAll(Collections.singleton("YubikeyHardwareTokenAsU2F"));
            int enabledAndConfiguredPrimaryAndBackupMethods = 0;
            List<String> enabled2faMethods = this.settings.get2FAMethodForUserList();
            List<String> enabledBackupMethods = this.settings.getBackupMethodForUserList();
            for (String configuredMethod : configuredMethodList) {
                if ((!this.pluginHandler.isPageAllowed(configuredMethod, username).booleanValue() || !enabled2faMethods.contains(configuredMethod)) && !enabledBackupMethods.contains(configuredMethod)) continue;
                ++enabledAndConfiguredPrimaryAndBackupMethods;
            }
            Boolean shouldShowLinkToListMethod = Boolean.FALSE;
            if (enabledAndConfiguredPrimaryAndBackupMethods >= 1) {
                shouldShowLinkToListMethod = Boolean.TRUE;
                context.put("validate2faMethodListUrl", this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist"));
            }
            context.put("shouldShowLinkToValidateListMethod", shouldShowLinkToListMethod);
            String template = this.pluginSettings.getValidateWebAuthnHardwareTokenTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    private boolean successfullyPerformedU2FValidation(HttpServletRequest request) {
        HttpSession session = request.getSession();
        return session.getAttribute("validate_U2F_successfully") != null && BooleanUtils.toBoolean((Boolean)((Boolean)session.getAttribute("validate_U2F_successfully")));
    }

    private Boolean isInternetExplorer(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        if (StringUtils.indexOfIgnoreCase((CharSequence)userAgent, (CharSequence)"MSIE") > 0 || StringUtils.indexOfIgnoreCase((CharSequence)userAgent, (CharSequence)"Trident/") > 0) {
            LOGGER.debug("Browser is IE");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }
}

