/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.service.MoAdminsAuditService;
import com.miniorange.twofactor.crowd.common.service.MoLogEntityService;
import com.miniorange.twofactor.crowd.scheduler.AuditLogScheduler;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorResetSettings
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorResetSettings.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private UserManager userManager;
    private MoLogEntityService logEntityService;
    private MoAdminsAuditService moAdminsAuditService;
    private AuditLogScheduler scheduler;

    public MoTwoFactorResetSettings(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, UserManager userManager, AuditLogScheduler scheduler, MoLogEntityService logEntityService, MoAdminsAuditService moAdminsAuditService) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.userManager = userManager;
        this.logEntityService = logEntityService;
        this.scheduler = scheduler;
        this.moAdminsAuditService = moAdminsAuditService;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.info("Reset plugin settings servlet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        Boolean isAdmin = Boolean.FALSE;
        LOGGER.debug("MoResetSettingsServlet logged in Crowd user= " + username);
        if (StringUtils.isNotBlank((CharSequence)username)) {
            UserProfile user = this.userManager.getRemoteUser();
            isAdmin = Boolean.FALSE;
            if (user != null && this.userManager.isAdmin(user.getUserKey())) {
                isAdmin = Boolean.TRUE;
            }
        }
        if (BooleanUtils.toBoolean((Boolean)isAdmin)) {
            List<String> allAvailableCrowdUserNameList = this.pluginHandler.getUserFromCrowdUsingUsername("", "AllUsers", "", -1);
            if (this.settings.getAutoDeleteAuditLogs()) {
                this.scheduler.unschedule();
            }
            this.settings.clearPluginSettings(allAvailableCrowdUserNameList);
            this.logEntityService.delete(0);
            this.moAdminsAuditService.deleteLogs();
            StringBuffer htmlStart = new StringBuffer();
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.pluginConfiguration.getConfigureActionUrl());
            response.setContentType("text/html;charset=utf-8");
            htmlStart.append("<html><head><script src=\"https://code.jquery.com/jquery-3.2.1.min.js\"></script><script>$(document).ready(function() {window.location.href=\"" + buffer.toString() + "\";});</script></head><body><br><br><div class=\"aui-message aui-message-info\" style=\"background-color: #DEEBFF;\"><span>Please wait!!We are resetting plugin settings.</span></body></html>");
            PrintWriter writer = response.getWriter();
            writer.write(htmlStart.toString());
            writer.close();
        }
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

