/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorResetCurrentUserSettings
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorResetCurrentUserSettings.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private UserManager userManager;

    public MoTwoFactorResetCurrentUserSettings(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, UserManager userManager) {
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.info("Reset plugin settings servlet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        Boolean isAdmin = Boolean.FALSE;
        LOGGER.debug("MoTwoFactorResetCurrentUserSettings logged in Crowd user : " + username);
        if (StringUtils.isNotBlank((CharSequence)username)) {
            UserProfile user = this.userManager.getRemoteUser();
            isAdmin = Boolean.FALSE;
            if (user != null && this.userManager.isAdmin(user.getUserKey())) {
                isAdmin = Boolean.TRUE;
            }
        }
        if (BooleanUtils.toBoolean((Boolean)isAdmin)) {
            String status;
            List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
            if (configuredUser.contains(username)) {
                configuredUser.removeAll(Collections.singleton(username));
                status = "SUCCESS";
            } else {
                status = "ERROR";
            }
            this.settings.setListOf2FAConfiguredUsers(configuredUser);
            if (StringUtils.equalsIgnoreCase((CharSequence)"SUCCESS", (CharSequence)status)) {
                this.settings.setUserSettings(username, new MoTwoFactorCommonUserSettings());
            }
        }
        resp.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

