/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDirectoryMapping;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.common.service.MoAdminsAuditService;
import com.miniorange.twofactor.crowd.common.service.MoLogEntityService;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorAjaxCallsEditServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoTwoFactorAjaxCallsEditServlet.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private CrowdService crowdService;
    private Boolean responseSent;
    MoLogEntityService service;
    MoAdminsAuditService moAdminsAuditService;
    private ApplicationManager applicationManager;

    public MoTwoFactorAjaxCallsEditServlet(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings, CrowdService crowdService, MoLogEntityService service, MoAdminsAuditService moAdminsAuditService, ApplicationManager applicationManager) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
        this.crowdService = crowdService;
        this.service = service;
        this.moAdminsAuditService = moAdminsAuditService;
        this.applicationManager = applicationManager;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("Calling Ajax with edit access");
        String action = MoTwoFactorUtility.sanitizeText(request.getParameter("action"));
        LOGGER.debug("action to perform :" + action);
        this.responseSent = Boolean.FALSE;
        if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
            LOGGER.error("Invalid license found");
            this.sendErrorResponse("Invalid License Found", response);
            return;
        }
        if (!this.pluginHandler.isTwoFactorVerifiedOrIsTwoFactorDisabled(request).booleanValue()) {
            LOGGER.error("Either 2FA is not verified by the user or 2FA is disabled for them");
            this.sendErrorResponse("Not enough permission", response);
            return;
        }
        List<String> userAccessiblePages = this.pluginHandler.getUserAccessiblePages();
        if (userAccessiblePages.contains("Basic_Configuration_readwrite") && !this.responseSent.booleanValue()) {
            switch (action) {
                case "Enable2faForAllUsers": {
                    this.enable2FAForAllUser(request, response);
                    break;
                }
                case "Disable2faForAllUsers": {
                    this.disable2FAForAllUser(request, response);
                    break;
                }
                case "Enable2faForSoftware": {
                    this.enable2faForSoftware(request, response);
                    break;
                }
                case "Disable2faForSoftware": {
                    this.disable2faForSoftware(request, response);
                    break;
                }
                case "SavedMethodSettings": {
                    this.SavedMethodSettings(request, response);
                    break;
                }
                case "ConfigureMobileAuthnSettings": {
                    this.ConfigureMobileAuthnSettings(request, response);
                    break;
                }
                case "ConfigureDuoPushSettings": {
                    this.ConfigureDuoPushSettings(request, response);
                    break;
                }
                case "ConfigureWebAuthnSettings": {
                    this.ConfigureWebAuthnSettings(request, response);
                    break;
                }
                case "ConfigureOtpOverEmailSettings": {
                    this.ConfigureOtpOverEmailSettings(request, response);
                    break;
                }
                case "SendTestOtpOverEmail": {
                    this.SendTestOtpOverEmail(request, response);
                }
            }
        }
        if (userAccessiblePages.contains("User_Management_readwrite") && !this.responseSent.booleanValue()) {
            switch (action) {
                case "Disable2faForUser": {
                    this.disable2FAForUser(request, response);
                    break;
                }
                case "Enable2faForUser": {
                    this.enable2FAForUser(request, response);
                    break;
                }
                case "Reset2faForUser": {
                    this.reset2FAForUser(request, response);
                    break;
                }
                case "Enable2faForSelectedUsers": {
                    this.enable2FAForSelectedUsers(request, response);
                    break;
                }
                case "Disable2faForSelectedUsers": {
                    this.disable2faForSelectedUsers(request, response);
                    break;
                }
                case "Enable2faForAllUsers": {
                    this.enable2FAForAllUser(request, response);
                    break;
                }
                case "Disable2faForAllUsers": {
                    this.disable2FAForAllUser(request, response);
                    break;
                }
                case "Reset2faForSelectedUsers": {
                    this.reset2faForSelectedUsers(request, response);
                    break;
                }
                case "Reset2faForAllUsers": {
                    this.reset2FAForAllUser(request, response);
                    break;
                }
                case "Enable2faForGroup": {
                    this.enable2faForGroup(request, response);
                    break;
                }
                case "Disable2faForGroup": {
                    this.disable2faForGroup(request, response);
                    break;
                }
                case "Enable2faForSelectedGroups": {
                    this.enable2FAForSelectedGroups(request, response);
                    break;
                }
                case "Disable2faForSelectedGroups": {
                    this.disable2faForSelectedGroups(request, response);
                    break;
                }
                case "Enable2faForAllGroups": {
                    this.enable2FAForAllGroups(request, response, true);
                    break;
                }
                case "Disable2faForAllGroups": {
                    this.disable2FAForAllGroups(request, response, true);
                    break;
                }
                case "Enable2faForDirectory": {
                    this.enable2faForDirectory(request, response);
                    break;
                }
                case "Disable2FAForDirectory": {
                    this.disable2faForDirectory(request, response);
                    break;
                }
                case "Enable2faForSelectedDirectories": {
                    this.enable2FAForSelectedDirectories(request, response);
                    break;
                }
                case "Disable2faForSelectedDirectories": {
                    this.disable2faForSelectedDirectories(request, response);
                    break;
                }
                case "Enable2faForAllDirectories": {
                    this.enable2FAForAllDirectories(request, response, true);
                    break;
                }
                case "Disable2faForAllDirectories": {
                    try {
                        this.disable2FAForAllDirectories(request, response, true);
                        break;
                    }
                    catch (DirectoryNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "RemoveLockedUser": {
                    this.removeLockedUser(request, response);
                    break;
                }
                case "RemoveSelectedLockedUsers": {
                    this.removeSelectedLockedUsers(request, response);
                    break;
                }
                case "RemoveAllLockedUsers": {
                    this.removeAllLockedUsers(request, response);
                }
            }
        }
        if (userAccessiblePages.contains("IP_Restriction_readwrite") && !this.responseSent.booleanValue()) {
            switch (action) {
                case "RemoveWhitelistIp": {
                    this.removeWhitelistIp(request, response);
                    break;
                }
                case "RemoveBlacklistIp": {
                    this.removeBlacklistIp(request, response);
                    break;
                }
                case "RemoveSelectedWhitelistIps": {
                    this.removeSelectedWhitelistIps(request, response);
                    break;
                }
                case "RemoveSelectedBlacklistIps": {
                    this.removeSelectedBlacklistIps(request, response);
                    break;
                }
                case "RemoveAllWhitelistIps": {
                    this.removeAllWhitelistIps(request, response);
                    break;
                }
                case "RemoveAllBlacklistIps": {
                    this.removeAllBlacklistIps(request, response);
                }
            }
        }
        if (userAccessiblePages.contains("Advanced_Settings_readwrite") && !this.responseSent.booleanValue()) {
            switch (action) {
                case "RemoveSkip2FAUrl": {
                    this.removeSkip2FAUrl(request, response);
                }
            }
        }
        if (!this.responseSent.booleanValue()) {
            LOGGER.error("The Requested method is not allowed or the user do not have enough access");
            response.setContentType("application/json");
            response.sendError(405, "The requested method is not allowed or you do not have enough access.");
        }
        if (userAccessiblePages.contains("Audit_Logs_readwrite") && !this.responseSent.booleanValue()) {
            switch (action) {
                case "ClearAuditLogs": {
                    this.ClearAuditLogs(request, response);
                }
            }
        }
    }

    private void ClearAuditLogs(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String logsType = req.getParameter("logsType");
            if (StringUtils.equals((CharSequence)logsType, (CharSequence)"EndUsersLogs")) {
                this.service.delete(0);
                this.pluginHandler.storeAdminsAuditLogs("-", "Cleared Authentication logs", "", req);
            } else if (StringUtils.equals((CharSequence)logsType, (CharSequence)"AdminsLogs")) {
                this.moAdminsAuditService.deleteLogs();
                this.pluginHandler.storeAdminsAuditLogs("-", "Cleared Configuration logs", "", req);
            }
            this.sendSuccessFullResponse("Success", resp);
        }
        catch (Exception e) {
            LOGGER.error("Error while Clearing Audit Logs :", e);
            this.sendErrorResponse("Error", resp);
        }
    }

    private void removeSkip2FAUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.info("Calling removeSkip2FAUrl");
        try {
            String url = MoTwoFactorUtility.sanitizeText(request.getParameter("url"));
            LOGGER.debug("Removing URL : " + url);
            List<String> skip2FAUrlList = this.settings.getSkip2FAForGivenUrlList();
            LOGGER.debug("Before Remove : " + skip2FAUrlList);
            skip2FAUrlList.remove(url);
            LOGGER.debug("After Remove : " + skip2FAUrlList);
            this.settings.setSkip2FAForGivenUrlList(skip2FAUrlList);
            this.pluginHandler.storeAdminsAuditLogs("Skip 2FA for API", "Updated Advanced Options Tab", "Removed :  " + url, request);
            String skip2FAUrlString = this.settings.getSkip2faUrls();
            LOGGER.debug("skip2FAUrlString before removing specific url : " + skip2FAUrlString);
            String[] urls2 = skip2FAUrlString.split(";");
            Object[] updated_urls = new String[urls2.length];
            int counter = 0;
            for (int index = 0; index < urls2.length; ++index) {
                if (urls2[index].equals(url)) continue;
                updated_urls[counter] = urls2[index];
                ++counter;
            }
            skip2FAUrlString = StringUtils.join((Object[])updated_urls, (String)";");
            LOGGER.debug("skip2FAUrlString after removing specific url : " + skip2FAUrlString);
            this.settings.setSkip2faUrls(skip2FAUrlString);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing URL : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeAllBlacklistIps(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeAllBlacklistIps");
        try {
            this.settings.setBlacklistIpAddressWithMessages(new HashMap<String, String>());
            LOGGER.debug("Successfully Removed All IPs from Blacklist");
            this.pluginHandler.storeAdminsAuditLogs("IP Blacklist", "Updated IP restrictions Tab", "Removed All IPs from Blacklist", request);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Blacklist IP : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeAllWhitelistIps(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeAllWhitelistIps");
        try {
            this.settings.setWhitelistIpAddressWithMessages(new HashMap<String, String>());
            LOGGER.debug("Successfully Removed All IPs from Whitelist");
            this.pluginHandler.storeAdminsAuditLogs("IP Whitelist", "Updated IP restrictions Tab", "Removed All IPs from Whitelist", request);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Whitelist IP : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeSelectedBlacklistIps(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeSelectedBlacklistIps");
        try {
            String[] selectedBlacklistIps = request.getParameterValues("selectedBlacklistIps");
            Map<String, String> blacklistIpAddressMessageMap = this.settings.getBlacklistIpAddressWithMessages();
            for (String ipAddress : selectedBlacklistIps) {
                blacklistIpAddressMessageMap.entrySet().removeIf(entry -> ipAddress.equals(entry.getKey()));
                StringBuilder builder = new StringBuilder();
                builder.append("Removed IP for Blacklisting");
                builder.append("////");
                builder.append("Ip Address:" + ipAddress);
                this.pluginHandler.storeAdminsAuditLogs("IP Blacklist", "Updated IP restrictions Tab", builder.toString(), request);
            }
            this.settings.setBlacklistIpAddressWithMessages(blacklistIpAddressMessageMap);
            LOGGER.debug("Successfully Removed Selected IPs from Blacklist");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Blacklist IP : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeSelectedWhitelistIps(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeSelectedWhitelistIps");
        try {
            String[] selectedWhitelistIps = request.getParameterValues("selectedWhitelistIps");
            Map<String, String> whitelistIpAddressMessageMap = this.settings.getWhitelistIpAddressWithMessages();
            for (String ipAddress : selectedWhitelistIps) {
                whitelistIpAddressMessageMap.entrySet().removeIf(entry -> ipAddress.equals(entry.getKey()));
                StringBuilder builder = new StringBuilder();
                builder.append("Removed IP for Whitelisting");
                builder.append("////");
                builder.append("Ip Address:" + ipAddress);
                this.pluginHandler.storeAdminsAuditLogs("IP Whitelist", "Updated IP restrictions Tab", builder.toString(), request);
            }
            this.settings.setWhitelistIpAddressWithMessages(whitelistIpAddressMessageMap);
            LOGGER.debug("Successfully Removed Selected IPs from Whitelist");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Whitelist IP : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeBlacklistIp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeBlacklistIp");
        try {
            String ipAddress = MoTwoFactorUtility.sanitizeText(request.getParameter("ipAddress"));
            Map<String, String> blacklistIpAddressMessageMap = this.settings.getBlacklistIpAddressWithMessages();
            LOGGER.debug("Before Remove : " + blacklistIpAddressMessageMap);
            blacklistIpAddressMessageMap.remove(ipAddress);
            LOGGER.debug("After Remove : " + blacklistIpAddressMessageMap);
            this.settings.setBlacklistIpAddressWithMessages(blacklistIpAddressMessageMap);
            StringBuilder builder = new StringBuilder();
            builder.append("Removed IP from Blacklisting");
            builder.append("////");
            builder.append("Ip Address:" + ipAddress);
            this.pluginHandler.storeAdminsAuditLogs("IP Blacklist", "Updated IP restrictions Tab", builder.toString(), request);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Blacklist IP : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeWhitelistIp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeWhitelistIp");
        try {
            String ipAddress = MoTwoFactorUtility.sanitizeText(request.getParameter("ipAddress"));
            LOGGER.debug("Removing IP : " + ipAddress);
            Map<String, String> whitelistIpAddressMessageMap = this.settings.getWhitelistIpAddressWithMessages();
            LOGGER.debug("Before Remove : " + whitelistIpAddressMessageMap);
            whitelistIpAddressMessageMap.remove(ipAddress);
            StringBuilder builder = new StringBuilder();
            builder.append("Removed IP from Whitelisting");
            builder.append("////");
            builder.append("Ip Address:" + ipAddress);
            this.pluginHandler.storeAdminsAuditLogs("IP Whitelist", "Updated IP restrictions Tab", builder.toString(), request);
            LOGGER.debug("After Remove : " + whitelistIpAddressMessageMap);
            this.settings.setWhitelistIpAddressWithMessages(whitelistIpAddressMessageMap);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Whitelist IP : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeAllLockedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeAllLockedUsers");
        try {
            this.settings.setLockedUserDetails(new HashMap<String, String>());
            LOGGER.debug("Successfully Removed All Users from Locked List");
            this.pluginHandler.storeAdminsAuditLogs("All users", "Unlocked Users", "", request);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Locked User : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeSelectedLockedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeSelectedLockedUsers");
        try {
            String[] selectedLockedUserList = request.getParameterValues("selectedLockedUserList");
            Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
            for (String selectedUser : selectedLockedUserList) {
                LOGGER.debug("Removing Locked User : " + selectedUser);
                if (!lockedUserDetails.containsKey(selectedUser)) continue;
                lockedUserDetails.remove(selectedUser);
                this.pluginHandler.storeAdminsAuditLogs(selectedUser, "Unlocked User", "", request);
            }
            this.settings.setLockedUserDetails(lockedUserDetails);
            LOGGER.debug("Successfully Removed Selected User from Locked List");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Locked User : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeLockedUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeLockedUser");
        try {
            String username = MoTwoFactorUtility.sanitizeText(request.getParameter("username").trim());
            LOGGER.debug("Removing Locked User : " + username);
            Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
            if (lockedUserDetails.containsKey(username)) {
                lockedUserDetails.remove(username);
                this.settings.setLockedUserDetails(lockedUserDetails);
            }
            this.pluginHandler.storeAdminsAuditLogs(username, "Unlocked User", "", request);
            LOGGER.debug("Successfully Removed User from Locked List: " + username);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Locked User : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2FAForAllUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2FAForAllUser");
        try {
            EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
            LOGGER.debug("Query for User : " + query);
            Iterable usersFromSystem = this.crowdService.search((Query)query);
            List<String> enabled2FAUserList = this.settings.getEnable2FAForUsersList();
            for (User user : usersFromSystem) {
                if (enabled2FAUserList.contains(user.getName())) continue;
                LOGGER.debug("Enabling 2FA for :-" + user.getName());
                this.performEnable2FAForUser(user.getName());
            }
            this.settings.setEnable2FAForAllUsers(Boolean.TRUE);
            this.pluginHandler.storeAdminsAuditLogs("All users", "2FA Enabled for user", "", request);
            LOGGER.debug("Successfully Enabled 2FA for All Users");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Enabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2FAForAllUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2FAForAllUser");
        try {
            List<String> enabled2FAUserList = this.settings.getEnable2FAForUsersList();
            LOGGER.debug("Total 2FA Enabled User Count : " + enabled2FAUserList.size());
            for (int i = enabled2FAUserList.size() - 1; i >= 0; --i) {
                String username = enabled2FAUserList.get(i);
                this.performDisable2FAForUser(username);
            }
            this.settings.setEnable2FAForAllUsers(Boolean.FALSE);
            LOGGER.debug("Successfully Disabled 2FA for All Users");
            this.pluginHandler.storeAdminsAuditLogs("All users", "2FA Disabled", "", request);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Disabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2FAForAllGroups(HttpServletRequest request, HttpServletResponse response, Boolean sendResponseBack) throws IOException {
        LOGGER.debug("Calling disable2FAForAllGroups");
        try {
            List<String> enable2FAGroupList = this.settings.getEnable2FAForGroupsList();
            LOGGER.debug("Total 2FA enabled Groups : " + enable2FAGroupList.size());
            for (int i = enable2FAGroupList.size() - 1; i >= 0; --i) {
                String groupname = enable2FAGroupList.get(i);
                LOGGER.debug("Disabling 2FA for Group :" + groupname);
                this.performDisable2FAForGroup(groupname, true);
            }
            this.settings.setEnable2FAForGroupsList(new ArrayList<String>());
            LOGGER.debug("Successfully Disable 2FA for All Groups");
            this.pluginHandler.storeAdminsAuditLogs("All groups", "2FA Disabled", "", request);
            if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                this.sendSuccessFullResponse("Success", response);
            }
        }
        catch (Exception e) {
            LOGGER.error("Issue with disabling 2FA : " + e);
            if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                this.sendErrorResponse("Error", response);
            }
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void enable2FAForAllGroups(HttpServletRequest request, HttpServletResponse response, Boolean sendResponseBack) throws IOException {
        LOGGER.debug("Calling enable2FAForAllGroups");
        try {
            EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
            List<String> enable2FAGroupList = this.settings.getEnable2FAForGroupsList();
            LOGGER.debug("Query for Group : " + query);
            Iterable groupsFromSystem = this.crowdService.search((Query)query);
            for (Group group : groupsFromSystem) {
                if (enable2FAGroupList.contains(group.getName())) continue;
                enable2FAGroupList.add(group.getName());
                this.performEnable2FAForGroup(group.getName());
            }
            this.settings.setEnable2FAForGroupsList(enable2FAGroupList);
            this.pluginHandler.storeAdminsAuditLogs("All groups", "2FA Enabled for group", "", request);
            LOGGER.debug("Successfully Enabled 2FA for All Groups");
            if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                this.sendSuccessFullResponse("Success", response);
            }
        }
        catch (Exception e) {
            LOGGER.error("Issue with enabling 2FA : " + e);
            if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                this.sendErrorResponse("Error", response);
            }
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void disable2faForSelectedGroups(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2faForSelectedGroups");
        try {
            String[] selectedGroup;
            List<String> enable2FAGroupList = this.settings.getEnable2FAForGroupsList();
            for (String groupname : selectedGroup = request.getParameterValues("selectedGroups")) {
                if (!enable2FAGroupList.contains(groupname)) continue;
                enable2FAGroupList.removeAll(Collections.singleton(groupname));
                this.pluginHandler.storeAdminsAuditLogs(groupname, "2FA Disabled for group", "", request);
                this.settings.setEnable2FAForGroupsList(enable2FAGroupList);
                this.performDisable2FAForGroup(groupname, false);
            }
            this.settings.setEnable2FAForGroupsList(enable2FAGroupList);
            LOGGER.debug("Successfully Disabled 2FA for Selected Groups");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Disabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2FAForSelectedGroups(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2FAForSelectedGroups");
        try {
            String[] selectedGroup;
            List<String> enable2FAGroupList = this.settings.getEnable2FAForGroupsList();
            for (String groupname : selectedGroup = request.getParameterValues("selectedGroups")) {
                if (enable2FAGroupList.contains(groupname)) continue;
                this.performEnable2FAForGroup(groupname);
                enable2FAGroupList.add(groupname);
                this.pluginHandler.storeAdminsAuditLogs(groupname, "2FA Enabled for group", "", request);
            }
            this.settings.setEnable2FAForGroupsList(enable2FAGroupList);
            LOGGER.error("Successfully Enabled 2FA for Selected Groups");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Enabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2faForGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2faForGroup");
        try {
            String groupname = MoTwoFactorUtility.sanitizeText(request.getParameter("groupname").trim());
            LOGGER.debug("Enabling 2FA for Group : " + groupname);
            List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
            if (!enable2FAForGroupsList.contains(groupname)) {
                enable2FAForGroupsList.add(groupname);
                this.performEnable2FAForGroup(groupname);
                this.settings.setEnable2FAForGroupsList(enable2FAForGroupsList);
                this.pluginHandler.storeAdminsAuditLogs(groupname, "2FA Enabled for group", "", request);
            }
            LOGGER.debug("Successfully Enabled 2FA for Group : " + groupname);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with enabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2faForGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2faForGroup");
        try {
            String groupname = MoTwoFactorUtility.sanitizeText(request.getParameter("groupname").trim());
            LOGGER.debug("Disabling 2FA for Group : " + groupname);
            List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
            if (enable2FAForGroupsList.contains(groupname)) {
                enable2FAForGroupsList.removeAll(Collections.singleton(groupname));
                this.settings.setEnable2FAForGroupsList(enable2FAForGroupsList);
                this.pluginHandler.storeAdminsAuditLogs(groupname, "2FA Disabled for group", "", request);
                this.performDisable2FAForGroup(groupname, false);
            }
            LOGGER.debug("Successfully Disable 2FA for Group : " + groupname);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with disabling 2fa : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2FAForAllDirectories(HttpServletRequest request, HttpServletResponse response, Boolean sendResponseBack) throws IOException, DirectoryNotFoundException {
        LOGGER.debug("Calling disable2FAForAllDirectories");
        List<String> enable2FADirectoryList = this.settings.getEnable2FAForDirectoriesList();
        for (int i = enable2FADirectoryList.size() - 1; i >= 0; --i) {
            String directoryName = enable2FADirectoryList.get(i);
            this.performDisable2FAForDirectory(directoryName);
        }
        this.settings.setEnable2FAForDirectoriesList(new ArrayList<String>());
        LOGGER.debug("Successfully Disabled 2FA for All Directories");
        this.pluginHandler.storeAdminsAuditLogs("All Directories", "2FA Disabled", "", request);
        if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
            this.sendSuccessFullResponse("Success", response);
        }
    }

    private void enable2FAForAllDirectories(HttpServletRequest request, HttpServletResponse response, Boolean sendResponseBack) throws IOException {
        LOGGER.debug("Calling enable2FAForAllDirectories");
        try {
            ArrayList<Directory> directoriesFromCrowd = new ArrayList<Directory>();
            Application crowdApplication = null;
            try {
                crowdApplication = this.applicationManager.findByName("crowd");
            }
            catch (ApplicationNotFoundException e) {
                throw new RuntimeException(e);
            }
            List directoryMappings = crowdApplication.getApplicationDirectoryMappings();
            for (ApplicationDirectoryMapping mapping : directoryMappings) {
                directoriesFromCrowd.add(mapping.getDirectory());
            }
            List<String> enable2FADirectoryList = this.settings.getEnable2FAForDirectoriesList();
            for (Directory directory : directoriesFromCrowd) {
                if (enable2FADirectoryList.contains(directory.getName())) continue;
                enable2FADirectoryList.add(directory.getName());
                this.performEnable2FAForDirectory(directory.getName());
            }
            this.settings.setEnable2FAForDirectoriesList(enable2FADirectoryList);
            LOGGER.debug("Successfully Enabled 2FA for All Directories");
            this.pluginHandler.storeAdminsAuditLogs("All Directories", "2FA Enabled for directory", "", request);
            if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                this.sendSuccessFullResponse("Success", response);
            }
        }
        catch (Exception e) {
            LOGGER.error("Issue with enabling 2FA: " + e);
            if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                this.sendErrorResponse("Error", response);
            }
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void disable2faForSelectedDirectories(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2FAForSelectedDirectories");
        try {
            String[] selectedDirectories;
            List<String> enable2FADirectoryList = this.settings.getEnable2FAForDirectoriesList();
            for (String directoryName : selectedDirectories = request.getParameterValues("selectedDirectories")) {
                if (!enable2FADirectoryList.contains(directoryName)) continue;
                enable2FADirectoryList.removeAll(Collections.singleton(directoryName));
                this.pluginHandler.storeAdminsAuditLogs(directoryName, "2FA Disabled for directory", "", request);
                this.settings.setEnable2FAForDirectoriesList(enable2FADirectoryList);
                this.performDisable2FAForDirectory(directoryName);
            }
            this.settings.setEnable2FAForDirectoriesList(enable2FADirectoryList);
            LOGGER.debug("Successfully Disabled 2FA for Selected Directories");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Disabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2FAForSelectedDirectories(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2FAForSelectedDirectories");
        try {
            String[] selectedDirectories;
            List<String> enable2FADirectoryList = this.settings.getEnable2FAForDirectoriesList();
            for (String directoryName : selectedDirectories = request.getParameterValues("selectedDirectories")) {
                if (enable2FADirectoryList.contains(directoryName)) continue;
                this.performEnable2FAForDirectory(directoryName);
                enable2FADirectoryList.add(directoryName);
                this.pluginHandler.storeAdminsAuditLogs(directoryName, "2FA Enabled for directory", "", request);
            }
            this.settings.setEnable2FAForDirectoriesList(enable2FADirectoryList);
            LOGGER.debug("Successfully Enabled 2FA for Selected Directories");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Enabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2faForDirectory(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2faForDirectory");
        try {
            String directoryName = MoTwoFactorUtility.sanitizeText(request.getParameter("directoryname").trim());
            List<String> enable2FAForDirectoriesList = this.settings.getEnable2FAForDirectoriesList();
            if (!enable2FAForDirectoriesList.contains(directoryName)) {
                enable2FAForDirectoriesList.add(directoryName);
                this.performEnable2FAForDirectory(directoryName);
                this.settings.setEnable2FAForDirectoriesList(enable2FAForDirectoriesList);
                this.pluginHandler.storeAdminsAuditLogs(directoryName, "2FA Enabled for directory", "", request);
            }
            LOGGER.debug("Successfully Enabled 2FA for Directory: " + directoryName);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with enabling 2FA: " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2faForDirectory(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2faForDirectory");
        try {
            String directoryName = MoTwoFactorUtility.sanitizeText(request.getParameter("directoryname").trim());
            List<String> enable2FAForDirectoriesList = this.settings.getEnable2FAForDirectoriesList();
            if (enable2FAForDirectoriesList.contains(directoryName)) {
                enable2FAForDirectoriesList.removeAll(Collections.singleton(directoryName));
                this.settings.setEnable2FAForDirectoriesList(enable2FAForDirectoriesList);
                this.pluginHandler.storeAdminsAuditLogs(directoryName, "2FA Disabled for directory", "", request);
                this.performDisable2FAForDirectory(directoryName);
            }
            LOGGER.debug("Successfully Disabled 2FA for Directory: " + directoryName);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with disabling 2FA: " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void reset2faForSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling reset2faForSelectedUsers");
        try {
            String[] selectedUser;
            for (String username : selectedUser = request.getParameterValues("selectedUsers")) {
                this.performReset2FAForUser(username);
                this.pluginHandler.storeAdminsAuditLogs(username, "2FA reset for User", "", request);
            }
            LOGGER.debug("Successfully Reset 2FA for Selected Users");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with resetting 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2faForSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2faForSelectedUsers");
        try {
            String[] selectedUser;
            for (String username : selectedUser = request.getParameterValues("selectedUsers")) {
                this.performDisable2FAForUser(username);
                this.pluginHandler.storeAdminsAuditLogs(username, "2FA Disabled for user", "", request);
            }
            LOGGER.debug("Successfully Disabled 2FA for Selected Users");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Disabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2FAForSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2FAForSelectedUsers");
        try {
            String[] selectedUser;
            for (String username : selectedUser = request.getParameterValues("selectedUsers")) {
                this.performEnable2FAForUser(username);
                this.pluginHandler.storeAdminsAuditLogs(username, "2FA Enabled for user", "", request);
            }
            LOGGER.debug("Successfully Enabled 2FA for Selected Users");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Enabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void reset2FAForAllUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling reset2FAForAllUser");
        try {
            List<String> configured2FAUsers = this.settings.getListOf2FAConfiguredUsers();
            LOGGER.debug("Total 2FA Enabled User Count : " + configured2FAUsers.size());
            for (int i = configured2FAUsers.size() - 1; i >= 0; --i) {
                String username = configured2FAUsers.get(i);
                LOGGER.debug("Resetting 2FA for User :" + username);
                this.performReset2FAForUser(username);
            }
            LOGGER.debug("Successfully Reset 2FA for All Users");
            this.pluginHandler.storeAdminsAuditLogs("All users", "2FA Reset", "", request);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Resetting 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void reset2FAForUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling reset2FAForUser");
        try {
            String username = MoTwoFactorUtility.sanitizeText(request.getParameter("username").trim());
            if (BooleanUtils.toBoolean((Boolean)this.performReset2FAForUser(username))) {
                LOGGER.debug("Successfully Reset 2FA for Username : " + username);
                this.pluginHandler.storeAdminsAuditLogs(username, "2FA reset for User", "", request);
                this.sendSuccessFullResponse("Success", response);
            } else {
                LOGGER.debug("Issue with resetting 2fa for username : " + username);
                this.sendErrorResponse("Error", response);
            }
        }
        catch (Exception e) {
            LOGGER.error("Issue with Resetting 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2FAForUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2FAForUser");
        try {
            String username = MoTwoFactorUtility.sanitizeText(request.getParameter("username").trim());
            LOGGER.debug("Enabling 2FA for Username : " + username);
            if (BooleanUtils.toBoolean((Boolean)this.performEnable2FAForUser(username))) {
                LOGGER.debug("Successfully Enabled 2FA for Username : " + username);
                this.pluginHandler.storeAdminsAuditLogs(username, "2FA Enabled for user", "", request);
                this.sendSuccessFullResponse("Success", response);
            } else {
                LOGGER.debug("Issue with enabling 2fa for username : " + username);
                this.sendErrorResponse("Error", response);
            }
        }
        catch (Exception e) {
            LOGGER.error("Issue with enabling 2fa : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2FAForUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2FAForUser");
        try {
            String username = MoTwoFactorUtility.sanitizeText(request.getParameter("username").trim());
            LOGGER.debug("Disabling 2FA for Username : " + username);
            if (BooleanUtils.toBoolean((Boolean)this.performDisable2FAForUser(username))) {
                LOGGER.debug("Successfully Disabled 2FA for Username : " + username);
                this.pluginHandler.storeAdminsAuditLogs(username, "2FA Disabled for user", "", request);
                this.sendSuccessFullResponse("Success", response);
            } else {
                LOGGER.debug("Issue with disabling 2fa for username : " + username);
                this.sendErrorResponse("Error", response);
            }
        }
        catch (Exception e) {
            LOGGER.error("Issue with disabling 2fa : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2faForSoftware(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2faForSoftware");
        try {
            this.settings.setEnableTwoFactor(true);
            this.pluginHandler.storeAdminsAuditLogs("Crowd Software", "2FA Activated", "", request);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Enabling 2FA for crowd : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2faForSoftware(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2faForSoftware");
        try {
            this.settings.setEnableTwoFactor(false);
            this.pluginHandler.storeAdminsAuditLogs("Crowd Software", "2FA Deactivated", "", request);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Disabling 2FA for crowd : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void ConfigureMobileAuthnSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            LOGGER.debug("Saving Mobile Authenticator Settings");
            String appLabel = req.getParameter("appLabel");
            String showSupportedAppPopup = req.getParameter("showSupportedAppPopup");
            String enableShareSecretKey = req.getParameter("enableShareSecretKey");
            LOGGER.debug("appLabel :" + appLabel);
            LOGGER.debug("showSupportedAppPopup :" + showSupportedAppPopup);
            LOGGER.debug("enableShareSecretKey :" + enableShareSecretKey);
            if (appLabel != null && !StringUtils.equalsIgnoreCase((CharSequence)this.settings.getAppLabel("Crowd"), (CharSequence)appLabel) || showSupportedAppPopup != null && this.settings.getShowSupportedAppPopup() != BooleanUtils.toBoolean((String)showSupportedAppPopup) || enableShareSecretKey != null && this.settings.getEnableShareSecretKey() != BooleanUtils.toBoolean((String)enableShareSecretKey)) {
                this.pluginHandler.storeAdminsAuditLogs("Mobile Authenticator", "Method Settings Updated", "-", req);
            }
            if (appLabel != null) {
                this.settings.setAppLabel(appLabel, "Crowd");
            }
            if (showSupportedAppPopup != null) {
                this.settings.setShowSupportedAppPopup(BooleanUtils.toBoolean((String)showSupportedAppPopup));
            }
            if (enableShareSecretKey != null) {
                this.settings.setEnableShareSecretKey(BooleanUtils.toBoolean((String)enableShareSecretKey));
            }
            this.sendSuccessFullResponse("Success", resp);
        }
        catch (Exception e) {
            LOGGER.error("Error while saving Mobile Authenticator settings :" + e.getMessage());
            this.sendErrorResponse("Error", resp);
        }
    }

    private void ConfigureDuoPushSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Saving Duo Push Notification Settings");
        String duoPushNotificationIntegrationKey = req.getParameter("duoPushNotificationIntegrationKey");
        String duoPushNotificationSecretKey = req.getParameter("duoPushNotificationSecretKey");
        String duoPushNotificationHostName = req.getParameter("duoPushNotificationHostName");
        LOGGER.debug("duoPushNotificationIntegrationKey :" + duoPushNotificationIntegrationKey);
        LOGGER.debug("duoPushNotificationSecretKey :" + duoPushNotificationSecretKey);
        LOGGER.debug("duoPushNotificationHostName :" + duoPushNotificationHostName);
        if (this.pluginHandler.isValidIntegrationKeyAndSecretKey(duoPushNotificationIntegrationKey, duoPushNotificationSecretKey, duoPushNotificationHostName).booleanValue()) {
            try {
                LOGGER.debug("Saving Duo Push Notification Settings");
                if (!(StringUtils.equalsIgnoreCase((CharSequence)this.settings.getDuoPushNotificationIntegrationKey(), (CharSequence)duoPushNotificationIntegrationKey) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getDuoPushNotificationSecretKey(), (CharSequence)duoPushNotificationSecretKey) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getDuoPushNotificationHostName(), (CharSequence)duoPushNotificationHostName))) {
                    this.pluginHandler.storeAdminsAuditLogs("DuoPushNotification", "Method Settings Updated", "-", req);
                }
                this.settings.setDuoPushNotificationIntegrationKey(duoPushNotificationIntegrationKey);
                this.settings.setDuoPushNotificationSecretKey(duoPushNotificationSecretKey);
                this.settings.setDuoPushNotificationHostName(duoPushNotificationHostName);
                this.sendSuccessFullResponse("Success", resp);
            }
            catch (Exception e) {
                LOGGER.error("Error while saving Duo Push Notifications settings :" + e.getMessage());
                this.sendErrorResponse("Error", resp);
            }
        } else {
            LOGGER.debug("Invalid Duo Push credentials");
            this.sendErrorResponse("Invalid Duo Push credentials", resp);
        }
    }

    private void ConfigureWebAuthnSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            LOGGER.debug("Saving Web Authn Settings");
            String attestationType = req.getParameter("attestationType");
            String authenticatorType = req.getParameter("authenticatorType");
            String userVerification = req.getParameter("userVerification");
            String residentKey = req.getParameter("residentKey");
            LOGGER.debug("attestationType :" + attestationType);
            LOGGER.debug("authenticatorType :" + authenticatorType);
            LOGGER.debug("userVerification :" + userVerification);
            LOGGER.debug("residentKey :" + residentKey);
            if (StringUtils.isNotBlank((CharSequence)attestationType) && !StringUtils.equalsIgnoreCase((CharSequence)this.settings.getAttestationType(), (CharSequence)attestationType) || StringUtils.isNotBlank((CharSequence)authenticatorType) && !StringUtils.equalsIgnoreCase((CharSequence)this.settings.getAuthenticatorType(), (CharSequence)authenticatorType) || StringUtils.isNotBlank((CharSequence)userVerification) && !StringUtils.equalsIgnoreCase((CharSequence)this.settings.getUserVerification(), (CharSequence)userVerification) || StringUtils.isNotBlank((CharSequence)residentKey) && !StringUtils.equalsIgnoreCase((CharSequence)this.settings.getResidentKey(), (CharSequence)residentKey)) {
                this.pluginHandler.storeAdminsAuditLogs("WebAuthn", "Method Settings Updated", "-", req);
            }
            if (StringUtils.isNotBlank((CharSequence)attestationType)) {
                this.settings.setAttestationType(attestationType);
            }
            if (StringUtils.isNotBlank((CharSequence)authenticatorType)) {
                this.settings.setAuthenticatorType(authenticatorType);
            }
            if (StringUtils.isNotBlank((CharSequence)userVerification)) {
                this.settings.setUserVerification(userVerification);
            }
            if (StringUtils.isNotBlank((CharSequence)residentKey)) {
                this.settings.setResidentKey(residentKey);
            }
            this.sendSuccessFullResponse("Success", resp);
        }
        catch (Exception e) {
            LOGGER.error("Error while saving Web Authn Notifications settings :" + e.getMessage());
            this.sendErrorResponse("Error", resp);
        }
    }

    private void ConfigureOtpOverEmailSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            if (this.pluginHandler.getUserAccessiblePages().contains("Basic_Configuration_readwrite")) {
                int number;
                LOGGER.debug("Saving Otp over Email Settings");
                String emailSubject = req.getParameter("emailSubject");
                String emailTemplate = req.getParameter("emailTemplate");
                String otpLength = req.getParameter("otpLength");
                String otpValidityDuration = req.getParameter("otpValidityDuration");
                Boolean isChanged = false;
                String customMailServer = req.getParameter("customMailServer");
                String customMailServerProtocol = req.getParameter("protocol");
                String customMailServerHostName = req.getParameter("hostName");
                String customMailServerSmtpPort = req.getParameter("smtpPort");
                String customMailServerFromAddress = req.getParameter("fromAddress");
                String customMailServerUsername = req.getParameter("mailServerUsername");
                String customMailServerPassword = req.getParameter("mailServerPassword");
                String customMailServerTls = req.getParameter("customMailServerTls");
                LOGGER.debug("Saving Custom Mail Server Configurations :, customMailServer :" + customMailServer + ", customMailServerProtocol :" + customMailServerProtocol + ", customMailServerHostName :" + customMailServerHostName + ", customMailServerSmtpPort :" + customMailServerSmtpPort + ", customMailServerFromAddress :" + customMailServerFromAddress + ", customMailServerUsername :" + customMailServerUsername + ", customMailServerTls :" + customMailServerTls);
                if (!this.settings.getCustomMailServer().equals(BooleanUtils.toBoolean((String)customMailServer))) {
                    isChanged = true;
                }
                if (StringUtils.isBlank((CharSequence)customMailServerSmtpPort) || StringUtils.isBlank((CharSequence)customMailServerHostName) || StringUtils.isBlank((CharSequence)customMailServerFromAddress)) {
                    this.settings.setCustomMailServer(Boolean.FALSE);
                } else {
                    this.settings.setCustomMailServer(BooleanUtils.toBoolean((String)customMailServer));
                }
                if (!(StringUtils.equalsIgnoreCase((CharSequence)this.settings.getCustomMailServerProtocol(), (CharSequence)customMailServerProtocol) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getCustomMailServerHostName(), (CharSequence)customMailServerHostName) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getCustomMailServerSmtpPort(), (CharSequence)customMailServerSmtpPort) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getCustomMailServerFromAddress(), (CharSequence)customMailServerFromAddress) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getCustomMailServerUsername(), (CharSequence)MoTwoFactorUtility.encryptString(customMailServerUsername, "MO2FA_CUSTOM_MAIL_SERVER_USERNAME")) && StringUtils.equalsIgnoreCase((CharSequence)this.settings.getCustomMailServerPassword(), (CharSequence)MoTwoFactorUtility.encryptString(customMailServerPassword, "MO2FA_CUSTOM_MAIL_SERVER_PASSWORD")) && this.settings.getCustomMailServerTls() == BooleanUtils.toBoolean((String)customMailServerTls))) {
                    isChanged = true;
                }
                this.settings.setCustomMailServerProtocol(customMailServerProtocol);
                this.settings.setCustomMailServerHostName(customMailServerHostName);
                this.settings.setCustomMailServerSmtpPort(customMailServerSmtpPort);
                this.settings.setCustomMailServerFromAddress(customMailServerFromAddress);
                this.settings.setCustomMailServerUsername(MoTwoFactorUtility.encryptString(customMailServerUsername, "MO2FA_CUSTOM_MAIL_SERVER_USERNAME"));
                this.settings.setCustomMailServerPassword(MoTwoFactorUtility.encryptString(customMailServerPassword, "MO2FA_CUSTOM_MAIL_SERVER_PASSWORD"));
                this.settings.setCustomMailServerTls(BooleanUtils.toBoolean((String)customMailServerTls));
                emailSubject = MoTwoFactorUtility.sanitizeText(emailSubject);
                Boolean isError = Boolean.FALSE;
                try {
                    number = Integer.parseInt(otpLength);
                    if (number > 8 || number < 4) {
                        LOGGER.error("Invalid OTP Length. The OTP Length must be between 4 to 8.");
                        isError = Boolean.TRUE;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Please enter valid OTP Length. OTP Length should be in number format.");
                    isError = Boolean.TRUE;
                }
                try {
                    number = Integer.parseInt(otpValidityDuration);
                    if (number > 30 || number < 1) {
                        LOGGER.error("Invalid OTP Validity Duration. The OTP Validity Duration must be between 1 and 30.");
                        isError = Boolean.TRUE;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Please enter valid OTP Validity Duration. OTP Validity Duration date should be in number format.");
                    isError = Boolean.TRUE;
                }
                if (!isError.booleanValue()) {
                    if (StringUtils.isNotBlank((CharSequence)emailSubject)) {
                        if (!StringUtils.equalsIgnoreCase((CharSequence)this.settings.getEmailSubject(), (CharSequence)emailSubject)) {
                            isChanged = true;
                        }
                        this.settings.setEmailSubject(emailSubject);
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)this.settings.getEmailTemplate(), (CharSequence)emailTemplate)) {
                        isChanged = true;
                    }
                    this.settings.setEmailTemplate(emailTemplate);
                    if (StringUtils.isNotBlank((CharSequence)otpLength)) {
                        if (this.settings.getOtpLength() != Integer.parseInt(otpLength)) {
                            isChanged = true;
                        }
                        this.settings.setOtpLength(Integer.parseInt(otpLength));
                    }
                    if (StringUtils.isNotBlank((CharSequence)otpValidityDuration)) {
                        if (this.settings.getOtpValidityDuration() != Integer.parseInt(otpValidityDuration)) {
                            isChanged = true;
                        }
                        this.settings.setOtpValidityDuration(Integer.parseInt(otpValidityDuration));
                    }
                    if (isChanged.booleanValue()) {
                        this.pluginHandler.storeAdminsAuditLogs("OtpOverEmail", "Method Settings Updated", "-", req);
                    }
                    this.sendSuccessFullResponse("Success", resp);
                } else {
                    this.sendErrorResponse("Error", resp);
                }
            }
            this.sendSuccessFullResponse("Success", resp);
        }
        catch (Exception e) {
            LOGGER.error("Error while saving Otp Over Email settings :" + e.getMessage());
            this.sendErrorResponse("Error", resp);
        }
    }

    private void SendTestOtpOverEmail(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String toEmail = req.getParameter("ToEmail");
            String Subject2 = "Test Email";
            String Body = "This is a Test Email to ensure the connections you configured for your custom mail server in Crowd is working as expected. <br><br>Thank you.";
            String error = this.pluginHandler.sendEmail(Subject2, Body, toEmail);
            JSONObject data = new JSONObject();
            data.put("Error", error);
            this.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (Exception e) {
            LOGGER.error("error while sending test mail :", e);
            JSONObject data = new JSONObject();
            data.put("Error", e.getMessage());
            this.sendErrorResponse(data.toString(), resp);
        }
    }

    private void SavedMethodSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            Object data;
            String selectedMethod = req.getParameter("selectedMethod");
            String enabled = req.getParameter("enabled");
            String Main = req.getParameter("Main");
            String FromRadio = req.getParameter("FromRadio");
            LOGGER.debug(" FromRadio :" + FromRadio);
            LOGGER.debug(" selectedMethod :" + selectedMethod);
            if (BooleanUtils.toBoolean((String)FromRadio)) {
                selectedMethod = selectedMethod.contains("Main") ? selectedMethod.substring(0, selectedMethod.length() - 4) : selectedMethod.substring(0, selectedMethod.length() - 6);
            }
            List<String> twoFactorMethodForUserList = this.settings.get2FAMethodForUserList();
            List<String> backupMethodForUserList = this.settings.getBackupMethodForUserList();
            String methodName = selectedMethod.substring(2);
            if (BooleanUtils.toBoolean((String)enabled)) {
                if (BooleanUtils.toBoolean((String)Main)) {
                    if (!twoFactorMethodForUserList.contains(methodName)) {
                        if (StringUtils.contains((CharSequence)methodName, (CharSequence)"YubikeyHardwareTokenAsU2F") && (twoFactorMethodForUserList.contains("WebAuthn") || backupMethodForUserList.contains("WebAuthn")) || StringUtils.contains((CharSequence)methodName, (CharSequence)"WebAuthn") && (twoFactorMethodForUserList.contains("YubikeyHardwareTokenAsU2F") || backupMethodForUserList.contains("YubikeyHardwareTokenAsU2F"))) {
                            LOGGER.debug("Web Authn and Yubikey can't be configured together");
                            return;
                        }
                        twoFactorMethodForUserList.add(methodName);
                        LOGGER.debug(" added as 2fa method: " + methodName);
                        this.pluginHandler.storeAdminsAuditLogs(methodName, "2FA Method Enabled", "", req);
                    }
                    if (backupMethodForUserList.contains(methodName)) {
                        backupMethodForUserList.remove(methodName);
                        LOGGER.debug(" removed as backup method: " + methodName);
                    }
                } else {
                    if (this.CheckIfOnlyPrimaryMethodInFallback(methodName, twoFactorMethodForUserList, resp).booleanValue()) {
                        return;
                    }
                    if (twoFactorMethodForUserList.contains(methodName)) {
                        twoFactorMethodForUserList.remove(methodName);
                        LOGGER.debug(" removed as 2fa method: " + methodName);
                    }
                    if (!backupMethodForUserList.contains(methodName)) {
                        if (twoFactorMethodForUserList.size() > 0) {
                            if (StringUtils.contains((CharSequence)methodName, (CharSequence)"YubikeyHardwareTokenAsU2F") && (twoFactorMethodForUserList.contains("WebAuthn") || backupMethodForUserList.contains("WebAuthn")) || StringUtils.contains((CharSequence)methodName, (CharSequence)"WebAuthn") && (twoFactorMethodForUserList.contains("YubikeyHardwareTokenAsU2F") || backupMethodForUserList.contains("YubikeyHardwareTokenAsU2F"))) {
                                LOGGER.debug("Web Authn and Yubikey can't be configured together");
                                return;
                            }
                            backupMethodForUserList.add(methodName);
                            LOGGER.debug(" added as backup method: " + methodName);
                            this.pluginHandler.storeAdminsAuditLogs(methodName, "Backup Method Enabled", "", req);
                        } else {
                            if (!methodName.contains("BackupCode")) {
                                twoFactorMethodForUserList.add(methodName);
                                LOGGER.debug(" added as 2fa method: " + methodName);
                            }
                            JSONObject data2 = new JSONObject();
                            data2.put("methodName", methodName);
                            if (BooleanUtils.toBoolean((String)Main)) {
                                data2.put("type", "2FA Method");
                            } else {
                                data2.put("type", "Backup Method");
                            }
                            data2.put("enablingBackupWithout2FA", true);
                            this.sendSuccessFullResponse(data2.toString(), resp);
                            return;
                        }
                    }
                }
                this.settings.set2FAMethodForUserList(twoFactorMethodForUserList);
                this.settings.setBackupMethodForUserList(backupMethodForUserList);
            } else {
                if (twoFactorMethodForUserList.contains(methodName)) {
                    if (twoFactorMethodForUserList.size() == 1) {
                        JSONObject data3 = new JSONObject();
                        data3.put("methodName", methodName);
                        if (BooleanUtils.toBoolean((String)Main)) {
                            data3.put("type", "2FA Method");
                        } else {
                            data3.put("type", "Backup Method");
                        }
                        data3.put("disablingLast2FAMethod", true);
                        this.sendSuccessFullResponse(data3.toString(), resp);
                        return;
                    }
                    if (this.CheckIfOnlyPrimaryMethodInFallback(methodName, twoFactorMethodForUserList, resp).booleanValue()) {
                        return;
                    }
                    twoFactorMethodForUserList.remove(methodName);
                    LOGGER.debug(" removed as 2fa method: " + methodName);
                }
                if (backupMethodForUserList.contains(methodName)) {
                    backupMethodForUserList.remove(methodName);
                    LOGGER.debug(" removed as backup method: " + methodName);
                }
                this.settings.set2FAMethodForUserList(twoFactorMethodForUserList);
                this.settings.setBackupMethodForUserList(backupMethodForUserList);
                if (this.settings.getMfaMethodsBasedOnGroupsMap().containsKey(methodName)) {
                    data = new JSONObject();
                    ((JSONObject)data).put("methodName", methodName);
                    if (BooleanUtils.toBoolean((String)Main)) {
                        ((JSONObject)data).put("type", "2FA Method");
                    } else {
                        ((JSONObject)data).put("type", "Backup Method");
                    }
                    ((JSONObject)data).put("disablingMfaMethodsBasedOnGroupsMethod", true);
                    this.sendSuccessFullResponse(((JSONObject)data).toString(), resp);
                }
                this.pluginHandler.storeAdminsAuditLogs(methodName, "2FA Method Disabled", "", req);
            }
            if (!BooleanUtils.toBoolean((String)FromRadio)) {
                switch (methodName) {
                    case "GoogleAuthenticator": {
                        LOGGER.debug(" Saving google authenticator Toggle button");
                        if (BooleanUtils.toBoolean((String)enabled)) {
                            this.settings.setTwoFactorForMobileAuthn(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForMobileAuthn(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "DuoPushNotification": {
                        LOGGER.debug(" saving Duo Push Notification toggle button");
                        if (BooleanUtils.toBoolean((String)enabled) && this.pluginHandler.isDuoPushNotificationSettingsConfigured().booleanValue()) {
                            this.settings.setTwoFactorForDuopush(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForDuopush(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "YubikeyHardwareTokenAsU2F": {
                        LOGGER.debug(" Saving Yubikey Hardware Toggle button");
                        if (BooleanUtils.toBoolean((String)enabled) && StringUtils.startsWithIgnoreCase((CharSequence)this.pluginConfiguration.getBaseUrl().trim(), (CharSequence)"https://")) {
                            if (this.settings.getTwoFactorForWebAuthn().booleanValue()) break;
                            this.settings.setTwoFactorForYubikey(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForYubikey(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "WebAuthn": {
                        LOGGER.debug("Saving WebAuthn Toggle button");
                        if (BooleanUtils.toBoolean((String)enabled) && StringUtils.startsWithIgnoreCase((CharSequence)this.pluginConfiguration.getBaseUrl().trim(), (CharSequence)"https://")) {
                            if (this.settings.getTwoFactorForYubikey().booleanValue()) break;
                            this.settings.setTwoFactorForWebAuthn(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForWebAuthn(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "OtpOverEmail": {
                        LOGGER.debug(" Saving OtpoverEmail's Toggle button");
                        if (BooleanUtils.toBoolean((String)enabled) && (this.pluginHandler.isSmtpConfigured().booleanValue() || this.settings.getCustomMailServer().booleanValue())) {
                            this.settings.setTwoFactorForOtpOverEmail(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForOtpOverEmail(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "OtpOverSms": {
                        LOGGER.debug(" Saving Otpoversms's Toggle button");
                        if (BooleanUtils.toBoolean((String)enabled) && this.pluginHandler.isSmsGatewayConfigured().booleanValue()) {
                            this.settings.setTwoFactorForOtpOverSms(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForOtpOverSms(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "SecurityQuestion": {
                        LOGGER.debug(" Saving Securtiy Question Toggle Button");
                        if (BooleanUtils.toBoolean((String)enabled)) {
                            this.settings.setTwoFactorForSecurityQuestion(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForSecurityQuestion(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "BackupCode": {
                        LOGGER.debug(" Saving BackupCode Toggle Button");
                        if (BooleanUtils.toBoolean((String)enabled)) {
                            this.settings.setTwoFactorForBackup(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForBackup(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                    }
                }
                this.settings.set2FAMethodForUserList(twoFactorMethodForUserList);
                this.settings.setBackupMethodForUserList(backupMethodForUserList);
            }
            data = new JSONObject();
            ((JSONObject)data).put("methodName", methodName);
            if (BooleanUtils.toBoolean((String)Main)) {
                ((JSONObject)data).put("type", "2FA Method");
            } else {
                ((JSONObject)data).put("type", "Backup Method");
            }
            this.sendSuccessFullResponse(((JSONObject)data).toString(), resp);
        }
        catch (Exception e) {
            LOGGER.error("Error while saving 2fa toggle/radio button :" + e.getMessage());
            this.sendErrorResponse("Error", resp);
        }
    }

    private Boolean performReset2FAForUser(String username) throws Exception {
        String status;
        LOGGER.debug("Calling performReset2FAForUser for User : " + username);
        List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
        if (configuredUser.contains(username)) {
            configuredUser.removeAll(Collections.singleton(username));
            UserProfile crowdUser = this.pluginConfiguration.getCrowdUserFromManager(username);
            if (BooleanUtils.toBoolean((Boolean)this.settings.getSendEmailAfterReset2fa())) {
                this.pluginHandler.sendEmailReset2fa(crowdUser);
            }
            status = "SUCCESS";
        } else {
            status = "ERROR";
        }
        this.settings.setListOf2FAConfiguredUsers(configuredUser);
        if (StringUtils.equalsIgnoreCase((CharSequence)"SUCCESS", (CharSequence)status)) {
            this.settings.setUserSettings(username, new MoTwoFactorCommonUserSettings());
            Map<String, String> configuredMobileNumbers = this.settings.getConfiguredMobileNumbers();
            configuredMobileNumbers.remove(username);
            this.settings.setConfiguredMobileNumbers(configuredMobileNumbers);
        }
        return Boolean.TRUE;
    }

    private Boolean performDisable2FAForUser(String username) {
        try {
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            List<String> disable2FAForUsersList = this.settings.getDisable2FAForUsersList();
            if (enable2FAForUsersList.contains(username)) {
                LOGGER.debug("Disabling 2FA for User : " + username);
                enable2FAForUsersList.removeAll(Collections.singleton(username));
                this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
                disable2FAForUsersList.add(username);
                this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("Issue with disabling 2fa : " + e);
            return Boolean.FALSE;
        }
    }

    private Boolean performEnable2FAForUser(String username) {
        try {
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            List<String> disable2FAForUsersList = this.settings.getDisable2FAForUsersList();
            if (!enable2FAForUsersList.contains(username)) {
                LOGGER.debug("Enabling 2FA for User : " + username);
                disable2FAForUsersList.removeAll(Collections.singleton(username));
                this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
                enable2FAForUsersList.add(username);
                this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("Issue with enabling 2fa : " + e);
            return Boolean.FALSE;
        }
    }

    private Boolean performEnable2FAForGroup(String groupname) {
        LOGGER.debug("Calling performEnable2FAForGroup for Group : " + groupname);
        List<String> usersFromGroup = this.pluginHandler.getAllUsersInGroup(groupname);
        for (String username : usersFromGroup) {
            this.performEnable2FAForUser(username);
        }
        return Boolean.TRUE;
    }

    private Boolean performDisable2FAForGroup(String groupname, Boolean disableForAll) {
        LOGGER.debug("Calling performDisable2FAForGroup for Group : " + groupname);
        List<String> usersFromGroup = this.pluginHandler.getAllUsersInGroup(groupname);
        Boolean shouldDisable2FAforUser = Boolean.TRUE;
        for (String username : usersFromGroup) {
            shouldDisable2FAforUser = Boolean.TRUE;
            if (BooleanUtils.toBoolean((Boolean)disableForAll)) {
                this.performDisable2FAForUser(username);
                continue;
            }
            List<String> groupListOfUser = this.pluginHandler.getAllGroupsOfUser(groupname);
            List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
            if (groupListOfUser.size() < enable2FAForGroupsList.size()) {
                for (String groupnameOfUser : groupListOfUser) {
                    if (!enable2FAForGroupsList.contains(groupnameOfUser)) continue;
                    shouldDisable2FAforUser = Boolean.FALSE;
                    break;
                }
            } else {
                for (String enableGroupName : enable2FAForGroupsList) {
                    if (!groupListOfUser.contains(enableGroupName)) continue;
                    shouldDisable2FAforUser = Boolean.FALSE;
                    break;
                }
            }
            if (!BooleanUtils.toBoolean((Boolean)shouldDisable2FAforUser)) continue;
            this.performDisable2FAForUser(username);
        }
        return Boolean.TRUE;
    }

    private Boolean performEnable2FAForDirectory(String directoryname) throws DirectoryNotFoundException {
        LOGGER.debug("Calling performEnable2FAForDirectory");
        List<String> groupsInDirectory = this.pluginHandler.getAllGroupsInDirectory(directoryname);
        List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
        for (String groupname : groupsInDirectory) {
            if (enable2FAForGroupsList.contains(groupname)) continue;
            enable2FAForGroupsList.add(groupname);
            this.settings.setEnable2FAForGroupsList(enable2FAForGroupsList);
        }
        List<String> usersFromDirectory = this.pluginHandler.getAllUsersInDirectory(directoryname);
        for (String username : usersFromDirectory) {
            this.performEnable2FAForUser(username);
        }
        return Boolean.TRUE;
    }

    public Boolean performDisable2FAForDirectory(String directoryname) throws DirectoryNotFoundException {
        LOGGER.debug("Calling performDisable2FAForDirectory");
        List<String> groupsFromDirectory = this.pluginHandler.getAllGroupsInDirectory(directoryname);
        List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
        for (String groupname : groupsFromDirectory) {
            if (!enable2FAForGroupsList.contains(groupname)) continue;
            enable2FAForGroupsList.removeAll(Collections.singleton(groupname));
            this.settings.setEnable2FAForGroupsList(enable2FAForGroupsList);
        }
        List<String> usersFromDirectory = this.pluginHandler.getAllUsersInDirectory(directoryname);
        for (String username : usersFromDirectory) {
            this.performDisable2FAForUser(username);
        }
        return Boolean.TRUE;
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendSuccessFullResponse");
        this.responseSent = Boolean.TRUE;
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void sendErrorResponse(String errorMessages, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendErrorResponse");
        this.responseSent = Boolean.TRUE;
        resp.setContentType("application/json");
        resp.setStatus(500);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }

    private Boolean CheckIfOnlyPrimaryMethodInFallback(String methodName, List<String> twoFactorMethodForUserList, HttpServletResponse resp) throws IOException {
        List<String> fallBackMethods = this.settings.getFallBackMethods();
        if (fallBackMethods.contains(methodName)) {
            fallBackMethods.retainAll(twoFactorMethodForUserList);
            if (fallBackMethods.size() == 1) {
                JSONObject data = new JSONObject();
                data.put("methodName", methodName);
                data.put("disablingLastConfiguredFallBackMethod", true);
                this.sendSuccessFullResponse(data.toString(), resp);
                return true;
            }
        }
        return false;
    }
}

