/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorLookAndFeelTemplates
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorLookAndFeelTemplates.class);
    private static final String VM_PATH = "/templates/com/miniorange/twofactor/crowd/lookandfeeltemplates.vm";
    private TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private MoTwoFactorCrowdPluginSettings crowdPluginSettings;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    public String message = "";
    public ArrayList errorMessage;

    public MoTwoFactorLookAndFeelTemplates(UserManager userManager, TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, LoginUriProvider loginUriProvider, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings, MoTwoFactorCrowdPluginSettings crowdPluginSettings) {
        this.userManager = userManager;
        this.renderer = renderer;
        this.settings = settings;
        this.loginUriProvider = loginUriProvider;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
        this.crowdPluginSettings = crowdPluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorLookAndFeelTemplates Servlet doGet() called.");
        UserProfile user = this.userManager.getRemoteUser();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("LookAndFeel");
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            if (!this.crowdPluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.crowdPluginSettings.getLicenseVerified().booleanValue() || this.crowdPluginSettings.getLicenseVerified().booleanValue() && this.crowdPluginSettings.isTrialLicense().booleanValue() && this.crowdPluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
            this.message = "";
            this.errorMessage = new ArrayList();
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorLookAndFeelTemplates Servlet doPost() called.");
        UserProfile user = this.userManager.getRemoteUser();
        this.message = "";
        this.errorMessage = new ArrayList();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("LookAndFeel");
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            if (!this.crowdPluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.crowdPluginSettings.getLicenseVerified().booleanValue() || this.crowdPluginSettings.getLicenseVerified().booleanValue() && this.crowdPluginSettings.isTrialLicense().booleanValue() && this.crowdPluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
            Boolean settingsSubmitted = BooleanUtils.toBoolean((String)MoTwoFactorUtility.sanitizeText(request.getParameter("settingsSubmitted")));
            ArrayList<String> securityQuestionsList = new ArrayList();
            if (BooleanUtils.toBoolean((Boolean)settingsSubmitted)) {
                String welcomeMessageTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("welcomeMessageTemplate"), (CharSequence)"");
                String configureGoogleAuthenticatorTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("configureGoogleAuthenticatorTemplate"), (CharSequence)"");
                String validateGoogleAuthenticatorTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("validateGoogleAuthenticatorTemplate"), (CharSequence)"");
                String configureSecurityQuestionTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("configureSecurityQuestionTemplate"), (CharSequence)"");
                String validateSecurityQuestionTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("validateSecurityQuestionTemplate"), (CharSequence)"");
                String configureOtpOverEmailTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("configureOtpOverEmailTemplate"), (CharSequence)"");
                String validateOtpOverEmailTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("validateOtpOverEmailTemplate"), (CharSequence)"");
                String configureOtpOverSmsTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("configureOtpOverSmsTemplate"), (CharSequence)"");
                String validateOtpOverSmsTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("validateOtpOverSmsTemplate"), (CharSequence)"");
                String configureBackupCodeTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("configureBackupCodeTemplate"), (CharSequence)"");
                String validateBackupCodeTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("validateBackupCodeTemplate"), (CharSequence)"");
                String lockedUsersTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("lockedUsersTemplate"), (CharSequence)"");
                String blocklistIpTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("blocklistIpTemplate"), (CharSequence)"");
                String configureHardwareTokenTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("configureU2FHardwareTokenTemplate"), (CharSequence)"");
                String validateHardwareTokenTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("validateU2FHardwareTokenTemplate"), (CharSequence)"");
                String configureDuoPushNotificationTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("configureDuoPushNotificationTemplate"), (CharSequence)"");
                String validateDuoPushNotificationTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("validateDuoPushNotificationTemplate"), (CharSequence)"");
                String configureWebAuthenticationTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("configureWebAuthenticationTemplate"), (CharSequence)"");
                String validateWebAuthenticationTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("validateWebAuthenticationTemplate"), (CharSequence)"");
                String inlineRegistration_2faMethodListTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("inlineRegistration_2faMethodListTemplate"), (CharSequence)"");
                String inlineRegistration_backupMethodListTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("inlineRegistration_backupMethodListTemplate"), (CharSequence)"");
                String inlineRegistration_remaining2faMethodsListTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("inlineRegistration_remaining2faMethodsListTemplate"), (CharSequence)"");
                String validate_2faMethodListTemplate = (String)StringUtils.defaultIfBlank((CharSequence)request.getParameter("validate_2faMethodListTemplate"), (CharSequence)"");
                securityQuestionsList = this.settings.getSecurityQuestionsList();
                Integer flagForSecurityQuestionAuditLog = 0;
                for (int i = 0; i <= 10; ++i) {
                    try {
                        String question;
                        if (request.getParameter("question_" + i) == null || !StringUtils.isNotBlank((CharSequence)(question = MoTwoFactorUtility.sanitizeText(request.getParameter("question_" + i).trim())))) continue;
                        LOGGER.debug("question_" + i + " value :" + question);
                        if (securityQuestionsList.contains(question)) continue;
                        securityQuestionsList.set(i, question.trim());
                        flagForSecurityQuestionAuditLog = 1;
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.error("error while saving security questions in look and feel Tab");
                    }
                }
                if (flagForSecurityQuestionAuditLog == 1) {
                    this.pluginHandler.storeAdminsAuditLogs("-", "Updated Security Questions", "", request);
                }
                this.pluginHandler.save2FATemplateSettings(welcomeMessageTemplate, configureGoogleAuthenticatorTemplate, validateGoogleAuthenticatorTemplate, configureSecurityQuestionTemplate, validateSecurityQuestionTemplate, configureOtpOverEmailTemplate, validateOtpOverEmailTemplate, configureOtpOverSmsTemplate, validateOtpOverSmsTemplate, configureDuoPushNotificationTemplate, validateDuoPushNotificationTemplate, configureHardwareTokenTemplate, validateHardwareTokenTemplate, configureWebAuthenticationTemplate, validateWebAuthenticationTemplate, configureBackupCodeTemplate, validateBackupCodeTemplate, lockedUsersTemplate, blocklistIpTemplate, inlineRegistration_2faMethodListTemplate, inlineRegistration_backupMethodListTemplate, inlineRegistration_remaining2faMethodsListTemplate, validate_2faMethodListTemplate, securityQuestionsList, request);
                LOGGER.info("Successfully save configuration");
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private Map<String, Object> initializeConfig() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", this.message);
        context.put("errorMessage", this.errorMessage);
        context.put("contextPath", this.pluginConfiguration.getBaseUrl());
        context.put("welcomeMessageTemplate", this.pluginSettings.getWelcomeMessageTemplate());
        context.put("configureGoogleAuthenticatorTemplate", this.pluginSettings.getConfigureGoogleAuthenticatorTemplate());
        context.put("validateGoogleAuthenticatorTemplate", this.pluginSettings.getValidateGoogleAuthenticatorTemplate());
        context.put("configureSecurityQuestionTemplate", this.pluginSettings.getConfigureSecurityQuestionTemplate());
        context.put("validateSecurityQuestionTemplate", this.pluginSettings.getValidateSecurityQuestionTemplate());
        context.put("configureOtpOverEmailTemplate", this.pluginSettings.getConfigureOtpOverEmailTemplate());
        context.put("validateOtpOverEmailTemplate", this.pluginSettings.getValidateOtpOverEmailTemplate());
        context.put("configureOtpOverSMSTemplate", this.pluginSettings.getConfigureOtpOverSmsTemplate());
        context.put("validateOtpOverSMSTemplate", this.pluginSettings.getValidateOtpOverSmsTemplate());
        context.put("configureBackupCodeTemplate", this.pluginSettings.getConfigureBackupCodeTemplate());
        context.put("validateBackupCodeTemplate", this.pluginSettings.getValidateBackupCodeTemplate());
        context.put("lockedUsersTemplate", this.pluginSettings.getLockedUserTemplate());
        context.put("blocklistIpTemplate", this.pluginSettings.getBlocklistIpTemplate());
        context.put("configureU2FHardwareTokenTemplate", this.pluginSettings.getConfigureU2FHardwareTokenTemplate());
        context.put("validateU2FHardwareTokenTemplate", this.pluginSettings.getValidateWebAuthnHardwareTokenTemplate());
        context.put("configureDuoPushNotificationTemplate", this.pluginSettings.getConfigureDuoPushNotificationTemplate());
        context.put("validateDuoPushNotificationTemplate", this.pluginSettings.getValidateDuoPushNotificationTemplate());
        context.put("configureWebAuthenticationTemplate", this.pluginSettings.getConfigureWebAuthnAs2faMethodTemplate());
        context.put("validateWebAuthenticationTemplate", this.pluginSettings.getValidateWebAuthnAs2faMethodTemplate());
        context.put("inlineRegistration_2faMethodListTemplate", this.pluginSettings.getInlineRegistration_2faMethodListTemplate());
        context.put("inlineRegistration_backupMethodListTemplate", this.pluginSettings.getInlineRegistration_backupMethodListTemplate());
        context.put("inlineRegistration_remaining2faMethodsListTemplate", this.pluginSettings.getInlineRegistration_remaining2faMethodsListTemplate());
        context.put("validate_2faMethodListTemplate", this.pluginSettings.getValidate_2faMethodListTemplate());
        context.put("configureOtpOverSmsTemplate", this.pluginSettings.getConfigureOtpOverSmsTemplate());
        context.put("validateOtpOverSmsTemplate", this.pluginSettings.getValidateOtpOverSmsTemplate());
        List<Object> securityQuestionsList = new ArrayList();
        securityQuestionsList = this.settings.getSecurityQuestionsList();
        LOGGER.debug("securityQuestionsList :" + this.settings.getSecurityQuestionsList());
        if (securityQuestionsList.isEmpty()) {
            LOGGER.debug("hi");
            securityQuestionsList = MoTwoFactorUtility.getQuestionList();
            this.settings.setSecurityQuestionsList(securityQuestionsList);
            LOGGER.debug("securityQuestionsList :" + this.settings.getSecurityQuestionsList());
        }
        context.put("securityQuestionsList", this.settings.getSecurityQuestionsList());
        context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
        context.put("pageAccessType", this.pluginHandler.getPageAccessForCurrentUser("LookAndFeel"));
        context.put("isAdmin", this.pluginHandler.isSystemAdmin());
        context.put("pagesAccessibleToUser", this.pluginHandler.getUserAccessiblePages());
        context.put("licenseType", this.crowdPluginSettings.getLicenseType());
        context.put("licenseExpireDate", this.crowdPluginSettings.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.crowdPluginSettings.isNoOfUserExceed());
        context.put("daysLeftToExpire", this.crowdPluginSettings.getDaysLeftToExpire());
        context.put("isLicenseExpired", this.crowdPluginSettings.isLicenseExpired());
        return context;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TemplateRenderer renderer) {
        this.renderer = renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public MoTwoFactorCrowdPluginSettings getCrowdPluginSettings() {
        return this.crowdPluginSettings;
    }

    public void setCrowdPluginSettings(MoTwoFactorCrowdPluginSettings crowdPluginSettings) {
        this.crowdPluginSettings = crowdPluginSettings;
    }
}

