/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.servlets;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.io.BaseEncoding;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.miniorange.twofactor.crowd.webauthn.MoSettings;
import com.miniorange.twofactor.crowd.webauthn.dto.Credential;
import com.miniorange.twofactor.crowd.webauthn.utils.AuthenticatorAssertionResponse;
import com.miniorange.twofactor.crowd.webauthn.utils.PublicKeyCredential;
import com.miniorange.twofactor.crowd.webauthn.utils.PublicKeyCredentialResponse;
import com.miniorange.twofactor.crowd.webauthn.utils.Server;
import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class FinishGetAssertion
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(FinishGetAssertion.class);
    private static final int FINGERPRINT = 2;
    private static final int SCREEN_LOCK = 134;
    private static final long serialVersionUID = 1L;
    private MoSettings moSettings;
    @ComponentImport
    private I18nResolver i18nResolver;

    @Autowired
    public FinishGetAssertion(MoSettings moSettings, I18nResolver i18nResolver) {
        this.moSettings = moSettings;
        this.i18nResolver = i18nResolver;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String session;
        String currentUser = request.getParameter("username");
        LOGGER.debug("Current user in FinishGetAssertion is :- " + currentUser);
        String data = request.getParameter("data");
        if (data == null) {
            data = "";
        }
        if ((session = request.getParameter("session")) == null) {
            session = "";
        }
        String credentialId = null;
        String type = null;
        String uvm = null;
        JsonElement assertionJson = null;
        try {
            JsonElement uvmJson;
            JsonElement typeJson;
            JsonObject json = new JsonParser().parse(data).getAsJsonObject();
            JsonElement idJson = json.get("id");
            if (idJson != null) {
                credentialId = idJson.getAsString();
            }
            if ((typeJson = json.get("type")) != null) {
                type = typeJson.getAsString();
            }
            if ((uvmJson = json.get("uvm")) != null && uvmJson.isJsonArray()) {
                JsonElement uvmElement;
                JsonArray uvmArray = uvmJson.getAsJsonArray();
                if (uvmJson.isJsonArray() && (uvmElement = uvmArray.get(0)) != null) {
                    switch (uvmElement.getAsJsonObject().get("userVerificationMethod").getAsInt()) {
                        case 2: {
                            uvm = "Fingerprint";
                            break;
                        }
                        case 134: {
                            uvm = "Screen Lock";
                            break;
                        }
                        default: {
                            uvm = "Others";
                        }
                    }
                }
            }
            if ((assertionJson = json.get("response")) == null) {
                throw new ServletException("Missing element 'response'");
            }
        }
        catch (IllegalStateException e) {
            throw new ServletException("Passed data not a json object");
        }
        catch (ClassCastException e) {
            throw new ServletException("Invalid input");
        }
        catch (JsonParseException e) {
            throw new ServletException("Input not valid json");
        }
        AuthenticatorAssertionResponse assertion = null;
        try {
            assertion = new AuthenticatorAssertionResponse(assertionJson);
        }
        catch (Exception e) {
            throw new ServletException(e.toString());
        }
        String credentialIdRecoded = BaseEncoding.base64Url().encode(BaseEncoding.base64Url().decode(credentialId));
        PublicKeyCredential cred = new PublicKeyCredential(credentialIdRecoded, type, BaseEncoding.base64Url().decode(credentialId), assertion);
        Credential savedCredential = null;
        try {
            savedCredential = this.moSettings.getUserCred(currentUser);
        }
        catch (Exception e) {
            LOGGER.debug("Empty Servlet Exception found " + e);
        }
        LOGGER.debug("SavedCredential :- " + savedCredential);
        Server.verifyAssertion(cred, currentUser, session, savedCredential);
        response.setContentType("application/json");
        String handle = DatatypeConverter.printHexBinary(savedCredential.getCredential().rawId);
        PublicKeyCredentialResponse rsp = new PublicKeyCredentialResponse(true, "Successful assertion", handle);
        LOGGER.debug("Here inside the finish get Assertion :- " + handle + "\t" + this.i18nResolver.getText("my.plugin.platform") + "\tcurrent User :- " + currentUser + "\t");
        response.getWriter().println(rsp.toJson());
    }
}

