/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistrationOtpOverEmail
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistrationOtpOverEmail.class);
    private static final String REGISTRATION_VM_PATH = "/templates/com/miniorange/twofactor/crowd/inlineregistration_otpoveremail.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorInlineRegistrationOtpOverEmail(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationOtpOverEmail doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && this.pluginHandler.isPageAllowed("OtpOverEmail", username).booleanValue() && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "InlineRegistration_OtpOverEmail").booleanValue()) {
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("baseUrl", this.pluginConfiguration.getBaseUrl());
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            ArrayList<String> errorMessage = new ArrayList<String>();
            HttpSession session = request.getSession();
            if (session.getAttribute("otp_code") == null) {
                try {
                    if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isSmtpConfigured()) || this.settings.getCustomMailServer().booleanValue()) {
                        this.pluginHandler.sendOtpOnEmail(request, this.pluginConfiguration.getCrowdUser());
                    } else {
                        errorMessage.add("Issue with sending email. Mail Server is not Configured. Please contact to administrator.");
                    }
                }
                catch (Exception e) {
                    errorMessage.add("Issue with sending Email. Please contact to administrator.");
                }
            }
            context.put("errorMessage", errorMessage);
            context.put("successMessage", "");
            String template = this.pluginSettings.getConfigureOtpOverEmailTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(REGISTRATION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationOtpOverEmail doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && this.pluginHandler.isPageAllowed("OtpOverEmail", username).booleanValue()) {
            String successMessage;
            ArrayList<String> errorMessage;
            block22: {
                errorMessage = new ArrayList<String>();
                successMessage = "";
                if (BooleanUtils.toBoolean((String)request.getParameter("resendOtpLinkClicked"))) {
                    LOGGER.debug("Reset OTP link clicked");
                    try {
                        if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isSmtpConfigured()) || this.settings.getCustomMailServer().booleanValue()) {
                            this.pluginHandler.sendOtpOnEmail(request, this.pluginConfiguration.getCrowdUser());
                            successMessage = "Successfully resend the OTP to your email.";
                            break block22;
                        }
                        errorMessage.add("Issue with sending email. Mail Server is not Configured. Please contact to administrator.");
                    }
                    catch (Exception e) {
                        errorMessage.add("Issue with sending Email. Please contact to admin");
                    }
                } else {
                    LOGGER.debug("Checking OTP validation");
                    String otp = StringUtils.trimToEmpty((String)request.getParameter("otpCode"));
                    if (MoTwoFactorUtility.isValidNumberFormat(otp).booleanValue()) {
                        LOGGER.debug("OTP is Valid = " + otp);
                        HttpSession session = request.getSession();
                        String storedOtpCode = (String)session.getAttribute("otp_code");
                        Boolean isValid = Boolean.FALSE;
                        if (StringUtils.equalsIgnoreCase((CharSequence)otp, (CharSequence)storedOtpCode)) {
                            long storedOtpExpiryTime;
                            long currentTimeInMili = System.currentTimeMillis();
                            if (currentTimeInMili < (storedOtpExpiryTime = ((Long)session.getAttribute("otp_expiry_time")).longValue())) {
                                isValid = Boolean.TRUE;
                            } else {
                                isValid = Boolean.FALSE;
                                errorMessage.add("OTP is Valid. But Time Expired.");
                            }
                        } else {
                            isValid = Boolean.FALSE;
                            errorMessage.add("Invalid OTP Entered");
                        }
                        if (isValid.booleanValue()) {
                            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Successful", "OTP Over Email");
                            LOGGER.debug("OTP validated Successfully...");
                            session.removeAttribute("otp_code");
                            session.removeAttribute("otp_expiry_time");
                            session.removeAttribute("last_email_otp_sent_time");
                            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                            twoFactorUserClass.setConfigured2FAMethodsByUser("OtpOverEmail");
                            List<String> enabledBackupMethodList = this.settings.getBackupMethodForUserList();
                            List<String> enabledMethodList = this.settings.get2FAMethodForUserList();
                            if (session.getAttribute("considering_backup_method") != null || StringUtils.isNotBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod()) && enabledMethodList.contains(twoFactorUserClass.getCurrent2FAMethod())) {
                                LOGGER.debug("Configured Otp over email as a Backup Method");
                                session.removeAttribute("considering_backup_method");
                            } else if (enabledBackupMethodList.size() != 0) {
                                LOGGER.debug("Backup Method is enabled. Redirecting to Backup Method.");
                                twoFactorUserClass.setCurrent2FAMethod("OtpOverEmail");
                                this.settings.setUserSettings(username, twoFactorUserClass);
                                String url = this.pluginHandler.getInlineRegistrationBackupMethodUrl(request, twoFactorUserClass.getConfigured2FAMethodsByUser(), username);
                                if (StringUtils.isNotBlank((CharSequence)url)) {
                                    response.sendRedirect(url);
                                    return;
                                }
                            } else {
                                LOGGER.debug("Setting otp over email as primary method");
                                twoFactorUserClass.setCurrent2FAMethod("OtpOverEmail");
                            }
                            LOGGER.debug("2FA is Configured successfully");
                            session = request.getSession();
                            session.setAttribute("2fa_verification", (Object)true);
                            session.removeAttribute("executing_2fa_flow");
                            if (this.settings.getShowRemaining2FAMethodsAfterInlineRegistration().booleanValue() && this.settings.get2FAMethodForUserList().size() + this.settings.getBackupMethodForUserList().size() - twoFactorUserClass.getConfigured2FAMethodsByUser().size() > 0) {
                                session.setAttribute("2fa_show_remaining_methods", (Object)true);
                            }
                            this.settings.setUserSettings(username, twoFactorUserClass);
                            this.settings.addTo2FAConfiguredUsersList(username);
                            this.pluginHandler.redirectToValidUrl(request, response);
                            return;
                        }
                        this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Failed", "OTP Over Email");
                        if (errorMessage.size() == 0) {
                            errorMessage.add("OTP is not valid");
                        }
                    } else {
                        this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Failed", "OTP Over Email");
                        LOGGER.debug("OTP is Not valid");
                        errorMessage.add("Invalid OTP entered. Please enter valid OTP.");
                    }
                }
            }
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("errorMessage", errorMessage);
            context.put("successMessage", successMessage);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("baseUrl", this.pluginConfiguration.getBaseUrl());
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            String template = this.pluginSettings.getConfigureOtpOverEmailTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(REGISTRATION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

