/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDirectoryMapping;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorExportDirectories
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorExportDirectories.class);
    @ComponentImport
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    @ComponentImport
    private CrowdService crowdService;
    @ComponentImport
    private UserManager userManager;
    @ComponentImport
    private DirectoryManager directoryManager;
    @ComponentImport
    private ApplicationManager applicationManager;

    public MoTwoFactorExportDirectories(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, CrowdService crowdService, UserManager userManager, DirectoryManager directoryManager, ApplicationManager applicationManager) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.crowdService = crowdService;
        this.userManager = userManager;
        this.directoryManager = directoryManager;
        this.applicationManager = applicationManager;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LOGGER.debug("MoTwoFactorExportDirectories doGet called");
        String pageAccess = this.pluginHandler.getPageAccessForCurrentUser("User_Management");
        if (pageAccess.contains("read")) {
            LOGGER.debug("Valid Admin user found");
            String action = MoTwoFactorUtility.sanitizeText(request.getParameter("action"));
            if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"AllDirectories")) {
                LOGGER.debug("Exporting All Directories");
                this.exportAllDirectories(request, response);
                return;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)action, (CharSequence)"EnabledDirectories")) {
                LOGGER.debug("Exporting Enabled Directories");
                this.exportEnabledDirectories(request, response);
                return;
            }
            LOGGER.debug("Invalid Export action parameter");
        }
        LOGGER.debug("Invalid User or user is not an admin.");
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    private void exportEnabledDirectories(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("exportEnabledDirectories called");
        List<String> enabledList = this.settings.getEnable2FAForDirectoriesList();
        String str = ",Date : " + new Date(System.currentTimeMillis()) + "\n";
        str = str + ",Total 2FA Enabled Directories,: " + enabledList.size() + "\n\n";
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add("#");
        stringJoiner.add("Directory Name");
        str = str + stringJoiner.toString() + "\n";
        int i = 0;
        for (String directoryName : enabledList) {
            stringJoiner = new StringJoiner(",");
            stringJoiner.add("" + ++i);
            stringJoiner.add(directoryName);
            str = str + stringJoiner.toString() + "\n";
        }
        this.pluginHandler.storeAdminsAuditLogs("Enabled Directories", "Export Directories", "-", request);
        response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_2FA_Enabled_Directories.csv\"");
        response.setHeader("Cache-Control", "max-age=0");
        response.setHeader("Pragma", "");
        response.setContentType("text/csv");
        response.getOutputStream().write(str.getBytes());
    }

    private void exportAllDirectories(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("exportAllDirectories called");
        List<String> enabledList = this.settings.getEnable2FAForDirectoriesList();
        String str = ",Date : " + new Date(System.currentTimeMillis()) + "\n";
        str = str + ",Total 2FA Enabled Directories,: " + enabledList.size() + "\n";
        StringJoiner stringJoiner = new StringJoiner(",");
        stringJoiner.add("#");
        stringJoiner.add("Directories Name");
        stringJoiner.add("2FA Enabled");
        str = str + stringJoiner.toString() + "\n";
        List applications = this.applicationManager.findAll();
        ArrayList<Directory> filteredDirectories = new ArrayList<Directory>();
        for (Application application : applications) {
            List directoryMappings = application.getApplicationDirectoryMappings();
            if (!Objects.equals(application.getName(), "crowd")) continue;
            for (ApplicationDirectoryMapping mapping : directoryMappings) {
                Directory directory = mapping.getDirectory();
                filteredDirectories.add(directory);
            }
        }
        int i = 0;
        for (Directory directory : filteredDirectories) {
            stringJoiner = new StringJoiner(",");
            stringJoiner.add("" + ++i);
            stringJoiner.add(directory.getName());
            if (enabledList.contains(directory.getName())) {
                stringJoiner.add("Enabled");
            } else {
                stringJoiner.add("Disabled");
            }
            str = str + stringJoiner.toString() + "\n";
        }
        this.pluginHandler.storeAdminsAuditLogs("All Directories", "Export Directories", "-", request);
        response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_Directories.csv\"");
        response.setHeader("Cache-Control", "max-age=0");
        response.setHeader("Pragma", "");
        response.setContentType("text/csv");
        response.getOutputStream().write(str.getBytes());
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }
}

