/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.gson.JsonObject;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import com.miniorange.twofactor.crowd.webauthn.MoSettings;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorConfigure2FAByUser
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorConfigure2FAByUser.class);
    private static final String CONFIGURE_2FA_BY_USER_VM_PATH = "/templates/com/miniorange/twofactor/crowd/configure2fabyuser.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private UserManager userManager;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private String qrcode;
    private String secretKey;
    private Boolean shareSecretKey;
    private MoSettings webAuthnSettings;

    public MoTwoFactorConfigure2FAByUser(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, UserManager userManager, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings, MoTwoFactorPluginHandler pluginHandler, MoSettings webAuthnSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.userManager = userManager;
        this.pluginSettings = pluginSettings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.webAuthnSettings = webAuthnSettings;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorConfigure2FAByUser doGet called");
        if (!this.pluginSettings.getLicenseVerified().booleanValue()) {
            LOGGER.error("Crowd 2FA Plugin License Not Verified");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && this.canAccessPage(request)) {
            JSONObject jsonObject;
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser();
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            List<String> methodsConfiguredByUser = twoFactorUserClass.getConfigured2FAMethodsByUser();
            this.initializeQrCode(request, twoFactorUserClass);
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", username);
            context.put("enableTwoFactor", BooleanUtils.toBoolean((Boolean)this.settings.getEnableTwoFactor()));
            context.put("qrcode", this.qrcode);
            context.put("shareSecretKey", this.settings.getEnableShareSecretKey());
            if (twoFactorUserClass.getConfigured2FAMethodsByUser().contains("GoogleAuthenticator")) {
                String encryptedSecret = twoFactorUserClass.getTotpSecret();
                String userSalt = twoFactorUserClass.getUserSalt();
                String decryptedString = MoTwoFactorUtility.decryptString(encryptedSecret, this.settings.getEncryptionKey());
                this.secretKey = decryptedString.replaceAll(userSalt, "");
            }
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("secretKey", this.secretKey);
            context.put("googleAuthenticatorConfigured", methodsConfiguredByUser.contains("GoogleAuthenticator"));
            context.put("otpOverEmailConfigured", methodsConfiguredByUser.contains("OtpOverEmail"));
            context.put("otpOverSmsConfigured", methodsConfiguredByUser.contains("OtpOverSms"));
            context.put("securityQuestionConfigured", methodsConfiguredByUser.contains("SecurityQuestion"));
            context.put("backupCodeConfigured", methodsConfiguredByUser.contains("BackupCode"));
            context.put("duoPushNotificationConfigured", methodsConfiguredByUser.contains("DuoPushNotification"));
            context.put("u2fHardwareTokenConfigured", methodsConfiguredByUser.contains("YubikeyHardwareTokenAsU2F"));
            context.put("webAuthnConfigured", methodsConfiguredByUser.contains("WebAuthn"));
            context.put("isSslSetup", StringUtils.contains((CharSequence)this.pluginConfiguration.getBaseUrl(), (CharSequence)"https"));
            context.put("displayEndUserReconfigurationPage", Boolean.TRUE);
            context.put("attestationType", this.settings.getAttestationType());
            context.put("authenticatorType", this.settings.getAuthenticatorType());
            context.put("userVerification", this.settings.getUserVerification());
            context.put("residentKey", this.settings.getResidentKey());
            context.put("currentLoggedInUser", this.pluginConfiguration.getCurrentLoggedInUser());
            List<String> methodForUserList = this.settings.get2FAMethodForUserList();
            List<String> backupMethodForUser = this.settings.getBackupMethodForUserList();
            context.put("methodForUserList", methodForUserList);
            context.put("countryCode", this.settings.getDefaultContryCode());
            MoTwoFactorCommonUserSettings twofactoruserclass = this.settings.getUserSettings(userProfile.getUsername());
            List<String> configuredMethodList = twofactoruserclass.getConfigured2FAMethodsByUser();
            Boolean shouldShowGoogleAuthenticator = this.shouldShowMethod("GoogleAuthenticator", userProfile, methodForUserList, backupMethodForUser);
            context.put("shouldShowGoogleAuthenticator", shouldShowGoogleAuthenticator);
            Boolean shouldShowDuoPushNotification = this.shouldShowMethod("DuoPushNotification", userProfile, methodForUserList, backupMethodForUser);
            context.put("shouldShowDuoPushNotification", shouldShowDuoPushNotification);
            context.put("duoPushNotificationSettingsConfigured", this.pluginHandler.isDuoPushNotificationSettingsConfigured());
            Boolean shouldShowWebAuthn = this.shouldShowMethod("WebAuthn", userProfile, methodForUserList, backupMethodForUser);
            context.put("shouldShowWebAuthn", shouldShowWebAuthn);
            Boolean shouldShowU2FHardwareToken = this.shouldShowMethod("YubikeyHardwareTokenAsU2F", userProfile, methodForUserList, backupMethodForUser);
            context.put("shouldShowU2FHardwareToken", shouldShowU2FHardwareToken);
            Boolean shouldShowOtpOverEmail = this.shouldShowMethod("OtpOverEmail", userProfile, methodForUserList, backupMethodForUser);
            context.put("shouldShowOtpOverEmail", shouldShowOtpOverEmail);
            context.put("smtpConfigured", this.pluginHandler.isSmtpConfigured());
            context.put("customMailServer", this.settings.getCustomMailServer());
            Boolean shouldShowOtpOverSms = this.shouldShowMethod("OtpOverSms", userProfile, methodForUserList, backupMethodForUser);
            context.put("shouldShowOtpOverSms", shouldShowOtpOverSms);
            context.put("smsGatewayConfigured", this.pluginHandler.isSmsGatewayConfigured());
            Boolean shouldShowSecurityQuestion = this.shouldShowMethod("SecurityQuestion", userProfile, methodForUserList, backupMethodForUser);
            context.put("shouldShowSecurityQuestion", shouldShowSecurityQuestion);
            Boolean shouldShowBackupCode = this.shouldShowMethod("BackupCode", userProfile, methodForUserList, backupMethodForUser);
            context.put("shouldShowBackupCode", shouldShowBackupCode);
            context.put("shouldShowBackupCodeWarning", shouldShowBackupCode != false && twoFactorUserClass.getBackupCodes().size() == 0);
            int totalConfiguredMethods = 0;
            if (BooleanUtils.toBoolean((Boolean)shouldShowGoogleAuthenticator)) {
                ++totalConfiguredMethods;
            }
            if (BooleanUtils.toBoolean((Boolean)shouldShowOtpOverSms)) {
                ++totalConfiguredMethods;
            }
            if (BooleanUtils.toBoolean((Boolean)shouldShowOtpOverEmail)) {
                ++totalConfiguredMethods;
            }
            if (BooleanUtils.toBoolean((Boolean)shouldShowSecurityQuestion)) {
                ++totalConfiguredMethods;
            }
            if (BooleanUtils.toBoolean((Boolean)shouldShowBackupCode)) {
                ++totalConfiguredMethods;
            }
            if (BooleanUtils.toBoolean((Boolean)shouldShowDuoPushNotification)) {
                ++totalConfiguredMethods;
            }
            if (BooleanUtils.toBoolean((Boolean)shouldShowU2FHardwareToken)) {
                ++totalConfiguredMethods;
            }
            if (BooleanUtils.toBoolean((Boolean)shouldShowWebAuthn)) {
                ++totalConfiguredMethods;
            }
            String duoPushNotificationEnrollPortalUrl = "";
            try {
                if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isDuoPushNotificationSettingsConfigured())) {
                    LOGGER.debug("Duo Settings Configured");
                    JsonObject jsonObject2 = this.pluginHandler.sendDuoPushNotificationPreauth(username, request);
                    duoPushNotificationEnrollPortalUrl = StringUtils.equalsIgnoreCase((CharSequence)"enroll", (CharSequence)jsonObject2.get("result").getAsString()) ? jsonObject2.get("enroll_portal_url").getAsString() : "ENROLLED";
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while sending Duo Push Notification pre auth request" + e);
            }
            context.put("duoPushNotificationEnrollPortalUrl", duoPushNotificationEnrollPortalUrl);
            context.put("totalConfiguredMethods", totalConfiguredMethods);
            context.put("totalMethodsConfiguredByUser", methodsConfiguredByUser);
            context.put("securityQuestionNumber", this.getSecurityQuestionNumber());
            context.put("downloadBackupCodeUrl", this.pluginConfiguration.getDownloadBackupCodeUrl());
            context.put("backupCodeConfigured", methodsConfiguredByUser.contains("BackupCode"));
            if (this.settings.getSecurityQuestionsList().isEmpty()) {
                this.settings.setSecurityQuestionsList(MoTwoFactorUtility.getQuestionList());
            }
            context.put("questionList", this.settings.getSecurityQuestionsList());
            context.put("is2faEnabled", this.settings.getEnable2FAForUsersList().contains(username));
            context.put("isAdmin", this.pluginHandler.isSystemAdmin());
            context.put("userFullName", userProfile.getFullName());
            context.put("emailAddress", userProfile.getEmail());
            context.put("rememberMeDeviceDetails", twoFactorUserClass.getRememberMeDeviceDetails());
            if (twoFactorUserClass.getRememberMeDeviceDetails().size() > 0) {
                context.put("rememberMeDeviceDetailsMap", this.generateRememberMeDeviceDetailsMap(twoFactorUserClass.getRememberMeDeviceDetails()));
            }
            context.put("currentDefault2faMethod", twoFactorUserClass.getCurrent2FAMethod());
            context.put("allowToReconfigureMethod", this.settings.getAllowToReconfigureConfigured2faMethod());
            context.put("enableEnforceCurrentMethod", this.settings.getEnableEnforce2faMethodForUser());
            context.put("currentIPAddress", MoTwoFactorUtility.getCurrentIpAddress(request, this.settings));
            context.put("contextPath", request.getContextPath());
            context.put("minio_token", this.settings.setCSRFTokenInSession(request));
            if (shouldShowU2FHardwareToken.booleanValue()) {
                HashMap<String, String> hardwareCreds = this.webAuthnSettings.getUserRawId();
                String hardwareCredString = hardwareCreds.get(username);
                if (StringUtils.isEmpty((CharSequence)hardwareCredString)) {
                    hardwareCredString = "{}";
                }
                if (!this.isValidJson(hardwareCredString)) {
                    jsonObject = new JSONObject();
                    jsonObject.put("Previous Credential", hardwareCredString);
                    context.put("hardwareCreds", this.generateWebAuthCredMap(jsonObject));
                    context.put("hardwareCredsString", jsonObject.toString());
                } else {
                    JSONObject hardwareCredsObj = new JSONObject(hardwareCredString);
                    context.put("hardwareCreds", this.generateWebAuthCredMap(hardwareCredsObj));
                    context.put("hardwareCredsString", hardwareCredsObj.toString());
                }
            }
            if (shouldShowWebAuthn.booleanValue()) {
                HashMap<String, String> webAuthnCreds = this.webAuthnSettings.getUserRawIdForWebAuthn();
                String webAuthnCredString = webAuthnCreds.get(username);
                if (StringUtils.isEmpty((CharSequence)webAuthnCredString)) {
                    webAuthnCredString = "{}";
                }
                if (!this.isValidJson(webAuthnCredString)) {
                    jsonObject = new JSONObject();
                    jsonObject.put("Previous Credential", webAuthnCredString);
                    context.put("webAuthnCreds", this.generateWebAuthCredMap(jsonObject));
                    context.put("webAuthnCredsString", jsonObject.toString());
                } else {
                    JSONObject webAuthnCredObj = new JSONObject(webAuthnCredString);
                    context.put("webAuthnCreds", this.generateWebAuthCredMap(webAuthnCredObj));
                    context.put("webAuthnCredsString", webAuthnCredObj.toString());
                }
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(CONFIGURE_2FA_BY_USER_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    private boolean shouldShowMethod(String methodName, UserProfile user, List<String> methodForUserList, List<String> backupMethodForUser) {
        if (user != null && (this.userManager.isSystemAdmin(user.getUserKey()) || this.userManager.isAdmin(user.getUserKey()))) {
            return true;
        }
        if (this.pluginHandler.isPageAllowed(methodName, user.getUsername()).booleanValue()) {
            return BooleanUtils.toBoolean((Boolean)((this.settings.getEnableTwoFactorForSoftware() != false || this.settings.getEnableTwoFactorForJsd() != false) && methodForUserList.contains(methodName) ? 1 : 0)) || BooleanUtils.toBoolean((Boolean)backupMethodForUser.contains(methodName));
        }
        return false;
    }

    private boolean canAccessPage(HttpServletRequest req) {
        HttpSession session = req.getSession();
        return !BooleanUtils.toBoolean((Boolean)((Boolean)session.getAttribute("executing_2fa_flow")));
    }

    private Map<String, List<String>> generateRememberMeDeviceDetailsMap(List<String> rememberMeDeviceDetails) {
        TreeMap<String, List<String>> rememberMeDeviceDetailsMap = new TreeMap<String, List<String>>();
        LOGGER.debug("rememberMeDeviceDetails : " + rememberMeDeviceDetails);
        for (String deviceDetails : rememberMeDeviceDetails) {
            LinkedList<String> mapValues = new LinkedList<String>();
            String osName = deviceDetails.split("=====")[0].trim().split("\\|\\|")[2].trim();
            String browserName = deviceDetails.split("=====")[0].trim().split("\\|\\|")[1].trim();
            String expiryDate = new Date(Long.parseLong(deviceDetails.split("=====")[1].trim())).toString();
            mapValues.add(osName);
            mapValues.add(browserName);
            mapValues.add(expiryDate);
            rememberMeDeviceDetailsMap.put(deviceDetails, mapValues);
        }
        return rememberMeDeviceDetailsMap;
    }

    private Map<String, String> generateWebAuthCredMap(JSONObject credObject) {
        HashMap<String, String> credMap = new HashMap<String, String>();
        Iterator<String> keys = credObject.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            if (!(credObject.get(key) instanceof String)) continue;
            String rId = credObject.getString(key);
            credMap.put(key, rId);
        }
        return credMap;
    }

    private boolean isValidJson(String jsonString) {
        try {
            new JSONObject(jsonString);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    private void initializeQrCode(HttpServletRequest request, MoTwoFactorCommonUserSettings twoFactorUserClass) {
        String crowdInstanceKeyValue;
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        this.secretKey = MoTwoFactorUtility.generateKey();
        HttpSession session = request.getSession();
        if (session.getAttribute("2fa_secret") == null || StringUtils.isBlank((CharSequence)((String)session.getAttribute("2fa_secret")))) {
            session.setAttribute("2fa_secret", (Object)this.secretKey);
        } else {
            this.secretKey = (String)session.getAttribute("2fa_secret");
        }
        this.qrcode = MoTwoFactorUtility.generateQrCode(this.secretKey, username, this.settings.getAppLabel("Crowd"));
        session.setAttribute("2fa_qrcode", (Object)this.qrcode);
        if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getUserSalt())) {
            String userSpecific_salt_key = MoTwoFactorUtility.generateRandomString(10);
            twoFactorUserClass.setUserSalt(userSpecific_salt_key);
            this.settings.setUserSettings(username, twoFactorUserClass);
        }
        if (StringUtils.isEmpty((CharSequence)(crowdInstanceKeyValue = this.settings.getEncryptionKey()))) {
            String crowd_instance_key = MoTwoFactorUtility.generateRandomString(10);
            this.settings.setEncryptionKey(crowd_instance_key);
        }
    }

    private List<String> getSecurityQuestionNumber() {
        int securityQuestionCount = MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_QUESTION_COUNT - MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_CUSTOM_QUESTION_COUNT;
        ArrayList<String> securityQuestionNumber = new ArrayList<String>();
        for (int i = 1; i <= securityQuestionCount; ++i) {
            securityQuestionNumber.add("Question " + i);
        }
        return securityQuestionNumber;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

