/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.Customer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorPluginException;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorCustomerLoginAction
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorCustomerLoginAction.class);
    private static final String CUSTOMERLOGINACCOUNT_VM_PATH = "/templates/com/miniorange/twofactor/crowd/login.vm";
    @ComponentImport
    private UserManager userManager;
    @ComponentImport
    private LoginUriProvider loginUriProvider;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    @ComponentImport
    private I18nHelper i18nHelper;
    @ComponentImport
    private TemplateRenderer renderer;
    public String message = "";
    public ArrayList errorMessage;

    public MoTwoFactorCustomerLoginAction(UserManager userManager, LoginUriProvider loginUriProvider, I18nHelper i18nHelper, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings, MoTwoFactorPluginConfiguration pluginConfiguration, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.i18nHelper = i18nHelper;
        this.pluginSettings = pluginSettings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.renderer = renderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorCustomerLoginAction Servlet doGet() called.");
        LOGGER.info("Register Action validate");
        UserProfile user = this.userManager.getRemoteUser();
        this.message = "";
        this.errorMessage = new ArrayList();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            if (this.pluginSettings.isCustomerRegistered().booleanValue() && this.pluginSettings.getLicenseVerified().booleanValue() && !this.pluginSettings.isTrialLicense().booleanValue() && !this.pluginSettings.isLicenseExpired().booleanValue()) {
                LOGGER.debug("customer is registered, redirecting to the configure action");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/configure");
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(CUSTOMERLOGINACCOUNT_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.info("Login action execute submitted");
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            if (this.pluginSettings.isCustomerRegistered().booleanValue() && this.pluginSettings.getLicenseVerified().booleanValue() && !this.pluginSettings.isTrialLicense().booleanValue() && !this.pluginSettings.isLicenseExpired().booleanValue()) {
                LOGGER.debug("customer is registered, redirecting to the configure action");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/configure");
                return;
            }
            String submitted = MoTwoFactorUtility.sanitizeText(request.getParameter("submitted"));
            String email = MoTwoFactorUtility.sanitizeText(request.getParameter("email"));
            String password = MoTwoFactorUtility.sanitizeText(request.getParameter("password"));
            if (BooleanUtils.toBoolean((String)submitted)) {
                if (StringUtils.isBlank((CharSequence)email)) {
                    this.errorMessage.add(this.i18nHelper.getText("2fa.error.register.email.empty"));
                    response.setContentType("text/html;charset=utf-8");
                    this.renderer.render(CUSTOMERLOGINACCOUNT_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
                }
                if (StringUtils.isBlank((CharSequence)password)) {
                    this.errorMessage.add(this.i18nHelper.getText("2fa.error.register.password.empty"));
                    response.setContentType("text/html;charset=utf-8");
                    this.renderer.render(CUSTOMERLOGINACCOUNT_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
                }
                try {
                    try {
                        Customer customer = this.pluginHandler.fetchCustomer(email, password);
                        this.pluginSettings.setCustomerId(customer.getCustomerId().toString());
                        this.pluginSettings.setCustomerEmail(customer.getEmail());
                        this.pluginSettings.setCustomerAPIKey(customer.getApiKey());
                        this.pluginSettings.setCustomerTokenKey(customer.getTokenKey());
                        this.initializeConfig();
                        response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                        return;
                    }
                    catch (MoTwoFactorPluginException e) {
                        this.errorMessage.add("Invalid username and password.");
                        response.setContentType("text/html;charset=utf-8");
                        this.renderer.render(CUSTOMERLOGINACCOUNT_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while verifying account details", e);
                    this.errorMessage.add("An unknown error occurred. Please check logs and contact us at support-atlassian@miniorange.atlassian.net.");
                    response.setContentType("text/html;charset=utf-8");
                    this.renderer.render(CUSTOMERLOGINACCOUNT_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
                }
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(CUSTOMERLOGINACCOUNT_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    private Map<String, Object> initializeConfig() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", this.message);
        context.put("errorMessage", this.errorMessage);
        context.put("crowdBaseUrl", this.pluginSettings.getBaseUrl());
        context.put("licenseType", this.pluginSettings.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettings.getLicenseExpireDate());
        context.put("isLicenseVerified", this.pluginSettings.getLicenseVerified());
        context.put("isNoOfUserExceed", this.pluginSettings.isNoOfUserExceed());
        context.put("isAdmin", this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey()));
        context.put("pagesAccessibleToUser", this.pluginHandler.getUserAccessiblePages());
        context.put("multiLingualSupportToggle", this.pluginSettings.getMultiLingualSupportToggle());
        context.put("contextPath", this.pluginConfiguration.getBaseUrl());
        return context;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

