/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd;

import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class MoTwoFactorMigrationEvent
implements InitializingBean,
DisposableBean {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorMigrationEvent.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;

    public MoTwoFactorMigrationEvent(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.debug("MoPluginMigrationEvent afterPropertiesSet Called");
        this.migrateIpAddressToIpAddressAndIpCommentsInMap();
        if (!this.settings.getCombineIpAddressAndIpMessage().booleanValue()) {
            LOGGER.debug("Migrating IP Address list to IP Address Map with IP Comments");
            this.migrateWhiteListIpAddressToIpAddressMapWithIpComments();
            this.migrateBlackListIpAddressToIpAddressMapWithIpComments();
            this.settings.setCombineIpAddressAndIpMessage(true);
        } else {
            LOGGER.debug("IP Address list is already migrated to IP Address Map with IP Comments");
        }
        if (!this.settings.getDisableUsersListMigrated().booleanValue()) {
            this.migrateDisableUsersSettings();
            this.settings.setDisableUsersListMigrated(true);
        } else {
            LOGGER.debug("Disabled users settings are already migrated");
        }
        if (!this.settings.getAdvanceSettingMigrate().booleanValue()) {
            LOGGER.debug("Migrating Advance Settings");
            this.settings.setSkip2FAForGivenUrlList(new ArrayList<String>());
            this.pluginHandler.modifyAndSaveStringOfSkip2FAUrls(this.settings.getSkip2faUrls(), null);
            this.settings.setAdvanceSettingMigrate(Boolean.TRUE);
        } else {
            LOGGER.debug("Advance Settings are already migrated");
        }
        if (!this.settings.getConfiguredMobileNumbersMigrated().booleanValue()) {
            this.migrateConfiguredMobileNumbers();
            this.settings.setConfiguredMobileNumbersMigrated(true);
        } else {
            LOGGER.debug("Configured Mobile Numbers are already Migrated");
        }
        this.migrateConfigureTab();
    }

    public void destroy() throws Exception {
    }

    public void migrateConfiguredMobileNumbers() {
        List<String> configuredUsersList = this.settings.getListOf2FAConfiguredUsers();
        TreeMap<String, String> configuredMobileNumbers = new TreeMap<String, String>();
        for (String username : configuredUsersList) {
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getMobileNumber())) continue;
            String mobileNumberWithCountryCode = twoFactorUserClass.getCountryCode() + twoFactorUserClass.getMobileNumber();
            configuredMobileNumbers.put(username, mobileNumberWithCountryCode);
        }
        this.settings.setConfiguredMobileNumbers(configuredMobileNumbers);
        LOGGER.debug("Configured Mobile numbers Migration completed");
    }

    private void migrateConfigureTab() {
        List<String> twoFactorMethodForUserList = this.settings.get2FAMethodForUserList();
        List<String> backupMethodForUserList = this.settings.getBackupMethodForUserList();
        ArrayList<String> allMethodsToggle = new ArrayList<String>(twoFactorMethodForUserList);
        allMethodsToggle.addAll(backupMethodForUserList);
        if (allMethodsToggle.size() > 0 && !allMethodsToggle.contains("GoogleAuthenticator")) {
            this.settings.setTwoFactorForMobileAuthn(Boolean.FALSE);
        }
        this.settings.setTwoFactorForDuopush(Boolean.FALSE);
        this.settings.setTwoFactorForYubikey(Boolean.FALSE);
        this.settings.setTwoFactorForWebAuthn(Boolean.FALSE);
        this.settings.setTwoFactorForOtpOverEmail(Boolean.FALSE);
        this.settings.setTwoFactorForOtpOverSms(Boolean.FALSE);
        this.settings.setTwoFactorForSecurityQuestion(Boolean.FALSE);
        this.settings.setTwoFactorForBackup(Boolean.FALSE);
        Iterator iterator = allMethodsToggle.iterator();
        while (iterator.hasNext()) {
            String twoFactorMethod;
            switch (twoFactorMethod = (String)iterator.next()) {
                case "GoogleAuthenticator": {
                    this.settings.setTwoFactorForMobileAuthn(Boolean.TRUE);
                    break;
                }
                case "DuoPushNotification": {
                    this.settings.setTwoFactorForDuopush(Boolean.TRUE);
                    break;
                }
                case "YubikeyHardwareTokenAsU2F": {
                    this.settings.setTwoFactorForYubikey(Boolean.TRUE);
                    break;
                }
                case "WebAuthn": {
                    this.settings.setTwoFactorForWebAuthn(Boolean.TRUE);
                    break;
                }
                case "OtpOverEmail": {
                    this.settings.setTwoFactorForOtpOverEmail(Boolean.TRUE);
                    break;
                }
                case "OtpOverSms": {
                    this.settings.setTwoFactorForOtpOverSms(Boolean.TRUE);
                    break;
                }
                case "SecurityQuestion": {
                    this.settings.setTwoFactorForSecurityQuestion(Boolean.TRUE);
                    break;
                }
                case "BackupCode": {
                    this.settings.setTwoFactorForBackup(Boolean.TRUE);
                }
            }
        }
    }

    private void migrateIpAddressToIpAddressAndIpCommentsInMap() {
        LOGGER.debug("Migrating IP Addresses with message to IP Address and message Map IP Map");
        if (!this.settings.getCombineIpAddressAndIpMessageInMapMigration().booleanValue()) {
            Map<String, String> whitelistIpAddressWithMessages = this.settings.getWhitelistIpAddressWithMessagesOld();
            Map<String, String> whitelistIpAddressAndMessagesInMap = this.settings.getWhitelistIpAddressWithMessages();
            for (Map.Entry<String, String> entry : whitelistIpAddressWithMessages.entrySet()) {
                if (whitelistIpAddressAndMessagesInMap.get(entry.getKey()) != null) continue;
                whitelistIpAddressAndMessagesInMap.put(entry.getKey(), entry.getValue());
            }
            this.settings.setWhitelistIpAddressAndMessagesInMap(whitelistIpAddressAndMessagesInMap);
            Map<String, String> blacklistIpAddressWithMessages = this.settings.getBlacklistIpAddressWithMessagesOld();
            Map<String, String> blacklistIpAddressAndMessagesInMap = this.settings.getBlacklistIpAddressWithMessages();
            for (Map.Entry<String, String> entry : blacklistIpAddressWithMessages.entrySet()) {
                if (blacklistIpAddressAndMessagesInMap.get(entry.getKey()) != null) continue;
                blacklistIpAddressAndMessagesInMap.put(entry.getKey(), entry.getValue());
            }
            this.settings.setBlacklistIpAddressAndMessagesInMap(blacklistIpAddressAndMessagesInMap);
            this.settings.setCombineIpAddressAndCommentsInMap(true);
            LOGGER.debug("Successfully Migrated IP Addresses with message to IP Address and message Map IP Map");
        }
    }

    private void migrateWhiteListIpAddressToIpAddressMapWithIpComments() {
        LOGGER.debug("Migrating WhiteList IP Addresses - Mapping IP Addresses with IP Comments");
        HashMap<String, String> listOfIpAddressesWithIpComments = new HashMap<String, String>();
        List<String> listOfIpAddresses = this.settings.getWhitelistIpAddresses();
        if (listOfIpAddresses.size() > 0) {
            for (String IpAddress : listOfIpAddresses) {
                int count = IpAddress.split("\\.").length;
                String validIpAddress = count == 1 ? IpAddress.trim() + ".*.*.*" : (count == 2 ? IpAddress.trim() + ".*.*" : (count == 3 ? IpAddress.trim() + ".*" : IpAddress));
                LOGGER.debug("Migrating IP Address = " + validIpAddress);
                listOfIpAddressesWithIpComments.put(validIpAddress, "-");
            }
            this.settings.setWhitelistIpAddressWithMessages(listOfIpAddressesWithIpComments);
            LOGGER.debug("Successfully Migrated WhiteList IP Addresses to IP Address Map with IP Comments");
        } else {
            LOGGER.error("List of IP Addresses is empty. No IP Address is whitelisted yet!");
        }
    }

    private void migrateBlackListIpAddressToIpAddressMapWithIpComments() {
        LOGGER.debug("Migrating BlackList IP Addresses - Mapping IP Addresses with IP Comments");
        HashMap<String, String> listOfIpAddressesWithIpComments = new HashMap<String, String>();
        List<String> listOfIpAddresses = this.settings.getBlacklistIpAddresses();
        if (listOfIpAddresses.size() > 0) {
            for (String IpAddress : listOfIpAddresses) {
                int count = IpAddress.split("\\.").length;
                String validIpAddress = count == 1 ? IpAddress.trim() + ".*.*.*" : (count == 2 ? IpAddress.trim() + ".*.*" : (count == 3 ? IpAddress.trim() + ".*" : IpAddress));
                LOGGER.debug("Migrating IP Address = " + validIpAddress);
                listOfIpAddressesWithIpComments.put(validIpAddress, "-");
            }
            this.settings.setBlacklistIpAddressWithMessages(listOfIpAddressesWithIpComments);
            LOGGER.debug("Successfully Migrated BlackList IP Addresses to IP Address Map with IP Comments");
        } else {
            LOGGER.error("List of IP Addresses is empty. No IP Address is blacklisted yet!");
        }
    }

    private void migrateDisableUsersSettings() {
        List<String> allUsers = this.pluginHandler.getUserFromCrowdUsingUsername("", "AllUsers", "", -1);
        List<String> enabled2FAForUsersList = this.settings.getEnable2FAForUsersList();
        List disable2FAForUsersList = (List)CollectionUtils.subtract(allUsers, enabled2FAForUsersList);
        this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
        LOGGER.debug("destroy method called");
    }
}

