function performActionChange(selectedAction) {
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/view/moapi",
        timeout: 0,
        data: {
            "action": "ChangeUserManagementSelectedAction",
            "selectedAction": selectedAction
        },
        type: "GET",
        success: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        error: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        async: true
    });
}

function performEnable2FAForUser(response, username) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        document.getElementById("tr"+username).style = "";
        var html = "<a onclick=\"return disable2FAForUser('"+username+"')\">Disable 2FA</a>";
        document.getElementById("span"+username).innerHTML = html;
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enabled 2FA for user : '+username+'</p>'
        });
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2fa for user : '+username+'</p>'
        });
    }
}

function performDisable2FAForUser(response, username) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        document.getElementById("tr"+username).style.background = "#f5f5f5";
        var html = "<a onclick=\"return enable2FAForUser('"+username+"')\">Enable 2FA</a>";
        document.getElementById("span"+username).innerHTML = html;
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disabled 2FA for user : '+username+'</p>'
        });
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2fa for user : '+username+'</p>'
        });
    }
}

function performReset2FAForUser(response, username) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        if (document.getElementById("resetspan"+username)) {
            document.getElementById("resetspan"+username).innerHTML = "";
        }
        require('aui/flag')({
            title: 'Resetting 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Reset 2FA for user : '+username+'</p>'
        });
    } else {
        require('aui/flag')({
            title: 'Resetting 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with resetting 2fa for user : '+username+'</p>'
        });
    }
}

function enable2FAForUser(username) {
    require('aui/flag')({
        title: 'Enabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Enabling 2FA for User : '+username+' in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForUser",
            "username": username
        },
        type: "GET",
        success: function (response) {
            performEnable2FAForUser(response, username);
        },
        error: function (response) {
            performEnable2FAForUser(response, username);
        },
        async: true
    });
}

function disable2FAForUser(username) {
    require('aui/flag')({
        title: 'Disabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Disabling 2FA for User : '+username+' in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForUser",
            "username": username
        },
        type: "GET",
        success: function (response) {
            performDisable2FAForUser(response, username);
        },
        error: function (response) {
            performDisable2FAForUser(response, username);
        },
        async: true
    });
}

function reset2FAForUser(username) {
    require('aui/flag')({
        title: 'Resetting 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Resetting 2FA for User : '+username+' in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Reset2faForUser",
            "username": username
        },
        type: "GET",
        success: function (response) {
            performReset2FAForUser(response, username);
        },
        error: function (response) {
            performReset2FAForUser(response, username);
        },
        async: true
    });
}

function enable2faForAllUsers() {
    require('aui/flag')({
        title: 'Enabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Enabling 2FA for All Users in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForAllUsers"
        },
        type: "GET",
        success: function (response) {
            performEnable2faForAllUsers(response);
        },
        error: function (response) {
            performEnable2faForAllUsers(response);
        },
        async: true
    });
}

function performEnable2faForAllUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enabled 2FA for All Users.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Enabling 2FA for All Users</p>'
        });
    }
}

function disable2faForAllUsers() {
    require('aui/flag')({
        title: 'Disabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Disabling 2FA for All Users in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForAllUsers"
        },
        type: "GET",
        success: function (response) {
            performDisable2faForAllUsers(response);
        },
        error: function (response) {
            performDisable2faForAllUsers(response);
        },
        async: true
    });
}

function performDisable2faForAllUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disabled 2FA for All Users.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Disabling 2FA for All Users</p>'
        });
    }
}

function reset2faForAllUsers() {
    require('aui/flag')({
        title: 'Resetting 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Resetting 2FA for All Users in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Reset2faForAllUsers"
        },
        type: "GET",
        success: function (response) {
            performReset2faForAllUsers(response);
        },
        error: function (response) {
            performReset2faForAllUsers(response);
        },
        async: true
    });
}

function performReset2faForAllUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Resetting 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Reset 2FA for All Users.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Resetting 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Resetting 2FA for All Users</p>'
        });
    }
}

function toggleAllUsers() {
    var isChecked = document.getElementById("selectAllUsers").checked;
    var startIndex = document.getElementById("startIndex").value;
    var endIndex = document.getElementById("endIndex").value - 1;

    for (var i=startIndex;i<=endIndex;i++) {
        document.getElementById("selectedUser"+i).checked = isChecked;
    }
}

function toggleAllGroups() {
    var isChecked = document.getElementById("selectAllGroups").checked;
    var startIndex = document.getElementById("startIndex").value;
    var endIndex = document.getElementById("endIndex").value - 1;

    for (var i=startIndex;i<=endIndex;i++) {
        document.getElementById("selectedGroup"+i).checked = isChecked;
    }
}

function toggleAllDirectories() {
    var isChecked = document.getElementById("selectAllDirectories").checked;
    var startIndex = document.getElementById("startIndex").value;
    var endIndex = document.getElementById("endIndex").value - 1;

    for (var i=startIndex;i<=endIndex;i++) {
        document.getElementById("selectedDirectory"+i).checked = isChecked;
    }
}

function toggleAllLockedUsers() {
    var isChecked = document.getElementById("selectAllLockedUsers").checked;
    var startIndex = document.getElementById("startIndex").value;
    var endIndex = document.getElementById("endIndex").value - 1;

    for (var i=startIndex;i<=endIndex;i++) {
        document.getElementById("selectedLockedUser"+i).checked = isChecked;
    }
}

function performBulk2faAction() {
    var action = document.getElementById("bulk2faAction");
    if (action.value =="") {
        document.getElementById("bulk2faAction").style.borderColor = "red";
        alert("Please select valid Bulk Action");
    } else {
        document.getElementById("bulk2faAction").style.borderColor = "";
        var startIndex = document.getElementById("startIndex").value;
        var endIndex = document.getElementById("endIndex").value - 1;

        switch (action.value) {
            case "Enable 2FA For Selected Users":
                enable2faForSelectedUsers(startIndex, endIndex);
                break;
            case "Disable 2FA For Selected Users":
                disable2faForSelectedUsers(startIndex, endIndex);
                break;
            case "Reset 2FA For Selected Users":
                reset2faForSelectedUsers(startIndex, endIndex);
                break;

            case "Enable 2FA For All Users":
                enable2faForAllUsers();
                break;
            case "Disable 2FA For All Users":
                disable2faForAllUsers();
                break;
            case "Reset 2FA For All Users":
                reset2faForAllUsers();
                break;
            case "Enable 2FA For Selected Groups":
                enable2faForSelectedGroups(startIndex, endIndex);
                break;
            case "Disable 2FA For Selected Groups":
                disable2faForSelectedGroups(startIndex, endIndex);
                break;
            case "Enable 2FA For All Groups":
                enable2faForAllGroups();
                break;
            case "Disable 2FA For All Groups":
                disable2faForAllGroups();
                break;
            case "Enable 2FA For Selected Directories":
                enable2faForSelectedDirectories(startIndex, endIndex);
                break;
            case "Disable 2FA For Selected Directories":
                disable2faForSelectedDirectories(startIndex, endIndex);
                break;
            case "Enable 2FA For All Directories":
                enable2faForAllDirectories();
                break;
            case "Disable 2FA For All Directories":
                disable2faForAllDirectories();
                break;
            case "Remove Selected Locked Users":
                removeSelectedLockedUsers(startIndex, endIndex);
                break;
            case "Remove All Locked Users":
                removeAllLockedUsers();
                break;
        }
    }
}

function performDisable2FAForSelectedGroups(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disabled 2FA for Selected Groups.</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2FA for Selected Group.</p>'
        });
    }
}

function disable2faForSelectedGroups(startIndex, endIndex) {
    var isGroupSelected = false;
    var selectedGroups = new Array();

    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedGroup"+i).checked;
        if (isChecked == true) {
            isGroupSelected = true;
            selectedGroups.push(document.getElementById("selectedGroup"+i).value);
        }
    }
    if (isGroupSelected == true) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Disabling 2FA for Selected Groups in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "Disable2faForSelectedGroups",
                "selectedGroups":selectedGroups
            },
            type: "GET",
            success: function (response) {
                performDisable2FAForSelectedGroups(response);
            },
            error: function (response) {
                performDisable2FAForSelectedGroups(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>No Group is selected. Please select valid Groups.</p>'
        });
    }
}

function performEnable2FAForSelectedGroups(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enabled 2FA for Selected Groups.</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2FA for Selected Group.</p>'
        });
    }
}

function enable2faForSelectedGroups(startIndex, endIndex) {
    var isGroupSelected = false;
    var selectedGroups = new Array();
    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedGroup"+i).checked;
        if (isChecked == true) {
            isGroupSelected = true;
            selectedGroups.push(document.getElementById("selectedGroup"+i).value);
        }
    }

    if (isGroupSelected == true) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Enabling 2FA for Selected Groups in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "Enable2faForSelectedGroups",
                "selectedGroups":selectedGroups
            },
            type: "GET",
            success: function (response) {
                performEnable2FAForSelectedGroups(response);
            },
            error: function (response) {
                performEnable2FAForSelectedGroups(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>No Group is selected. Please select valid Groups.</p>'
        });
    }
}

function performReset2FAForSelectedUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Resetting 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Reset 2FA for Selected Users.</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Resetting 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with resetting 2fa for Selected Users.</p>'
        });
    }
}

function reset2faForSelectedUsers(startIndex, endIndex) {
    var isCustomerSelected = false;
    var selectedUsers = new Array();
    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedUser"+i).checked;
        if (isChecked == true) {
            isCustomerSelected = true;
            selectedUsers.push(document.getElementById("selectedUser"+i).value);
        }
    }

    if (isCustomerSelected == true) {
        require('aui/flag')({
            title: 'Resetting 2FA',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Resetting 2FA for Selected Users in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "Reset2faForSelectedUsers",
                "selectedUsers":selectedUsers
            },
            type: "GET",
            success: function (response) {
                performReset2FAForSelectedUsers(response);
            },
            error: function (response) {
                performReset2FAForSelectedUsers(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
            title: 'Resetting 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>No user is selected. Please select valid user.</p>'
        });
    }
}

function performDisable2FAForSelectedUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disabled 2FA for Selected Users.</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2fa for Selected Users.</p>'
        });
    }
}

function disable2faForSelectedUsers(startIndex, endIndex) {
    var isCustomerSelected = false;
    var selectedUsers = new Array();
    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedUser"+i).checked;
        if (isChecked == true) {
            isCustomerSelected = true;
            selectedUsers.push(document.getElementById("selectedUser"+i).value);
        }
    }

    if (isCustomerSelected == true) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Disabling 2FA for Selected Users in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "Disable2faForSelectedUsers",
                "selectedUsers":selectedUsers
            },
            type: "GET",
            success: function (response) {
                performDisable2FAForSelectedUsers(response);
            },
            error: function (response) {
                performDisable2FAForSelectedUsers(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>No user is selected. Please select valid user.</p>'
        });
    }
}

function performEnable2FAForSelectedUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enabled 2FA for Selected Users.</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2fa for Selected Users.</p>'
        });
    }
}

function enable2faForSelectedUsers(startIndex, endIndex) {
    var isCustomerSelected = false;
    var selectedUsers = new Array();
    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedUser"+i).checked;
        if (isChecked == true) {
            isCustomerSelected = true;
            selectedUsers.push(document.getElementById("selectedUser"+i).value);
        }
    }

    if (isCustomerSelected == true) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Enabling 2FA for Selected Users in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "Enable2faForSelectedUsers",
                "selectedUsers":selectedUsers
            },
            type: "GET",
            success: function (response) {
                performEnable2FAForSelectedUsers(response);
            },
            error: function (response) {
                performEnable2FAForSelectedUsers(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>No user is selected. Please select valid user.</p>'
        });
    }
}

function performEnable2FAForGroup(response, groupname) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        document.getElementById("tr"+groupname).style = "";
        var html = "<a onclick=\"return disable2FAForGroup('"+groupname+"')\">Disable 2FA</a>";
        document.getElementById("span"+groupname).innerHTML = html;

        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enabled 2FA for Group : '+groupname+'</p>'
        });
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2fa for Group : '+groupname+'</p>'
        });
    }
}

function performDisable2FAForGroup(response, groupname) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        document.getElementById("tr"+groupname).style.background = "#f5f5f5";
        var html = "<a onclick=\"return enable2FAForGroup('"+groupname+"')\">Enable 2FA</a>";
        document.getElementById("span"+groupname).innerHTML = html;

        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disabled 2FA for Group : '+groupname+'</p>'
        });
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2fa for Group : '+groupname+'</p>'
        });
    }
}

function enable2faForAllGroups() {
    require('aui/flag')({
        title: 'Enabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Enabling 2FA for All Group in background. You can still access Crowd, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForAllGroups"
        },
        type: "GET",
        success: function (response) {
            performEnable2faForAllGroups(response);
        },
        error: function (response) {
            performEnable2faForAllGroups(response);
        },
        async: true
    });
}

function performEnable2faForAllGroups(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enable 2FA for All Groups</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2fa for user : '+username+'</p>'
        });
    }
}

function disable2faForAllGroups() {
    require('aui/flag')({
        title: 'Disabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Disabling 2FA for All Group in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForAllGroups"
        },
        type: "GET",
        success: function (response) {
            performDisable2faForAllGroups(response);
        },
        error: function (response) {
            performDisable2faForAllGroups(response);
        },
        async: true
    });
}

function performDisable2faForAllGroups(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disable 2FA for All Groups</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Disabling 2fa for All Groups.</p>'
        });
    }
}

function enable2FAForGroup(groupname) {
    require('aui/flag')({
        title: 'Enabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Enabling 2FA for Group : '+groupname+' in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForGroup",
            "groupname": groupname
        },
        type: "GET",
        success: function (response) {
            performEnable2FAForGroup(response, groupname);
        },
        error: function (response) {
            performEnable2FAForGroup(response, groupname);
        },
        async: true
    });
}

function disable2FAForGroup(groupname) {
    require('aui/flag')({
        title: 'Disabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Disabling 2FA for Group : '+groupname+' in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForGroup",
            "groupname": groupname
        },
        type: "GET",
        success: function (response) {
            performDisable2FAForGroup(response, groupname);
        },
        error: function (response) {
            performDisable2FAForGroup(response, groupname);
        },
        async: true
    });
}

function performEnable2FAForDirectory(response, directoryname) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        document.getElementById("tr"+directoryname).style = "";
        var html = "<a onclick=\"return disable2faForDirectory('"+directoryname+"')\">Disable 2FA</a>";
        document.getElementById("span"+directoryname).innerHTML = html;

        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enabled 2FA for Directory : '+directoryname+'</p>'
        });
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2fa for Directory : '+directoryname+'</p>'
        });
    }
}

function performDisable2FAForDirectory(response, directoryname) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        document.getElementById("tr"+directoryname).style.background = "#f5f5f5";
        var html = "<a onclick=\"return enable2FAForDirectory('"+directoryname+"')\">Enable 2FA</a>";
        document.getElementById("span"+directoryname).innerHTML = html;

        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disabled 2FA for Directory : '+directoryname+'</p>'
        });
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2fa for Directory: ' + directoryname + ' - ' + response.statusText + '</p>'
        });
    }
}

function enable2faForAllDirectories() {
    require('aui/flag')({
        title: 'Enabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Enabling 2FA for All Directory in background. You can still access Crowd, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForAllDirectories"
        },
        type: "GET",
        success: function (response) {
            performEnable2faForAllDirectories(response);
        },
        error: function (response) {
            performEnable2faForAllDirectories(response);
        },
        async: true
    });
}

function performEnable2faForAllDirectories(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enable 2FA for All Directories</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2fa for user : '+username+'</p>'
        });
    }
}

function disable2faForAllDirectories() {
    require('aui/flag')({
        title: 'Disabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Disabling 2FA for All Directory in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForAllDirectories"
        },
        type: "GET",
        success: function (response) {
            performDisable2faForAllDirectories(response);
        },
        error: function (response) {
            performDisable2faForAllDirectories(response);
        },
        async: true
    });
}

function performDisable2faForAllDirectories(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disable 2FA for All Directories</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Disabling 2fa for All Directories.</p>'
        });
    }
}

function enable2FAForDirectory(directoryname) {
    require('aui/flag')({
        title: 'Enabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Enabling 2FA for Directory : '+directoryname+' in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForDirectory",
            "directoryname": directoryname
        },
        type: "GET",
        success: function (response) {
            performEnable2FAForDirectory(response, directoryname);
        },
        error: function (response) {
            performEnable2FAForDirectory(response, directoryname);
        },
        async: true
    });
}

function disable2faForDirectory(directoryname) {
    require('aui/flag')({
        title: 'Disabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Disabling 2FA for Directory : '+directoryname+' in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2FAForDirectory",
            "directoryname": directoryname
        },
        type: "GET",
        success: function (response) {
            performDisable2FAForDirectory(response, directoryname);
        },
        error: function (response) {
            performDisable2FAForDirectory(response, directoryname);
        },
        async: true
    });
}


function exportDirectories() {
    var action;
    if (document.getElementById("directorySearchFilterAllDirectories").selected == true) {
        action = "AllDirectories";
    } else {
        action = "EnabledDirectories";
    }
    window.location.href = document.getElementById("exportDirectoriesUrlId").value+"?action="+action;
}

function performDisable2FAForSelectedDirectories(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disabled 2FA for Selected Directories.</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with disabling 2FA for Selected Directory.</p>'
        });
    }
}

function disable2faForSelectedDirectories(startIndex, endIndex) {
    var isDirectorySelected = false;
    var selectedDirectories = new Array();

    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedDirectory"+i).checked;
        if (isChecked == true) {
            isDirectorySelected = true;
            selectedDirectories.push(document.getElementById("selectedDirectory"+i).value);
        }
    }
    if (isDirectorySelected == true) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Disabling 2FA for Selected Directories in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "Disable2faForSelectedDirectories",
                "selectedDirectories":selectedDirectories
            },
            type: "GET",
            success: function (response) {
                performDisable2FAForSelectedDirectories(response);
            },
            error: function (response) {
                performDisable2FAForSelectedDirectories(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>No Directory is selected. Please select valid Directories.</p>'
        });
    }
}

function performEnable2FAForSelectedDirectories(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enabled 2FA for Selected Directories.</p>'
        });

        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with enabling 2FA for Selected Directory.</p>'
        });
    }
}

function enable2faForSelectedDirectories(startIndex, endIndex) {
    var isDirectorySelected = false;
    var selectedDirectories = new Array();
    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedDirectory"+i).checked;
        if (isChecked == true) {
            isDirectorySelected = true;
            selectedDirectories.push(document.getElementById("selectedDirectory"+i).value);
        }
    }

    if (isDirectorySelected == true) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Enabling 2FA for Selected Directories in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "Enable2faForSelectedDirectories",
                "selectedDirectories":selectedDirectories
            },
            type: "GET",
            success: function (response) {
                performEnable2FAForSelectedDirectories(response);
            },
            error: function (response) {
                performEnable2FAForSelectedDirectories(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>No Directory is selected. Please select valid Directories.</p>'
        });
    }
}

function removeLockedUser(username) {
    require('aui/flag')({
        title: 'Locked User',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Removing Locked user : '+username+' from list in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "RemoveLockedUser",
            "username": username
        },
        type: "GET",
        success: function (response) {
            performRemoveLockedUser(response, username);
        },
        error: function (response) {
            performRemoveLockedUser(response, username);
        },
        async: true
    });
}

function performRemoveLockedUser(response, username) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Locked User',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Removed Locked User '+username+' from list.</p>'
        });

        setTimeout(function() {
            window.location.href = window.location.pathname;
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Locked User',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Removing Locked user '+username+' from list.</p>'
        });
    }
}

function removeSelectedLockedUsers(startIndex, endIndex) {
    var isUserSelected = false;
    var selectedLockedUserList = new Array();
    for (var i=startIndex;i<=endIndex;i++) {
        var isChecked = document.getElementById("selectedLockedUser"+i).checked;
        if (isChecked == true) {
            isUserSelected = true;
            selectedLockedUserList.push(document.getElementById("selectedLockedUser"+i).value);
        }
    }

    if (isUserSelected == true) {
        require('aui/flag')({
            title: 'Locked Users',
            type: 'info',
            close: 'never',
            body: '<p>We are currently Removing Selected Locked Users in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
        });
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
            timeout: 0,
            data: {
                "action": "RemoveSelectedLockedUsers",
                "selectedLockedUserList":selectedLockedUserList
            },
            type: "GET",
            success: function (response) {
                performRemoveSelectedLockedUsers(response);
            },
            error: function (response) {
                performRemoveSelectedLockedUsers(response);
            },
            async: true
        });
    } else {
        require('aui/flag')({
            title: 'Locked Users',
            type: 'error',
            close: 'auto',
            body: '<p>No User is selected. Please select valid the Users.</p>'
        });
    }
}

function performRemoveSelectedLockedUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Locked Users',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Removed selected Locked User from list.</p>'
        });

        setTimeout(function() {
            window.location.href = window.location.pathname;
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Locked Users',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Removing Locked Users from list.</p>'
        });
    }
}

function removeAllLockedUsers() {
    require('aui/flag')({
        title: 'Locked Users',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Removing All Locked Users in background. You can still access Crowd, although performance may be impacted.</p><br><div class="mo-loading"><div>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "RemoveAllLockedUsers"
        },
        type: "GET",
        success: function (response) {
            performRemoveAllLockedUsers(response);
        },
        error: function (response) {
            performRemoveAllLockedUsers(response);
        },
        async: true
    });
}

function performRemoveAllLockedUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }
    if (response.status == 200) {
        require('aui/flag')({
            title: 'Locked Users',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Removed All Locked Users from list.</p>'
        });

        setTimeout(function() {
            window.location.href = window.location.pathname;
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Locked Users',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Removing All Locked Users from list.</p>'
        });
    }
}

function exportUsers() {
    require('aui/flag')({
        title: 'Exporting Users',
        type: 'info',
        close: 'manual',
        body: '<p>We are currently preparing export file in the background.<br>Please do not close or navigate away from this page till the export gets completed.</p><br>'
    });
    var action;
    if (document.getElementById("userSearchFilterAllUsers").selected === true) {
        action = "AllUsers";
    } else if (document.getElementById("userSearchFilterEnabledUsers").selected === true) {
        action = "EnabledUsers";
    } else if(document.getElementById("userSearchFilterDisabledUsers").selected === true) {
        action = "DisabledUsers"
    }
    else {
        action = "ConfiguredUsers";
    }
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/exportUsers",
        timeout: 0,
        data: {
            "action": action
        },
        success: function (data, status, xhr) {
            console.log("success");
            // Extract the filename from the Content-Disposition header
            var filename = "";

            var contentDisposition = xhr.getResponseHeader('Content-Disposition');
            if (contentDisposition && contentDisposition.indexOf('attachment') !== -1) {
                var filenameRegex = /filename[^;=\n]*=((['"]).*?\2|[^;\n]*)/;
                var matches = filenameRegex.exec(contentDisposition);
                if (matches != null && matches[1]) {
                    filename = matches[1].replace(/['"]/g, '');
                }
            }
            // Create a Blob and create a link to trigger the download
            var blob = new Blob([data], { type: 'text/csv' });
            var link = document.createElement('a');
            link.href = window.URL.createObjectURL(blob);
            link.download = filename || 'download.csv';
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            window.location=window.location;

        },
        error: function (xhr, status, error) {
            console.log("Error while exporting users.")
        },
        async: true
    });
}

function exportGroups() {
    var action;
    if (document.getElementById("groupSearchFilterAllGroups").selected == true) {
        action = "AllGroups";
    } else {
        action = "EnabledGroups";
    }
    window.location.href = document.getElementById("exportGroupsUrlId").value+"?action="+action;
}
function performDisable2faForAllUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Disabled 2FA for All Users.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Disabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Disabling 2FA for All Users</p>'
        });
    }
}
function performEnable2faForAllUsers(response) {
    var a = document.getElementsByClassName("aui-flag");
    for (var i=a.length-1;i>=0;i--) {
        a[i].remove();
    }

    if (response.status == 200) {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'success',
            close: 'auto',
            body: '<p>Successfully Enabled 2FA for All Users.</p>'
        });
        setTimeout(function() {
            location.reload();
        }, 2000);
    } else {
        require('aui/flag')({
            title: 'Enabling 2FA',
            type: 'error',
            close: 'auto',
            body: '<p>Issue with Enabling 2FA for All Users</p>'
        });
    }
}
function disable2faForAllUsers() {
    require('aui/flag')({
        title: 'Disabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Disabling 2FA for All Users in background. You can still access Crowd, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Disable2faForAllUsers"
        },
        type: "GET",
        success: function (response) {
            performDisable2faForAllUsers(response);
        },
        error: function (response) {
            performDisable2faForAllUsers(response);
        },
        async: true
    });
}
function enable2faForAllUsers() {
    require('aui/flag')({
        title: 'Enabling 2FA',
        type: 'info',
        close: 'never',
        body: '<p>We are currently Enabling 2FA for All Users in background. You can still access Crowd, although performance may be impacted.</p><p><aui-spinner size="large"></aui-spinner></p>'
    });
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/twofactor/edit/moapi",
        timeout: 0,
        data: {
            "action": "Enable2faForAllUsers"
        },
        type: "GET",
        success: function (response) {
            performEnable2faForAllUsers(response);
        },
        error: function (response) {
            performEnable2faForAllUsers(response);
        },
        async: true
    });
}
function confirmEnableOrDisable2FAForAllUsers() {
    var dialog = new AJS.Dialog({
        width: 500,
        height: 150,
        id: "confirm-dialog",
        closeOnOutsideClick: true
    });
    if (AJS.$("#enable2FAForAllUsers")[0].checked == true) {
        dialog.addPanel("Panel 1", "<p>Are you sure you want to <b>Enable 2FA for all users</b>?</p>", "panel-body");
        dialog.addButton("Yes", function (dialog) {
            dialog.hide();
            enable2faForAllUsers();
        });
        dialog.addLink("No", function (dialog) {
            dialog.hide();
            AJS.$("#enable2FAForAllUsers")[0].checked = false;
        }, "#");
        dialog.show();
    } else {
        dialog.addPanel("Panel 1", "<p>Are you sure you want to <b>Disable 2FA for all users</b>?</p>", "panel-body");
        dialog.addButton("Yes", function (dialog) {
            dialog.hide();
            disable2faForAllUsers();
        });
        dialog.addLink("No", function (dialog) {
            dialog.hide();
            AJS.$("#enable2FAForAllUsers")[0].checked = true;
        }, "#");
        dialog.show();
    }
}
function openCloseElemenet(elementId){
    document.getElementById(elementId).classList.toggle("showElement");
}