/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.miniorange.twofactor.crowd.webauthn.utils.AuthenticationExtensionsClientInputs;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.bouncycastle.crypto.digests.SHA256Digest;

public class CollectedClientData {
    String type;
    String challenge;
    String origin;
    String hashAlgorithm;
    String tokenBindingId;
    AuthenticationExtensionsClientInputs clientExtensions;
    AuthenticationExtensionsClientInputs authenticatorExtensions;

    CollectedClientData() {
    }

    public static CollectedClientData decode(String json) {
        Gson gson = new Gson();
        try {
            return gson.fromJson(json, CollectedClientData.class);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    public String encode() {
        Gson gson = new Gson();
        return gson.toJson(this);
    }

    public byte[] getHash() {
        String json = this.encode();
        try {
            return CollectedClientData.digest(json.getBytes(StandardCharsets.UTF_8), this.hashAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return CollectedClientData.sha256Digest(json.getBytes(StandardCharsets.UTF_8));
        }
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getHashAlg() {
        return this.hashAlgorithm;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setChallenge(String challenge) {
        this.challenge = challenge;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public String getTokenBinding() {
        return this.tokenBindingId;
    }

    public String getType() {
        return this.type;
    }

    public AuthenticationExtensionsClientInputs getClientExtensions() {
        return this.clientExtensions;
    }

    public AuthenticationExtensionsClientInputs getAuthenticatorExtensions() {
        return this.authenticatorExtensions;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.challenge, this.origin, this.hashAlgorithm, this.tokenBindingId, this.clientExtensions, this.authenticatorExtensions);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CollectedClientData)) {
            return false;
        }
        return this.encode().equals(((CollectedClientData)obj).encode());
    }

    public static byte[] digest(byte[] input, String alg) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance(alg);
        return digest.digest(input);
    }

    public static byte[] sha256Digest(byte[] input) {
        SHA256Digest digest = new SHA256Digest();
        digest.update(input, 0, input.length);
        byte[] result = new byte[digest.getDigestSize()];
        digest.doFinal(result, 0);
        return result;
    }
}

