/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.servlets;

import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.io.BaseEncoding;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.miniorange.twofactor.crowd.webauthn.MoPluginManager;
import com.miniorange.twofactor.crowd.webauthn.MoSettings;
import com.miniorange.twofactor.crowd.webauthn.utils.MoHttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DataStore
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(DataStore.class);
    private MoSettings moSettings;
    private final SecureRandom random = new SecureRandom();
    @ComponentImport
    private I18nResolver i18nResolver;
    private String platform;
    private MoPluginManager moPluginManager;

    @Autowired
    public DataStore(I18nResolver i18nResolver, MoSettings moSettings, MoPluginManager moPluginManager) {
        this.moSettings = moSettings;
        this.i18nResolver = i18nResolver;
        this.moPluginManager = moPluginManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.platform = this.i18nResolver.getText("my.plugin.platform");
        LOGGER.debug("In MoSecureUtil" + request.getParameter("action"));
        switch (request.getParameter("action")) {
            case "setRawId": {
                this.setRawId(request, response);
                break;
            }
            case "getRawId": {
                this.getRawId(request, response);
                break;
            }
            case "CheckUserIsRegistered": {
                this.CheckUserIsRegistered(request.getParameter("username"), response);
                break;
            }
            case "clearPlugin": {
                this.clearPlugin(request, response);
            }
            case "printMap": {
                this.printMap(request, response);
                break;
            }
            case "getUserConfigTemplate": {
                this.getUserConfigTemplate(request, response);
                break;
            }
            case "getWebAuthnConfiguration": {
                this.getWebAuthnConfiguration(request, response);
                break;
            }
            default: {
                LOGGER.debug("Could not found");
            }
        }
    }

    private void getWebAuthnConfiguration(HttpServletRequest req, HttpServletResponse resp) {
        try {
            JsonObject result = new JsonObject();
            result.addProperty("enableWebAuthn", this.moSettings.getEnableWebAuthn());
            result.addProperty("forceWebAuthn", this.moSettings.getForceWebAuthn());
            Boolean isLicenseValid = (this.moPluginManager.isLicenseValid() != false || this.moPluginManager.isEvaluationOrSubscriptionLicense() == false) && this.moPluginManager.isLicenseDefined();
            result.addProperty("isLicenseValid", isLicenseValid);
            this.sendSuccessResponse(result.toString(), resp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getRawId(HttpServletRequest req, HttpServletResponse resp) {
        try {
            JsonObject result = new JsonObject();
            JsonArray resArray = new JsonArray();
            String user = this.moSettings.getCurrentLoggedInUser();
            LOGGER.debug(" User is :- " + user);
            if (user.equals("test")) {
                user = this.moSettings.getCurrentLoggedInUser();
            }
            LOGGER.debug("User is :- " + user);
            HashMap<Object, Object> userRawId = new HashMap();
            userRawId = StringUtils.equalsIgnoreCase((CharSequence)req.getParameter("authMethod"), (CharSequence)"webAuthentication") ? this.moSettings.getUserRawIdForWebAuthn() : this.moSettings.getUserRawId();
            if (userRawId.containsKey(user)) {
                LOGGER.debug("THe user is present in the RawId");
            } else {
                LOGGER.debug("The user does not presenti n the rawID");
            }
            String RawId = (String)userRawId.get(user);
            if (!this.isValidJson(RawId)) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Previous Credential", RawId);
                RawId = jsonObject.toString();
            }
            JSONObject credObject = new JSONObject(RawId);
            Iterator<String> keys = credObject.keys();
            while (keys.hasNext()) {
                String key = keys.next();
                if (!(credObject.get(key) instanceof String)) continue;
                JsonObject allowCredential = new JsonObject();
                String rId = credObject.getString(key);
                allowCredential.addProperty("type", "public-key");
                allowCredential.addProperty("id", rId);
                resArray.add(allowCredential);
            }
            LOGGER.debug("base URL = " + this.moSettings.getApplicationBaseUrl());
            String rpId = Iterables.get(Splitter.on("//").split(this.moSettings.getApplicationBaseUrl()), 1);
            LOGGER.debug("rpId = " + rpId);
            if (rpId.contains(":")) {
                rpId = Iterables.get(Splitter.on(':').split(rpId), 0);
                LOGGER.debug("effective rpId = " + rpId);
            }
            result.addProperty("rpId", rpId);
            byte[] challenge = new byte[32];
            this.random.nextBytes(challenge);
            result.addProperty("challenge", BaseEncoding.base64().encode(challenge));
            result.add("allowCredential", resArray);
            ArrayList postParameters = new ArrayList();
            JsonObject extentions = new JsonObject();
            extentions.addProperty("appId", "");
            result.add("extentions", extentions);
            this.sendSuccessResponse(result.toString(), resp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setRawId(HttpServletRequest req, HttpServletResponse resp) {
        try {
            JSONObject credObject;
            String rawId = req.getParameter("rawId");
            String credName = req.getParameter("credName");
            LOGGER.debug("Username is in setRawId:- " + req.getParameter("username"));
            String user = req.getParameter("username") == "" ? this.moSettings.getCurrentLoggedInUser() : req.getParameter("username");
            HashMap<Object, Object> userRawId = new HashMap();
            userRawId = StringUtils.equalsIgnoreCase((CharSequence)req.getParameter("authMethod"), (CharSequence)"WebAuthn") ? this.moSettings.getUserRawIdForWebAuthn() : this.moSettings.getUserRawId();
            String rId = "{}";
            if (userRawId.containsKey(user) && !this.isValidJson(rId = (String)userRawId.get(user))) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("Previous Credential", rId);
                rId = jsonObject.toString();
            }
            if ((credObject = new JSONObject(rId)).has(credName)) {
                credName = credName + "(1)";
            }
            credObject.put(credName, rawId);
            userRawId.put(user, credObject.toString());
            if (StringUtils.equalsIgnoreCase((CharSequence)req.getParameter("authMethod"), (CharSequence)"WebAuthn")) {
                this.moSettings.setUserRawIdForWebAuthn(userRawId);
            } else {
                this.moSettings.setUserRawId(userRawId);
            }
            JsonObject result = new JsonObject();
            result.addProperty("sendSuccessful", "true");
            result.addProperty("rawId", rawId + "helloLEtsSeeIfItChanges");
            this.sendSuccessResponse(result.toString(), resp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void CheckUserIsRegistered(String username, HttpServletResponse resp) {
        try {
            username = this.moSettings.getCurrentLoggedInUser();
            HashMap<String, String> map = this.moSettings.getCredParamMap();
            List<String> webauthnDisabledUsers = this.moSettings.getListOfWebAuthnDisabledUsers();
            LOGGER.debug("Printing map :- " + map);
            boolean isUserRegistered = map.containsKey(username);
            boolean isWebauthnDisabled = webauthnDisabledUsers.contains(username);
            boolean isUserActive = false;
            String doesUserExist = null;
            try {
                ArrayList<NameValuePair> postParameters = new ArrayList<NameValuePair>();
                postParameters.add(new BasicNameValuePair("action", "userActiveAndExist"));
                postParameters.add(new BasicNameValuePair("username", username));
                String url = this.moSettings.getApplicationBaseUrl() + "/plugins/servlet/webAuthn/MoUtils";
                LOGGER.debug("URL is :- " + url);
                String response = MoHttpUtils.sendPostRequest(url, postParameters, "application/x-www-form-urlencoded", null);
                LOGGER.debug("Response is ;- " + response);
                JsonObject jsonObject = new JsonParser().parse(response).getAsJsonObject();
                LOGGER.debug("The value int it is  :- " + jsonObject.get("isUserActive").getAsBoolean());
                isUserActive = jsonObject.get("isUserActive").getAsBoolean();
                doesUserExist = jsonObject.get("doesUserExist").getAsString();
            }
            catch (Exception e) {
                LOGGER.debug("Exception occurred :- " + e);
            }
            JsonObject result = new JsonObject();
            result.addProperty("checkUserIsRegistered", isUserRegistered);
            result.addProperty("doesUserExist", doesUserExist);
            result.addProperty("isUserActive", isUserActive);
            result.addProperty("isWebauthnDisabled", isWebauthnDisabled);
            Boolean isLicenseValid = (this.moPluginManager.isLicenseValid() != false || this.moPluginManager.isEvaluationOrSubscriptionLicense() == false) && this.moPluginManager.isLicenseDefined();
            result.addProperty("isLicenseValid", isLicenseValid);
            this.sendSuccessResponse(result.toString(), resp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendSuccessResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void clearPlugin(HttpServletRequest req, HttpServletResponse resp) {
        LOGGER.debug("Clearing plugin settings");
        this.moSettings.clearPluginSetting();
    }

    private void printMap(HttpServletRequest req, HttpServletResponse resp) {
        try {
            HashMap<String, String> CredParamMap = this.moSettings.getCredParamMap();
            LOGGER.debug(" Printing CredParamMap :- " + CredParamMap);
            HashMap<String, String> UserParamMap = this.moSettings.getUserCredMap();
            LOGGER.debug(" Printing UserParamMap :- " + UserParamMap);
            HashMap<String, String> userRawId = this.moSettings.getUserRawId();
            LOGGER.debug(" Printing userRawId :- " + userRawId);
            JsonObject result = new JsonObject();
            result.addProperty("checkUserIsRegistered", "false");
            this.sendSuccessResponse(result.toString(), resp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isValidJson(String jsonString) {
        try {
            new JSONObject(jsonString);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void getUserConfigTemplate(HttpServletRequest req, HttpServletResponse resp) {
        try {
            LOGGER.debug("Inside the getUserConfigTemplate");
            String loginTemplate = IOUtils.toString((InputStream)DataStore.class.getResourceAsStream("/templates/defaultLoginTemplateBamboo.ftl"), (String)"UTF-8");
            LOGGER.debug("Login TEmplate is :- " + loginTemplate);
            JsonObject result = new JsonObject();
            result.addProperty("temp", loginTemplate);
            this.sendSuccessResponse(result.toString(), resp);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

