/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistrationSecurityQuestion
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistrationSecurityQuestion.class);
    private static final String BACKUPMETHOD_VM_PATH = "/templates/com/miniorange/twofactor/crowd/inlineregistration_securityquestion.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorInlineRegistrationSecurityQuestion(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationSecurityQuestion doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "InlineRegistration_SecurityQuestion").booleanValue()) {
            int securityQuestionCount = MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_QUESTION_COUNT - MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_CUSTOM_QUESTION_COUNT;
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            if (this.settings.getSecurityQuestionsList().isEmpty()) {
                this.settings.setSecurityQuestionsList(MoTwoFactorUtility.getQuestionList());
            }
            context.put("questionList", this.settings.getSecurityQuestionsList());
            context.put("errorMessage", new ArrayList());
            context.put("securityQuestionNumber", this.getSecurityQuestionNumber(securityQuestionCount));
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextPath", this.pluginConfiguration.getBaseUrl());
            String template = this.pluginSettings.getConfigureSecurityQuestionTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(BACKUPMETHOD_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationSecurityQuestion doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            int securityQuestionCount = MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_QUESTION_COUNT - MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_CUSTOM_QUESTION_COUNT;
            ArrayList<String> errorMessage = new ArrayList<String>();
            TreeMap<String, String> securityQuestionAnswer = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            for (int i = 0; i < securityQuestionCount; ++i) {
                if (request.getParameter("question_" + i) == null || request.getParameter("answer_" + i) == null) {
                    errorMessage.add("Please enter unique and valid question-answers");
                    break;
                }
                String key = request.getParameter("question_" + i).trim();
                String value = request.getParameter("answer_" + i).trim();
                if (StringUtils.isNotEmpty((CharSequence)key) && StringUtils.isNotEmpty((CharSequence)value) && !StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"Select Security Question")) {
                    if (BooleanUtils.toBoolean((Boolean)securityQuestionAnswer.containsKey(key))) {
                        errorMessage.add("Security Question must be unique");
                        break;
                    }
                    try {
                        value = MoTwoFactorUtility.hashString(value.toLowerCase());
                    }
                    catch (NoSuchAlgorithmException e) {
                        LOGGER.error("Error " + e);
                    }
                } else {
                    errorMessage.add("Please select valid question answer");
                    break;
                }
                securityQuestionAnswer.put(key, value);
            }
            String key = request.getParameter("custom_question").trim();
            String value = request.getParameter("custom_answer").trim();
            LOGGER.debug("hash Custom Question Value " + value);
            if (StringUtils.isNotEmpty((CharSequence)key) && StringUtils.isNotEmpty((CharSequence)value)) {
                if (BooleanUtils.toBoolean((Boolean)securityQuestionAnswer.containsKey(key))) {
                    errorMessage.add("Security Question must be unique");
                } else {
                    try {
                        value = MoTwoFactorUtility.hashString(value.toLowerCase());
                    }
                    catch (NoSuchAlgorithmException e) {
                        LOGGER.error("Error " + e);
                    }
                    securityQuestionAnswer.put(key, value);
                }
            } else {
                errorMessage.add("Please enter valid Custom question answer");
            }
            if (errorMessage.isEmpty()) {
                LOGGER.debug("2FA is Configured successfully");
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Successful", "Security Question");
                HttpSession session = request.getSession();
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                twoFactorUserClass.setSecurityQuestionAnswer(securityQuestionAnswer);
                twoFactorUserClass.setConfigured2FAMethodsByUser("SecurityQuestion");
                List<String> enabledBackupMethodList = this.settings.getBackupMethodForUserList();
                LOGGER.debug("CONSIDERING_BACKUP_METHOD : " + session.getAttribute("considering_backup_method"));
                List<String> enabledMethodList = this.settings.get2FAMethodForUserList();
                if (session.getAttribute("considering_backup_method") != null || StringUtils.isNotBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod()) && enabledMethodList.contains(twoFactorUserClass.getCurrent2FAMethod())) {
                    LOGGER.debug("Configured Security questions as a Backup Method");
                    session.removeAttribute("considering_backup_method");
                } else if (enabledBackupMethodList.size() != 0) {
                    LOGGER.debug("Backup Method is enabled. Redirecting to Backup Method.");
                    twoFactorUserClass.setCurrent2FAMethod("SecurityQuestion");
                    this.settings.setUserSettings(username, twoFactorUserClass);
                    String url = this.pluginHandler.getInlineRegistrationBackupMethodUrl(request, twoFactorUserClass.getConfigured2FAMethodsByUser());
                    if (StringUtils.isNotBlank((CharSequence)url)) {
                        response.sendRedirect(url);
                        return;
                    }
                } else {
                    LOGGER.debug("Setting up security questions as primary method");
                    twoFactorUserClass.setCurrent2FAMethod("SecurityQuestion");
                }
                session = request.getSession();
                session.setAttribute("2fa_verification", (Object)true);
                session.removeAttribute("executing_2fa_flow");
                if (this.settings.getShowRemaining2FAMethodsAfterInlineRegistration().booleanValue() && this.settings.get2FAMethodForUserList().size() + this.settings.getBackupMethodForUserList().size() - twoFactorUserClass.getConfigured2FAMethodsByUser().size() > 0) {
                    session.setAttribute("2fa_show_remaining_methods", (Object)true);
                }
                this.settings.setUserSettings(username, twoFactorUserClass);
                this.settings.addTo2FAConfiguredUsersList(username);
                this.pluginHandler.redirectToValidUrl(request, response);
                return;
            }
            LOGGER.error("Failed to configure Security Questions");
            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Failed", "Security Question");
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            context.put("username", displayName);
            if (this.settings.getSecurityQuestionsList().isEmpty()) {
                this.settings.setSecurityQuestionsList(MoTwoFactorUtility.getQuestionList());
            }
            context.put("questionList", this.settings.getSecurityQuestionsList());
            context.put("errorMessage", errorMessage);
            context.put("securityQuestionNumber", this.getSecurityQuestionNumber(securityQuestionCount));
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextPath", this.pluginConfiguration.getBaseUrl());
            String template = this.pluginSettings.getConfigureSecurityQuestionTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(BACKUPMETHOD_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    private List<String> getSecurityQuestionNumber(int securityQuestionCount) {
        ArrayList<String> securityQuestionNumber = new ArrayList<String>();
        for (int i = 1; i <= securityQuestionCount; ++i) {
            securityQuestionNumber.add("Question " + i);
        }
        return securityQuestionNumber;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

