/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.google.gson.Gson;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonAuditLogDetails;
import com.miniorange.twofactor.crowd.common.service.MoAdminsAuditService;
import com.miniorange.twofactor.crowd.common.service.MoLogEntityService;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.StringJoiner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorExportAuditLogs
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorExportAuditLogs.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoLogEntityService service;
    private MoAdminsAuditService moAdminsAuditService;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorExportAuditLogs(MoTwoFactorCommonPluginSettings settings, MoLogEntityService service, MoAdminsAuditService moAdminsAuditService, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        LOGGER.debug("MoTwoFactorExportAuditLogs constructor called...");
        this.settings = settings;
        this.service = service;
        this.moAdminsAuditService = moAdminsAuditService;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("MoTwoFactorExportAuditLogs doGet() called...");
        String pageAccess = this.pluginHandler.getPageAccessForCurrentUser("Audit_Logs");
        if (pageAccess.contains("read")) {
            LOGGER.debug("Valid Admin user found");
            String username = MoTwoFactorUtility.sanitizeText(request.getParameter("user_name"));
            String ip = MoTwoFactorUtility.sanitizeText(request.getParameter("ip_"));
            String action = MoTwoFactorUtility.sanitizeText(request.getParameter("action_"));
            String period = MoTwoFactorUtility.sanitizeText(request.getParameter("period_"));
            String type = MoTwoFactorUtility.sanitizeText(request.getParameter("logtype"));
            String clearLogs = MoTwoFactorUtility.sanitizeText(request.getParameter("clearLogs"));
            LOGGER.debug("type :" + type);
            ArrayList<HashMap> filteredAuditLogsList = new ArrayList<HashMap>();
            List<Object> filteredOldAuditLogsList = new ArrayList();
            ArrayList<HashMap> filteredAdminsAuditLogsList = new ArrayList<HashMap>();
            ArrayList<MoTwoFactorCommonAuditLogDetails> auditLogsObjects = new ArrayList<MoTwoFactorCommonAuditLogDetails>();
            if (StringUtils.isNotBlank((CharSequence)type) && type.equals("old")) {
                try {
                    filteredOldAuditLogsList = this.pluginHandler.getOldLogs(this.settings.getAuditLogs(), username, ip, action, period);
                }
                catch (ParseException e) {
                    LOGGER.error("Error :", e);
                }
                Gson gson = new Gson();
                for (int counter = 0; counter < filteredOldAuditLogsList.size(); ++counter) {
                    MoTwoFactorCommonAuditLogDetails backToObject = gson.fromJson((String)filteredOldAuditLogsList.get(counter), MoTwoFactorCommonAuditLogDetails.class);
                    auditLogsObjects.add(backToObject);
                }
            } else {
                if (StringUtils.isNotBlank((CharSequence)type) && type.equals("bothLogs")) {
                    String performedBy = request.getParameter("performedBySearchKeyword");
                    String performedOn = request.getParameter("performedOnSearchKeyword");
                    String details = request.getParameter("moreDetailsSearchKeyword");
                    String adminsAuditLogsCsv = this.pluginHandler.exportAdminAuditLogs(performedBy, performedOn, details, action, period, filteredAdminsAuditLogsList, clearLogs, pageAccess, request, response);
                    String auditLogsCsv = this.pluginHandler.exportAuditLogs(action, period, username, ip, filteredAuditLogsList, clearLogs, request, response);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream);
                    zipOutputStream.putNextEntry(new ZipEntry("Crowd_2FA_Authentication_Audit_Logs.csv"));
                    zipOutputStream.write(auditLogsCsv.getBytes());
                    zipOutputStream.closeEntry();
                    zipOutputStream.putNextEntry(new ZipEntry("Crowd_2FA_Configuration_Audit_Logs.csv"));
                    zipOutputStream.write(adminsAuditLogsCsv.getBytes());
                    zipOutputStream.closeEntry();
                    zipOutputStream.close();
                    response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_Logs.zip\"");
                    response.setHeader("Cache-Control", "max-age=0");
                    response.setHeader("Pragma", "");
                    response.setContentType("application/zip");
                    response.getOutputStream().write(byteArrayOutputStream.toByteArray());
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)type) && type.equals("adminsAuditLogs")) {
                    String performedBy = request.getParameter("performedBySearchKeyword");
                    String performedOn = request.getParameter("performedOnSearchKeyword");
                    String details = request.getParameter("moreDetailsSearchKeyword");
                    String adminsAuditLogsCsv = this.pluginHandler.exportAdminAuditLogs(performedBy, performedOn, details, action, period, filteredAdminsAuditLogsList, clearLogs, pageAccess, request, response);
                    response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_2FA_Configuration_Audit_Logs.csv\"");
                    response.setHeader("Cache-Control", "max-age=0");
                    response.setHeader("Pragma", "");
                    response.setContentType("text/csv");
                    response.getOutputStream().write(adminsAuditLogsCsv.getBytes());
                    return;
                }
                String auditLogsCsv = this.pluginHandler.exportAuditLogs(action, period, username, ip, filteredAuditLogsList, clearLogs, request, response);
                response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_2FA_Authentication_Audit_Logs.csv\"");
                response.setHeader("Cache-Control", "max-age=0");
                response.setHeader("Pragma", "");
                response.setContentType("text/csv");
                response.getOutputStream().write(auditLogsCsv.getBytes());
                return;
            }
            this.pluginHandler.storeAdminsAuditLogs("Old Audit Logs", "Export Logs", "-", request);
            if (StringUtils.isNotBlank((CharSequence)type) && type.equals("old")) {
                String str = ",,Date : " + new Date(System.currentTimeMillis()) + "\n";
                StringJoiner stringJoiner = new StringJoiner(",");
                stringJoiner.add("Sr.no");
                stringJoiner.add("Username");
                stringJoiner.add("Date");
                stringJoiner.add("IP Address");
                stringJoiner.add("Action");
                stringJoiner.add("2FA Method");
                str = str + stringJoiner.toString() + "\n";
                int listCounter = 0;
                for (int counter = 0; counter < auditLogsObjects.size(); ++counter) {
                    stringJoiner = new StringJoiner(",");
                    stringJoiner.add("" + ++listCounter);
                    stringJoiner.add(((MoTwoFactorCommonAuditLogDetails)auditLogsObjects.get(counter)).getUsername());
                    stringJoiner.add(((MoTwoFactorCommonAuditLogDetails)auditLogsObjects.get(counter)).getLoginDateWithTime());
                    stringJoiner.add(((MoTwoFactorCommonAuditLogDetails)auditLogsObjects.get(counter)).getIpAddress());
                    stringJoiner.add(((MoTwoFactorCommonAuditLogDetails)auditLogsObjects.get(counter)).getAction());
                    stringJoiner.add(((MoTwoFactorCommonAuditLogDetails)auditLogsObjects.get(counter)).getLoginMethod());
                    str = str + stringJoiner.toString() + "\n";
                }
                response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_2FA_Old_Audit_Logs.csv\"");
                response.setHeader("Cache-Control", "max-age=0");
                response.setHeader("Pragma", "");
                response.setContentType("text/csv");
                response.getOutputStream().write(str.getBytes());
            }
            return;
        }
        LOGGER.debug("Invalid User or user is not an admin.");
        this.pluginHandler.redirectToValidUrl(request, response);
    }
}

