/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import com.miniorange.twofactor.crowd.webauthn.MoSettings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorAjaxCallsUserServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoTwoFactorAjaxCallsUserServlet.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private MoSettings moSettings;
    private Boolean responseSent;

    public MoTwoFactorAjaxCallsUserServlet(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings, MoSettings moSettings) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
        this.moSettings = moSettings;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("Calling Ajax with user access");
        this.responseSent = Boolean.FALSE;
        String action = MoTwoFactorUtility.sanitizeText(request.getParameter("action"));
        LOGGER.debug("action to perform :" + action);
        if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
            LOGGER.error("Invalid license found");
            this.sendErrorResponse("Invalid License Found", response);
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)this.pluginConfiguration.getCurrentLoggedInUser())) {
            if (StringUtils.equals((CharSequence)action, (CharSequence)"SendOtpOverEmail")) {
                this.sendOtpOverEmail(request, response);
                return;
            }
            if (StringUtils.equals((CharSequence)action, (CharSequence)"SendOtpOverSms")) {
                this.sendOtpOverSms(request, response);
                return;
            }
        } else {
            this.sendErrorResponse("username is blank", response);
        }
        if (!this.pluginHandler.isTwoFactorVerifiedOrIsTwoFactorDisabled(request).booleanValue()) {
            LOGGER.error("Either 2FA is not verified by the user or 2FA is disabled for them");
            this.sendErrorResponse("Not enough permission", response);
            return;
        }
        if (StringUtils.equals((CharSequence)action, (CharSequence)"SetAsDefault2fa")) {
            this.setAsDefault2fa(request, response, MoTwoFactorUtility.sanitizeText(request.getParameter("method")));
            return;
        }
        if (!this.settings.getAllowToReconfigureConfigured2faMethod().booleanValue()) {
            LOGGER.debug("Insufficient Access to perform " + action);
            this.sendErrorResponse("Not enough permission", response);
            return;
        }
        String CurrentLoggedInUser = this.pluginConfiguration.getCurrentLoggedInUser();
        if (this.pluginHandler.isSystemAdmin().booleanValue() || BooleanUtils.toBoolean((Boolean)this.settings.getEnableTwoFactorForSoftware()) && this.settings.getEnable2FAForUsersList().contains(CurrentLoggedInUser)) {
            switch (action) {
                case "Reset": {
                    this.reset2FA(request, response);
                    break;
                }
                case "clear_previous_credentials_for_webAuthn": {
                    this.clear_credentials_for_webAuth(request, response);
                    break;
                }
                case "RemoveDeviceDetails": {
                    this.removeDeviceDetails(request, response);
                    break;
                }
                case "EnableBackupCode": {
                    this.enableBackupCode(request, response);
                    break;
                }
                case "DisableBackupCode": {
                    this.disableBackupCode(request, response);
                    break;
                }
                case "ChangeBackupCode": {
                    this.changeBackupCode(request, response);
                    break;
                }
                default: {
                    response.setContentType("application/json");
                    response.sendError(405, "The requested method is not allowed. Choose valid Method");
                    return;
                }
            }
        }
    }

    private void sendOtpOverEmail(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block7: {
            LOGGER.debug("Calling sendOtpOverEmail");
            String username = this.pluginConfiguration.getCurrentLoggedInUser();
            if (this.pluginHandler.isSystemAdmin().booleanValue() || this.settings.getEnable2FAForUsersList().contains(username) && (this.settings.get2FAMethodForUserList().contains("OtpOverEmail") || this.settings.getBackupMethodForUserList().contains("OtpOverEmail")) && this.settings.getEnableTwoFactor().booleanValue()) {
                if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isSmtpConfigured()) || this.settings.getCustomMailServer().booleanValue()) {
                    try {
                        UserProfile user = this.pluginConfiguration.getCrowdUser();
                        LOGGER.debug("Sending OTP to: " + user.getEmail());
                        String message = this.pluginHandler.sendOtpOnEmail(request, user);
                        if (StringUtils.equalsIgnoreCase((CharSequence)message, (CharSequence)"Success")) {
                            LOGGER.debug("Successfully Send OTP on Email : " + user.getEmail());
                            this.sendSuccessFullResponse("Success", response);
                            break block7;
                        }
                        this.sendErrorResponse("Error", response);
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error : " + e);
                        this.sendErrorResponse("Error", response);
                    }
                } else {
                    this.sendErrorResponse("No SMTP Configured", response);
                }
            } else {
                LOGGER.error("The user is not allowed to access this as 2FA for crowd is disabled or 2FA for user is disabled or Otp Over Email method is not enabled");
                this.sendErrorResponse("Not enough permission to send otp, please contact your administrator", response);
            }
        }
    }

    private void sendOtpOverSms(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("sendOtpOverSms Called");
        String csrf_token = request.getParameter("csrf_token");
        LOGGER.debug("Token" + csrf_token);
        if (!this.settings.isValidCSRFToken(request, csrf_token)) {
            this.sendErrorResponse("csrf token missing", response);
        } else {
            LOGGER.debug("coming in else condition");
            String username = this.pluginConfiguration.getCurrentLoggedInUser();
            if (this.pluginHandler.isSystemAdmin().booleanValue() || this.settings.getEnable2FAForUsersList().contains(username) && (this.settings.get2FAMethodForUserList().contains("OtpOverSms") || this.settings.getBackupMethodForUserList().contains("OtpOverSms")) && this.settings.getEnableTwoFactor().booleanValue()) {
                if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isSmsGatewayConfigured())) {
                    try {
                        UserProfile user = this.pluginConfiguration.getCrowdUser(username);
                        String countryCode = MoTwoFactorUtility.sanitizeText(request.getParameter("countryCode"));
                        String mobileNumber = MoTwoFactorUtility.sanitizeText(request.getParameter("mobileNumber"));
                        LOGGER.debug("Sending OTP to: " + username + " on mobile : " + countryCode + " " + mobileNumber);
                        this.pluginHandler.sendOtpOnSms(request, user, countryCode, mobileNumber);
                        LOGGER.debug("Successfully Sent OTP on SMS : " + countryCode + " " + mobileNumber);
                        this.sendSuccessFullResponse("Success", response);
                    }
                    catch (Exception e) {
                        LOGGER.debug("An error occurred while sending the OTP over SMS " + e);
                        this.sendErrorResponse("Error", response);
                    }
                } else {
                    LOGGER.debug("SMS Gateway Not Configured");
                    this.sendErrorResponse("SMS Gateway Not Configured", response);
                }
            } else {
                LOGGER.error("The user is not allowed to access this as 2FA for crowd is disabled or 2FA for user is disabled or Otp Over Sms method is not enabled");
                this.sendErrorResponse("Not enough permission to send otp, please contact your administrator", response);
            }
        }
    }

    private void setAsDefault2fa(HttpServletRequest request, HttpServletResponse response, String method) throws IOException {
        block6: {
            String username;
            LOGGER.debug("Calling setAsDefault2fa");
            if (this.settings.getEnableEnforce2faMethodForUser().booleanValue()) {
                LOGGER.error("Can't set " + method + " as default as a different method is enforced by the administrator");
                this.sendErrorResponse("Error", response);
            }
            if (StringUtils.isNotBlank((CharSequence)(username = this.pluginConfiguration.getCurrentLoggedInUser()))) {
                try {
                    MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                    if (this.settings.get2FAMethodForUserList().contains(method) && twoFactorUserClass.getConfigured2FAMethodsByUser().contains(method)) {
                        LOGGER.debug("Setting default 2FA method to : " + method);
                        twoFactorUserClass.setCurrent2FAMethod(method);
                        this.settings.setUserSettings(username, twoFactorUserClass);
                        LOGGER.debug("Successfully set default 2fa method to : " + method);
                        this.sendSuccessFullResponse("Success", response);
                        break block6;
                    }
                    LOGGER.error("Cannot set " + method + "as default as it is not configured by user: " + username + "or " + method + "is not enabled as a 2FA method by admin");
                    this.sendErrorResponse("Error", response);
                }
                catch (Exception e) {
                    LOGGER.error("Issue with Setting Default 2FA : " + e);
                    this.sendErrorResponse("Error", response);
                }
            } else {
                response.sendRedirect(this.pluginConfiguration.getBaseUrl());
                return;
            }
        }
    }

    private void changeBackupCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling changeBackupCode");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                LOGGER.debug("Changing Backup Code for : " + username);
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                List<String> backupCodes = this.pluginHandler.generateBackupCode();
                twoFactorUserClass.setBackupCodes(this.pluginHandler.encodeBackupCode(backupCodes));
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Successful", "Backup Code");
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully Changed Backup Code for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                LOGGER.error("Issue with Changing Backup Code : " + e);
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Failed", "Backup Code");
                this.sendErrorResponse("Error", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void disableBackupCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disableBackupCode");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Disabling Backup Code for : " + username);
                List<String> configured2FAByUserList = twoFactorUserClass.getConfigured2FAMethodsByUser();
                if (configured2FAByUserList.size() == 1) {
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    configuredUser.remove(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                configured2FAByUserList.removeAll(Collections.singleton("BackupCode"));
                twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAByUserList);
                twoFactorUserClass.setBackupCodes(new ArrayList<String>());
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully Disable Backup Code for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                LOGGER.error("Issue with Disabling Backup Code : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void enableBackupCode(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enableBackupCode");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Enabling Backup Code for : " + username);
                List<String> backupCodes = this.pluginHandler.generateBackupCode();
                twoFactorUserClass.setBackupCodes(this.pluginHandler.encodeBackupCode(backupCodes));
                twoFactorUserClass.setConfigured2FAMethodsByUser("BackupCode");
                this.settings.setUserSettings(username, twoFactorUserClass);
                List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                if (!configuredUser.contains(username)) {
                    configuredUser.add(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Successful", "Backup Code");
                LOGGER.debug("Successfully Enabled Backup Code for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Failed", "Backup Code");
                LOGGER.error("Issue with Removing Backup Code : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void removeDeviceDetails(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeDeviceDetails");
        try {
            String deviceDetails = MoTwoFactorUtility.sanitizeText(request.getParameter("deviceDetails").trim());
            String username = MoTwoFactorUtility.sanitizeText(request.getParameter("username").trim());
            LOGGER.debug("Removing Device Details : " + deviceDetails + " for Username : " + username);
            MoTwoFactorCommonUserSettings twoFactorCommonUserSettings = this.settings.getUserSettings(username);
            List<String> rememberMeDeviceDetails = twoFactorCommonUserSettings.getRememberMeDeviceDetails();
            rememberMeDeviceDetails.removeAll(Collections.singleton(deviceDetails));
            twoFactorCommonUserSettings.setRememberMeDeviceDetails(rememberMeDeviceDetails);
            this.settings.setUserSettings(username, twoFactorCommonUserSettings);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Device Details : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void clear_credentials_for_webAuth(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling clear_credentials_for_webAuth");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Resetting webAuthn for : " + username);
                HashMap<Object, Object> userRawId = new HashMap();
                userRawId = this.moSettings.getUserRawIdForWebAuthn();
                JSONObject credObj = new JSONObject();
                userRawId.put(username, credObj.toString());
                this.moSettings.setUserRawIdForWebAuthn(userRawId);
                List<String> configured2FAByUserList = twoFactorUserClass.getConfigured2FAMethodsByUser();
                if (configured2FAByUserList.size() == 1) {
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    configuredUser.remove(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                configured2FAByUserList.removeAll(Collections.singleton("WebAuthn"));
                twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAByUserList);
                LOGGER.debug("Current 2fa Method : " + twoFactorUserClass.getCurrent2FAMethod());
                if (StringUtils.equalsIgnoreCase((CharSequence)twoFactorUserClass.getCurrent2FAMethod(), (CharSequence)"WebAuthn")) {
                    twoFactorUserClass.setCurrent2FAMethod(this.pluginHandler.getPrimaryConfigured2faMethod(configured2FAByUserList));
                }
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully cleared webAuthn for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                LOGGER.error("Issue with clearing webAuthn  : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have permissions to clear webAuthn 2FA for user.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void reset2FA(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling Reset 2FA method");
        String method = MoTwoFactorUtility.sanitizeText(request.getParameter("method"));
        LOGGER.debug("Current 2FA Reset method : " + method);
        try {
            if (StringUtils.containsIgnoreCase((CharSequence)method, (CharSequence)"GoogleAuthenticator")) {
                this.resetGoogleAuthenticator(request, response);
            } else if (StringUtils.containsIgnoreCase((CharSequence)method, (CharSequence)"SecurityQuestion")) {
                this.resetSecurityQuestion(request, response);
            } else if (StringUtils.containsIgnoreCase((CharSequence)method, (CharSequence)"OtpOverEmail")) {
                this.resetOtpOverEmail(request, response);
            } else if (StringUtils.containsIgnoreCase((CharSequence)method, (CharSequence)"OtpOverSms")) {
                this.resetOtpOverSms(request, response);
            } else if (StringUtils.containsIgnoreCase((CharSequence)method, (CharSequence)"DuoPushNotification")) {
                this.resetDuoPushNotification(request, response);
            } else if (StringUtils.containsIgnoreCase((CharSequence)method, (CharSequence)"YubikeyHardwareTokenAsU2F")) {
                this.resetU2FHardwareToken(request, response);
            }
        }
        catch (Exception e) {
            LOGGER.error("Issue with Setting Default 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void resetDuoPushNotification(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling resetDuoPushNotification");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Resetting Duo Push Notification for : " + username);
                List<String> configured2FAByUserList = twoFactorUserClass.getConfigured2FAMethodsByUser();
                if (configured2FAByUserList.size() == 1) {
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    configuredUser.remove(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                configured2FAByUserList.removeAll(Collections.singleton("DuoPushNotification"));
                twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAByUserList);
                LOGGER.debug("Current 2fa Method : " + twoFactorUserClass.getCurrent2FAMethod());
                if (StringUtils.equalsIgnoreCase((CharSequence)twoFactorUserClass.getCurrent2FAMethod(), (CharSequence)"DuoPushNotification")) {
                    twoFactorUserClass.setCurrent2FAMethod(this.pluginHandler.getPrimaryConfigured2faMethod(configured2FAByUserList));
                }
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully Reset Duo Push Notification for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                LOGGER.error("Issue with Resetting Duo Push Notification : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void resetU2FHardwareToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling resetU2FHardwareToken");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Resetting Hardware Token for : " + username);
                HashMap<String, String> userRawId = this.moSettings.getUserRawId();
                JSONObject credObj = new JSONObject();
                userRawId.put(username, credObj.toString());
                this.moSettings.setUserRawId(userRawId);
                List<String> configured2FAByUserList = twoFactorUserClass.getConfigured2FAMethodsByUser();
                if (configured2FAByUserList.size() == 1) {
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    configuredUser.remove(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                configured2FAByUserList.removeAll(Collections.singleton("YubikeyHardwareTokenAsU2F"));
                twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAByUserList);
                twoFactorUserClass.setHardwareTokenU2FDeviceDetails(new HashMap<String, String>());
                LOGGER.debug("Current 2fa Method : " + twoFactorUserClass.getCurrent2FAMethod());
                if (StringUtils.equalsIgnoreCase((CharSequence)twoFactorUserClass.getCurrent2FAMethod(), (CharSequence)"YubikeyHardwareTokenAsU2F")) {
                    twoFactorUserClass.setCurrent2FAMethod(this.pluginHandler.getPrimaryConfigured2faMethod(configured2FAByUserList));
                }
                this.settings.setIsWebAuthnConfigured(username, false);
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully Reset Hardware Token for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                LOGGER.error("Error occured while resetting hardware token " + e);
                LOGGER.error("Issue with Resetting Hardware Token : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            LOGGER.error("You don't have an access to reset the yubikey method for user.");
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void resetOtpOverSms(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling resetOtpOverSms");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                HttpSession session = request.getSession(true);
                session.removeAttribute("sms_otp_code");
                session.removeAttribute("txId");
                session.removeAttribute("otp_expiry_time");
                session.removeAttribute("last_otp_sent_time");
                session.removeAttribute("countryCode");
                session.removeAttribute("mobileNumber");
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Resetting OTP Over SMS for : " + username);
                LOGGER.debug("Before resetting: twoFactorUserClass : " + twoFactorUserClass);
                List<String> configured2FAByUserList = twoFactorUserClass.getConfigured2FAMethodsByUser();
                if (configured2FAByUserList.size() == 1) {
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    configuredUser.remove(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                configured2FAByUserList.removeAll(Collections.singleton("OtpOverSms"));
                twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAByUserList);
                LOGGER.debug("Current 2fa Method : " + twoFactorUserClass.getCurrent2FAMethod());
                if (StringUtils.equalsIgnoreCase((CharSequence)twoFactorUserClass.getCurrent2FAMethod(), (CharSequence)"OtpOverSms")) {
                    twoFactorUserClass.setCurrent2FAMethod(this.pluginHandler.getPrimaryConfigured2faMethod(configured2FAByUserList));
                }
                twoFactorUserClass.setMobileNumber("");
                twoFactorUserClass.setCountryCode("");
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("After resetting: twoFactorUserClass : " + twoFactorUserClass);
                LOGGER.debug("Successfully Reset OTP Over SMS for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                LOGGER.error("Issue with Resetting OTP Over SMS : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void resetOtpOverEmail(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling resetOtpOverEmail");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                HttpSession session = request.getSession(true);
                session.removeAttribute("otp_code");
                session.removeAttribute("otp_expiry_time");
                session.removeAttribute("last_email_otp_sent_time");
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Resetting OTP Over Email for : " + username);
                List<String> configured2FAByUserList = twoFactorUserClass.getConfigured2FAMethodsByUser();
                if (configured2FAByUserList.size() == 1) {
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    configuredUser.remove(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                configured2FAByUserList.removeAll(Collections.singleton("OtpOverEmail"));
                twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAByUserList);
                LOGGER.debug("Current 2fa Method : " + twoFactorUserClass.getCurrent2FAMethod());
                if (StringUtils.equalsIgnoreCase((CharSequence)twoFactorUserClass.getCurrent2FAMethod(), (CharSequence)"OtpOverEmail")) {
                    twoFactorUserClass.setCurrent2FAMethod(this.pluginHandler.getPrimaryConfigured2faMethod(configured2FAByUserList));
                }
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully Reset OTP Over Email for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                LOGGER.error("Issue with Resetting OTP Over Email : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void resetSecurityQuestion(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling resetSecurityQuestion");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Resetting Security Question for : " + username);
                List<String> configured2FAByUserList = twoFactorUserClass.getConfigured2FAMethodsByUser();
                if (configured2FAByUserList.size() == 1) {
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    configuredUser.remove(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                configured2FAByUserList.removeAll(Collections.singleton("SecurityQuestion"));
                twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAByUserList);
                twoFactorUserClass.setSecurityQuestionAnswer(new HashMap<String, String>());
                LOGGER.debug("Current 2fa Method : " + twoFactorUserClass.getCurrent2FAMethod());
                if (StringUtils.equalsIgnoreCase((CharSequence)twoFactorUserClass.getCurrent2FAMethod(), (CharSequence)"SecurityQuestion")) {
                    twoFactorUserClass.setCurrent2FAMethod(this.pluginHandler.getPrimaryConfigured2faMethod(configured2FAByUserList));
                }
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully Reset Security Question for : " + username);
                this.sendSuccessFullResponse("Success", response);
            }
            catch (Exception e) {
                LOGGER.error("Issue with Resetting Security Question : " + e);
                this.sendErrorResponse("Error", response);
            }
        } else {
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void resetGoogleAuthenticator(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Calling resetGoogleAuthenticator");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            try {
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                LOGGER.debug("Resetting Mobile Authenticator for : " + username);
                HttpSession session = req.getSession();
                String secret = MoTwoFactorUtility.generateKey();
                session.setAttribute("2fa_secret", (Object)secret);
                String qrcode = MoTwoFactorUtility.generateQrCode(secret, username, this.settings.getAppLabel("Crowd"));
                session.setAttribute("2fa_qrcode", (Object)qrcode);
                String userSpecific_salt_key = MoTwoFactorUtility.generateRandomString(10);
                twoFactorUserClass.setUserSalt(userSpecific_salt_key);
                String userSalt = (String)StringUtils.defaultIfBlank((CharSequence)twoFactorUserClass.getUserSalt(), (CharSequence)"");
                String secretWithSalt = "";
                if (StringUtils.isNotBlank((CharSequence)userSalt)) {
                    secretWithSalt = secret + userSalt;
                    String encryptedString = MoTwoFactorUtility.encryptString(secretWithSalt, this.settings.getEncryptionKey());
                    LOGGER.debug("Encrypted String " + encryptedString);
                    secret = encryptedString;
                }
                twoFactorUserClass.setTotpSecret(secret);
                List<String> configured2FAByUserList = twoFactorUserClass.getConfigured2FAMethodsByUser();
                if (configured2FAByUserList.size() == 1) {
                    List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
                    configuredUser.remove(username);
                    this.settings.setListOf2FAConfiguredUsers(configuredUser);
                }
                configured2FAByUserList.removeAll(Collections.singleton("GoogleAuthenticator"));
                twoFactorUserClass.setConfigured2FAMethodsByUser(configured2FAByUserList);
                LOGGER.debug("Current 2fa Method : " + twoFactorUserClass.getCurrent2FAMethod());
                if (StringUtils.equalsIgnoreCase((CharSequence)twoFactorUserClass.getCurrent2FAMethod(), (CharSequence)"GoogleAuthenticator")) {
                    twoFactorUserClass.setCurrent2FAMethod(this.pluginHandler.getPrimaryConfigured2faMethod(configured2FAByUserList));
                }
                this.settings.setUserSettings(username, twoFactorUserClass);
                LOGGER.debug("Successfully Reset Mobile Authenticator for : " + username);
                this.sendSuccessFullResponse("Success", resp);
            }
            catch (Exception e) {
                LOGGER.error("Issue with Resetting Google Authenticator : " + e);
                this.sendErrorResponse("Error", resp);
            }
        } else {
            resp.sendRedirect(this.pluginConfiguration.getBaseUrl());
            return;
        }
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendSuccessFullResponse");
        this.responseSent = Boolean.TRUE;
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void sendErrorResponse(String errorMessages, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendErrorResponse");
        this.responseSent = Boolean.TRUE;
        resp.setContentType("application/json");
        resp.setStatus(500);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }
}

