/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.common.service;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.entity.MoAdminsLogEntity;
import com.miniorange.twofactor.crowd.common.service.MoAdminsAuditService;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.java.ao.DBParam;
import net.java.ao.Query;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class MoAdminsAuditServiceImpl
implements MoAdminsAuditService {
    private static final Log LOGGER = LogFactory.getLog(MoAdminsAuditServiceImpl.class);
    private MoTwoFactorCommonPluginSettings settings;
    public ActiveObjects ao;
    private Date period;
    private String adminsAuditLogPerformedBy;
    private String adminsAuditLogPerformedOn;
    private String adminsAuditLogsDetails;

    public MoAdminsAuditServiceImpl(ActiveObjects ao, MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
        this.ao = ao;
    }

    @Override
    public void add(final String performedOn, final String performedBy, final Date dateTime, final String action, final String details) {
        try {
            this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction() {
                    MoAdminsLogEntity moAdminsLogEntity = (MoAdminsLogEntity)MoAdminsAuditServiceImpl.this.ao.create(MoAdminsLogEntity.class, new DBParam[0]);
                    LOGGER.debug("perfomedOn :" + performedOn + " \n performedBy" + performedBy);
                    moAdminsLogEntity.setAction(action);
                    moAdminsLogEntity.setDateAndTime(dateTime);
                    moAdminsLogEntity.setMoreDetails(details);
                    moAdminsLogEntity.setPerformedBy(performedBy);
                    moAdminsLogEntity.setPerformedOn(performedOn);
                    moAdminsLogEntity.setLowerCaseMoreDetails(details.toLowerCase(Locale.ENGLISH));
                    moAdminsLogEntity.setLowerCasePerformedBy(performedBy.toLowerCase(Locale.ENGLISH));
                    moAdminsLogEntity.setLowerCasePerformedOn(performedOn.toLowerCase(Locale.ENGLISH));
                    moAdminsLogEntity.save();
                    return null;
                }
            });
        }
        catch (Exception e) {
            LOGGER.debug("Error in storing Configuration audit logs = " + e.getMessage());
        }
    }

    @Override
    public Integer getSize(String action, String performedOn, String performedBy, String date, String details) {
        LOGGER.debug("Getting size based on filter from the miniOrange 2FA plugin's Admins Audit Table");
        this.period = new Date(0L);
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        if (StringUtils.isNotBlank((CharSequence)date) && !date.equals("All Days")) {
            long daysForLogsInLong = NumberUtils.createInteger((String)date).intValue();
            long givenDaysInMilliSecs = daysForLogsInLong * 86400000L;
            long timeInPast = timeMilliSecs - givenDaysInMilliSecs;
            this.period = new Date(timeInPast);
        }
        this.adminsAuditLogPerformedOn = StringUtils.isBlank((CharSequence)performedOn) ? "" : (performedOn = performedOn.toLowerCase(Locale.ENGLISH));
        this.adminsAuditLogPerformedBy = StringUtils.isBlank((CharSequence)performedBy) ? "" : (performedBy = performedBy.toLowerCase(Locale.ENGLISH));
        this.adminsAuditLogsDetails = StringUtils.isBlank((CharSequence)details) ? "" : (details = details.toLowerCase(Locale.ENGLISH));
        Integer size = StringUtils.isBlank((CharSequence)action) || action.equals("All Actions") ? Integer.valueOf(this.ao.count(MoAdminsLogEntity.class, Query.select().where("DATE_AND_TIME >=  ? AND LOWER_CASE_PERFORMED_ON LIKE ? AND LOWER_CASE_PERFORMED_BY LIKE ? AND LOWER_CASE_MORE_DETAILS LIKE ?", new Object[]{this.period, "%" + this.adminsAuditLogPerformedOn + "%", "%" + this.adminsAuditLogPerformedBy + "%", "%" + this.adminsAuditLogsDetails + "%"}))) : Integer.valueOf(this.ao.count(MoAdminsLogEntity.class, Query.select().where("ACTION LIKE ? AND DATE_AND_TIME >=  ? AND LOWER_CASE_PERFORMED_ON LIKE ? AND LOWER_CASE_PERFORMED_BY LIKE ? AND LOWER_CASE_MORE_DETAILS LIKE ?", new Object[]{action, this.period, "%" + this.adminsAuditLogPerformedOn + "%", "%" + this.adminsAuditLogPerformedBy + "%", "%" + this.adminsAuditLogsDetails + "%"})));
        return size;
    }

    @Override
    public List<MoAdminsLogEntity> all() {
        LOGGER.debug("Getting records from the miniOrange 2FA plugin's Audit Table");
        return (List)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<List<MoAdminsLogEntity>>(){

            public List<MoAdminsLogEntity> doInTransaction() {
                return Arrays.asList((MoAdminsLogEntity[])MoAdminsAuditServiceImpl.this.ao.find(MoAdminsLogEntity.class, Query.select().order("DATE_AND_TIME ASC")));
            }
        });
    }

    @Override
    public List<MoAdminsLogEntity> getLogs(final Integer offset, final String action, String performedOn, String performedBy, String date, String details, Integer allLogs) {
        LOGGER.debug("Getting records from the miniOrange 2FA plugin's Audit Table");
        this.period = new Date(0L);
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        if (StringUtils.isNotBlank((CharSequence)date) && !date.equals("All Days")) {
            long daysForAutoDeleteLogsInLong = NumberUtils.createInteger((String)date).intValue();
            long givenDaysInMilliSecs = daysForAutoDeleteLogsInLong * 86400000L;
            long timeInPast = timeMilliSecs - givenDaysInMilliSecs;
            this.period = new Date(timeInPast);
        }
        this.adminsAuditLogPerformedOn = StringUtils.isBlank((CharSequence)performedOn) ? "" : (performedOn = performedOn.toLowerCase(Locale.ENGLISH));
        this.adminsAuditLogPerformedBy = StringUtils.isBlank((CharSequence)performedBy) ? "" : (performedBy = performedBy.toLowerCase(Locale.ENGLISH));
        this.adminsAuditLogsDetails = StringUtils.isBlank((CharSequence)details) ? "" : (details = details.toLowerCase(Locale.ENGLISH));
        if (allLogs == -1) {
            return (List)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<List<MoAdminsLogEntity>>(){

                public List<MoAdminsLogEntity> doInTransaction() {
                    if (StringUtils.isBlank((CharSequence)action) || action.equals("All Actions")) {
                        return Arrays.asList((MoAdminsLogEntity[])MoAdminsAuditServiceImpl.this.ao.find(MoAdminsLogEntity.class, Query.select().order("DATE_AND_TIME DESC").where(" DATE_AND_TIME >=  ? AND PERFORMED_BY LIKE ? AND PERFORMED_ON LIKE ? AND MORE_DETAILS LIKE ?", new Object[]{MoAdminsAuditServiceImpl.this.period, "%" + MoAdminsAuditServiceImpl.this.adminsAuditLogPerformedBy + "%", "%" + MoAdminsAuditServiceImpl.this.adminsAuditLogPerformedOn + "%", "%" + MoAdminsAuditServiceImpl.this.adminsAuditLogsDetails + "%"})));
                    }
                    return Arrays.asList((MoAdminsLogEntity[])MoAdminsAuditServiceImpl.this.ao.find(MoAdminsLogEntity.class, Query.select().order("DATE_AND_TIME DESC").where("ACTION LIKE ? AND DATE_AND_TIME >=  ? AND PERFORMED_BY LIKE ? AND PERFORMED_ON LIKE ? AND MORE_DETAILS LIKE ?", new Object[]{"%" + action + "%", MoAdminsAuditServiceImpl.this.period, "%" + MoAdminsAuditServiceImpl.this.adminsAuditLogPerformedBy + "%", "%" + MoAdminsAuditServiceImpl.this.adminsAuditLogPerformedOn + "%", "%" + MoAdminsAuditServiceImpl.this.adminsAuditLogsDetails + "%"})));
                }
            });
        }
        return (List)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<List<MoAdminsLogEntity>>(){

            public List<MoAdminsLogEntity> doInTransaction() {
                if (StringUtils.isBlank((CharSequence)action) || action.equals("All Actions")) {
                    return Arrays.asList((MoAdminsLogEntity[])MoAdminsAuditServiceImpl.this.ao.find(MoAdminsLogEntity.class, Query.select().order("DATE_AND_TIME DESC").where(" DATE_AND_TIME >=  ? AND LOWER_CASE_PERFORMED_BY LIKE ? AND LOWER_CASE_PERFORMED_ON LIKE ? AND LOWER_CASE_MORE_DETAILS LIKE ?", new Object[]{MoAdminsAuditServiceImpl.this.period, "%" + MoAdminsAuditServiceImpl.this.adminsAuditLogPerformedBy + "%", "%" + MoAdminsAuditServiceImpl.this.adminsAuditLogPerformedOn + "%", "%" + MoAdminsAuditServiceImpl.this.adminsAuditLogsDetails + "%"}).offset((offset - 1) * 20).limit(20)));
                }
                return Arrays.asList((MoAdminsLogEntity[])MoAdminsAuditServiceImpl.this.ao.find(MoAdminsLogEntity.class, Query.select().order("DATE_AND_TIME DESC").where("ACTION LIKE ? AND DATE_AND_TIME >=  ? AND LOWER_CASE_PERFORMED_BY LIKE ? AND LOWER_CASE_PERFORMED_ON LIKE ? AND LOWER_CASE_MORE_DETAILS LIKE ?", new Object[]{"%" + action + "%", MoAdminsAuditServiceImpl.this.period, "%" + MoAdminsAuditServiceImpl.this.adminsAuditLogPerformedBy + "%", "%" + MoAdminsAuditServiceImpl.this.adminsAuditLogPerformedOn + "%", "%" + MoAdminsAuditServiceImpl.this.adminsAuditLogsDetails + "%"}).offset((offset - 1) * 20).limit(20)));
            }
        });
    }

    @Override
    public void deleteLogs() {
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                MoAdminsAuditServiceImpl.this.ao.delete(MoAdminsAuditServiceImpl.this.ao.find(MoAdminsLogEntity.class, Query.select().order("DATE_AND_TIME ASC")));
                return null;
            }
        });
    }
}

