/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorUserDetailsAction
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoTwoFactorUserDetailsAction.class);
    private static final String USERDETAILS_VM_PATH = "/templates/com/miniorange/twofactor/crowd/userdetails.vm";
    @ComponentImport
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    @ComponentImport
    private UserManager userManager;
    @ComponentImport
    private LoginUriProvider loginUriProvider;
    public String message = "";
    public ArrayList errorMessage = new ArrayList();

    public MoTwoFactorUserDetailsAction(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings, MoTwoFactorPluginConfiguration pluginConfiguration, UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
        this.userManager = userManager;
        this.renderer = renderer;
        this.loginUriProvider = loginUriProvider;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorUserDetailsAction Servlet doGet() called.");
        UserProfile user = this.userManager.getRemoteUser();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("User_Management");
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            Map<String, Object> context = this.performUserManagement(request, response, pageAccessType);
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(USERDETAILS_VM_PATH, context, (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("execute is called from MoTwoFactorUserDetailsAction");
        UserProfile user = this.userManager.getRemoteUser();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("Basic_Configuration");
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
            Map<String, Object> context = this.performUserManagement(request, response, pageAccessType);
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(USERDETAILS_VM_PATH, context, (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        }
    }

    private Map<String, Object> performUserManagement(HttpServletRequest request, HttpServletResponse response, String pageAccessType) {
        Map<String, Object> context;
        LOGGER.debug("performUserManagement called");
        String userManagementSelectedAction = MoTwoFactorUtility.sanitizeText(request.getParameter("userManagementSelectedAction"));
        if (StringUtils.isEmpty((CharSequence)userManagementSelectedAction)) {
            userManagementSelectedAction = this.settings.getUserManagementSelectedAction();
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)userManagementSelectedAction, (CharSequence)"UserAction")) {
            Integer totalUsers;
            Integer endIndex;
            Integer startIndex;
            Integer selectedPage;
            String endIndexAsString;
            String startIndexAsString;
            String usernameSearchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("usernameSearchKeyword"));
            String userSearchFilter = MoTwoFactorUtility.sanitizeText(request.getParameter("userSearchFilter"));
            Boolean userDetailsSubmitted = BooleanUtils.toBoolean((String)request.getParameter("userDetailsSubmitted"));
            this.message = "";
            if (StringUtils.isBlank((CharSequence)usernameSearchKeyword)) {
                usernameSearchKeyword = "";
            }
            if (BooleanUtils.toBoolean((Boolean)userDetailsSubmitted)) {
                startIndexAsString = "";
                endIndexAsString = "";
            } else {
                String searchFilter;
                String searchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("usernameSearchKeywordUrl"));
                if (StringUtils.isNotBlank((CharSequence)searchKeyword)) {
                    usernameSearchKeyword = searchKeyword.trim();
                }
                if (StringUtils.isNotBlank((CharSequence)(searchFilter = MoTwoFactorUtility.sanitizeText(request.getParameter("searchFilter"))))) {
                    userSearchFilter = searchFilter.trim();
                }
                startIndexAsString = MoTwoFactorUtility.sanitizeText(request.getParameter("startIndex"));
                endIndexAsString = MoTwoFactorUtility.sanitizeText(request.getParameter("endIndex"));
            }
            Integer numberOfRecordsPerPage = MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                selectedPage = 1;
                startIndex = 1;
                endIndex = numberOfRecordsPerPage;
            } else {
                startIndex = Integer.parseInt(startIndexAsString.replaceAll(",", ""));
                endIndex = Integer.parseInt(endIndexAsString.replaceAll(",", ""));
                selectedPage = endIndex / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            }
            if (StringUtils.isBlank((CharSequence)userSearchFilter)) {
                userSearchFilter = "AllUsers";
            }
            List<String> totalEnabledUserList = this.settings.getEnable2FAForUsersList();
            List<String> totalDisabledUserList = this.settings.getDisable2FAForUsersList();
            List<String> totalConfiguredUserList = this.settings.getListOf2FAConfiguredUsers();
            Boolean enable2FAForAllUsers = this.settings.getEnable2FAForAllUsers();
            Integer totalUsersInCrowd = this.pluginHandler.getTotalUserCount("");
            LOGGER.debug("totalUsersInCrowd :" + totalUsersInCrowd);
            LOGGER.info("Searching for users using " + usernameSearchKeyword);
            LOGGER.info("Apply Search on:  " + userSearchFilter);
            usernameSearchKeyword = MoTwoFactorUtility.sanitizeText(usernameSearchKeyword);
            int page = (selectedPage - 1) * 20;
            ArrayList<String> usernameList = new ArrayList();
            if (StringUtils.equalsIgnoreCase((CharSequence)userSearchFilter, (CharSequence)"EnabledUsers")) {
                userSearchFilter = "EnabledUsers";
                usernameList = this.pluginHandler.getFromList(totalEnabledUserList, usernameSearchKeyword.trim(), page);
                totalUsers = this.pluginHandler.getSizeOfUserList(totalEnabledUserList, usernameSearchKeyword);
                Collections.sort(usernameList);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)userSearchFilter, (CharSequence)"ConfiguredUsers")) {
                userSearchFilter = "ConfiguredUsers";
                usernameList = this.pluginHandler.getFromList(totalConfiguredUserList, usernameSearchKeyword.trim(), page);
                totalUsers = this.pluginHandler.getSizeOfUserList(totalConfiguredUserList, usernameSearchKeyword);
                Collections.sort(usernameList);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)userSearchFilter, (CharSequence)"DisabledUsers")) {
                userSearchFilter = "DisabledUsers";
                usernameList = this.pluginHandler.getFromList(totalDisabledUserList, usernameSearchKeyword.trim(), page);
                totalUsers = this.pluginHandler.getSizeOfUserList(totalDisabledUserList, usernameSearchKeyword);
                Collections.sort(usernameList);
            } else {
                userSearchFilter = "AllUsers";
                usernameList = this.pluginHandler.getUserFromCrowdUsingUsername(usernameSearchKeyword.trim(), page);
                totalUsers = this.pluginHandler.getTotalUserCount(usernameSearchKeyword);
            }
            LOGGER.debug("totalUsers :" + totalUsers);
            Integer emailListIndex = 0;
            Integer fullNameListIndex = 1;
            List<Map<String, String>> list = this.pluginHandler.getUserData(usernameList);
            List<String> configured2FAUserList = this.pluginHandler.getListOf2FAConfiguredUsersUsingUsername(usernameList);
            List<String> enable2FAForUserList = this.pluginHandler.getListOf2FAEnabledUsersUsingUsername(usernameList);
            ArrayList<String> currentPageUsersList = usernameList;
            Integer numberOfPages = (int)Math.ceil((double)totalUsers.intValue() / 20.0);
            if (list.get(emailListIndex).size() > numberOfPages * MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE) {
                Integer n = numberOfPages;
                numberOfPages = numberOfPages + 1;
            }
            LOGGER.debug("Before initializeUserDetails");
            totalUsersInCrowd = this.pluginHandler.getTotalUserCount("");
            context = this.initializeUserDetails(usernameSearchKeyword, selectedPage, startIndex, endIndex, list, emailListIndex, fullNameListIndex, configured2FAUserList, enable2FAForUserList, currentPageUsersList, numberOfPages, numberOfRecordsPerPage, totalUsers, totalUsersInCrowd, userManagementSelectedAction);
            context.put("userSearchFilter", userSearchFilter);
            context.put("total2faEnabledUsers", totalEnabledUserList.size());
            context.put("total2faDisabledUsers", totalDisabledUserList.size());
            context.put("total2faConfiguredUsers", totalConfiguredUserList.size());
            context.put("excludeGroupsList", new ArrayList());
            context.put("enable2FAForAllUsers", this.settings.getEnable2FAForAllUsers());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)userManagementSelectedAction, (CharSequence)"GroupAction")) {
            Integer totalGroups;
            Integer endIndex;
            Integer startIndex;
            Integer selectedPage;
            String endIndexAsString;
            String startIndexAsString;
            String currentForm = MoTwoFactorUtility.sanitizeText(request.getParameter("currentForm"));
            String groupSearchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("groupSearchKeyword"));
            String groupSearchFilter = MoTwoFactorUtility.sanitizeText(request.getParameter("groupSearchFilter"));
            Boolean groupDetailsSubmitted = BooleanUtils.toBoolean((String)MoTwoFactorUtility.sanitizeText(request.getParameter("groupDetailsSubmitted")));
            List<String> skip2faGroupsList = this.settings.getExclude2faForGroupList();
            List<Object> excludeGroupsList = new ArrayList();
            this.message = "";
            ArrayList<String> addedgroups = new ArrayList<String>();
            ArrayList<String> removedgroups = new ArrayList<String>();
            if (pageAccessType.equals("readwrite") && StringUtils.equalsIgnoreCase((CharSequence)currentForm, (CharSequence)"Form2")) {
                String[] excludeGroups = request.getParameterValues("excludeGroups");
                if (excludeGroups != null && excludeGroups.length != 0) {
                    excludeGroupsList = Arrays.asList(StringUtils.split((String)excludeGroups[0], (String)","));
                    excludeGroupsList.removeAll(Arrays.asList(null, ""));
                    ArrayList<String> groupsToAdd = new ArrayList<String>();
                    if (excludeGroupsList.size() > 0) {
                        for (String string : excludeGroupsList) {
                            if (skip2faGroupsList.size() == 0 || !skip2faGroupsList.contains(string)) {
                                addedgroups.add(string);
                            }
                            groupsToAdd.add(string);
                        }
                        for (String string : skip2faGroupsList) {
                            if (groupsToAdd.contains(string)) continue;
                            removedgroups.add(string);
                        }
                        LOGGER.debug("Exclude Groups : " + groupsToAdd);
                        this.settings.setExclude2faForGroupList(groupsToAdd);
                    } else {
                        this.settings.setExclude2faForGroupList(new ArrayList<String>());
                    }
                } else {
                    this.settings.setExclude2faForGroupList(new ArrayList<String>());
                }
                if (!addedgroups.isEmpty() || !removedgroups.isEmpty()) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Added:" + ((Object)addedgroups).toString());
                    builder.append("//// ////");
                    builder.append("Removed:" + removedgroups);
                    this.pluginHandler.storeAdminsAuditLogs("Skip 2FA for Groups", "Updated User Management Tab", builder.toString(), request);
                }
            }
            excludeGroupsList = this.settings.getExclude2faForGroupList();
            LOGGER.debug("Saves Groups : " + excludeGroupsList);
            if (StringUtils.isBlank((CharSequence)groupSearchKeyword)) {
                groupSearchKeyword = "";
            }
            if (BooleanUtils.toBoolean((Boolean)groupDetailsSubmitted)) {
                startIndexAsString = "";
                endIndexAsString = "";
            } else {
                String searchFilter;
                String searchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("groupSearchKeywordUrl"));
                if (searchKeyword != null) {
                    groupSearchKeyword = searchKeyword.trim();
                }
                if (StringUtils.isNotBlank((CharSequence)(searchFilter = MoTwoFactorUtility.sanitizeText(request.getParameter("searchFilter"))))) {
                    groupSearchFilter = searchFilter.trim();
                }
                startIndexAsString = MoTwoFactorUtility.sanitizeText(request.getParameter("startIndex"));
                endIndexAsString = MoTwoFactorUtility.sanitizeText(request.getParameter("endIndex"));
            }
            Integer numberOfRecordsPerPage = MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                selectedPage = 1;
                startIndex = 1;
                endIndex = numberOfRecordsPerPage;
            } else {
                startIndex = Integer.parseInt(startIndexAsString.replaceAll(",", ""));
                endIndex = Integer.parseInt(endIndexAsString.replaceAll(",", ""));
                selectedPage = endIndex / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            }
            if (StringUtils.isBlank((CharSequence)groupSearchFilter)) {
                groupSearchFilter = "AllGroups";
            }
            List<String> totalEnabledGroupList = this.settings.getEnable2FAForGroupsList();
            LOGGER.info("Searching for groups using " + groupSearchKeyword);
            LOGGER.info("Apply Search on:  " + groupSearchFilter);
            groupSearchKeyword = MoTwoFactorUtility.sanitizeText(groupSearchKeyword);
            int page = (selectedPage - 1) * 20;
            ArrayList<String> groupNameList = new ArrayList();
            if (StringUtils.equalsIgnoreCase((CharSequence)groupSearchFilter, (CharSequence)"EnabledGroups")) {
                groupSearchFilter = "EnabledGroups";
                groupNameList = this.pluginHandler.getFromListForGroups(totalEnabledGroupList, groupSearchKeyword, page);
                Collections.sort(groupNameList);
                totalGroups = this.pluginHandler.getSizeOfGroupsList(totalEnabledGroupList, groupSearchKeyword);
            } else {
                groupSearchFilter = "AllGroups";
                groupNameList = this.pluginHandler.getGroupsFromCrowdUsingGroupname(groupSearchKeyword.trim(), page);
                totalGroups = this.pluginHandler.getTotalGroupsSize(groupSearchKeyword.trim());
            }
            List<String> list = this.pluginHandler.getListOf2FAEnabledGroupsUsingGroupname(groupNameList);
            ArrayList<String> currentPageGroupsList = groupNameList;
            Integer numberOfPages = (int)Math.ceil((double)totalGroups.intValue() / 20.0);
            if (groupNameList.size() > numberOfPages * MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE) {
                Integer n = numberOfPages;
                numberOfPages = numberOfPages + 1;
            }
            Collections.sort(totalEnabledGroupList);
            context = this.initializeGroupDetails(groupSearchKeyword, selectedPage, startIndex, endIndex, groupNameList, list, currentPageGroupsList, numberOfPages, numberOfRecordsPerPage, totalGroups, userManagementSelectedAction);
            context.put("excludeGroupsList", excludeGroupsList);
            context.put("groupSearchFilter", groupSearchFilter);
            context.put("total2faEnabledGroups", totalEnabledGroupList.size());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)userManagementSelectedAction, (CharSequence)"DirectoryAction")) {
            Integer totalDirectories;
            Integer endIndex;
            Integer startIndex;
            Integer selectedPage;
            String endIndexAsString;
            String startIndexAsString;
            String currentForm = MoTwoFactorUtility.sanitizeText(request.getParameter("currentForm"));
            String directorySearchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("directorySearchKeyword"));
            String directorySearchFilter = MoTwoFactorUtility.sanitizeText(request.getParameter("directorySearchFilter"));
            Boolean directoryDetailsSubmitted = BooleanUtils.toBoolean((String)MoTwoFactorUtility.sanitizeText(request.getParameter("directoryDetailsSubmitted")));
            this.message = "";
            if (StringUtils.isBlank((CharSequence)directorySearchKeyword)) {
                directorySearchKeyword = "";
            }
            if (BooleanUtils.toBoolean((Boolean)directoryDetailsSubmitted)) {
                startIndexAsString = "";
                endIndexAsString = "";
            } else {
                String searchFilter;
                String searchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("directorySearchKeywordUrl"));
                if (searchKeyword != null) {
                    directorySearchKeyword = searchKeyword.trim();
                }
                if (StringUtils.isNotBlank((CharSequence)(searchFilter = MoTwoFactorUtility.sanitizeText(request.getParameter("searchFilter"))))) {
                    directorySearchFilter = searchFilter.trim();
                }
                startIndexAsString = MoTwoFactorUtility.sanitizeText(request.getParameter("startIndex"));
                endIndexAsString = MoTwoFactorUtility.sanitizeText(request.getParameter("endIndex"));
            }
            Integer numberOfRecordsPerPage = MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                selectedPage = 1;
                startIndex = 1;
                endIndex = numberOfRecordsPerPage;
            } else {
                startIndex = Integer.parseInt(startIndexAsString.replaceAll(",", ""));
                endIndex = Integer.parseInt(endIndexAsString.replaceAll(",", ""));
                selectedPage = endIndex / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            }
            if (StringUtils.isBlank((CharSequence)directorySearchFilter)) {
                directorySearchFilter = "AllDirectories";
            }
            List<String> totalEnabledDirectoryList = this.settings.getEnable2FAForDirectoriesList();
            LOGGER.info("Searching for directories using " + directorySearchKeyword);
            LOGGER.info("Apply Search on:  " + directorySearchFilter);
            directorySearchKeyword = MoTwoFactorUtility.sanitizeText(directorySearchKeyword);
            int page = (selectedPage - 1) * 20;
            ArrayList<String> directoryNameList = new ArrayList();
            if (StringUtils.equalsIgnoreCase((CharSequence)directorySearchFilter, (CharSequence)"EnabledDirectories")) {
                directorySearchFilter = "EnabledDirectories";
                directoryNameList = this.pluginHandler.getFromListForDirectories(totalEnabledDirectoryList, directorySearchKeyword, page);
                Collections.sort(directoryNameList);
                totalDirectories = this.pluginHandler.getSizeOfDirectoriesList(totalEnabledDirectoryList, directorySearchKeyword);
            } else {
                directorySearchFilter = "AllDirectories";
                directoryNameList = this.pluginHandler.getDirectoryFromCrowdUsingDirectoryname(directorySearchKeyword.trim(), page);
                totalDirectories = this.pluginHandler.getTotalDirectoriesSize(directorySearchKeyword.trim());
            }
            List<String> enable2FAForDirectoryList = this.pluginHandler.getListOf2FAEnabledDirectoriesUsingDirectoryname(directoryNameList);
            ArrayList<String> currentPageDirectoriesList = directoryNameList;
            Integer numberOfPages = (int)Math.ceil((double)totalDirectories.intValue() / 20.0);
            if (directoryNameList.size() > numberOfPages * MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE) {
                Integer n = numberOfPages;
                numberOfPages = numberOfPages + 1;
            }
            Collections.sort(totalEnabledDirectoryList);
            context = this.initializeDirectoryDetails(directorySearchKeyword, selectedPage, startIndex, endIndex, directoryNameList, enable2FAForDirectoryList, currentPageDirectoriesList, numberOfPages, numberOfRecordsPerPage, totalDirectories, userManagementSelectedAction);
            context.put("directorySearchFilter", directorySearchFilter);
            context.put("total2faEnabledDirectories", totalEnabledDirectoryList.size());
        } else {
            Integer endIndex;
            Integer startIndex;
            Integer selectedPage;
            String endIndexAsString;
            String startIndexAsString;
            String usernameSearchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("usernameSearchKeyword"));
            Boolean lockedUserDetailsSubmitted = BooleanUtils.toBoolean((String)MoTwoFactorUtility.sanitizeText(request.getParameter("lockedUserDetailsSubmitted")));
            this.message = "";
            if (StringUtils.isBlank((CharSequence)usernameSearchKeyword)) {
                usernameSearchKeyword = "";
            }
            if (BooleanUtils.toBoolean((Boolean)lockedUserDetailsSubmitted)) {
                startIndexAsString = "";
                endIndexAsString = "";
            } else {
                String searchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("usernameSearchKeywordUrl"));
                if (searchKeyword != null) {
                    usernameSearchKeyword = searchKeyword.trim();
                }
                startIndexAsString = MoTwoFactorUtility.sanitizeText(request.getParameter("startIndex"));
                endIndexAsString = MoTwoFactorUtility.sanitizeText(request.getParameter("endIndex"));
            }
            Integer numberOfRecordsPerPage = MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                selectedPage = 1;
                startIndex = 1;
                endIndex = numberOfRecordsPerPage;
            } else {
                startIndex = Integer.parseInt(startIndexAsString.replaceAll(",", ""));
                endIndex = Integer.parseInt(endIndexAsString.replaceAll(",", ""));
                selectedPage = endIndex / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            }
            LOGGER.info("Searching for User using " + usernameSearchKeyword);
            usernameSearchKeyword = MoTwoFactorUtility.sanitizeText(usernameSearchKeyword);
            this.pluginHandler.performLockedUserDetailsCleanUp();
            Map<String, String> lockedUserDetails = this.pluginHandler.getLockedUserDetailsUsingUsername(usernameSearchKeyword.trim(), 100);
            Map<String, String> currentPageLockedUserDetails = this.pluginHandler.getSelectedDetailsForPagination(lockedUserDetails, (Integer)(startIndex - 1), (Integer)(endIndex - 1));
            Integer numberOfPages = lockedUserDetails.size() / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
            if (lockedUserDetails.size() > numberOfPages * MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE) {
                Integer n = numberOfPages;
                numberOfPages = numberOfPages + 1;
            }
            context = this.initializeLockedUsersDetails(usernameSearchKeyword, selectedPage, startIndex, endIndex, lockedUserDetails, currentPageLockedUserDetails, numberOfPages, numberOfRecordsPerPage, userManagementSelectedAction);
            context.put("excludeGroupsList", new ArrayList());
        }
        context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
        context.put("isAdmin", this.pluginHandler.isSystemAdmin());
        context.put("message", this.message);
        context.put("errorMessage", this.errorMessage);
        context.put("exportUsersUrl", this.pluginConfiguration.getExportUsersUrl());
        context.put("exportGroupsUrl", this.pluginConfiguration.getExportGroupsUrl());
        context.put("exportDirectoriesUrl", this.pluginConfiguration.getExportDirectoriesUrl());
        context.put("contextPath", this.pluginConfiguration.getBaseUrl());
        context.put("pagesAccessibleToUser", this.pluginHandler.getUserAccessiblePages());
        context.put("pageAccessType", this.pluginHandler.getPageAccessForCurrentUser("User_Management"));
        context.put("daysLeftToExpire", this.pluginSettings.getDaysLeftToExpire());
        context.put("isLicenseExpired", this.pluginSettings.isLicenseExpired());
        context.put("crowdBaseUrl", this.pluginSettings.getBaseUrl());
        context.put("licenseType", this.pluginSettings.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettings.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.pluginSettings.isNoOfUserExceed());
        return context;
    }

    private Map<String, Object> initializeUserDetails(String usernameSearchKeyword, Integer selectedPage, Integer startIndex, Integer endIndex, List<Map<String, String>> userData, Integer emailListIndex, Integer fullNameListIndex, List<String> configured2FAUserList, List<String> enable2FAForUserList, List<String> currentPageUsersList, Integer numberOfPages, Integer numberOfRecordsPerPage, Integer totalUsers, Integer totalUsersInCrowd, String userManagementSelectedAction) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        LOGGER.debug("inside initializeUserDetails...");
        context.put("usernameSearchKeyword", usernameSearchKeyword);
        context.put("selectedPage", selectedPage);
        context.put("startIndex", startIndex);
        context.put("endIndex", endIndex);
        context.put("userData", userData);
        context.put("emailListIndex", emailListIndex);
        context.put("fullNameListIndex", fullNameListIndex);
        context.put("configured2FAUserList", configured2FAUserList);
        context.put("enable2FAForUserList", enable2FAForUserList);
        context.put("currentPageUsersList", currentPageUsersList);
        context.put("numberOfPages", numberOfPages);
        context.put("numberOfRecordsPerPage", numberOfRecordsPerPage);
        context.put("totalUsers", totalUsers);
        context.put("totalUsersInCrowd", totalUsersInCrowd);
        context.put("userManagementSelectedAction", userManagementSelectedAction);
        context.put("numberOfPagesList", this.getNumberOfPagesList(numberOfPages));
        return context;
    }

    private Map<String, Object> initializeGroupDetails(String groupSearchKeyword, Integer selectedPage, Integer startIndex, Integer endIndex, List<String> groupNameList, List<String> enable2FAForGroupList, List<String> currentPageGroupsList, Integer numberOfPages, Integer numberOfRecordsPerPage, Integer totalGroups, String userManagementSelectedAction) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        LOGGER.debug("inside initializeUserDetails...");
        context.put("groupSearchKeyword", groupSearchKeyword);
        context.put("selectedPage", selectedPage);
        context.put("startIndex", startIndex);
        context.put("endIndex", endIndex);
        context.put("groupNameList", groupNameList);
        context.put("enable2FAForGroupList", enable2FAForGroupList);
        context.put("currentPageGroupsList", currentPageGroupsList);
        context.put("numberOfPages", numberOfPages);
        context.put("numberOfRecordsPerPage", numberOfRecordsPerPage);
        context.put("totalGroups", totalGroups);
        context.put("userManagementSelectedAction", userManagementSelectedAction);
        context.put("numberOfPagesList", this.getNumberOfPagesList(numberOfPages));
        return context;
    }

    private Map<String, Object> initializeDirectoryDetails(String directorySearchKeyword, Integer selectedPage, Integer startIndex, Integer endIndex, List<String> directoryNameList, List<String> enable2FAForDirectoryList, List<String> currentPageDirectoriesList, Integer numberOfPages, Integer numberOfRecordsPerPage, Integer totalDirectories, String userManagementSelectedAction) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        LOGGER.debug("inside initializeDirectoryDetails...");
        context.put("directorySearchKeyword", directorySearchKeyword);
        context.put("selectedPage", selectedPage);
        context.put("startIndex", startIndex);
        context.put("endIndex", endIndex);
        context.put("directoryNameList", directoryNameList);
        context.put("enable2FAForDirectoryList", enable2FAForDirectoryList);
        context.put("currentPageDirectoriesList", currentPageDirectoriesList);
        context.put("numberOfPages", numberOfPages);
        context.put("numberOfRecordsPerPage", numberOfRecordsPerPage);
        context.put("totalDirectories", totalDirectories);
        context.put("userManagementSelectedAction", userManagementSelectedAction);
        context.put("numberOfPagesList", this.getNumberOfPagesList(numberOfPages));
        return context;
    }

    private Map<String, Object> initializeLockedUsersDetails(String usernameSearchKeyword, Integer selectedPage, Integer startIndex, Integer endIndex, Map<String, String> lockedUserDetails, Map<String, String> currentPageLockedUserDetails, Integer numberOfPages, Integer numberOfRecordsPerPage, String userManagementSelectedAction) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        LOGGER.debug("inside initializeUserDetails...");
        context.put("usernameSearchKeyword", usernameSearchKeyword);
        context.put("selectedPage", selectedPage);
        context.put("startIndex", startIndex);
        context.put("endIndex", endIndex);
        context.put("lockedUserDetails", lockedUserDetails);
        context.put("currentPageLockedUserDetails", currentPageLockedUserDetails);
        context.put("numberOfPages", numberOfPages);
        context.put("numberOfRecordsPerPage", numberOfRecordsPerPage);
        context.put("userManagementSelectedAction", userManagementSelectedAction);
        context.put("numberOfPagesList", this.getNumberOfPagesList(numberOfPages));
        return context;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public List<String> getNumberOfPagesList(Integer numberOfPages) {
        ArrayList<String> numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= numberOfPages; ++i) {
            numberOfPagesList.add("" + i);
        }
        return numberOfPagesList;
    }
}

