/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.stereotype.Component;

@Component
public class MoTwoFactorPluginConfiguration {
    private static Log LOGGER = LogFactory.getLog(MoTwoFactorPluginConfiguration.class);
    public final String SECRETE_KEY = "miniOrangeSecretKey";
    @ComponentImport
    private UserManager userManager;
    @ComponentImport
    private CrowdService crowdService;
    @ComponentImport
    private PropertyManager propertyManager;
    @ComponentImport
    private ApplicationProperties applicationProperties;

    public MoTwoFactorPluginConfiguration(UserManager userManager, CrowdService crowdService, PropertyManager propertyManager, ApplicationProperties applicationProperties) {
        this.userManager = userManager;
        this.crowdService = crowdService;
        this.applicationProperties = applicationProperties;
        this.propertyManager = propertyManager;
    }

    public String getBaseUrl() {
        try {
            String baseURL = this.propertyManager.getBaseUrl().toString();
            return baseURL;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting base URL", e);
            return null;
        }
    }

    public String getSSOCookieName() {
        CookieConfiguration cookieConfiguration = this.propertyManager.getCookieConfiguration();
        String ssoCookieName = "";
        ssoCookieName = cookieConfiguration.getName();
        if (StringUtils.isEmpty((CharSequence)ssoCookieName)) {
            LOGGER.debug("Crowd cookies is not configured. using default one.");
            ssoCookieName = "crowd.token_key";
        }
        LOGGER.debug("Crowd SSO cookie name : " + ssoCookieName);
        return ssoCookieName;
    }

    public String getManageAddOnURL() {
        return this.getBaseUrl().concat("/plugins/servlet/upm");
    }

    public String getConfigureActionUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/twofactor/configure");
    }

    public String getLogoutActionUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/twofactor/userlogout");
    }

    public String getLoginActionUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/twofactor/dologin");
    }

    public String getAjaxConfigurationSaveUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/twofactor/ajaxconfigurationsave");
    }

    public String getDownloadBackupCodeUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/twofactor/downloadbackupcode");
    }

    public String getExportUsersUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/twofactor/exportUsers");
    }

    public String getExportGroupsUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/twofactor/exportGroups");
    }

    public String getExportDirectoriesUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/twofactor/exportDirectories");
    }

    public String getExportAuditLogsUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/twofactor/exportAuditLogs");
    }

    public String getUserDetailsUrl() {
        return this.getBaseUrl().concat("/plugins/servlet/twofactor/userdetails");
    }

    public String getDashboardUrl() {
        return this.getBaseUrl().concat("/console/user/viewprofile.action");
    }

    public String getCurrentLoggedInUser() {
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null) {
            return "";
        }
        return user.getUsername();
    }

    public UserProfile getCrowdUser(String username) {
        UserProfile user = this.userManager.getUserProfile(username);
        return user;
    }

    public UserProfile getCrowdUser() {
        UserProfile user = this.userManager.getRemoteUser();
        return user;
    }

    public UserProfile getCrowdUserFromManager(String username) {
        return this.userManager.getUserProfile(username);
    }

    public List<String> getUsersGroup(String username) {
        List<String> currentUserGroups = this.getAllGroupsOfUser(username);
        ArrayList<String> existingUserRoles = new ArrayList<String>();
        for (String group : currentUserGroups) {
            if (existingUserRoles.contains(group)) continue;
            existingUserRoles.add(group);
        }
        return existingUserRoles;
    }

    public List<String> getAllGroupsOfUser(String username) {
        MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(username).returningAtMost(-1);
        LOGGER.debug("query =  " + query);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        existingGroups = new ArrayList();
        for (Group groupObject : groups) {
            existingGroups.add(groupObject.getName());
        }
        return existingGroups;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public static String executePostRequest(CloseableHttpClient httpClient, HttpPost postRequest) {
        try {
            CloseableHttpResponse response = httpClient.execute(postRequest);
            if (response.getEntity() != null) {
                String output;
                BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
                String status = "";
                while ((output = br.readLine()) != null) {
                    status = status + output;
                }
                httpClient.close();
                return status;
            }
            httpClient.close();
            return "";
        }
        catch (Exception e) {
            LOGGER.error("Error" + e);
            return "Failed";
        }
    }

    private JsonObject convertToJsonObject(MoTwoFactorCommonUserSettings userRelatedSettings) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("enable2FaForUser", userRelatedSettings.getEnable2FaForUser());
        jsonObject.addProperty("totpSecret", userRelatedSettings.getTotpSecret());
        jsonObject.addProperty("userSalt", userRelatedSettings.getUserSalt());
        jsonObject.addProperty("current2FAMethod", userRelatedSettings.getCurrent2FAMethod());
        JsonArray configured2FAMethodsByUserArray = new JsonArray();
        for (String string : userRelatedSettings.getConfigured2FAMethodsByUser()) {
            JsonPrimitive jsonPrimitive = new JsonPrimitive(string);
            configured2FAMethodsByUserArray.add(jsonPrimitive);
        }
        jsonObject.add("configured2FAMethodsByUser", configured2FAMethodsByUserArray);
        JsonObject securityQuestionAnswerObj = new JsonObject();
        if (userRelatedSettings.getSecurityQuestionAnswer() != null) {
            for (String string : userRelatedSettings.getSecurityQuestionAnswer().keySet()) {
                if (string == null) continue;
                securityQuestionAnswerObj.addProperty(string, userRelatedSettings.getSecurityQuestionAnswer().get(string));
            }
        }
        jsonObject.add("securityQuestionAnswer", securityQuestionAnswerObj);
        JsonArray jsonArray = new JsonArray();
        for (String deviceDetails : userRelatedSettings.getRememberMeDeviceDetails()) {
            JsonPrimitive defaultGroupObject = new JsonPrimitive(deviceDetails);
            jsonArray.add(defaultGroupObject);
        }
        jsonObject.add("rememberMeDeviceDetails", jsonArray);
        JsonArray jsonArray2 = new JsonArray();
        for (String backupCode : userRelatedSettings.getBackupCodes()) {
            JsonPrimitive backupCodeElement = new JsonPrimitive(backupCode);
            jsonArray2.add(backupCodeElement);
        }
        jsonObject.add("backupCodes", jsonArray2);
        return jsonObject;
    }

    public User getCrowdApplicationUser(String username) {
        return this.crowdService.getUser(username);
    }
}

