/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.decoder;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.decoder.AbstractDecoder;
import co.nstant.in.cbor.model.HalfPrecisionFloat;
import java.io.InputStream;

public class HalfPrecisionFloatDecoder
extends AbstractDecoder<HalfPrecisionFloat> {
    public HalfPrecisionFloatDecoder(CborDecoder decoder, InputStream inputStream) {
        super(decoder, inputStream);
    }

    @Override
    public HalfPrecisionFloat decode(int initialByte) throws CborException {
        int bits = this.nextSymbol() << 8 | this.nextSymbol();
        return new HalfPrecisionFloat(HalfPrecisionFloatDecoder.toFloat(bits));
    }

    private static float toFloat(int bits) {
        int s2 = (bits & 0x8000) >> 15;
        int e = (bits & 0x7C00) >> 10;
        int f = bits & 0x3FF;
        if (e == 0) {
            return (float)((double)(s2 != 0 ? -1 : 1) * Math.pow(2.0, -14.0) * ((double)f / Math.pow(2.0, 10.0)));
        }
        if (e == 31) {
            return f != 0 ? Float.NaN : (float)(s2 != 0 ? -1 : 1) * Float.POSITIVE_INFINITY;
        }
        return (float)((double)(s2 != 0 ? -1 : 1) * Math.pow(2.0, e - 15) * (1.0 + (double)f / Math.pow(2.0, 10.0)));
    }
}

