/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.google.common.primitives.Bytes;
import com.miniorange.twofactor.crowd.webauthn.utils.Algorithm;
import com.miniorange.twofactor.crowd.webauthn.utils.CredentialPublicKey;
import jakarta.xml.bind.DatatypeConverter;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.List;

public class EccKey
extends CredentialPublicKey {
    byte[] x;
    byte[] y;
    int crv;

    EccKey() {
        this.x = null;
        this.y = null;
        this.alg = Algorithm.UNDEFINED;
    }

    public EccKey(Algorithm alg, byte[] x, byte[] y) {
        this.alg = alg;
        this.x = x;
        this.y = y;
    }

    public EccKey(byte[] x, byte[] y) {
        this.x = x;
        this.y = y;
    }

    public int hashCode() {
        return Arrays.hashCode(Bytes.concat(this.x, this.y));
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof EccKey) {
                EccKey other = (EccKey)obj;
                if (Arrays.equals(this.x, other.x) && Arrays.equals(this.y, other.y) && this.alg == other.alg) {
                    return true;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public byte[] encode() throws CborException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        List<DataItem> dataItems = new CborBuilder().addMap().put(new UnsignedInteger(1L), new UnsignedInteger(this.kty)).put(new UnsignedInteger(3L), new NegativeInteger(this.alg.encodeToInt())).put(new NegativeInteger(-1L), new UnsignedInteger(this.crv)).put(new NegativeInteger(-2L), new ByteString(this.x)).put(new NegativeInteger(-3L), new ByteString(this.y)).end().build();
        new CborEncoder(output).encode(dataItems);
        return output.toByteArray();
    }

    public byte[] getX() {
        return this.x;
    }

    public byte[] getY() {
        return this.y;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("alg:");
        b.append(this.alg.toReadableString());
        b.append(" x:");
        b.append(DatatypeConverter.printHexBinary(this.x));
        b.append(" y:");
        b.append(DatatypeConverter.printHexBinary(this.y));
        return b.toString();
    }
}

