/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.miniorange.twofactor.crowd.webauthn.utils.Algorithm;
import com.miniorange.twofactor.crowd.webauthn.utils.EccKey;
import com.miniorange.twofactor.crowd.webauthn.utils.RsaKey;
import java.security.InvalidParameterException;
import java.util.List;

public abstract class CredentialPublicKey {
    Algorithm alg;
    int kty;
    byte[] cborEncodedKey;
    static final int CRV_LABEL = -1;
    static final int X_LABEL = -2;
    static final int Y_LABEL = -3;
    static final int N_LABEL = -1;
    static final int E_LABEL = -2;
    static final int KTY_LABEL = 1;
    static final int ALG_LABEL = 3;

    public abstract byte[] encode() throws CborException;

    public abstract String toString();

    public Algorithm getAlg() {
        return this.alg;
    }

    public static CredentialPublicKey decode(byte[] cbor) throws CborException {
        List<DataItem> dataItems = CborDecoder.decode(cbor);
        if (dataItems.size() < 1 || !(dataItems.get(0) instanceof Map)) {
            return null;
        }
        Map map = (Map)dataItems.get(0);
        if (map.getKeys().size() == 4) {
            RsaKey rsaKey = new RsaKey();
            for (DataItem d : map.getKeys()) {
                int tmp = 0;
                if (d instanceof NegativeInteger) {
                    tmp = ((NegativeInteger)d).getValue().intValue();
                } else if (d instanceof UnsignedInteger) {
                    tmp = ((UnsignedInteger)d).getValue().intValue();
                }
                switch (tmp) {
                    case -1: {
                        if (map.get(d) instanceof ByteString) {
                            rsaKey.n = ((ByteString)map.get(d)).getBytes();
                            break;
                        }
                        throw new InvalidParameterException("Public key 'N' invalid type");
                    }
                    case -2: {
                        if (map.get(d) instanceof ByteString) {
                            rsaKey.e = ((ByteString)map.get(d)).getBytes();
                            break;
                        }
                        throw new InvalidParameterException("Public key 'E' invalid type");
                    }
                    case 1: {
                        if (map.get(d) instanceof UnsignedInteger) {
                            rsaKey.kty = ((UnsignedInteger)map.get(d)).getValue().intValue();
                            break;
                        }
                        throw new InvalidParameterException("Public key 'KTY' invalid type");
                    }
                    case 3: {
                        if (map.get(d) instanceof NegativeInteger) {
                            rsaKey.alg = Algorithm.decode(((NegativeInteger)map.get(d)).getValue().intValue());
                            if (Algorithm.isRsaAlgorithm(rsaKey.alg)) break;
                            throw new InvalidParameterException("Unsupported RSA algorithm");
                        }
                        throw new InvalidParameterException("Public key 'ALG' invalid type");
                    }
                }
            }
            return rsaKey;
        }
        if (map.getKeys().size() == 5) {
            EccKey eccKey = new EccKey();
            for (DataItem d : map.getKeys()) {
                int tmp = 0;
                if (d instanceof NegativeInteger) {
                    tmp = ((NegativeInteger)d).getValue().intValue();
                } else if (d instanceof UnsignedInteger) {
                    tmp = ((UnsignedInteger)d).getValue().intValue();
                }
                switch (tmp) {
                    case -1: {
                        if (map.get(d) instanceof UnsignedInteger) {
                            eccKey.crv = ((UnsignedInteger)map.get(d)).getValue().intValue();
                            break;
                        }
                        throw new InvalidParameterException("Public key 'CRV' invalid type");
                    }
                    case -2: {
                        if (map.get(d) instanceof ByteString) {
                            eccKey.x = ((ByteString)map.get(d)).getBytes();
                            break;
                        }
                        throw new InvalidParameterException("Public key 'X' invalid type");
                    }
                    case -3: {
                        if (map.get(d) instanceof ByteString) {
                            eccKey.y = ((ByteString)map.get(d)).getBytes();
                            break;
                        }
                        throw new InvalidParameterException("Public key 'Y' invalid type");
                    }
                    case 1: {
                        if (map.get(d) instanceof UnsignedInteger) {
                            eccKey.kty = ((UnsignedInteger)map.get(d)).getValue().intValue();
                            break;
                        }
                        throw new InvalidParameterException("Public key 'KTY' invalid type");
                    }
                    case 3: {
                        if (map.get(d) instanceof NegativeInteger) {
                            eccKey.alg = Algorithm.decode(((NegativeInteger)map.get(d)).getValue().intValue());
                            if (Algorithm.isEccAlgorithm(eccKey.alg)) break;
                            throw new InvalidParameterException("Unsupported ECC algorithm");
                        }
                        throw new InvalidParameterException("Public key 'ALG' invalid type");
                    }
                }
            }
            return eccKey;
        }
        throw new InvalidParameterException("Unsupported COSE public key sent");
    }
}

