/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn.utils;

import com.atlassian.json.jsonorg.JSONObject;
import com.google.common.io.BaseEncoding;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.miniorange.twofactor.crowd.webauthn.utils.AuthenticatorData;
import com.miniorange.twofactor.crowd.webauthn.utils.AuthenticatorResponse;
import com.miniorange.twofactor.crowd.webauthn.utils.CollectedClientData;
import java.nio.charset.StandardCharsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthenticatorAssertionResponse
extends AuthenticatorResponse {
    private static Log LOGGER = LogFactory.getLog(AuthenticatorAssertionResponse.class);
    byte[] authDataBytes;
    AuthenticatorData authData;
    byte[] signature;
    byte[] userHandle;

    public AuthenticatorAssertionResponse() {
    }

    public AuthenticatorAssertionResponse(String clientDataJSON, String authenticatorData, String signatureString) throws Exception {
        this.clientData = CollectedClientData.decode(clientDataJSON);
        this.clientDataBytes = clientDataJSON.getBytes(StandardCharsets.UTF_8);
        this.authData = AuthenticatorData.decode(BaseEncoding.base64().decode(authenticatorData));
        this.signature = BaseEncoding.base64().decode(signatureString);
    }

    public AuthenticatorAssertionResponse(JsonElement data) throws Exception {
        Gson gson = new Gson();
        try {
            JSONObject jsonObject = new JSONObject(data.getAsJsonObject().toString());
            AssertionResponseJson parsedObject = new AssertionResponseJson();
            parsedObject.authenticatorData = jsonObject.getString("authenticatorData");
            parsedObject.clientDataJSON = jsonObject.getString("clientDataJSON");
            parsedObject.signature = jsonObject.getString("signature");
            parsedObject.userHandle = jsonObject.getString("userHandle");
            this.clientDataBytes = BaseEncoding.base64().decode(parsedObject.clientDataJSON);
            JSONObject clientDataJson = new JSONObject(new String(this.clientDataBytes, StandardCharsets.UTF_8));
            this.clientData = new CollectedClientData();
            if (clientDataJson != null) {
                if (clientDataJson.has("type")) {
                    this.clientData.setType(clientDataJson.getString("type"));
                }
                if (clientDataJson.has("origin")) {
                    this.clientData.setOrigin(clientDataJson.getString("origin"));
                }
                if (clientDataJson.has("challenge")) {
                    this.clientData.setChallenge(clientDataJson.getString("challenge"));
                }
            }
            this.authDataBytes = BaseEncoding.base64().decode(parsedObject.authenticatorData);
            this.authData = AuthenticatorData.decode(this.authDataBytes);
            this.signature = BaseEncoding.base64().decode(parsedObject.signature);
            this.userHandle = BaseEncoding.base64().decode(parsedObject.userHandle);
        }
        catch (JsonSyntaxException e) {
            throw new Exception("Response format incorrect");
        }
    }

    public byte[] getAuthDataBytes() {
        return this.authDataBytes;
    }

    public AuthenticatorData getAuthenticatorData() {
        return this.authData;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getUserHandle() {
        return this.userHandle;
    }

    private static class AssertionResponseJson {
        String clientDataJSON;
        String authenticatorData;
        String signature;
        String userHandle;

        private AssertionResponseJson() {
        }
    }
}

