/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.google.common.io.BaseEncoding;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.miniorange.twofactor.crowd.webauthn.MoConstants;
import com.miniorange.twofactor.crowd.webauthn.dto.Credential;
import com.miniorange.twofactor.crowd.webauthn.utils.AttestationExtension;
import com.miniorange.twofactor.crowd.webauthn.utils.AuthenticatorAttestationResponse;
import com.miniorange.twofactor.crowd.webauthn.utils.CableRegistrationData;
import com.miniorange.twofactor.crowd.webauthn.utils.PublicKeyCredential;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MoSettings {
    private static Log LOGGER = LogFactory.getLog(MoSettings.class);
    @ComponentImport
    private PluginSettingsFactory pluginSettingsFactory;
    private PluginSettings pluginSettings;
    @ComponentImport
    private I18nResolver i18nResolver;
    @ComponentImport
    private ApplicationProperties applicationProperties;
    @ComponentImport
    private UserManager userManager;

    @Autowired
    public MoSettings(PluginSettingsFactory pluginSettingsFactory, ApplicationProperties applicationProperties, I18nResolver i18nResolver, UserManager userManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.applicationProperties = applicationProperties;
        this.i18nResolver = i18nResolver;
        this.userManager = userManager;
    }

    public String getUsernameAttribute() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get(MoConstants.USERNAME.getKey())), (CharSequence)"NameID");
    }

    public void setUsernameAttribute(String usernameAttribute) {
        this.pluginSettings.put(MoConstants.USERNAME.getKey(), (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)usernameAttribute, (CharSequence)"NameID"))));
    }

    public String getCurrentLoggedInUser() {
        String username = "";
        String platform = this.i18nResolver.getText("my.plugin.platform");
        UserProfile user = this.userManager.getRemoteUser();
        if (user == null) {
            return "";
        }
        username = user.getUsername();
        LOGGER.debug("Platform is :- " + platform);
        LOGGER.debug("Username in moSerttings :- " + username + " The Platform is :- " + this.i18nResolver.getText("my.plugin.platform"));
        return username;
    }

    public int[] getJiraVersionNumber() {
        int[] a = new int[]{};
        return a;
    }

    public HashMap<String, String> getUserCredMap() {
        Object object = this.pluginSettings.get(MoConstants.USERCRED.getKey());
        if (object != null) {
            return (HashMap)object;
        }
        return new HashMap<String, String>();
    }

    public void setUserCredMap(HashMap<String, String> userCred) {
        this.pluginSettings.put(MoConstants.USERCRED.getKey(), userCred);
    }

    public void removeUserCred(String rawId, String username) {
        HashMap<String, String> map = this.getCredParamMap();
        String key = username + ";miniOrange;" + rawId;
        map.remove(key);
        this.setCredParamMap(map);
    }

    public void removeUserCred(List<String> rawIds, String username) {
        HashMap<String, String> map = this.getCredParamMap();
        for (String rawId : rawIds) {
            String key = username + ";miniOrange;" + rawId;
            map.remove(key);
        }
        this.setCredParamMap(map);
    }

    public Credential getUserCred(String userName) {
        HashMap<String, AttestationExtension> extensionMap;
        String userKey;
        HashMap<String, String> map = this.getCredParamMap();
        LOGGER.debug("GetUserCredMap :- " + map);
        if (!map.containsKey(userName) && userName.contains(";miniOrange;") && map.containsKey(userKey = userName.split(";miniOrange;")[0])) {
            String prevCredString = map.get(userKey);
            map.put(userName, prevCredString);
            map.remove(userKey);
        }
        String jsonStr = map.get(userName);
        JsonObject jsonObject = new JsonParser().parse(jsonStr).getAsJsonObject();
        AuthenticatorAttestationResponse attestation = null;
        try {
            attestation = new AuthenticatorAttestationResponse(jsonObject.get("makeCredentialResponse"));
        }
        catch (Exception e) {
            LOGGER.debug("Error OCcurred :- " + e);
        }
        if (attestation.getAttestationObject().getAuthenticatorData().hasExtensionData() && (extensionMap = attestation.getAttestationObject().getAuthenticatorData().getExtensionData()).containsKey("cableRegistration")) {
            CableRegistrationData cableRegistrationData = (CableRegistrationData)extensionMap.get("cableRegistration");
        }
        String credentialIdRecoded = BaseEncoding.base64Url().encode(BaseEncoding.base64Url().decode(jsonObject.get("credentialId").getAsString()));
        PublicKeyCredential cred = new PublicKeyCredential(credentialIdRecoded, jsonObject.get("type").getAsString(), BaseEncoding.base64Url().decode(jsonObject.get("credentialId").getAsString()), attestation);
        Credential credential = new Credential(cred);
        return credential;
    }

    public void setUserCred(String userName, Credential credential) {
        HashMap<String, String> map = this.getUserCredMap();
        String cred = credential.toJson();
        LOGGER.debug("String Saving in json format is :- " + cred);
        map.clear();
        map.put(userName, cred);
        this.setUserCredMap(map);
    }

    public HashMap<String, String> getUserRawIdForWebAuthn() {
        Object object = this.pluginSettings.get(MoConstants.RAWID_FOR_WEBAUTHN.getKey());
        if (object != null) {
            return (HashMap)object;
        }
        return new HashMap<String, String>();
    }

    public void setUserRawIdForWebAuthn(HashMap<String, String> roleMapping) {
        this.pluginSettings.put(MoConstants.RAWID_FOR_WEBAUTHN.getKey(), roleMapping);
    }

    public HashMap<String, String> getUserRawId() {
        Object object = this.pluginSettings.get(MoConstants.RAWID.getKey());
        if (object != null) {
            return (HashMap)object;
        }
        return new HashMap<String, String>();
    }

    public void setUserRawId(HashMap<String, String> roleMapping) {
        this.pluginSettings.put(MoConstants.RAWID.getKey(), roleMapping);
    }

    public void setCredParam(JsonElement makeCredentialResponse, String credentialId, String type, String currentUser, String rawId) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("makeCredentialResponse", makeCredentialResponse);
        jsonObject.addProperty("credentialId", credentialId);
        jsonObject.addProperty("type", type);
        String jsonStr = jsonObject.toString();
        HashMap<String, String> map = this.getCredParamMap();
        String credKey = currentUser + ";miniOrange;" + rawId;
        map.put(credKey, jsonStr);
        this.setCredParamMap(map);
    }

    public HashMap<String, String> getCredParamMap() {
        Object object = this.pluginSettings.get(MoConstants.CREDPARAM.getKey());
        if (object != null) {
            return (HashMap)object;
        }
        return new HashMap<String, String>();
    }

    public void setCredParamMap(HashMap<String, String> map) {
        this.pluginSettings.put(MoConstants.CREDPARAM.getKey(), map);
    }

    public void clearPluginSetting() {
        this.pluginSettings.remove(MoConstants.USERNAME.getKey());
        this.pluginSettings.remove(MoConstants.USERCRED.getKey());
        this.pluginSettings.remove(MoConstants.RAWID.getKey());
        this.pluginSettings.remove(MoConstants.CREDPARAM.getKey());
        this.pluginSettings.remove(MoConstants.ENABLE_WEBAUTHN.getKey());
        this.pluginSettings.remove(MoConstants.FORCE_WEBAUTHN.getKey());
        this.pluginSettings.remove(MoConstants.WEBAUTHN_DISABLED_USERS.getKey());
        this.pluginSettings.remove(MoConstants.NO_OF_USERS_PER_PAGE.getKey());
    }

    public void saveConfigurationSettings(Boolean enableWebAuthn, Boolean forceWebAuthn) {
        this.setEnableWebAuthn(enableWebAuthn);
        this.setForceWebAuthn(forceWebAuthn);
    }

    public void setEnableWebAuthn(Boolean enableWebAuthn) {
        this.pluginSettings.put(MoConstants.ENABLE_WEBAUTHN.getKey(), (Object)BooleanUtils.toString((Boolean)enableWebAuthn, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getEnableWebAuthn() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoConstants.ENABLE_WEBAUTHN.getKey()))), (boolean)false);
    }

    public void setForceWebAuthn(Boolean forceWebAuthn) {
        this.pluginSettings.put(MoConstants.FORCE_WEBAUTHN.getKey(), (Object)BooleanUtils.toString((Boolean)forceWebAuthn, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getForceWebAuthn() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBoolean((String)((String)this.pluginSettings.get(MoConstants.FORCE_WEBAUTHN.getKey()))), (boolean)false);
    }

    public String getApplicationBaseUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
    }

    public List<String> getListOfWebAuthnDisabledUsers() {
        if (this.pluginSettings.get(MoConstants.WEBAUTHN_DISABLED_USERS.getKey()) != null) {
            return (List)this.pluginSettings.get(MoConstants.WEBAUTHN_DISABLED_USERS.getKey());
        }
        return new ArrayList<String>();
    }

    public void setListOfWebAuthnDisabledUsers(List<String> userList) {
        this.pluginSettings.put(MoConstants.WEBAUTHN_DISABLED_USERS.getKey(), userList);
    }

    public Integer getNoOfUsersPerPage() {
        String noOfUsersPerPage = (String)this.pluginSettings.get(MoConstants.NO_OF_USERS_PER_PAGE.getKey());
        if (NumberUtils.isDigits((String)noOfUsersPerPage)) {
            return NumberUtils.createInteger((String)noOfUsersPerPage);
        }
        return 25;
    }

    public void setNoOfUsersPerPage(Integer num) {
        this.pluginSettings.put(MoConstants.NO_OF_USERS_PER_PAGE.getKey(), (Object)String.valueOf(num));
    }
}

