/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.webauthn;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
public class MoPluginManager {
    private static Log LOGGER = LogFactory.getLog(MoPluginManager.class);
    @ComponentImport
    private PluginLicenseManager pluginLicenseManager;

    public MoPluginManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public Boolean isEvaluationOrSubscriptionLicense() {
        PluginLicense pluginLicense;
        if (!this.isLicenseValid().booleanValue() && ((pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get()).isEvaluation() || pluginLicense.isSubscription())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseValid() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            LOGGER.debug(" pluginLicenseManager.getLicense().isDefined() : " + this.pluginLicenseManager.getLicense().isDefined());
            if (!((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid() || ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined()) {
                LOGGER.error("Invalid License");
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public boolean isLicenseDefined() {
        try {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            LOGGER.error("An exception occurs while verifying the license");
        }
        return Boolean.FALSE;
    }
}

