/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.gson.JsonObject;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorValidateDuoPushNotification
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorValidateDuoPushNotification.class);
    private static final String VM_PATH = "/templates/com/miniorange/twofactor/crowd/validate_duopushnotification.vm";
    private TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorValidateDuoPushNotification(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorValidateDuoPushNotification doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "Validate_DuoPushNotification").booleanValue()) {
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("baseUrl", this.pluginConfiguration.getBaseUrl());
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            Boolean enableRememberMeDevice = BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice()) && !BooleanUtils.toBoolean((Boolean)this.isInternetExplorer(req));
            context.put("enableRememberMeDevice", enableRememberMeDevice);
            ArrayList<String> errorMessage = new ArrayList<String>();
            try {
                if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isDuoPushNotificationSettingsConfigured())) {
                    JsonObject jsonObject = this.pluginHandler.sendDuoPushNotificationPreauth(username, req);
                    if (StringUtils.equalsIgnoreCase((CharSequence)"enroll", (CharSequence)jsonObject.get("result").getAsString())) {
                        errorMessage.add("Looks like you haven't configured Duo Push notification or your DUO configuration is lost. Please check the configuration first.");
                    }
                } else {
                    errorMessage.add("Issue with detecting duo push notification configuration. Please contact to administrator.");
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while sending Duo Push Notification pre auth request", e);
            }
            context.put("errorMessage", errorMessage);
            context.put("successMessage", "");
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            List<String> configuredMethodList = twoFactorUserClass.getConfigured2FAMethodsByUser();
            configuredMethodList.removeAll(Collections.singleton("DuoPushNotification"));
            Boolean shouldShowLinkToListMethod = Boolean.FALSE;
            if (configuredMethodList.size() >= 1) {
                shouldShowLinkToListMethod = Boolean.TRUE;
                context.put("validate2faMethodListUrl", this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist"));
            }
            context.put("shouldShowLinkToValidateListMethod", shouldShowLinkToListMethod);
            String template = this.pluginSettings.getValidateDuoPushNotificationTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                resp.setContentType("text/html;charset=utf-8");
                resp.getWriter().write(result);
                return;
            }
            this.renderer.render(VM_PATH, context, (Writer)resp.getWriter());
            return;
        }
        this.pluginHandler.redirectToValidUrl(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorValidateDuoPushNotification doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "Validate_DuoPushNotification").booleanValue()) {
            Integer loginAttemptsLeft;
            LOGGER.debug("User is valid user");
            HttpSession session = req.getSession();
            ArrayList<String> errorMessage = new ArrayList<String>();
            String successMessage = "";
            Boolean isValid = Boolean.TRUE;
            try {
                if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isDuoPushNotificationSettingsConfigured())) {
                    JsonObject jsonObject = this.pluginHandler.sendDuoPushNotificationPreauth(username, req);
                    if (StringUtils.equalsIgnoreCase((CharSequence)"enroll", (CharSequence)jsonObject.get("result").getAsString())) {
                        isValid = Boolean.FALSE;
                        errorMessage.add("Looks like you haven't configured Push notification or your DUO configuration is lost. Please check the configuration first.");
                    }
                } else {
                    errorMessage.add("Issue with detecting duo push notification configuration. Please contact to administrator.");
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while sending Duo Push Notification pre auth request", e);
            }
            if (isValid.booleanValue()) {
                session.setAttribute("SendingDuoPushNotificationRequest", (Object)Boolean.TRUE);
                isValid = this.pluginHandler.sendDuoPushNotificationAuth(username, req) != false || this.pluginHandler.sendDuoPhoneCallAuth(username, req) != false;
            }
            if (isValid.booleanValue() && session.getAttribute("SendingDuoPushNotificationRequest") != null) {
                LOGGER.debug("Push Notification validated Successfully...");
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "Login Successful", "DUO Push Notification");
                session.removeAttribute("SendingDuoPushNotificationRequest");
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                Boolean rememberMeOnThisDevice = Boolean.parseBoolean(req.getParameter("rememberMeOnThisDevice"));
                if (BooleanUtils.toBoolean((Boolean)rememberMeOnThisDevice)) {
                    String deviceDetails = MoTwoFactorUtility.getDeviceDetails(req);
                    LOGGER.debug("Current Device Details : " + deviceDetails);
                    List<String> rememberMeDeviceDetails = twoFactorUserClass.getRememberMeDeviceDetails();
                    if (StringUtils.isNotBlank((CharSequence)deviceDetails)) {
                        LOGGER.debug("Device details is not a blank");
                        LOGGER.debug("Stored Device Details : " + rememberMeDeviceDetails);
                        int rememberDeviceDuration = this.settings.getRememberMeDeviceDuration();
                        Calendar calendar = Calendar.getInstance();
                        calendar.add(5, rememberDeviceDuration);
                        Date date = calendar.getTime();
                        long newTimeInMili = date.getTime();
                        Boolean containsDeviceInList = Boolean.FALSE;
                        for (int i = 0; i < rememberMeDeviceDetails.size(); ++i) {
                            String device = rememberMeDeviceDetails.get(i);
                            if (!StringUtils.containsIgnoreCase((CharSequence)device, (CharSequence)deviceDetails)) continue;
                            LOGGER.debug("Changing device details time : " + newTimeInMili);
                            containsDeviceInList = Boolean.TRUE;
                            rememberMeDeviceDetails.add(i, deviceDetails.concat("=====" + newTimeInMili));
                            break;
                        }
                        if (!BooleanUtils.toBoolean((Boolean)containsDeviceInList)) {
                            if (deviceDetails.split("\\|\\|").length > 2) {
                                LOGGER.debug("Adding device details with time : " + newTimeInMili);
                                rememberMeDeviceDetails.add(deviceDetails.concat("=====" + newTimeInMili));
                            } else {
                                LOGGER.debug("Invalid Device Details : " + deviceDetails);
                            }
                        }
                        twoFactorUserClass.setRememberMeDeviceDetails(rememberMeDeviceDetails);
                        LOGGER.debug("After change Device Details : " + rememberMeDeviceDetails);
                        this.settings.setUserSettings(username, twoFactorUserClass);
                    }
                }
                session.setAttribute("2fa_verification", (Object)true);
                session.removeAttribute("executing_2fa_flow");
                this.settings.addTo2FAConfiguredUsersList(username);
                this.pluginHandler.redirectToValidUrl(req, resp);
                return;
            }
            LOGGER.error("Invalid response from Push Notification. Either timeout or user is performing other action.");
            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "Login Failed", "DUO Push Notification");
            session.removeAttribute("SendingDuoPushNotificationRequest");
            if (!BooleanUtils.toBoolean((Boolean)this.pluginHandler.checkBruteForceInvalidAttemptAction(req)) && BooleanUtils.toBoolean((Boolean)this.pluginHandler.shouldLockedOutUser(username))) {
                LOGGER.debug("User has exceeded number of invalid attempts");
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(req, this.settings), "Temporarily Locked", "DUO Push Notification");
                this.pluginHandler.performBruteForceUserLockAction(username, req);
                this.pluginHandler.performUserLogout(req, resp, username);
                resp.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/user_locked"));
                return;
            }
            if (errorMessage.isEmpty()) {
                errorMessage.add("Issue with validating Push Notification. Either user DENIED request or there was a timeout. Please try again.");
                LOGGER.debug("Issue with validating Push Notification. Either user DENIED request or there was a timeout. Please try again.");
            }
            if ((loginAttemptsLeft = Integer.valueOf(this.pluginHandler.checkNumberOfLoginAttemptsLeft(req, username))) == 2) {
                LOGGER.debug("Only a last 2 login attempts left");
                errorMessage.add("You will be locked out of your account after next 2 invalid login attempts!");
            } else if (loginAttemptsLeft == 1) {
                LOGGER.debug("Last login attempt");
                errorMessage.add("This is your last login attempt! Failed authentication  will lock you out of your account.");
            }
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("errorMessage", errorMessage);
            context.put("successMessage", successMessage);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/userLogout.action"));
            context.put("baseUrl", this.pluginConfiguration.getBaseUrl());
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            Boolean enableRememberMeDevice = BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice()) && !BooleanUtils.toBoolean((Boolean)this.isInternetExplorer(req));
            context.put("enableRememberMeDevice", enableRememberMeDevice);
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            List<String> configuredMethodList = twoFactorUserClass.getConfigured2FAMethodsByUser();
            configuredMethodList.removeAll(Collections.singleton("DuoPushNotification"));
            Boolean shouldShowLinkToListMethod = Boolean.FALSE;
            if (configuredMethodList.size() >= 1) {
                shouldShowLinkToListMethod = Boolean.TRUE;
                context.put("validate2faMethodListUrl", this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist"));
            }
            context.put("shouldShowLinkToValidateListMethod", shouldShowLinkToListMethod);
            String template = this.pluginSettings.getValidateDuoPushNotificationTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                resp.setContentType("text/html;charset=utf-8");
                resp.getWriter().write(result);
                return;
            }
            this.renderer.render(VM_PATH, context, (Writer)resp.getWriter());
            return;
        }
        this.pluginHandler.redirectToValidUrl(req, resp);
    }

    private Boolean isInternetExplorer(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        if (StringUtils.indexOfIgnoreCase((CharSequence)userAgent, (CharSequence)"MSIE") > 0 || StringUtils.indexOfIgnoreCase((CharSequence)userAgent, (CharSequence)"Trident/") > 0) {
            LOGGER.debug("Browser is IE");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

