/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistrationRemaining2FAMethods
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistrationRemaining2FAMethods.class);
    private static final String REMAINING_METHOD_LIST_VM_PATH = "/templates/com/miniorange/twofactor/crowd/inlineregistration_remaining2famethods.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorInlineRegistrationRemaining2FAMethods(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationRemaining2FAMethods doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("errorMessage", "");
            context.put("skipConfigurationUrl", this.pluginConfiguration.getDashboardUrl());
            context.put("continueConfigurationUrl", this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/configure2fabyuser");
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            MoTwoFactorCommonUserSettings userSettings = this.settings.getUserSettings(username);
            List<String> methodsConfiguredByUser = userSettings.getConfigured2FAMethodsByUser();
            LinkedList<String> remainingMethods = new LinkedList<String>();
            List<String> methodListForUser = this.settings.get2FAMethodForUserList();
            for (String method : methodListForUser) {
                if (methodsConfiguredByUser.contains(method)) continue;
                remainingMethods.add(this.getMethodName(method));
            }
            methodListForUser = this.settings.getBackupMethodForUserList();
            for (String method : methodListForUser) {
                if (methodsConfiguredByUser.contains(method)) continue;
                remainingMethods.add(this.getMethodName(method));
            }
            context.put("remainingMethods", remainingMethods);
            String template = this.pluginSettings.getInlineRegistration_remaining2faMethodsListTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(REMAINING_METHOD_LIST_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("console/secure/console.action"));
    }

    private String getMethodName(String method) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"SecurityQuestion", (CharSequence)method)) {
            return "Security Questions";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"GoogleAuthenticator", (CharSequence)method)) {
            return "Mobile Authenticator";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"OtpOverEmail", (CharSequence)method)) {
            return "OTP Over Email";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"YubikeyHardwareTokenAsU2F", (CharSequence)method)) {
            return "Yubikey Hardware Token";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"DuoPushNotification", (CharSequence)method)) {
            return "DUO Push Notification";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"WebAuthn", (CharSequence)method)) {
            return "Web Authentication as 2FA method";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"OtpOverSms", (CharSequence)method)) {
            return "OTP Over SMS";
        }
        return "Backup Code";
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

