/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.gson.JsonObject;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistrationDuoPushNotification
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistrationDuoPushNotification.class);
    private static final String REGISTRATION_VM_PATH = "/templates/com/miniorange/twofactor/crowd/inlineregistration_duopushnotification.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorInlineRegistrationDuoPushNotification(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationDuoPushNotification doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "InlineRegistration_DuoPushNotification").booleanValue()) {
            LOGGER.debug("inside if.........");
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("baseUrl", this.pluginConfiguration.getBaseUrl());
            ArrayList<String> errorMessage = new ArrayList<String>();
            String duoPushNotificationEnrollPortalUrl = "";
            try {
                if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isDuoPushNotificationSettingsConfigured())) {
                    JsonObject jsonObject = this.pluginHandler.sendDuoPushNotificationPreauth(username, request);
                    duoPushNotificationEnrollPortalUrl = StringUtils.equalsIgnoreCase((CharSequence)"enroll", (CharSequence)jsonObject.get("result").getAsString()) ? jsonObject.get("enroll_portal_url").getAsString() : "ENROLLED";
                } else {
                    errorMessage.add("Issue with sending email. Mail Server is not Configured. Please contact to administrator.");
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while sending Duo Push Notification pre auth request" + e);
            }
            LOGGER.debug("duoPushNotificationEnrollPortalUrl :" + duoPushNotificationEnrollPortalUrl);
            context.put("duoPushNotificationEnrollPortalUrl", duoPushNotificationEnrollPortalUrl);
            context.put("errorMessage", errorMessage);
            context.put("successMessage", "");
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            String template = this.pluginSettings.getConfigureDuoPushNotificationTemplate();
            LOGGER.debug("getting inline registration template :");
            if (StringUtils.isNotBlank((CharSequence)template)) {
                LOGGER.debug("rendering template..........");
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            this.renderer.render(REGISTRATION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        LOGGER.debug("inside else of do validate inline registration duo push notification.........");
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistrationDuoPushNotification doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            ArrayList<String> errorMessage = new ArrayList<String>();
            String successMessage = "";
            LOGGER.debug("Checking Push Notification Validation");
            HttpSession session = request.getSession();
            session.setAttribute("SendingDuoPushNotificationRequest", (Object)Boolean.TRUE);
            Boolean isValid = this.pluginHandler.sendDuoPushNotificationAuth(username, request) != false || this.pluginHandler.sendDuoPhoneCallAuth(username, request) != false;
            if (isValid.booleanValue() && session.getAttribute("SendingDuoPushNotificationRequest") != null) {
                this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Successful", "DUO Push Notification");
                LOGGER.debug("Push Notification validated Successfully...");
                session.removeAttribute("SendingDuoPushNotificationRequest");
                MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                twoFactorUserClass.setConfigured2FAMethodsByUser("DuoPushNotification");
                List<String> enabledBackupMethodList = this.settings.getBackupMethodForUserList();
                if (session.getAttribute("considering_backup_method") != null || StringUtils.isNotBlank((CharSequence)twoFactorUserClass.getCurrent2FAMethod())) {
                    LOGGER.debug("Configured DuoPush Noitification as a Backup Method");
                    session.removeAttribute("considering_backup_method");
                } else if (!enabledBackupMethodList.isEmpty()) {
                    LOGGER.debug("Backup Method is enabled. Redirecting to Backup Method.");
                    twoFactorUserClass.setCurrent2FAMethod("DuoPushNotification");
                    this.settings.setUserSettings(username, twoFactorUserClass);
                    String url = this.pluginHandler.getInlineRegistrationBackupMethodUrl(request, twoFactorUserClass.getConfigured2FAMethodsByUser());
                    if (StringUtils.isNotBlank((CharSequence)url)) {
                        response.sendRedirect(url);
                        return;
                    }
                } else {
                    LOGGER.debug("Setting up DuoPush Noitification primary method");
                    twoFactorUserClass.setCurrent2FAMethod("DuoPushNotification");
                }
                LOGGER.debug("2FA is Configured successfully");
                session.setAttribute("2fa_verification", (Object)true);
                session.removeAttribute("executing_2fa_flow");
                if (this.settings.getShowRemaining2FAMethodsAfterInlineRegistration().booleanValue() && this.settings.get2FAMethodForUserList().size() + this.settings.getBackupMethodForUserList().size() - twoFactorUserClass.getConfigured2FAMethodsByUser().size() > 0) {
                    session.setAttribute("2fa_show_remaining_methods", (Object)true);
                }
                this.settings.addTo2FAConfiguredUsersList(username);
                this.settings.setUserSettings(username, twoFactorUserClass);
                this.pluginHandler.redirectToValidUrl(request, response);
                return;
            }
            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "2FA Configuration Failed", "DUO Push Notification");
            errorMessage.add("Issue with validating the request. Please try again.");
            session.removeAttribute("SendingDuoPushNotificationRequest");
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("errorMessage", errorMessage);
            context.put("successMessage", successMessage);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/userLogout.action"));
            context.put("baseUrl", this.pluginConfiguration.getBaseUrl());
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            String pushNotificationEnrollPortalUrl = "";
            try {
                if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isDuoPushNotificationSettingsConfigured())) {
                    JsonObject jsonObject = this.pluginHandler.sendDuoPushNotificationPreauth(username, request);
                    pushNotificationEnrollPortalUrl = StringUtils.equalsIgnoreCase((CharSequence)"enroll", (CharSequence)jsonObject.get("result").getAsString()) ? jsonObject.get("enroll_portal_url").getAsString() : "ENROLLED";
                } else {
                    errorMessage.add("Issue with sending email. Mail Server is not Configured. Please contact to administrator.");
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while sending Duo Push Notification pre auth request" + e);
            }
            context.put("duoPushNotificationEnrollPortalUrl", pushNotificationEnrollPortalUrl);
            String template = this.pluginSettings.getConfigureDuoPushNotificationTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            this.renderer.render(REGISTRATION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }
}

