/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorInlineRegistration
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorInlineRegistration.class);
    private static final String INLINEREGISTRATION_VM_PATH = "/templates/com/miniorange/twofactor/crowd/inlineregistration_showinfo.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorInlineRegistration(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorInlineRegistration doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("contextPath", this.pluginConfiguration.getBaseUrl());
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            String nextPageUrl = "";
            if (BooleanUtils.toBoolean((Boolean)this.settings.getEnableEnforce2faMethodForUser())) {
                String method = this.settings.getPrimary2faMethodForUser();
                LOGGER.debug("Enforce Primary method is selected : " + method);
                if (method.equalsIgnoreCase("GoogleAuthenticator")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_googleauthenticator");
                } else if (method.equalsIgnoreCase("OtpOverEmail")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoveremail");
                } else if (method.equalsIgnoreCase("OtpOverSms")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoversms");
                } else if (method.equalsIgnoreCase("SecurityQuestion")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_securityquestion");
                } else if (method.equalsIgnoreCase("YubikeyHardwareTokenAsU2F")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_webauthnhardwaretoken");
                } else if (method.equalsIgnoreCase("WebAuthn")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_webauthnas2famethod");
                } else if (method.equalsIgnoreCase("DuoPushNotification")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_duopushnotification");
                }
            } else {
                List<String> methodsForUser = this.settings.get2FAMethodForUserList();
                if (methodsForUser.size() > 1) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_2famethodlist");
                } else if (methodsForUser.contains("GoogleAuthenticator")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_googleauthenticator");
                } else if (methodsForUser.contains("OtpOverEmail")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoveremail");
                } else if (methodsForUser.contains("OtpOverSms")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_otpoversms");
                } else if (methodsForUser.contains("SecurityQuestion")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_securityquestion");
                } else if (methodsForUser.contains("YubikeyHardwareTokenAsU2F")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_webauthnhardwaretoken");
                } else if (methodsForUser.contains("WebAuthn")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_webauthnas2famethod");
                } else if (methodsForUser.contains("DuoPushNotification")) {
                    nextPageUrl = this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/inlineregistration_duopushnotification");
                }
            }
            context.put("nextPage", nextPageUrl);
            String template = this.pluginSettings.getWelcomeMessageTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(INLINEREGISTRATION_VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        LOGGER.debug("user is not logged in ");
        response.sendRedirect(this.pluginConfiguration.getBaseUrl());
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

