/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorAjaxCallsEditServlet
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoTwoFactorAjaxCallsEditServlet.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    @ComponentImport
    private CrowdService crowdService;
    private Boolean responseSent;

    public MoTwoFactorAjaxCallsEditServlet(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings, CrowdService crowdService) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
        this.crowdService = crowdService;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("Calling Ajax with edit access");
        String action = MoTwoFactorUtility.sanitizeText(request.getParameter("action"));
        LOGGER.debug("action to perform :" + action);
        this.responseSent = Boolean.FALSE;
        if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
            LOGGER.error("Invalid license found");
            this.sendErrorResponse("Invalid License Found", response);
            return;
        }
        if (!this.pluginHandler.isTwoFactorVerifiedOrIsTwoFactorDisabled(request).booleanValue()) {
            LOGGER.error("Either 2FA is not verified by the user or 2FA is disabled for them");
            this.sendErrorResponse("Not enough permission", response);
            return;
        }
        List<String> userAccessiblePages = this.pluginHandler.getUserAccessiblePages();
        if (userAccessiblePages.contains("Basic_Configuration_readwrite") && !this.responseSent.booleanValue()) {
            switch (action) {
                case "Enable2faForAllUsers": {
                    this.enable2FAForAllUser(request, response);
                    break;
                }
                case "Disable2faForAllUsers": {
                    this.disable2FAForAllUser(request, response);
                    break;
                }
                case "Enable2faForSoftware": {
                    this.enable2faForSoftware(request, response);
                    break;
                }
                case "Disable2faForSoftware": {
                    this.disable2faForSoftware(request, response);
                    break;
                }
                case "SavedMethodSettings": {
                    this.SavedMethodSettings(request, response);
                    break;
                }
                case "ConfigureMobileAuthnSettings": {
                    this.ConfigureMobileAuthnSettings(request, response);
                    break;
                }
                case "ConfigureDuoPushSettings": {
                    this.ConfigureDuoPushSettings(request, response);
                    break;
                }
                case "ConfigureWebAuthnSettings": {
                    this.ConfigureWebAuthnSettings(request, response);
                    break;
                }
                case "ConfigureOtpOverEmailSettings": {
                    this.ConfigureOtpOverEmailSettings(request, response);
                }
            }
        }
        if (userAccessiblePages.contains("User_Management_readwrite") && !this.responseSent.booleanValue()) {
            switch (action) {
                case "Disable2faForUser": {
                    this.disable2FAForUser(request, response);
                    break;
                }
                case "Enable2faForUser": {
                    this.enable2FAForUser(request, response);
                    break;
                }
                case "Reset2faForUser": {
                    this.reset2FAForUser(request, response);
                    break;
                }
                case "Enable2faForSelectedUsers": {
                    this.enable2FAForSelectedUsers(request, response);
                    break;
                }
                case "Disable2faForSelectedUsers": {
                    this.disable2faForSelectedUsers(request, response);
                    break;
                }
                case "Enable2faForAllUsers": {
                    this.enable2FAForAllUser(request, response);
                    break;
                }
                case "Disable2faForAllUsers": {
                    this.disable2FAForAllUser(request, response);
                    break;
                }
                case "Reset2faForSelectedUsers": {
                    this.reset2faForSelectedUsers(request, response);
                    break;
                }
                case "Reset2faForAllUsers": {
                    this.reset2FAForAllUser(request, response);
                    break;
                }
                case "Enable2faForGroup": {
                    this.enable2faForGroup(request, response);
                    break;
                }
                case "Disable2faForGroup": {
                    this.disable2faForGroup(request, response);
                    break;
                }
                case "Enable2faForSelectedGroups": {
                    this.enable2FAForSelectedGroups(request, response);
                    break;
                }
                case "Disable2faForSelectedGroups": {
                    this.disable2faForSelectedGroups(request, response);
                    break;
                }
                case "Enable2faForAllGroups": {
                    this.enable2FAForAllGroups(request, response, true);
                    break;
                }
                case "Disable2faForAllGroups": {
                    this.disable2FAForAllGroups(request, response, true);
                    break;
                }
                case "RemoveLockedUser": {
                    this.removeLockedUser(request, response);
                    break;
                }
                case "RemoveSelectedLockedUsers": {
                    this.removeSelectedLockedUsers(request, response);
                    break;
                }
                case "RemoveAllLockedUsers": {
                    this.removeAllLockedUsers(request, response);
                }
            }
        }
        if (userAccessiblePages.contains("IP_Restriction_readwrite") && !this.responseSent.booleanValue()) {
            switch (action) {
                case "RemoveWhitelistIp": {
                    this.removeWhitelistIp(request, response);
                    break;
                }
                case "RemoveBlacklistIp": {
                    this.removeBlacklistIp(request, response);
                    break;
                }
                case "RemoveSelectedWhitelistIps": {
                    this.removeSelectedWhitelistIps(request, response);
                    break;
                }
                case "RemoveSelectedBlacklistIps": {
                    this.removeSelectedBlacklistIps(request, response);
                    break;
                }
                case "RemoveAllWhitelistIps": {
                    this.removeAllWhitelistIps(request, response);
                    break;
                }
                case "RemoveAllBlacklistIps": {
                    this.removeAllBlacklistIps(request, response);
                }
            }
        }
        if (userAccessiblePages.contains("Advanced_Settings_readwrite") && !this.responseSent.booleanValue()) {
            switch (action) {
                case "RemoveSkip2FAUrl": {
                    this.removeSkip2FAUrl(request, response);
                }
            }
        }
        if (!this.responseSent.booleanValue()) {
            LOGGER.error("The Requested method is not allowed or the user do not have enough access");
            response.setContentType("application/json");
            response.sendError(405, "The requested method is not allowed or you do not have enough access.");
        }
    }

    private void removeSkip2FAUrl(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.info("Calling removeSkip2FAUrl");
        try {
            String url = MoTwoFactorUtility.sanitizeText(request.getParameter("url"));
            LOGGER.debug("Removing URL : " + url);
            List<String> skip2FAUrlList = this.settings.getSkip2FAForGivenUrlList();
            LOGGER.debug("Before Remove : " + skip2FAUrlList);
            skip2FAUrlList.remove(url);
            LOGGER.debug("After Remove : " + skip2FAUrlList);
            this.settings.setSkip2FAForGivenUrlList(skip2FAUrlList);
            String skip2FAUrlString = this.settings.getSkip2faUrls();
            LOGGER.debug("skip2FAUrlString before removing specific url : " + skip2FAUrlString);
            String[] urls = skip2FAUrlString.split(";");
            Object[] updated_urls = new String[urls.length];
            int counter = 0;
            for (int index = 0; index < urls.length; ++index) {
                if (urls[index].equals(url)) continue;
                updated_urls[counter] = urls[index];
                ++counter;
            }
            skip2FAUrlString = StringUtils.join((Object[])updated_urls, (String)";");
            LOGGER.debug("skip2FAUrlString after removing specific url : " + skip2FAUrlString);
            this.settings.setSkip2faUrls(skip2FAUrlString);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing URL : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeAllBlacklistIps(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeAllBlacklistIps");
        try {
            this.settings.setBlacklistIpAddressWithMessages(new HashMap<String, String>());
            LOGGER.debug("Successfully Removed All IPs from Blacklist");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Blacklist IP : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeAllWhitelistIps(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeAllWhitelistIps");
        try {
            this.settings.setWhitelistIpAddressWithMessages(new HashMap<String, String>());
            LOGGER.debug("Successfully Removed All IPs from Whitelist");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Whitelist IP : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeSelectedBlacklistIps(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeSelectedBlacklistIps");
        try {
            String[] selectedBlacklistIps = request.getParameterValues("selectedBlacklistIps");
            Map<String, String> blacklistIpAddressMessageMap = this.settings.getBlacklistIpAddressWithMessages();
            for (String ipAddress : selectedBlacklistIps) {
                blacklistIpAddressMessageMap.entrySet().removeIf(entry -> ipAddress.equals(entry.getKey()));
            }
            this.settings.setBlacklistIpAddressWithMessages(blacklistIpAddressMessageMap);
            LOGGER.debug("Successfully Removed Selected IPs from Blacklist");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Blacklist IP : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeSelectedWhitelistIps(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeSelectedWhitelistIps");
        try {
            String[] selectedWhitelistIps = request.getParameterValues("selectedWhitelistIps");
            Map<String, String> whitelistIpAddressMessageMap = this.settings.getWhitelistIpAddressWithMessages();
            for (String ipAddress : selectedWhitelistIps) {
                whitelistIpAddressMessageMap.entrySet().removeIf(entry -> ipAddress.equals(entry.getKey()));
            }
            this.settings.setWhitelistIpAddressWithMessages(whitelistIpAddressMessageMap);
            LOGGER.debug("Successfully Removed Selected IPs from Whitelist");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Whitelist IP : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeBlacklistIp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeBlacklistIp");
        try {
            String ipAddress = MoTwoFactorUtility.sanitizeText(request.getParameter("ipAddress"));
            Map<String, String> blacklistIpAddressMessageMap = this.settings.getBlacklistIpAddressWithMessages();
            LOGGER.debug("Before Remove : " + blacklistIpAddressMessageMap);
            blacklistIpAddressMessageMap.remove(ipAddress);
            LOGGER.debug("After Remove : " + blacklistIpAddressMessageMap);
            this.settings.setBlacklistIpAddressWithMessages(blacklistIpAddressMessageMap);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Blacklist IP : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeWhitelistIp(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeWhitelistIp");
        try {
            String ipAddress = MoTwoFactorUtility.sanitizeText(request.getParameter("ipAddress"));
            LOGGER.debug("Removing IP : " + ipAddress);
            Map<String, String> whitelistIpAddressMessageMap = this.settings.getWhitelistIpAddressWithMessages();
            LOGGER.debug("Before Remove : " + whitelistIpAddressMessageMap);
            whitelistIpAddressMessageMap.remove(ipAddress);
            LOGGER.debug("After Remove : " + whitelistIpAddressMessageMap);
            this.settings.setWhitelistIpAddressWithMessages(whitelistIpAddressMessageMap);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Whitelist IP : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeAllLockedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeAllLockedUsers");
        try {
            this.settings.setLockedUserDetails(new HashMap<String, String>());
            LOGGER.debug("Successfully Removed All Users from Locked List");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Locked User : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeSelectedLockedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeSelectedLockedUsers");
        try {
            String[] selectedLockedUserList = request.getParameterValues("selectedLockedUserList");
            Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
            for (String selectedUser : selectedLockedUserList) {
                LOGGER.debug("Removing Locked User : " + selectedUser);
                if (!lockedUserDetails.containsKey(selectedUser)) continue;
                lockedUserDetails.remove(selectedUser);
            }
            this.settings.setLockedUserDetails(lockedUserDetails);
            LOGGER.debug("Successfully Removed Selected User from Locked List");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Locked User : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void removeLockedUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling removeLockedUser");
        try {
            String username = MoTwoFactorUtility.sanitizeText(request.getParameter("username").trim());
            LOGGER.debug("Removing Locked User : " + username);
            Map<String, String> lockedUserDetails = this.settings.getLockedUserDetails();
            if (lockedUserDetails.containsKey(username)) {
                lockedUserDetails.remove(username);
                this.settings.setLockedUserDetails(lockedUserDetails);
            }
            LOGGER.debug("Successfully Removed User from Locked List: " + username);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Removing Locked User : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2FAForAllUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2FAForAllUser");
        try {
            EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
            LOGGER.debug("Query for User : " + query);
            Iterable usersFromSystem = this.crowdService.search((Query)query);
            List<String> enabled2FAUserList = this.settings.getEnable2FAForUsersList();
            for (User user : usersFromSystem) {
                if (enabled2FAUserList.contains(user.getName())) continue;
                LOGGER.debug("Enabling 2FA for :-" + user.getName());
                this.performEnable2FAForUser(user.getName());
            }
            this.settings.setEnable2FAForAllUsers(Boolean.TRUE);
            LOGGER.debug("Successfully Enabled 2FA for All Users");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Enabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2FAForAllUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2FAForAllUser");
        try {
            List<String> enabled2FAUserList = this.settings.getEnable2FAForUsersList();
            LOGGER.debug("Total 2FA Enabled User Count : " + enabled2FAUserList.size());
            for (int i = enabled2FAUserList.size() - 1; i >= 0; --i) {
                String username = enabled2FAUserList.get(i);
                this.performDisable2FAForUser(username);
            }
            this.settings.setEnable2FAForAllUsers(Boolean.FALSE);
            LOGGER.debug("Successfully Disabled 2FA for All Users");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Disabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2FAForAllGroups(HttpServletRequest request, HttpServletResponse response, Boolean sendResponseBack) throws IOException {
        LOGGER.debug("Calling disable2FAForAllGroups");
        try {
            List<String> enable2FAGroupList = this.settings.getEnable2FAForGroupsList();
            LOGGER.debug("Total 2FA enabled Groups : " + enable2FAGroupList.size());
            for (int i = enable2FAGroupList.size() - 1; i >= 0; --i) {
                String groupname = enable2FAGroupList.get(i);
                LOGGER.debug("Disabling 2FA for Group :" + groupname);
                this.performDisable2FAForGroup(groupname, true);
            }
            this.settings.setEnable2FAForGroupsList(new ArrayList<String>());
            LOGGER.debug("Successfully Disable 2FA for All Groups");
            if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                this.sendSuccessFullResponse("Success", response);
            }
        }
        catch (Exception e) {
            LOGGER.error("Issue with disabling 2FA : " + e);
            if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                this.sendErrorResponse("Error", response);
            }
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void enable2FAForAllGroups(HttpServletRequest request, HttpServletResponse response, Boolean sendResponseBack) throws IOException {
        LOGGER.debug("Calling enable2FAForAllGroups");
        try {
            EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
            List<String> enable2FAGroupList = this.settings.getEnable2FAForGroupsList();
            LOGGER.debug("Query for Group : " + query);
            Iterable groupsFromSystem = this.crowdService.search((Query)query);
            for (Group group : groupsFromSystem) {
                if (enable2FAGroupList.contains(group.getName())) continue;
                enable2FAGroupList.add(group.getName());
                this.performEnable2FAForGroup(group.getName());
            }
            this.settings.setEnable2FAForGroupsList(enable2FAGroupList);
            LOGGER.debug("Successfully Enabled 2FA for All Groups");
            if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                this.sendSuccessFullResponse("Success", response);
            }
        }
        catch (Exception e) {
            LOGGER.error("Issue with enabling 2FA : " + e);
            if (BooleanUtils.toBoolean((Boolean)sendResponseBack)) {
                this.sendErrorResponse("Error", response);
            }
            response.sendRedirect(this.pluginConfiguration.getBaseUrl());
        }
    }

    private void disable2faForSelectedGroups(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2faForSelectedGroups");
        try {
            String[] selectedGroup;
            List<String> enable2FAGroupList = this.settings.getEnable2FAForGroupsList();
            for (String groupname : selectedGroup = request.getParameterValues("selectedGroups")) {
                if (!enable2FAGroupList.contains(groupname)) continue;
                enable2FAGroupList.removeAll(Collections.singleton(groupname));
                this.settings.setEnable2FAForGroupsList(enable2FAGroupList);
                this.performDisable2FAForGroup(groupname, false);
            }
            this.settings.setEnable2FAForGroupsList(enable2FAGroupList);
            LOGGER.debug("Successfully Disabled 2FA for Selected Groups");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Disabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2FAForSelectedGroups(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2FAForSelectedGroups");
        try {
            String[] selectedGroup;
            List<String> enable2FAGroupList = this.settings.getEnable2FAForGroupsList();
            for (String groupname : selectedGroup = request.getParameterValues("selectedGroups")) {
                if (enable2FAGroupList.contains(groupname)) continue;
                this.performEnable2FAForGroup(groupname);
                enable2FAGroupList.add(groupname);
            }
            this.settings.setEnable2FAForGroupsList(enable2FAGroupList);
            LOGGER.error("Successfully Enabled 2FA for Selected Groups");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Enabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2faForGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2faForGroup");
        try {
            String groupname = MoTwoFactorUtility.sanitizeText(request.getParameter("groupname").trim());
            LOGGER.debug("Enabling 2FA for Group : " + groupname);
            List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
            if (!enable2FAForGroupsList.contains(groupname)) {
                enable2FAForGroupsList.add(groupname);
                this.performEnable2FAForGroup(groupname);
                this.settings.setEnable2FAForGroupsList(enable2FAForGroupsList);
            }
            LOGGER.debug("Successfully Enabled 2FA for Group : " + groupname);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with enabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2faForGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2faForGroup");
        try {
            String groupname = MoTwoFactorUtility.sanitizeText(request.getParameter("groupname").trim());
            LOGGER.debug("Disabling 2FA for Group : " + groupname);
            List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
            if (enable2FAForGroupsList.contains(groupname)) {
                enable2FAForGroupsList.removeAll(Collections.singleton(groupname));
                this.settings.setEnable2FAForGroupsList(enable2FAForGroupsList);
                this.performDisable2FAForGroup(groupname, false);
            }
            LOGGER.debug("Successfully Disable 2FA for Group : " + groupname);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with disabling 2fa : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void reset2faForSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling reset2faForSelectedUsers");
        try {
            String[] selectedUser;
            for (String username : selectedUser = request.getParameterValues("selectedUsers")) {
                this.performReset2FAForUser(username);
            }
            LOGGER.debug("Successfully Reset 2FA for Selected Users");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with resetting 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2faForSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2faForSelectedUsers");
        try {
            String[] selectedUser;
            for (String username : selectedUser = request.getParameterValues("selectedUsers")) {
                this.performDisable2FAForUser(username);
            }
            LOGGER.debug("Successfully Disabled 2FA for Selected Users");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Disabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2FAForSelectedUsers(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2FAForSelectedUsers");
        try {
            String[] selectedUser;
            for (String username : selectedUser = request.getParameterValues("selectedUsers")) {
                this.performEnable2FAForUser(username);
            }
            LOGGER.debug("Successfully Enabled 2FA for Selected Users");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Enabling 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void reset2FAForAllUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling reset2FAForAllUser");
        try {
            List<String> configured2FAUsers = this.settings.getListOf2FAConfiguredUsers();
            LOGGER.debug("Total 2FA Enabled User Count : " + configured2FAUsers.size());
            for (int i = configured2FAUsers.size() - 1; i >= 0; --i) {
                String username = configured2FAUsers.get(i);
                LOGGER.debug("Resetting 2FA for User :" + username);
                this.performReset2FAForUser(username);
            }
            LOGGER.debug("Successfully Reset 2FA for All Users");
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Resetting 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void reset2FAForUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling reset2FAForUser");
        try {
            String username = MoTwoFactorUtility.sanitizeText(request.getParameter("username").trim());
            if (BooleanUtils.toBoolean((Boolean)this.performReset2FAForUser(username))) {
                LOGGER.debug("Successfully Reset 2FA for Username : " + username);
                this.sendSuccessFullResponse("Success", response);
            } else {
                LOGGER.debug("Issue with resetting 2fa for username : " + username);
                this.sendErrorResponse("Error", response);
            }
        }
        catch (Exception e) {
            LOGGER.error("Issue with Resetting 2FA : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2FAForUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2FAForUser");
        try {
            String username = MoTwoFactorUtility.sanitizeText(request.getParameter("username").trim());
            LOGGER.debug("Enabling 2FA for Username : " + username);
            if (BooleanUtils.toBoolean((Boolean)this.performEnable2FAForUser(username))) {
                LOGGER.debug("Successfully Enabled 2FA for Username : " + username);
                this.sendSuccessFullResponse("Success", response);
            } else {
                LOGGER.debug("Issue with enabling 2fa for username : " + username);
                this.sendErrorResponse("Error", response);
            }
        }
        catch (Exception e) {
            LOGGER.error("Issue with enabling 2fa : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2FAForUser(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2FAForUser");
        try {
            String username = MoTwoFactorUtility.sanitizeText(request.getParameter("username").trim());
            LOGGER.debug("Disabling 2FA for Username : " + username);
            if (BooleanUtils.toBoolean((Boolean)this.performDisable2FAForUser(username))) {
                LOGGER.debug("Successfully Disabled 2FA for Username : " + username);
                this.sendSuccessFullResponse("Success", response);
            } else {
                LOGGER.debug("Issue with disabling 2fa for username : " + username);
                this.sendErrorResponse("Error", response);
            }
        }
        catch (Exception e) {
            LOGGER.error("Issue with disabling 2fa : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void enable2faForSoftware(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling enable2faForSoftware");
        try {
            this.settings.setEnableTwoFactor(true);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Enabling 2FA for crowd : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void disable2faForSoftware(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Calling disable2faForSoftware");
        try {
            this.settings.setEnableTwoFactor(false);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            LOGGER.error("Issue with Disabling 2FA for crowd : " + e);
            this.sendErrorResponse("Error", response);
        }
    }

    private void ConfigureMobileAuthnSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            LOGGER.debug("Saving Mobile Authenticator Settings");
            String appLabel = req.getParameter("appLabel");
            String showSupportedAppPopup = req.getParameter("showSupportedAppPopup");
            String enableShareSecretKey = req.getParameter("enableShareSecretKey");
            LOGGER.debug("appLabel :" + appLabel);
            LOGGER.debug("showSupportedAppPopup :" + showSupportedAppPopup);
            LOGGER.debug("enableShareSecretKey :" + enableShareSecretKey);
            if (appLabel != null) {
                this.settings.setAppLabel(appLabel, "Crowd");
            }
            if (showSupportedAppPopup != null) {
                this.settings.setShowSupportedAppPopup(BooleanUtils.toBoolean((String)showSupportedAppPopup));
            }
            if (enableShareSecretKey != null) {
                this.settings.setEnableShareSecretKey(BooleanUtils.toBoolean((String)enableShareSecretKey));
            }
            this.sendSuccessFullResponse("Success", resp);
        }
        catch (Exception e) {
            LOGGER.error("Error while saving Mobile Authenticator settings :" + e.getMessage());
            this.sendErrorResponse("Error", resp);
        }
    }

    private void ConfigureDuoPushSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Saving Duo Push Notification Settings");
        String duoPushNotificationIntegrationKey = req.getParameter("duoPushNotificationIntegrationKey");
        String duoPushNotificationSecretKey = req.getParameter("duoPushNotificationSecretKey");
        String duoPushNotificationHostName = req.getParameter("duoPushNotificationHostName");
        LOGGER.debug("duoPushNotificationIntegrationKey :" + duoPushNotificationIntegrationKey);
        LOGGER.debug("duoPushNotificationSecretKey :" + duoPushNotificationSecretKey);
        LOGGER.debug("duoPushNotificationHostName :" + duoPushNotificationHostName);
        if (this.pluginHandler.isValidIntegrationKeyAndSecretKey(duoPushNotificationIntegrationKey, duoPushNotificationSecretKey, duoPushNotificationHostName).booleanValue()) {
            try {
                LOGGER.debug("Saving Duo Push Notification Settings");
                this.settings.setDuoPushNotificationIntegrationKey(duoPushNotificationIntegrationKey);
                this.settings.setDuoPushNotificationSecretKey(duoPushNotificationSecretKey);
                this.settings.setDuoPushNotificationHostName(duoPushNotificationHostName);
                this.sendSuccessFullResponse("Success", resp);
            }
            catch (Exception e) {
                LOGGER.error("Error while saving Duo Push Notifications settings :" + e.getMessage());
                this.sendErrorResponse("Error", resp);
            }
        } else {
            LOGGER.debug("Invalid Duo Push credentials");
            this.sendErrorResponse("Invalid Duo Push credentials", resp);
        }
    }

    private void ConfigureWebAuthnSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            LOGGER.debug("Saving Web Authn Settings");
            String attestationType = req.getParameter("attestationType");
            String authenticatorType = req.getParameter("authenticatorType");
            String userVerification = req.getParameter("userVerification");
            String residentKey = req.getParameter("residentKey");
            LOGGER.debug("attestationType :" + attestationType);
            LOGGER.debug("authenticatorType :" + authenticatorType);
            LOGGER.debug("userVerification :" + userVerification);
            LOGGER.debug("residentKey :" + residentKey);
            if (StringUtils.isNotBlank((CharSequence)attestationType)) {
                this.settings.setAttestationType(attestationType);
            }
            if (StringUtils.isNotBlank((CharSequence)authenticatorType)) {
                this.settings.setAuthenticatorType(authenticatorType);
            }
            if (StringUtils.isNotBlank((CharSequence)userVerification)) {
                this.settings.setUserVerification(userVerification);
            }
            if (StringUtils.isNotBlank((CharSequence)residentKey)) {
                this.settings.setResidentKey(residentKey);
            }
            this.sendSuccessFullResponse("Success", resp);
        }
        catch (Exception e) {
            LOGGER.error("Error while saving Web Authn Notifications settings :" + e.getMessage());
            this.sendErrorResponse("Error", resp);
        }
    }

    private void ConfigureOtpOverEmailSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            int number;
            LOGGER.debug("Saving Otp over Email Settings");
            String emailSubject = req.getParameter("emailSubject");
            String emailTemplate = req.getParameter("emailTemplate");
            String otpLength = req.getParameter("otpLength");
            String otpValidityDuration = req.getParameter("otpValidityDuration");
            emailSubject = MoTwoFactorUtility.sanitizeText(emailSubject);
            Boolean isError = Boolean.FALSE;
            try {
                number = Integer.parseInt(otpLength);
                if (number > 8 || number < 4) {
                    LOGGER.error("Invalid OTP Length. The OTP Length must be between 4 to 8.");
                    isError = Boolean.TRUE;
                }
            }
            catch (Exception e) {
                LOGGER.error("Please enter valid OTP Length. OTP Length should be in number format.");
                isError = Boolean.TRUE;
            }
            try {
                number = Integer.parseInt(otpValidityDuration);
                if (number > 30 || number < 1) {
                    LOGGER.error("Invalid OTP Validity Duration. The OTP Validity Duration must be between 1 and 30.");
                    isError = Boolean.TRUE;
                }
            }
            catch (Exception e) {
                LOGGER.error("Please enter valid OTP Validity Duration. OTP Validity Duration date should be in number format.");
                isError = Boolean.TRUE;
            }
            LOGGER.debug("emailSubject :" + emailSubject);
            LOGGER.debug("emailTemplate :" + emailTemplate);
            LOGGER.debug("otpLength :" + otpLength);
            LOGGER.debug("otpValidityDuration :" + otpValidityDuration);
            if (!isError.booleanValue()) {
                if (StringUtils.isNotBlank((CharSequence)emailSubject)) {
                    this.settings.setEmailSubject(emailSubject);
                }
                this.settings.setEmailTemplate(emailTemplate);
                if (StringUtils.isNotBlank((CharSequence)otpLength)) {
                    this.settings.setOtpLength(Integer.parseInt(otpLength));
                }
                if (StringUtils.isNotBlank((CharSequence)otpValidityDuration)) {
                    this.settings.setOtpValidityDuration(Integer.parseInt(otpValidityDuration));
                }
            }
            this.sendSuccessFullResponse("Success", resp);
        }
        catch (Exception e) {
            LOGGER.error("Error while saving Otp Over Email settings :" + e.getMessage());
            this.sendErrorResponse("Error", resp);
        }
    }

    private void SavedMethodSettings(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String selectedMethod = req.getParameter("selectedMethod");
            String enabled = req.getParameter("enabled");
            String Main = req.getParameter("Main");
            String FromRadio = req.getParameter("FromRadio");
            LOGGER.debug(" FromRadio :" + FromRadio);
            LOGGER.debug(" selectedMethod :" + selectedMethod);
            if (BooleanUtils.toBoolean((String)FromRadio)) {
                selectedMethod = selectedMethod.contains("Main") ? selectedMethod.substring(0, selectedMethod.length() - 4) : selectedMethod.substring(0, selectedMethod.length() - 6);
            }
            List<String> twoFactorMethodForUserList = this.settings.get2FAMethodForUserList();
            List<String> backupMethodForUserList = this.settings.getBackupMethodForUserList();
            String methodName = selectedMethod.substring(2);
            if (BooleanUtils.toBoolean((String)enabled)) {
                if (BooleanUtils.toBoolean((String)Main)) {
                    if (!twoFactorMethodForUserList.contains(methodName)) {
                        if (StringUtils.contains((CharSequence)methodName, (CharSequence)"YubikeyHardwareTokenAsU2F") && (twoFactorMethodForUserList.contains("WebAuthn") || backupMethodForUserList.contains("WebAuthn")) || StringUtils.contains((CharSequence)methodName, (CharSequence)"WebAuthn") && (twoFactorMethodForUserList.contains("YubikeyHardwareTokenAsU2F") || backupMethodForUserList.contains("YubikeyHardwareTokenAsU2F"))) {
                            LOGGER.debug("Web Authn and Yubikey can't be configured together");
                            return;
                        }
                        twoFactorMethodForUserList.add(methodName);
                        LOGGER.debug(" added as 2fa method: " + methodName);
                    }
                    if (backupMethodForUserList.contains(methodName)) {
                        backupMethodForUserList.remove(methodName);
                        LOGGER.debug(" removed as backup method: " + methodName);
                    }
                } else {
                    if (twoFactorMethodForUserList.contains(methodName)) {
                        twoFactorMethodForUserList.remove(methodName);
                        LOGGER.debug(" removed as 2fa method: " + methodName);
                    }
                    if (!backupMethodForUserList.contains(methodName)) {
                        if (twoFactorMethodForUserList.size() > 0) {
                            if (StringUtils.contains((CharSequence)methodName, (CharSequence)"YubikeyHardwareTokenAsU2F") && (twoFactorMethodForUserList.contains("WebAuthn") || backupMethodForUserList.contains("WebAuthn")) || StringUtils.contains((CharSequence)methodName, (CharSequence)"WebAuthn") && (twoFactorMethodForUserList.contains("YubikeyHardwareTokenAsU2F") || backupMethodForUserList.contains("YubikeyHardwareTokenAsU2F"))) {
                                LOGGER.debug("Web Authn and Yubikey can't be configured together");
                                return;
                            }
                            backupMethodForUserList.add(methodName);
                            LOGGER.debug(" added as backup method: " + methodName);
                        } else {
                            if (!methodName.contains("BackupCode")) {
                                twoFactorMethodForUserList.add(methodName);
                                LOGGER.debug(" added as 2fa method: " + methodName);
                            }
                            JSONObject data = new JSONObject();
                            data.put("methodName", methodName);
                            if (BooleanUtils.toBoolean((String)Main)) {
                                data.put("type", "2FA Method");
                            } else {
                                data.put("type", "Backup Method");
                            }
                            data.put("enablingBackupWithout2FA", true);
                            this.sendSuccessFullResponse(data.toString(), resp);
                            return;
                        }
                    }
                }
                this.settings.set2FAMethodForUserList(twoFactorMethodForUserList);
                this.settings.setBackupMethodForUserList(backupMethodForUserList);
            } else {
                if (twoFactorMethodForUserList.contains(methodName)) {
                    if (twoFactorMethodForUserList.size() == 1) {
                        JSONObject data = new JSONObject();
                        data.put("methodName", methodName);
                        if (BooleanUtils.toBoolean((String)Main)) {
                            data.put("type", "2FA Method");
                        } else {
                            data.put("type", "Backup Method");
                        }
                        data.put("disablingLast2FAMethod", true);
                        this.sendSuccessFullResponse(data.toString(), resp);
                        return;
                    }
                    twoFactorMethodForUserList.remove(methodName);
                    LOGGER.debug(" removed as 2fa method: " + methodName);
                }
                if (backupMethodForUserList.contains(methodName)) {
                    backupMethodForUserList.remove(methodName);
                    LOGGER.debug(" removed as backup method: " + methodName);
                }
                this.settings.set2FAMethodForUserList(twoFactorMethodForUserList);
                this.settings.setBackupMethodForUserList(backupMethodForUserList);
            }
            if (!BooleanUtils.toBoolean((String)FromRadio)) {
                switch (methodName) {
                    case "GoogleAuthenticator": {
                        LOGGER.debug(" Saving google authenticator Toggle button");
                        if (BooleanUtils.toBoolean((String)enabled)) {
                            this.settings.setTwoFactorForMobileAuthn(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForMobileAuthn(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "DuoPushNotification": {
                        LOGGER.debug(" saving Duo Push Notification toggle button");
                        if (BooleanUtils.toBoolean((String)enabled) && this.pluginHandler.isDuoPushNotificationSettingsConfigured().booleanValue()) {
                            this.settings.setTwoFactorForDuopush(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForDuopush(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "YubikeyHardwareTokenAsU2F": {
                        LOGGER.debug(" Saving Yubikey Hardware Toggle button");
                        if (BooleanUtils.toBoolean((String)enabled) && StringUtils.startsWithIgnoreCase((CharSequence)this.pluginConfiguration.getBaseUrl().trim(), (CharSequence)"https://")) {
                            if (this.settings.getTwoFactorForWebAuthn().booleanValue()) break;
                            this.settings.setTwoFactorForYubikey(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForYubikey(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "WebAuthn": {
                        LOGGER.debug("Saving WebAuthn Toggle button");
                        if (BooleanUtils.toBoolean((String)enabled) && StringUtils.startsWithIgnoreCase((CharSequence)this.pluginConfiguration.getBaseUrl().trim(), (CharSequence)"https://")) {
                            if (this.settings.getTwoFactorForYubikey().booleanValue()) break;
                            this.settings.setTwoFactorForWebAuthn(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForWebAuthn(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "OtpOverEmail": {
                        LOGGER.debug(" Saving OtpoverEmail's Toggle button");
                        if (BooleanUtils.toBoolean((String)enabled) && this.pluginHandler.isSmtpConfigured().booleanValue()) {
                            this.settings.setTwoFactorForOtpOverEmail(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForOtpOverEmail(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "OtpOverSms": {
                        LOGGER.debug(" Saving Otpoversms's Toggle button");
                        if (BooleanUtils.toBoolean((String)enabled) && this.pluginHandler.isSmsGatewayConfigured().booleanValue()) {
                            this.settings.setTwoFactorForOtpOverSms(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForOtpOverSms(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "SecurityQuestion": {
                        LOGGER.debug(" Saving Securtiy Question Toggle Button");
                        if (BooleanUtils.toBoolean((String)enabled)) {
                            this.settings.setTwoFactorForSecurityQuestion(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForSecurityQuestion(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                        break;
                    }
                    case "BackupCode": {
                        LOGGER.debug(" Saving BackupCode Toggle Button");
                        if (BooleanUtils.toBoolean((String)enabled)) {
                            this.settings.setTwoFactorForBackup(Boolean.TRUE);
                            break;
                        }
                        this.settings.setTwoFactorForBackup(Boolean.FALSE);
                        twoFactorMethodForUserList.remove(methodName);
                        backupMethodForUserList.remove(methodName);
                    }
                }
                this.settings.set2FAMethodForUserList(twoFactorMethodForUserList);
                this.settings.setBackupMethodForUserList(backupMethodForUserList);
            }
            Object data = new JSONObject();
            ((JSONObject)data).put("methodName", methodName);
            if (BooleanUtils.toBoolean((String)Main)) {
                ((JSONObject)data).put("type", "2FA Method");
            } else {
                ((JSONObject)data).put("type", "Backup Method");
            }
            this.sendSuccessFullResponse(((JSONObject)data).toString(), resp);
        }
        catch (Exception e) {
            LOGGER.error("Error while saving 2fa toggle/radio button :" + e.getMessage());
            this.sendErrorResponse("Error", resp);
        }
    }

    private Boolean performReset2FAForUser(String username) {
        String status;
        LOGGER.debug("Calling performReset2FAForUser for User : " + username);
        List<String> configuredUser = this.settings.getListOf2FAConfiguredUsers();
        if (configuredUser.contains(username)) {
            configuredUser.removeAll(Collections.singleton(username));
            status = "SUCCESS";
        } else {
            status = "ERROR";
        }
        this.settings.setListOf2FAConfiguredUsers(configuredUser);
        if (StringUtils.equalsIgnoreCase((CharSequence)"SUCCESS", (CharSequence)status)) {
            this.settings.setUserSettings(username, new MoTwoFactorCommonUserSettings());
        }
        return Boolean.TRUE;
    }

    private Boolean performDisable2FAForUser(String username) {
        try {
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            List<String> disable2FAForUsersList = this.settings.getDisable2FAForUsersList();
            if (enable2FAForUsersList.contains(username)) {
                LOGGER.debug("Disabling 2FA for User : " + username);
                enable2FAForUsersList.removeAll(Collections.singleton(username));
                this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
                disable2FAForUsersList.add(username);
                this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("Issue with disabling 2fa : " + e);
            return Boolean.FALSE;
        }
    }

    private Boolean performEnable2FAForUser(String username) {
        try {
            List<String> enable2FAForUsersList = this.settings.getEnable2FAForUsersList();
            List<String> disable2FAForUsersList = this.settings.getDisable2FAForUsersList();
            if (!enable2FAForUsersList.contains(username)) {
                LOGGER.debug("Enabling 2FA for User : " + username);
                disable2FAForUsersList.removeAll(Collections.singleton(username));
                this.settings.setDisable2FAForUsersList(disable2FAForUsersList);
                enable2FAForUsersList.add(username);
                this.settings.setEnable2FAForUsersList(enable2FAForUsersList);
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            LOGGER.error("Issue with enabling 2fa : " + e);
            return Boolean.FALSE;
        }
    }

    private Boolean performEnable2FAForGroup(String groupname) {
        LOGGER.debug("Calling performEnable2FAForGroup for Group : " + groupname);
        List<String> usersFromGroup = this.pluginHandler.getAllUsersInGroup(groupname);
        for (String username : usersFromGroup) {
            this.performEnable2FAForUser(username);
        }
        return Boolean.TRUE;
    }

    private Boolean performDisable2FAForGroup(String groupname, Boolean disableForAll) {
        LOGGER.debug("Calling performDisable2FAForGroup for Group : " + groupname);
        List<String> usersFromGroup = this.pluginHandler.getAllUsersInGroup(groupname);
        Boolean shouldDisable2FAforUser = Boolean.TRUE;
        for (String username : usersFromGroup) {
            shouldDisable2FAforUser = Boolean.TRUE;
            if (BooleanUtils.toBoolean((Boolean)disableForAll)) {
                this.performDisable2FAForUser(username);
                continue;
            }
            List<String> groupListOfUser = this.pluginHandler.getAllGroupsOfUser(groupname);
            List<String> enable2FAForGroupsList = this.settings.getEnable2FAForGroupsList();
            if (groupListOfUser.size() < enable2FAForGroupsList.size()) {
                for (String groupnameOfUser : groupListOfUser) {
                    if (!enable2FAForGroupsList.contains(groupnameOfUser)) continue;
                    shouldDisable2FAforUser = Boolean.FALSE;
                    break;
                }
            } else {
                for (String enableGroupName : enable2FAForGroupsList) {
                    if (!groupListOfUser.contains(enableGroupName)) continue;
                    shouldDisable2FAforUser = Boolean.FALSE;
                    break;
                }
            }
            if (!BooleanUtils.toBoolean((Boolean)shouldDisable2FAforUser)) continue;
            this.performDisable2FAForUser(username);
        }
        return Boolean.TRUE;
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendSuccessFullResponse");
        this.responseSent = Boolean.TRUE;
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes());
            resp.getOutputStream().close();
        }
    }

    private void sendErrorResponse(String errorMessages, HttpServletResponse resp) throws IOException {
        LOGGER.debug("sendErrorResponse");
        this.responseSent = Boolean.TRUE;
        resp.setContentType("application/json");
        resp.setStatus(500);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }
}

