/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.scheduler;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.sal.api.scheduling.PluginScheduler;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.service.MoLogEntityService;
import com.miniorange.twofactor.crowd.scheduler.AuditLogSchedulerTask;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class AuditLogScheduler
implements LifecycleAware {
    private static final Log LOGGER = LogFactory.getLog(AuditLogScheduler.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    @ComponentImport
    private PluginScheduler pluginScheduler;
    private MoLogEntityService logEntityService;
    public static final String KEY = AuditLogSchedulerTask.class.getName() + ":instance";
    private static final String JOB_NAME = AuditLogSchedulerTask.class.getName() + ":job";

    public AuditLogScheduler(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, PluginScheduler pluginScheduler, MoLogEntityService moAuditService) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginScheduler = pluginScheduler;
        this.logEntityService = moAuditService;
    }

    public void schedule() {
        LOGGER.info("Scheduling job");
        try {
            String jobName = JOB_NAME;
            long refreshTimeInMilliSeconds = 86400000L;
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(13, 1);
            this.pluginScheduler.scheduleJob(jobName, AuditLogSchedulerTask.class, (Map)new HashMap<String, Object>(){
                {
                    this.put(KEY, AuditLogScheduler.this);
                }
            }, cal.getTime(), refreshTimeInMilliSeconds);
            if (!this.settings.getAutoDeleteAuditLogs()) {
                LOGGER.debug("Auto delete audit logs is disabled. Stopping the scheduler");
                this.pluginScheduler.unscheduleJob(jobName);
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while scheduling job.");
        }
    }

    public void unschedule() {
        try {
            LOGGER.info("Un-scheduling job");
            String jobName = JOB_NAME;
            this.pluginScheduler.unscheduleJob(jobName);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while Un-scheduling job." + e.getMessage());
        }
    }

    public void onStart() {
        try {
            if (this.settings.getAutoDeleteAuditLogs()) {
                this.schedule();
                return;
            }
            this.unschedule();
        }
        catch (Exception e) {
            LOGGER.error("Error " + e);
        }
    }

    public void onStop() {
        try {
            this.unschedule();
        }
        catch (IllegalArgumentException t2) {
            LOGGER.error("No job exist. Can't un-schedule.");
        }
        catch (Throwable t3) {
            LOGGER.error("An Error occurred while un-scheduling job" + t3.getMessage());
        }
    }

    public Boolean deleteAuditLogs() throws ParseException {
        this.logEntityService.delete(this.settings.getAutoDeleteAuditLogsAfterDays());
        LOGGER.debug("Successfully deleted logs!");
        return true;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoLogEntityService getLogEntityService() {
        return this.logEntityService;
    }

    public void setLogEntityService(MoLogEntityService logEntityService) {
        this.logEntityService = logEntityService;
    }
}

