/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.scheduler.UpdateLicenseService;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorVerifyLicenseAction
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorVerifyLicenseAction.class);
    private static final String VERIFYLICENSE_VM_PATH = "/templates/com/miniorange/twofactor/crowd/verifylicense.vm";
    @ComponentImport
    private I18nHelper i18nHelper;
    @ComponentImport
    private UserManager userManager;
    @ComponentImport
    private LoginUriProvider loginUriProvider;
    @ComponentImport
    TemplateRenderer renderer;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private UpdateLicenseService updateLicenseService;
    public String message = "";
    public ArrayList errorMessage;

    public MoTwoFactorVerifyLicenseAction(UserManager userManager, LoginUriProvider loginUriProvider, MoTwoFactorCommonPluginSettings settings, I18nHelper i18nHelper, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings, UpdateLicenseService updateLicenseService, TemplateRenderer renderer, MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
        this.i18nHelper = i18nHelper;
        this.pluginSettings = pluginSettings;
        this.pluginHandler = pluginHandler;
        this.updateLicenseService = updateLicenseService;
        this.renderer = renderer;
        this.pluginConfiguration = pluginConfiguration;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorCustomerLoginAction Servlet doGet() called.");
        LOGGER.info("Register Action validate");
        UserProfile user = this.userManager.getRemoteUser();
        this.message = "";
        this.errorMessage = new ArrayList();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VERIFYLICENSE_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.info("verify license action execute called.");
        UserProfile user = this.userManager.getRemoteUser();
        this.message = "";
        this.errorMessage = new ArrayList();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            this.pluginSettings.getLicenseType();
            if (this.pluginSettings.isCustomerRegistered().booleanValue() && this.pluginSettings.getLicenseVerified().booleanValue() && !this.pluginSettings.isTrialLicense().booleanValue() && !this.pluginSettings.isLicenseExpired().booleanValue()) {
                LOGGER.debug("customer is registered with valid license, redirecting to the configuration page");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/configure");
                return;
            }
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("customer is not registered.");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            String submitted = MoTwoFactorUtility.sanitizeText(request.getParameter("submitted"));
            String backToRegister = MoTwoFactorUtility.sanitizeText(request.getParameter("backToRegister"));
            String key = MoTwoFactorUtility.sanitizeText(request.getParameter("key"));
            if (BooleanUtils.toBoolean((String)backToRegister)) {
                LOGGER.debug("back to login page");
                this.pluginSettings.removeCustomerAccount();
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (BooleanUtils.toBoolean((String)submitted)) {
                LOGGER.debug("verify license action submitted");
                if (StringUtils.isBlank((CharSequence)key)) {
                    this.errorMessage.add(this.i18nHelper.getText("2fa.error.verify.license.empty"));
                    response.setContentType("text/html;charset=utf-8");
                    this.renderer.render(VERIFYLICENSE_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
                }
                LOGGER.debug("key = " + key);
                Boolean valid = this.pluginHandler.verifyLicense(this.pluginSettings, key.trim());
                LOGGER.debug("valid = " + valid);
                if (valid.booleanValue()) {
                    this.updateLicenseService.schedule();
                    response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/configure");
                    return;
                }
                this.errorMessage.add(this.i18nHelper.getText("2fa.error.verify.license.invalid"));
                response.setContentType("text/html;charset=utf-8");
                this.renderer.render(VERIFYLICENSE_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VERIFYLICENSE_VM_PATH, this.initializeConfig(), (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    private Map<String, Object> initializeConfig() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", this.message);
        context.put("errorMessage", this.errorMessage);
        context.put("email", this.pluginSettings.getCustomerEmail());
        context.put("crowdBaseUrl", this.pluginSettings.getBaseUrl());
        context.put("contextPath", this.pluginSettings.getBaseUrl());
        context.put("licenseType", this.pluginSettings.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettings.getLicenseExpireDate());
        context.put("isLicenseVerified", this.pluginSettings.getLicenseVerified());
        context.put("isNoOfUserExceed", this.pluginSettings.isNoOfUserExceed());
        context.put("isAdmin", this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey()));
        context.put("pagesAccessibleToUser", this.pluginHandler.getUserAccessiblePages());
        return context;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

