/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.gson.JsonObject;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorSettingsAction
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorSettingsAction.class);
    private static final String CONFIGURE_VM_PATH = "/templates/com/miniorange/twofactor/crowd/configure.vm";
    @ComponentImport
    private TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings crowdPluginSettings;
    public String message = "";
    public ArrayList errorMessage;
    @ComponentImport
    private UserManager userManager;
    @ComponentImport
    private LoginUriProvider loginUriProvider;
    private String qrcode;
    private String secretKey;
    private int totalConfiguredMethods = 8;
    private Boolean showWelcomePrompt;

    public MoTwoFactorSettingsAction(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, UserManager userManager, TemplateRenderer renderer, LoginUriProvider loginUriProvider, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings crowdPluginSettings) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.userManager = userManager;
        this.renderer = renderer;
        this.loginUriProvider = loginUriProvider;
        this.pluginConfiguration = pluginConfiguration;
        this.crowdPluginSettings = crowdPluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorSettingsAction Servlet doGet() called.");
        UserProfile user = this.userManager.getRemoteUser();
        this.message = "";
        this.errorMessage = new ArrayList();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("Basic_Configuration");
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            if (!this.crowdPluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.crowdPluginSettings.getLicenseVerified().booleanValue() || this.crowdPluginSettings.getLicenseVerified().booleanValue() && this.crowdPluginSettings.isTrialLicense().booleanValue() && this.crowdPluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(CONFIGURE_VM_PATH, this.initializeConfig(request), (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorSettingsAction Servlet doPost() called.");
        UserProfile user = this.userManager.getRemoteUser();
        this.message = "";
        this.errorMessage = new ArrayList();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("Basic_Configuration");
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            if (!this.crowdPluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.crowdPluginSettings.getLicenseVerified().booleanValue() || this.crowdPluginSettings.getLicenseVerified().booleanValue() && this.crowdPluginSettings.isTrialLicense().booleanValue() && this.crowdPluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
            Boolean otpOverSmsSettingsSubmitted = BooleanUtils.toBoolean((String)MoTwoFactorUtility.sanitizeText(request.getParameter("otpOverSmsSettingsSubmitted")));
            String smsGateway = MoTwoFactorUtility.sanitizeText(request.getParameter("smsGateway"));
            String customerKey = MoTwoFactorUtility.sanitizeText(request.getParameter("customerKey"));
            String apiKey = MoTwoFactorUtility.sanitizeText(request.getParameter("apiKey"));
            String smsGatewayUrl = MoTwoFactorUtility.sanitizeText(request.getParameter("smsGatewayUrl"));
            String smsTemplate = MoTwoFactorUtility.sanitizeText(request.getParameter("smsTemplate"));
            String defaultCountryCode = MoTwoFactorUtility.sanitizeText(request.getParameter("defaultCountryCode"));
            if (pageAccessType.equals("readwrite") && BooleanUtils.toBoolean((Boolean)otpOverSmsSettingsSubmitted)) {
                if (!this.settings.validateDefaultCountryCode(defaultCountryCode)) {
                    this.errorMessage.add("Invalid Default Country Code");
                } else {
                    LOGGER.debug("defaultCountryCode =" + defaultCountryCode);
                    LOGGER.debug("smsGateway =" + smsGateway);
                    LOGGER.debug("customerKey =" + customerKey);
                    LOGGER.debug("apiKey =" + apiKey);
                    LOGGER.debug("smsGatewayUrl =" + smsGatewayUrl);
                    LOGGER.debug("smsTemplate =" + smsTemplate);
                    this.settings.setDefaultContryCode(MoTwoFactorUtility.sanitizeText(defaultCountryCode));
                    this.settings.setSmsGateway(smsGateway);
                    this.settings.setCustomerKey(customerKey);
                    this.settings.setApiKey(apiKey);
                    this.settings.setSmsGatewayUrl(smsGatewayUrl);
                    this.settings.setSmsTemplate(smsTemplate);
                    LOGGER.info("Successfully save configuration");
                    this.message = "Two Factor Settings Updated.";
                }
            }
            HashMap<String, Object> context = this.initializeConfig(request);
            if (StringUtils.isBlank((CharSequence)this.message) && StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("reset"), (CharSequence)"success")) {
                if (StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("method"), (CharSequence)"GoogleAuthenticator")) {
                    this.message = "Mobile Authenticator is removed. Now you can reconfigure it again.";
                } else if (StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("method"), (CharSequence)"OtpOverEmail")) {
                    this.message = "OTP Over Email is removed. Now you can reconfigure it again.";
                } else if (StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("method"), (CharSequence)"OtpOverSms")) {
                    this.message = "OTP Over SMS is removed. Now you can reconfigure it again.";
                } else if (StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("method"), (CharSequence)"SecurityQuestion")) {
                    this.message = "Security Question is removed. Now you can reconfigure it again.";
                } else if (StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("method"), (CharSequence)"YubikeyHardwareTokenAsU2F")) {
                    this.message = "Yubikey Hardware Token(U2F) is removed. Now you can reconfigure it again.";
                } else if (StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("method"), (CharSequence)"DuoPushNotification")) {
                    this.message = "Duo Push Notification is removed. Now you can reconfigure it again.";
                } else if (StringUtils.equalsIgnoreCase((CharSequence)request.getParameter("method"), (CharSequence)"WebAuthn")) {
                    this.message = "Web Authentication is removed. Now you can reconfigure it again.";
                }
            }
            if (StringUtils.isNotBlank((CharSequence)this.message)) {
                context.put("message", this.message);
            } else if (!this.getErrorMessage().isEmpty()) {
                context.put("errorMessage", this.errorMessage);
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(CONFIGURE_VM_PATH, context, (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    private ArrayList getErrorMessage() {
        return this.errorMessage;
    }

    private HashMap<String, Object> initializeConfig(HttpServletRequest request) {
        LOGGER.debug("inside initializeConfig...");
        HashMap<String, Object> context = new HashMap<String, Object>();
        List<String> twoFactorMethodForUserList = this.settings.get2FAMethodForUserList();
        Boolean enableTwoFactor = this.settings.getEnableTwoFactor();
        Boolean enableBackupMethod = this.settings.getEnableBackupMethod();
        List<String> backupMethodForUserList = this.settings.getBackupMethodForUserList();
        String duoPushNotificationEnrollPortalUrl = "";
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
        Boolean googleAuthenticatorConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("GoogleAuthenticator");
        Boolean otpOverEmailConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("OtpOverEmail");
        Boolean smtpConfigured = this.pluginHandler.isSmtpConfigured();
        Boolean otpOverSmsConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("OtpOverSms");
        Boolean smsGatewayConfigured = this.pluginHandler.isSmsGatewayConfigured();
        Boolean webAuthnConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("WebAuthn");
        String currentLoggedInUser = this.pluginConfiguration.getCurrentLoggedInUser();
        Boolean displayEndUserReconfigurationPage = Boolean.FALSE;
        Boolean securityQuestionConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("SecurityQuestion");
        this.showWelcomePrompt = this.settings.getShowWelcomePrompt();
        if (this.showWelcomePrompt.booleanValue()) {
            this.settings.setShowWelcomePrompt(Boolean.FALSE);
        }
        this.initializeQrCode(twoFactorUserClass, request);
        Boolean backupCodeConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("BackupCode");
        Boolean shouldShowBackupCodeWarning = backupCodeConfigured != false && twoFactorUserClass.getBackupCodes().size() == 0;
        Boolean u2fHardwareTokenConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("YubikeyHardwareTokenAsU2F");
        Boolean isSslSetup = StringUtils.contains((CharSequence)this.pluginConfiguration.getBaseUrl(), (CharSequence)"https");
        context.put("contextPath", request.getContextPath());
        context.put("attestationType", this.settings.getAttestationType());
        context.put("authenticatorType", this.settings.getAuthenticatorType());
        context.put("userVerification", this.settings.getUserVerification());
        context.put("residentKey", this.settings.getResidentKey());
        context.put("showWelcomePrompt", this.showWelcomePrompt);
        Boolean duoPushNotificationConfigured = twoFactorUserClass.getConfigured2FAMethodsByUser().contains("DuoPushNotification");
        Boolean duoPushNotificationSettingsConfigured = this.pluginHandler.isDuoPushNotificationSettingsConfigured();
        context.put("message", this.message);
        context.put("errorMessage", this.errorMessage);
        context.put("enableTwoFactor", enableTwoFactor);
        context.put("shareSecretKey", this.settings.getEnableShareSecretKey());
        if (twoFactorUserClass.getConfigured2FAMethodsByUser().contains("GoogleAuthenticator")) {
            String encryptedSecret = twoFactorUserClass.getTotpSecret();
            String userSalt = twoFactorUserClass.getUserSalt();
            String decryptedString = MoTwoFactorUtility.decryptString(encryptedSecret, this.settings.getEncryptionKey());
            this.secretKey = decryptedString.replaceAll(userSalt, "");
            LOGGER.debug("Displayed secret key " + this.secretKey);
        }
        context.put("enableBackupMethod", enableBackupMethod);
        context.put("googleAuthenticatorConfigured", googleAuthenticatorConfigured);
        context.put("otpOverEmailConfigured", otpOverEmailConfigured);
        context.put("smtpConfigured", smtpConfigured);
        context.put("otpOverSmsConfigured", otpOverSmsConfigured);
        context.put("smsGatewayConfigured", smsGatewayConfigured);
        context.put("webAuthnConfigured", webAuthnConfigured);
        context.put("currentLoggedInUser", currentLoggedInUser);
        context.put("displayEndUserReconfigurationPage", displayEndUserReconfigurationPage);
        context.put("securityQuestionConfigured", securityQuestionConfigured);
        context.put("backupCodeConfigured", backupCodeConfigured);
        context.put("shouldShowBackupCodeWarning", shouldShowBackupCodeWarning);
        context.put("u2fHardwareTokenConfigured", u2fHardwareTokenConfigured);
        context.put("isSslSetup", isSslSetup);
        context.put("duoPushNotificationConfigured", duoPushNotificationConfigured);
        context.put("duoPushNotificationSettingsConfigured", duoPushNotificationSettingsConfigured);
        context.put("qrcode", this.qrcode);
        context.put("secretKey", this.secretKey);
        context.put("questionList", MoTwoFactorSettingsAction.getQuestionList());
        context.put("securityQuestionNumber", this.getSecurityQuestionNumber());
        context.put("contextPath", this.pluginConfiguration.getBaseUrl());
        context.put("total2faEnabledUsers", this.settings.getEnable2FAForUsersList().size());
        context.put("totalConfiguredMethods", this.totalConfiguredMethods);
        context.put("shouldShowGoogleAuthenticator", Boolean.TRUE);
        context.put("shouldShowOtpOverEmail", Boolean.TRUE);
        context.put("shouldShowOtpOverSms", Boolean.TRUE);
        context.put("shouldShowSecurityQuestion", Boolean.TRUE);
        context.put("shouldShowWebAuthn", Boolean.TRUE);
        context.put("shouldShowBackupCode", Boolean.TRUE);
        context.put("shouldShowU2FHardwareToken", Boolean.TRUE);
        context.put("shouldShowDuoPushNotification", Boolean.TRUE);
        context.put("downloadBackupCodeUrl", this.pluginConfiguration.getDownloadBackupCodeUrl());
        context.put("totalMethodsConfiguredByUser", twoFactorUserClass.getConfigured2FAMethodsByUser().size());
        context.put("allowToReconfigureMethod", this.settings.getAllowToReconfigureConfigured2faMethod());
        context.put("enableEnforceCurrentMethod", this.settings.getEnableEnforce2faMethodForUser());
        context.put("primaryMethodForUser", this.settings.getPrimary2faMethodForUser());
        context.put("showAllConfiguredMethodsDirectly", this.settings.getShowAllConfiguredMethodToUser());
        context.put("showRemaining2FAMethodsAfterConfiguration", this.settings.getShowRemaining2FAMethodsAfterInlineRegistration());
        try {
            if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isDuoPushNotificationSettingsConfigured())) {
                JsonObject jsonObject = this.pluginHandler.sendDuoPushNotificationPreauth(username, request);
                duoPushNotificationEnrollPortalUrl = StringUtils.equalsIgnoreCase((CharSequence)"enroll", (CharSequence)jsonObject.get("result").getAsString()) ? jsonObject.get("enroll_portal_url").getAsString() : "ENROLLED";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Error while sending Duo Push Notification pre auth request" + e);
        }
        LOGGER.debug("duoPushNotificationEnrollPortalUrl::" + duoPushNotificationEnrollPortalUrl);
        context.put("duoPushNotificationEnrollPortalUrl", duoPushNotificationEnrollPortalUrl);
        if (this.settings.getEnableEnforce2faMethodForUser().booleanValue() && twoFactorUserClass.getConfigured2FAMethodsByUser().contains(this.settings.getPrimary2faMethodForUser()) && !StringUtils.equalsIgnoreCase((CharSequence)twoFactorUserClass.getCurrent2FAMethod(), (CharSequence)this.settings.getPrimary2faMethodForUser())) {
            twoFactorUserClass.setCurrent2FAMethod(this.settings.getPrimary2faMethodForUser());
            this.settings.setUserSettings(username, twoFactorUserClass);
        }
        context.put("currentDefault2faMethod", twoFactorUserClass.getCurrent2FAMethod());
        String appLabel = this.settings.getAppLabel("Crowd");
        context.put("appLabel", appLabel);
        context.put("showSupportedAppPopup", this.settings.getShowSupportedAppPopup());
        context.put("enableShareSecretKey", this.settings.getEnableShareSecretKey());
        context.put("emailTemplate", this.settings.getEmailTemplate());
        context.put("emailSubject", this.settings.getEmailSubject());
        context.put("emailTemplateBruteForce", this.settings.getEmailTemplateBruteForce());
        context.put("otpLength", this.settings.getOtpLength());
        context.put("otpValidityDuration", this.settings.getOtpValidityDuration());
        context.put("smtpConfigured", this.pluginHandler.isSmtpConfigured());
        context.put("authenticationLinkValidityDuration", this.settings.getAuthenticationLinkValidityDuration());
        context.put("smsGateway", this.settings.getSmsGateway());
        context.put("customerKey", this.settings.getCustomerKey());
        context.put("apiKey", this.settings.getApiKey());
        context.put("smsGatewayUrl", this.settings.getSmsGatewayUrl());
        context.put("smsTemplate", this.settings.getSmsTemplate());
        context.put("smsGatewayOptions", this.getSmsGatewayOptions());
        context.put("defaultCountryCode", this.settings.getDefaultContryCode());
        context.put("duoPushNotificationIntegrationKey", this.settings.getDuoPushNotificationIntegrationKey());
        context.put("duoPushNotificationSecretKey", this.settings.getDuoPushNotificationSecretKey());
        context.put("duoPushNotificationHostName", this.settings.getDuoPushNotificationHostName());
        context.put("attestationType", this.settings.getAttestationType());
        context.put("authenticatorType", this.settings.getAuthenticatorType());
        context.put("userVerification", this.settings.getUserVerification());
        context.put("residentKey", this.settings.getResidentKey());
        if (StringUtils.startsWithIgnoreCase((CharSequence)this.pluginConfiguration.getBaseUrl().trim(), (CharSequence)"https://")) {
            context.put("twoFactorForYubikey", this.settings.getTwoFactorForYubikey());
            context.put("twoFactorForWebAuthn", this.settings.getTwoFactorForWebAuthn());
        } else {
            context.put("twoFactorForYubikey", Boolean.FALSE);
            context.put("twoFactorForWebAuthn", Boolean.FALSE);
            twoFactorMethodForUserList.remove("WebAuthn");
            backupMethodForUserList.remove("WebAuthn");
            twoFactorMethodForUserList.remove("YubikeyHardwareTokenAsU2F");
            backupMethodForUserList.remove("YubikeyHardwareTokenAsU2F");
            this.settings.set2FAMethodForUserList(twoFactorMethodForUserList);
            this.settings.setBackupMethodForUserList(backupMethodForUserList);
            this.settings.setTwoFactorForWebAuthn(Boolean.FALSE);
            this.settings.setTwoFactorForYubikey(Boolean.FALSE);
        }
        if (duoPushNotificationSettingsConfigured.booleanValue()) {
            context.put("twoFactorForDuopush", this.settings.getTwoFactorForDuopush());
        } else {
            context.put("twoFactorForDuopush", Boolean.FALSE);
            twoFactorMethodForUserList.remove("DuoPushNotification");
            backupMethodForUserList.remove("DuoPushNotification");
            if (twoFactorMethodForUserList.isEmpty()) {
                twoFactorMethodForUserList.add("GoogleAuthenticator");
                this.settings.setTwoFactorForMobileAuthn(Boolean.TRUE);
            }
            this.settings.set2FAMethodForUserList(twoFactorMethodForUserList);
            this.settings.setBackupMethodForUserList(backupMethodForUserList);
            this.settings.setTwoFactorForDuopush(Boolean.FALSE);
        }
        if (this.pluginHandler.isSmsGatewayConfigured().booleanValue()) {
            context.put("twoFactorForOtpOverSms", this.settings.getTwoFactorForOtpOverSms());
        } else {
            context.put("twoFactorForOtpOverSms", Boolean.FALSE);
            twoFactorMethodForUserList.remove("OtpOverSms");
            backupMethodForUserList.remove("OtpOverSms");
            if (twoFactorMethodForUserList.isEmpty()) {
                twoFactorMethodForUserList.add("GoogleAuthenticator");
                this.settings.setTwoFactorForMobileAuthn(Boolean.TRUE);
            }
            this.settings.set2FAMethodForUserList(twoFactorMethodForUserList);
            this.settings.setBackupMethodForUserList(backupMethodForUserList);
            this.settings.setTwoFactorForOtpOverSms(Boolean.FALSE);
        }
        if (this.pluginHandler.isSmtpConfigured().booleanValue() || this.settings.getCustomMailServer().booleanValue()) {
            context.put("twoFactorForOtpOverEmail", this.settings.getTwoFactorForOtpOverEmail());
        } else {
            context.put("twoFactorForOtpOverEmail", Boolean.FALSE);
            twoFactorMethodForUserList.remove("OtpOverEmail");
            backupMethodForUserList.remove("OtpOverEmail");
            if (twoFactorMethodForUserList.isEmpty()) {
                twoFactorMethodForUserList.add("GoogleAuthenticator");
                this.settings.setTwoFactorForMobileAuthn(Boolean.TRUE);
            }
            this.settings.set2FAMethodForUserList(twoFactorMethodForUserList);
            this.settings.setBackupMethodForUserList(backupMethodForUserList);
            this.settings.setTwoFactorForOtpOverEmail(Boolean.FALSE);
        }
        context.put("twoFactorMethodForUserList", twoFactorMethodForUserList);
        context.put("backupMethodForUserList", backupMethodForUserList);
        context.put("twoFactorForMobileAuthn", this.settings.getTwoFactorForMobileAuthn());
        context.put("twoFactorForsecurityQuestion", this.settings.getTwoFactorForSecurityQuestion());
        context.put("twoFactorForBackup", this.settings.getTwoFactorForBackup());
        context.put("enable2FAForAllUsers", this.settings.getEnable2FAForAllUsers());
        context.put("adminEmail", this.pluginConfiguration.getCrowdApplicationUser(username).getEmailAddress());
        context.put("customMailServer", this.settings.getCustomMailServer());
        context.put("customMailServerHostName", this.settings.getCustomMailServerHostName());
        context.put("customMailServerProtocol", this.settings.getCustomMailServerProtocol());
        context.put("customMailServerFromAddress", this.settings.getCustomMailServerFromAddress());
        context.put("customMailServerSmtpPort", this.settings.getCustomMailServerSmtpPort());
        context.put("customMailServerUsername", MoTwoFactorUtility.decryptString(this.settings.getCustomMailServerUsername(), "MO2FA_CUSTOM_MAIL_SERVER_USERNAME"));
        context.put("customMailServerPassword", MoTwoFactorUtility.decryptString(this.settings.getCustomMailServerPassword(), "MO2FA_CUSTOM_MAIL_SERVER_PASSWORD"));
        context.put("customMailServerTls", this.settings.getCustomMailServerTls());
        context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
        context.put("isAdmin", this.pluginHandler.isSystemAdmin());
        context.put("pagesAccessibleToUser", this.pluginHandler.getUserAccessiblePages());
        context.put("pageAccessType", this.pluginHandler.getPageAccessForCurrentUser("Basic_Configuration"));
        context.put("otpOverSmsGatewayReqHeaders", this.settings.getOtpOverSmsGatewayReqHeaders());
        context.put("totalReqHeaders", this.settings.getOtpOverSmsGatewayReqHeaders().keySet().size());
        context.put("gatewayMethod", this.settings.getOtpOverSmsGatewayMethod());
        context.put("gatewayAuthMethod", this.settings.getOtpOverSmsGatewayAuthMethod());
        context.put("gatewayBasicAuthUsername", this.settings.getOtpOverSmsGatewayAuthBasicauthUsername());
        context.put("gatewayBasicAuthPassword", this.settings.getOtpOverSmsGatewayAuthBasicauthPassword());
        context.put("gatewayBearerToken", this.settings.getOtpOverSmsGatewayAuthBearerToken());
        context.put("gatewayApiKey", this.settings.getOtpOverSmsGatewayAuthAPIKey());
        context.put("gatewayRequestBody", this.settings.getOtpOverSmsGatewayBody());
        context.put("gatewayBodyType", this.settings.getOtpOverSmsGatewayBodyType());
        context.put("daysLeftToExpire", this.crowdPluginSettings.getDaysLeftToExpire());
        context.put("licenseType", this.crowdPluginSettings.getLicenseType());
        context.put("licenseExpireDate", this.crowdPluginSettings.getLicenseExpireDate());
        context.put("isNoOfUserExceed", this.crowdPluginSettings.isNoOfUserExceed());
        context.put("isLicenseExpired", this.crowdPluginSettings.isLicenseExpired());
        return context;
    }

    public ArrayList getSmsGatewayOptions() {
        ArrayList<String> smsGatewayOptions = new ArrayList<String>();
        smsGatewayOptions.add("miniOrange Gateway");
        smsGatewayOptions.add("Custom Gateway");
        return smsGatewayOptions;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public List<String> getSecurityQuestionNumber() {
        int securityQuestionCount = MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_QUESTION_COUNT - MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_CUSTOM_QUESTION_COUNT;
        ArrayList<String> securityQuestionNumber = new ArrayList<String>();
        for (int i = 1; i <= securityQuestionCount; ++i) {
            securityQuestionNumber.add("Question " + i);
        }
        return securityQuestionNumber;
    }

    public static List<String> getQuestionList() {
        return MoTwoFactorUtility.getQuestionList();
    }

    private void initializeQrCode(MoTwoFactorCommonUserSettings twoFactorUserClass, HttpServletRequest request) {
        String crowdInstanceKeyValue;
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        this.secretKey = MoTwoFactorUtility.generateKey();
        HttpSession session = request.getSession();
        if (session.getAttribute("2fa_secret") == null || StringUtils.isBlank((CharSequence)((String)session.getAttribute("2fa_secret")))) {
            session.setAttribute("2fa_secret", (Object)this.secretKey);
        } else {
            this.secretKey = (String)session.getAttribute("2fa_secret");
            this.secretKey = MoTwoFactorUtility.sanitizeText(this.secretKey);
        }
        this.qrcode = MoTwoFactorUtility.generateQrCode(this.secretKey, username, this.settings.getAppLabel("Crowd"));
        session.setAttribute("2fa_qrcode", (Object)this.qrcode);
        if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getUserSalt())) {
            String userSpecific_salt_key = MoTwoFactorUtility.generateRandomString(10);
            twoFactorUserClass.setUserSalt(userSpecific_salt_key);
        }
        if (StringUtils.isEmpty((CharSequence)(crowdInstanceKeyValue = this.settings.getEncryptionKey()))) {
            String crowd_instance_key = MoTwoFactorUtility.generateRandomString(10);
            this.settings.setEncryptionKey(crowd_instance_key);
        }
        this.settings.setUserSettings(username, twoFactorUserClass);
        session.setAttribute("2fa_verification", (Object)true);
    }
}

