/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.crowd.common.entity.MoLogEntity;
import com.miniorange.twofactor.crowd.common.exception.MoTwoFactorCommonPluginException;
import com.miniorange.twofactor.crowd.common.service.MoLogEntityService;
import com.miniorange.twofactor.crowd.scheduler.AuditLogScheduler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorAuditLogs
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAuditLogs.class);
    MoTwoFactorCrowdPluginSettings pluginSettings;
    private static final String AUDITLOGS_VM_PATH = "/templates/com/miniorange/twofactor/crowd/auditLogs.vm";
    @ComponentImport
    private TemplateRenderer renderer;
    @ComponentImport
    UserManager userManager;
    @ComponentImport
    LoginUriProvider loginUriProvider;
    MoTwoFactorCommonPluginSettings settings;
    MoTwoFactorPluginHandler pluginHandler;
    MoTwoFactorPluginConfiguration pluginConfiguration;
    MoLogEntityService service;
    AuditLogScheduler auditLogScheduler;
    public String message = "";
    public ArrayList errorMessage;
    private Integer currentIndex = 1;
    private Integer adminsAuditLogsCurrentIndex = 1;
    private Integer startIndex;
    private Integer prevIndex;
    private Integer nextIndex;
    private Integer endIndex;
    private Integer lastIndex;
    private Integer totalLogs;
    private Integer start;
    private Integer end;
    private String deletionScheduleDate;

    public MoTwoFactorAuditLogs(MoTwoFactorCrowdPluginSettings pluginSettings, MoLogEntityService moLogEntityService, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, AuditLogScheduler auditLogScheduler, UserManager userManager, LoginUriProvider loginUriProvider, MoTwoFactorPluginConfiguration pluginConfiguration, TemplateRenderer renderer) {
        this.service = moLogEntityService;
        this.pluginSettings = pluginSettings;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.auditLogScheduler = auditLogScheduler;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.pluginConfiguration = pluginConfiguration;
        this.renderer = renderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("AuditLogs Servlet doGet() called.");
        UserProfile user = this.userManager.getRemoteUser();
        this.message = "";
        this.errorMessage = new ArrayList();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("Audit_Logs");
        LOGGER.debug("pageAccessType :" + pageAccessType);
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("Customer is not registered");
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
                return;
            }
            if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
                return;
            }
            Map<String, Object> context = this.performDisplayLogs(request, response);
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(AUDITLOGS_VM_PATH, context, (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("Execute called in MoTwoFactorAuditLogs...");
        UserProfile user = this.userManager.getRemoteUser();
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("Audit_Logs");
        if (user != null && (this.userManager.isAdmin(user.getUserKey()) || pageAccessType != "")) {
            if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("customer is not registered.");
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/dologin");
            }
            if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                this.settings.setEnableTwoFactor(Boolean.FALSE);
                response.sendRedirect(this.pluginConfiguration.getBaseUrl() + "/plugins/servlet/twofactor/doverify");
            }
            Map<String, Object> context = this.performDisplayLogs(request, response);
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(AUDITLOGS_VM_PATH, context, (Writer)response.getWriter());
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        }
    }

    private Map<String, Object> performDisplayLogs(HttpServletRequest request, HttpServletResponse response) {
        LOGGER.debug("performDisplayLogs called");
        String pageAccessType = this.pluginHandler.getPageAccessForCurrentUser("Audit_Logs");
        ArrayList<HashMap> moLogEntitesHashMap = new ArrayList<HashMap>();
        String auditLogUsernameSearchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("auditLogUsernameSearchKeyword"));
        String auditLogIpSearchKeyword = MoTwoFactorUtility.sanitizeText(request.getParameter("auditLogIpSearchKeyword"));
        String filterUsersByAction = request.getParameter("filterUsersByAction");
        String filterUsersByPeriod = request.getParameter("filterUsersByPeriod");
        Boolean autoDeleteAuditLogsSubmitted = BooleanUtils.toBoolean((String)request.getParameter("autoDeleteAuditLogsSubmitted"));
        Boolean autoDeleteAuditLogs = BooleanUtils.toBoolean((String)request.getParameter("autoDeleteAuditLogs"));
        String autoDeleteLogsAfterDays = request.getParameter("autoDeleteLogsAfterDays");
        try {
            if (StringUtils.isBlank((CharSequence)auditLogUsernameSearchKeyword)) {
                auditLogUsernameSearchKeyword = "";
            }
            if (StringUtils.isBlank((CharSequence)auditLogIpSearchKeyword)) {
                auditLogIpSearchKeyword = "";
            }
            if (StringUtils.isBlank((CharSequence)filterUsersByAction)) {
                filterUsersByAction = "All Actions";
            }
            if (StringUtils.isBlank((CharSequence)filterUsersByPeriod)) {
                filterUsersByPeriod = "All Days";
            }
            this.currentIndex = request.getParameter("currentIndex") == null ? Integer.valueOf(1) : Integer.valueOf(Integer.parseInt(request.getParameter("currentIndex")));
            LOGGER.debug("Username:" + auditLogUsernameSearchKeyword);
            List<Object> aoAuditLogs = new ArrayList();
            aoAuditLogs = this.service.getLogs(this.currentIndex, filterUsersByAction, filterUsersByPeriod, auditLogUsernameSearchKeyword, auditLogIpSearchKeyword, 20);
            this.totalLogs = this.service.getSize(filterUsersByAction, filterUsersByPeriod, auditLogUsernameSearchKeyword, auditLogIpSearchKeyword);
            LocalDate localDate = LocalDate.now();
            this.deletionScheduleDate = localDate.plusDays(this.settings.getAutoDeleteAuditLogsAfterDays().intValue()).toString();
            ArrayList filteredLogs = new ArrayList();
            for (int i = 0; i < aoAuditLogs.size(); ++i) {
                MoLogEntity moLogEntity = (MoLogEntity)aoAuditLogs.get(i);
                if (moLogEntity == null) continue;
                HashMap<String, String> moLogEntityHash = new HashMap<String, String>();
                moLogEntityHash.put("user", moLogEntity.getUserName());
                SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
                moLogEntityHash.put("dateTime", formatter.format(moLogEntity.getDateAndTime()));
                moLogEntityHash.put("ipAddress", moLogEntity.getIpAddress());
                moLogEntityHash.put("action", moLogEntity.getAction());
                moLogEntityHash.put("type", moLogEntity.getLoginMethod());
                filteredLogs.add(moLogEntityHash);
            }
            this.setAuditIndexes(this.currentIndex, this.totalLogs);
            this.start = (this.currentIndex - 1) * 20;
            this.end = Math.min(this.start + 20, filteredLogs.size());
            int count = 0;
            for (int i = 0; i < filteredLogs.size(); ++i) {
                moLogEntitesHashMap.add(count, (HashMap)filteredLogs.get(i));
                ++count;
            }
            LOGGER.debug("Audit logs list size:" + moLogEntitesHashMap.size());
            if (autoDeleteAuditLogsSubmitted.booleanValue()) {
                LOGGER.debug("AutoDeleteAuditLogs value:" + autoDeleteAuditLogs);
                LOGGER.debug("AutoDeleteAuditLogsAfterDays" + autoDeleteLogsAfterDays);
                if (pageAccessType.equals("readwrite")) {
                    if (BooleanUtils.toBoolean((Boolean)autoDeleteAuditLogs)) {
                        if (StringUtils.isNotBlank((CharSequence)autoDeleteLogsAfterDays)) {
                            int days = Integer.parseInt(autoDeleteLogsAfterDays);
                            if (days >= 1) {
                                this.settings.setAutoDeleteAuditLogs(true);
                                this.settings.setAutoDeleteAuditLogsAfterDays(days);
                                this.auditLogScheduler.schedule();
                                this.message = "Audit Logs settings updated. We have started removing the old audit logs.";
                            } else {
                                this.settings.setAutoDeleteAuditLogs(false);
                            }
                            localDate = LocalDate.now();
                            this.deletionScheduleDate = localDate.plusDays(this.settings.getAutoDeleteAuditLogsAfterDays().intValue()).toString();
                        } else {
                            this.settings.setAutoDeleteAuditLogs(false);
                        }
                    } else {
                        this.message = "Audit Logs settings updated. We have stopped removing the old audit logs.";
                        this.settings.setAutoDeleteAuditLogs(false);
                        this.auditLogScheduler.unschedule();
                    }
                } else {
                    LOGGER.error("User does not have write access.");
                    this.errorMessage.add("User does not have write access.");
                }
            }
        }
        catch (MoTwoFactorCommonPluginException e) {
            LOGGER.error("Error " + e);
            this.errorMessage.add(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Error " + e);
            this.errorMessage.add("An error occurred.");
        }
        Map<String, Object> context = this.initializeConfig(this.currentIndex, this.startIndex, this.prevIndex, this.nextIndex, this.endIndex, this.lastIndex, this.totalLogs, this.start, this.end, auditLogUsernameSearchKeyword, auditLogIpSearchKeyword, filterUsersByAction, filterUsersByPeriod, moLogEntitesHashMap);
        context.put("pageAccessType", pageAccessType);
        return context;
    }

    private Map<String, Object> initializeConfig(Integer currentIndex, Integer startIndex, Integer prevIndex, Integer nextIndex, Integer endIndex, Integer lastIndex, Integer totalLogs, Integer start, Integer end, String auditLogUsernameSearchKeyword, String auditLogIpSearchKeyword, String filterUsersByAction, String filterUsersByPeriod, List<HashMap> moLogEntitesHashMap) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("auditLogUsernameSearchKeyword", auditLogUsernameSearchKeyword);
        context.put("auditLogIpSearchKeyword", auditLogIpSearchKeyword);
        context.put("filterUsersByAction", filterUsersByAction);
        context.put("filterUsersByPeriod", filterUsersByPeriod);
        context.put("currentIndex", currentIndex);
        context.put("startIndex", startIndex);
        context.put("endIndex", endIndex);
        context.put("prevIndex", prevIndex);
        context.put("nextIndex", nextIndex);
        context.put("totalLogs", totalLogs);
        context.put("lastIndex", lastIndex);
        context.put("start", start);
        context.put("end", end);
        context.put("message", this.message);
        context.put("errorMessage", this.errorMessage);
        context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
        context.put("crowdBaseUrl", this.pluginSettings.getBaseUrl());
        context.put("contextPath", this.pluginSettings.getBaseUrl());
        context.put("filterUsersByPeriod", filterUsersByPeriod);
        context.put("moLogEntitesHashMap", moLogEntitesHashMap);
        context.put("exportAuditLogsUrl", this.pluginSettings.getExportAuditLogsUrl());
        context.put("autoDeleteAuditLogs", this.settings.getAutoDeleteAuditLogs());
        context.put("autoDeleteLogsAfterDays", this.settings.getAutoDeleteAuditLogsAfterDays().toString());
        context.put("licenseType", this.pluginSettings.getLicenseType());
        context.put("licenseExpireDate", this.pluginSettings.getLicenseExpireDate());
        context.put("daysLeftToExpire", this.pluginSettings.getDaysLeftToExpire());
        context.put("isLicenseVerified", this.pluginSettings.getLicenseVerified());
        context.put("isNoOfUserExceed", this.pluginSettings.isNoOfUserExceed());
        context.put("isAdmin", this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey()));
        context.put("pagesAccessibleToUser", this.pluginHandler.getUserAccessiblePages());
        return context;
    }

    private void setAuditIndexes(Integer currentIndex, Integer tableSize) {
        this.lastIndex = tableSize % 20 != 0 ? Integer.valueOf(tableSize / 20 + 1) : Integer.valueOf(tableSize / 20);
        if (tableSize == 20) {
            this.lastIndex = 1;
        }
        this.prevIndex = currentIndex == 1 ? 1 : currentIndex - 1;
        this.nextIndex = currentIndex == this.lastIndex ? this.lastIndex : currentIndex + 1;
        this.startIndex = currentIndex % 5 == 0 ? currentIndex - 4 : currentIndex - (currentIndex % 5 - 1);
        this.endIndex = Integer.min(this.lastIndex, currentIndex % 5 == 0 ? currentIndex : currentIndex + (5 - currentIndex % 5));
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

