/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.impl;

import com.auth0.jwt.impl.ClaimsHolder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class PayloadSerializer
extends StdSerializer<ClaimsHolder> {
    public PayloadSerializer() {
        this((Class<ClaimsHolder>)null);
    }

    private PayloadSerializer(Class<ClaimsHolder> t2) {
        super(t2);
    }

    @Override
    public void serialize(ClaimsHolder holder, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        for (Map.Entry<String, Object> e : holder.getClaims().entrySet()) {
            if ("aud".equals(e.getKey())) {
                this.writeAudience(gen, e);
                continue;
            }
            gen.writeFieldName(e.getKey());
            if (e.getValue() instanceof Date) {
                gen.writeNumber(this.dateToSeconds((Date)e.getValue()));
                continue;
            }
            gen.writeObject(e.getValue());
        }
        gen.writeEndObject();
    }

    private void writeAudience(JsonGenerator gen, Map.Entry<String, Object> e) throws IOException {
        if (e.getValue() instanceof String) {
            gen.writeFieldName(e.getKey());
            gen.writeString((String)e.getValue());
        } else {
            List<Object> audArray = new ArrayList();
            if (e.getValue() instanceof String[]) {
                audArray = Arrays.asList((String[])e.getValue());
            } else if (e.getValue() instanceof List) {
                List audList = (List)e.getValue();
                for (Object aud : audList) {
                    if (!(aud instanceof String)) continue;
                    audArray.add((String)aud);
                }
            }
            if (audArray.size() == 1) {
                gen.writeFieldName(e.getKey());
                gen.writeString((String)audArray.get(0));
            } else if (audArray.size() > 1) {
                gen.writeFieldName(e.getKey());
                gen.writeStartArray();
                for (String string : audArray) {
                    gen.writeString(string);
                }
                gen.writeEndArray();
            }
        }
    }

    private long dateToSeconds(Date date) {
        return date.getTime() / 1000L;
    }
}

