/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.decoder;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.AdditionalInformation;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public abstract class AbstractDecoder<T> {
    protected static final int INFINITY = -1;
    protected final InputStream inputStream;
    protected final CborDecoder decoder;

    public AbstractDecoder(CborDecoder decoder, InputStream inputStream) {
        this.decoder = decoder;
        this.inputStream = inputStream;
    }

    public abstract T decode(int var1) throws CborException;

    protected int nextSymbol() throws CborException {
        try {
            int symbol = this.inputStream.read();
            if (symbol == -1) {
                throw new IOException("Unexpected end of stream");
            }
            return symbol;
        }
        catch (IOException ioException) {
            throw new CborException(ioException);
        }
    }

    protected long getLength(int initialByte) throws CborException {
        switch (AdditionalInformation.ofByte(initialByte)) {
            case DIRECT: {
                return initialByte & 0x1F;
            }
            case ONE_BYTE: {
                return this.nextSymbol();
            }
            case TWO_BYTES: {
                long twoByteValue = 0L;
                twoByteValue |= (long)(this.nextSymbol() << 8);
                return twoByteValue |= (long)(this.nextSymbol() << 0);
            }
            case FOUR_BYTES: {
                long fourByteValue = 0L;
                fourByteValue |= (long)this.nextSymbol() << 24;
                fourByteValue |= (long)this.nextSymbol() << 16;
                fourByteValue |= (long)this.nextSymbol() << 8;
                return fourByteValue |= (long)this.nextSymbol() << 0;
            }
            case EIGHT_BYTES: {
                long eightByteValue = 0L;
                eightByteValue |= (long)this.nextSymbol() << 56;
                eightByteValue |= (long)this.nextSymbol() << 48;
                eightByteValue |= (long)this.nextSymbol() << 40;
                eightByteValue |= (long)this.nextSymbol() << 32;
                eightByteValue |= (long)this.nextSymbol() << 24;
                eightByteValue |= (long)this.nextSymbol() << 16;
                eightByteValue |= (long)this.nextSymbol() << 8;
                return eightByteValue |= (long)this.nextSymbol() << 0;
            }
            case INDEFINITE: {
                return -1L;
            }
        }
        throw new CborException("Reserved additional information");
    }

    protected BigInteger getLengthAsBigInteger(int initialByte) throws CborException {
        switch (AdditionalInformation.ofByte(initialByte)) {
            case DIRECT: {
                return BigInteger.valueOf(initialByte & 0x1F);
            }
            case ONE_BYTE: {
                return BigInteger.valueOf(this.nextSymbol());
            }
            case TWO_BYTES: {
                long twoByteValue = 0L;
                twoByteValue |= (long)(this.nextSymbol() << 8);
                return BigInteger.valueOf(twoByteValue |= (long)(this.nextSymbol() << 0));
            }
            case FOUR_BYTES: {
                long fourByteValue = 0L;
                fourByteValue |= (long)this.nextSymbol() << 24;
                fourByteValue |= (long)this.nextSymbol() << 16;
                fourByteValue |= (long)this.nextSymbol() << 8;
                return BigInteger.valueOf(fourByteValue |= (long)this.nextSymbol() << 0);
            }
            case EIGHT_BYTES: {
                BigInteger eightByteValue = BigInteger.ZERO;
                eightByteValue = eightByteValue.or(BigInteger.valueOf(this.nextSymbol()).shiftLeft(56));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(this.nextSymbol()).shiftLeft(48));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(this.nextSymbol()).shiftLeft(40));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(this.nextSymbol()).shiftLeft(32));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(this.nextSymbol()).shiftLeft(24));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(this.nextSymbol()).shiftLeft(16));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(this.nextSymbol()).shiftLeft(8));
                eightByteValue = eightByteValue.or(BigInteger.valueOf(this.nextSymbol()).shiftLeft(0));
                return eightByteValue;
            }
            case INDEFINITE: {
                return BigInteger.valueOf(-1L);
            }
        }
        throw new CborException("Reserved additional information");
    }
}

