/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.webauthn.utils;

import co.nstant.in.cbor.CborBuilder;
import co.nstant.in.cbor.CborEncoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.NegativeInteger;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.miniorange.twofactor.webauthn.utils.Algorithm;
import com.miniorange.twofactor.webauthn.utils.CredentialPublicKey;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.DatatypeConverter;

public class RsaKey
extends CredentialPublicKey {
    byte[] n;
    byte[] e;

    RsaKey() {
        this.n = null;
        this.e = null;
        this.alg = Algorithm.UNDEFINED;
    }

    public RsaKey(Algorithm alg, byte[] n, byte[] e) {
        this.alg = alg;
        this.n = n;
        this.e = e;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.n), Arrays.hashCode(this.e));
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof RsaKey) {
                RsaKey other = (RsaKey)obj;
                if (Arrays.equals(this.n, other.n) && Arrays.equals(this.e, other.e) && this.alg == other.alg) {
                    return true;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public byte[] encode() throws CborException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        List<DataItem> dataItems = new CborBuilder().addMap().put(new UnsignedInteger(1L), new UnsignedInteger(this.kty)).put(new UnsignedInteger(3L), new NegativeInteger(this.alg.encodeToInt())).put(new NegativeInteger(-1L), new ByteString(this.n)).put(new NegativeInteger(-2L), new ByteString(this.e)).end().build();
        new CborEncoder(output).encode(dataItems);
        return output.toByteArray();
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("alg:");
        b.append(this.alg.toReadableString());
        b.append(" n:");
        b.append(DatatypeConverter.printHexBinary((byte[])this.n));
        b.append("<br />");
        b.append(" e:");
        b.append(DatatypeConverter.printHexBinary((byte[])this.e));
        return b.toString();
    }

    public byte[] getN() {
        return this.n;
    }

    public byte[] getE() {
        return this.e;
    }
}

