/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.webauthn.utils;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnicodeString;
import com.miniorange.twofactor.webauthn.utils.AttestationStatement;
import java.util.Arrays;
import java.util.Objects;

public class AndroidSafetyNetAttestationStatement
extends AttestationStatement {
    String ver = null;
    byte[] response = null;

    public static AndroidSafetyNetAttestationStatement decode(DataItem attStmt) throws Exception {
        AndroidSafetyNetAttestationStatement result = new AndroidSafetyNetAttestationStatement();
        Map given = (Map)attStmt;
        for (DataItem data : given.getKeys()) {
            if (!(data instanceof UnicodeString)) continue;
            if (((UnicodeString)data).getString().equals("ver")) {
                UnicodeString version = (UnicodeString)given.get(data);
                result.ver = version.getString();
                continue;
            }
            if (!((UnicodeString)data).getString().equals("response")) continue;
            result.response = ((ByteString)given.get(data)).getBytes();
        }
        if (result.response == null || result.ver == null) {
            throw new Exception("Invalid JWT Cbor");
        }
        return result;
    }

    @Override
    DataItem encode() throws CborException {
        Map map = new Map();
        map.put(new UnicodeString("ver"), new UnicodeString(this.ver));
        map.put(new UnicodeString("response"), new ByteString(this.response));
        return map;
    }

    public int hashCode() {
        return Objects.hash(this.ver, Arrays.hashCode(this.response));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AndroidSafetyNetAttestationStatement) {
            AndroidSafetyNetAttestationStatement other = (AndroidSafetyNetAttestationStatement)obj;
            try {
                if (!this.ver.equals(other.ver)) {
                    return false;
                }
            }
            catch (NullPointerException e) {
                return false;
            }
            return Arrays.equals(this.response, other.response);
        }
        return false;
    }

    public String getVer() {
        return this.ver;
    }

    public byte[] getResponse() {
        return this.response;
    }

    @Override
    public String getName() {
        return "Android SafetyNet";
    }
}

