/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.utility;

import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoEncryptionUtils {
    private static final Log LOGGER = LogFactory.getLog(MoEncryptionUtils.class);
    public static final String INIT_VECTOR = MoEncryptionUtils.generateRandomAlphaNumericKey(16);
    private static final String ENCRYPTION_ALGORITHM = "AES";

    public static String encrypt(String encryptionKey, String data) {
        try {
            byte[] decodedKey = encryptionKey.getBytes();
            byte[] truncatedKey = decodedKey.length > 16 ? Arrays.copyOf(decodedKey, 16) : decodedKey;
            SecretKeySpec key = new SecretKeySpec(truncatedKey, ENCRYPTION_ALGORITHM);
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            cipher.init(1, key);
            byte[] encVal = cipher.doFinal(data.getBytes());
            String encryptedValue = Base64.encodeBase64String(encVal);
            return encryptedValue;
        }
        catch (Throwable t) {
            LOGGER.debug("Error occurred while encrypting data");
            return "";
        }
    }

    public static String decrypt(String encryptionKey, String data) {
        try {
            byte[] decodedDataString = Base64.decodeBase64(data);
            byte[] decodedKey = encryptionKey.getBytes();
            byte[] truncatedKey = decodedKey.length > 16 ? Arrays.copyOf(decodedKey, 16) : decodedKey;
            SecretKeySpec key = new SecretKeySpec(truncatedKey, ENCRYPTION_ALGORITHM);
            Cipher cipher = Cipher.getInstance(ENCRYPTION_ALGORITHM);
            cipher.init(2, key);
            byte[] decVal = cipher.doFinal(decodedDataString);
            String decryptedValue = new String(decVal);
            return decryptedValue;
        }
        catch (Throwable t) {
            LOGGER.debug("Error occurred while decrypting data");
            return "";
        }
    }

    public static String generateRandomAlphaNumericKey(int bytes) {
        String randomString = RandomStringUtils.random((int)bytes, (boolean)true, (boolean)true);
        return randomString;
    }
}

