/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.servlet;

import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoTwoFactorValidateOtpOverEmail
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorValidateOtpOverEmail.class);
    private static final String VM_PATH = "/templates/com/miniorange/twofactor/crowd/validate_otpoveremail.vm";
    private final TemplateRenderer renderer;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorCrowdPluginSettings pluginSettings;

    public MoTwoFactorValidateOtpOverEmail(TemplateRenderer renderer, MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.renderer = renderer;
        this.settings = settings;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginHandler = pluginHandler;
        this.pluginSettings = pluginSettings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorValidateOtpOverEmail doGet called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username) && MoTwoFactorUtility.isValidUrlForUser(username, this.settings, "Validate_OtpOverEmail").booleanValue()) {
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("baseUrl", this.pluginConfiguration.getBaseUrl());
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            Boolean enableRememberMeDevice = BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice()) && !BooleanUtils.toBoolean((Boolean)this.isInternetExplorer(request));
            context.put("enableRememberMeDevice", enableRememberMeDevice);
            ArrayList<String> errorMessage = new ArrayList<String>();
            HttpSession session = request.getSession();
            if (session.getAttribute("otp_code") == null) {
                try {
                    if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isSmtpConfigured())) {
                        this.pluginHandler.sendOtpOnEmail(request, this.pluginConfiguration.getCrowdUser());
                    } else {
                        errorMessage.add("Issue with sending email. Mail Server is not Configured. Please contact to administrator.");
                    }
                }
                catch (Exception e) {
                    errorMessage.add("Issue with sending Email. Please contact to administrator.");
                }
            }
            context.put("errorMessage", errorMessage);
            context.put("successMessage", "");
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            List<String> configuredMethodList = twoFactorUserClass.getConfigured2FAMethodsByUser();
            configuredMethodList.removeAll(Collections.singleton("OtpOverEmail"));
            Boolean shouldShowLinkToListMethod = Boolean.FALSE;
            if (configuredMethodList.size() >= 1) {
                shouldShowLinkToListMethod = Boolean.TRUE;
                context.put("validate2faMethodListUrl", this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist"));
            }
            context.put("shouldShowLinkToValidateListMethod", shouldShowLinkToListMethod);
            String template = this.pluginSettings.getValidateOtpOverEmailTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug("MoTwoFactorValidateOtpOverEmail doPost called");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        if (StringUtils.isNotBlank((CharSequence)username)) {
            String successMessage;
            ArrayList<String> errorMessage;
            block30: {
                LOGGER.debug("User is valid user");
                errorMessage = new ArrayList<String>();
                successMessage = "";
                if (BooleanUtils.toBoolean((String)request.getParameter("resendOtpLinkClicked"))) {
                    LOGGER.debug("Resend OTP link clicked");
                    try {
                        if (BooleanUtils.toBoolean((Boolean)this.pluginHandler.isSmtpConfigured())) {
                            this.pluginHandler.sendOtpOnEmail(request, this.pluginConfiguration.getCrowdUser(username));
                            successMessage = "Successfully resend the OTP to your email.";
                            break block30;
                        }
                        errorMessage.add("Issue with sending email. Mail Server is not Configured. Please contact to administrator.");
                    }
                    catch (Exception e) {
                        errorMessage.add("Issue with sending Email. Please contact to admin");
                    }
                } else {
                    LOGGER.debug("Checking OTP validation");
                    String otp = MoTwoFactorUtility.sanitizeText(StringUtils.trimToEmpty((String)request.getParameter("otpCode")));
                    if (MoTwoFactorUtility.isValidNumberFormat(otp).booleanValue()) {
                        LOGGER.debug("OTP is Valid = " + otp);
                        HttpSession session = request.getSession(true);
                        String storedOtpCode = (String)session.getAttribute("otp_code");
                        Boolean isValid = Boolean.FALSE;
                        if (StringUtils.equalsIgnoreCase((CharSequence)otp, (CharSequence)storedOtpCode)) {
                            long storedOtpExpiryTime;
                            long currentTimeInMili = System.currentTimeMillis();
                            if (currentTimeInMili < (storedOtpExpiryTime = ((Long)session.getAttribute("otp_expiry_time")).longValue())) {
                                isValid = Boolean.TRUE;
                            } else {
                                isValid = Boolean.FALSE;
                                errorMessage.add("OTP is Valid. But Time Expired.");
                            }
                        } else {
                            isValid = Boolean.FALSE;
                            errorMessage.add("Invalid OTP Entered");
                        }
                        if (isValid.booleanValue()) {
                            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Login Successful", "OTP Over Email");
                            LOGGER.debug("OTP validated Successfully...");
                            session.removeAttribute("otp_code");
                            session.removeAttribute("otp_expiry_time");
                            session.removeAttribute("last_email_otp_sent_time");
                            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
                            Boolean rememberMeOnThisDevice = Boolean.parseBoolean(request.getParameter("rememberMeOnThisDevice"));
                            if (BooleanUtils.toBoolean((Boolean)rememberMeOnThisDevice)) {
                                String deviceDetails = MoTwoFactorUtility.getDeviceDetails(request);
                                LOGGER.debug("Current Device Details : " + deviceDetails);
                                List<String> rememberMeDeviceDetails = twoFactorUserClass.getRememberMeDeviceDetails();
                                if (StringUtils.isNotBlank((CharSequence)deviceDetails)) {
                                    LOGGER.debug("Device details is not a blank");
                                    LOGGER.debug("Stored Device Details : " + rememberMeDeviceDetails);
                                    int rememberDeviceDuration = this.settings.getRememberMeDeviceDuration();
                                    Calendar calendar = Calendar.getInstance();
                                    calendar.add(5, rememberDeviceDuration);
                                    Date date = calendar.getTime();
                                    long newTimeInMili = date.getTime();
                                    Boolean containsDeviceInList = Boolean.FALSE;
                                    for (int i = 0; i < rememberMeDeviceDetails.size(); ++i) {
                                        String device = rememberMeDeviceDetails.get(i);
                                        if (!StringUtils.containsIgnoreCase((CharSequence)device, (CharSequence)deviceDetails)) continue;
                                        LOGGER.debug("Changing device details time : " + newTimeInMili);
                                        containsDeviceInList = Boolean.TRUE;
                                        rememberMeDeviceDetails.add(i, deviceDetails.concat("=====" + newTimeInMili));
                                        break;
                                    }
                                    if (!BooleanUtils.toBoolean((Boolean)containsDeviceInList)) {
                                        if (deviceDetails.split("\\|\\|").length > 2) {
                                            LOGGER.debug("Adding device details with time : " + newTimeInMili);
                                            rememberMeDeviceDetails.add(deviceDetails.concat("=====" + newTimeInMili));
                                        } else {
                                            LOGGER.debug("Invalid Device Details : " + deviceDetails);
                                        }
                                    }
                                    twoFactorUserClass.setRememberMeDeviceDetails(rememberMeDeviceDetails);
                                    LOGGER.debug("After change Device Details : " + rememberMeDeviceDetails);
                                    this.settings.setUserSettings(username, twoFactorUserClass);
                                }
                            }
                            session.setAttribute("2fa_verification", (Object)true);
                            session.removeAttribute("executing_2fa_flow");
                            this.settings.addTo2FAConfiguredUsersList(username);
                            this.pluginHandler.redirectToValidUrl(request, response);
                            return;
                        }
                        this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Login Failed", "OTP Over Email");
                        if (!BooleanUtils.toBoolean((Boolean)this.pluginHandler.checkBruteForceInvalidAttemptAction(request)) && BooleanUtils.toBoolean((Boolean)this.pluginHandler.shouldLockedOutUser(username))) {
                            LOGGER.debug("User has exceeded number of invalid attempts");
                            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Temporarily Locked", "OTP Over Email");
                            this.pluginHandler.performBruteForceUserLockAction(username, request);
                            this.pluginHandler.performUserLogout(request, response, username);
                            response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/user_locked"));
                            return;
                        }
                        errorMessage.add("Invalid OTP. Please add valid one.");
                        LOGGER.debug("Invalid OTP. Please add valid one.");
                        Integer loginAttemptsLeft = this.pluginHandler.checkNumberOfLoginAttemptsLeft(request, username);
                        if (loginAttemptsLeft == 2) {
                            LOGGER.debug("Only a last 2 login attempts left");
                            errorMessage.add("You will be locked out of your account after next 2 invalid login attempts!");
                        } else if (loginAttemptsLeft == 1) {
                            LOGGER.debug("Last login attempt");
                            errorMessage.add("This is your last login attempt! Incorrect answers will lock you out of your account.");
                        }
                    } else {
                        this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Login Failed", "OTP Over Email");
                        if (!BooleanUtils.toBoolean((Boolean)this.pluginHandler.checkBruteForceInvalidAttemptAction(request)) && BooleanUtils.toBoolean((Boolean)this.pluginHandler.shouldLockedOutUser(username))) {
                            LOGGER.debug("User has exceeded number of invalid attempts");
                            this.pluginHandler.storeAuditLogs(username, MoTwoFactorUtility.getCurrentIpAddress(request, this.settings), "Temporarily Locked", "OTP Over Email");
                            this.pluginHandler.performBruteForceUserLockAction(username, request);
                            this.pluginHandler.performUserLogout(request, response, username);
                            response.sendRedirect(this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/user_locked"));
                            return;
                        }
                        errorMessage.add("Invalid OTP. Please add valid one.");
                        LOGGER.debug("Invalid OTP. Please add valid one.");
                        Integer loginAttemptsLeft = this.pluginHandler.checkNumberOfLoginAttemptsLeft(request, username);
                        if (loginAttemptsLeft == 2) {
                            LOGGER.debug("Only a last 2 login attempts left");
                            errorMessage.add("You will be locked out of your account after next 2 invalid login attempts!");
                        } else if (loginAttemptsLeft == 1) {
                            LOGGER.debug("Last login attempt");
                            errorMessage.add("This is your last login attempt! Incorrect answers will lock you out of your account.");
                        }
                    }
                }
            }
            UserProfile userProfile = this.pluginConfiguration.getCrowdUser(username);
            String displayName = userProfile.getFullName();
            if (StringUtils.isBlank((CharSequence)displayName)) {
                displayName = username;
            }
            HashMap<String, Object> context = new HashMap<String, Object>();
            context.put("username", displayName);
            context.put("errorMessage", errorMessage);
            context.put("successMessage", successMessage);
            context.put("logoutUrl", this.pluginConfiguration.getBaseUrl().concat("/console/logoff.action"));
            context.put("baseUrl", this.pluginConfiguration.getBaseUrl());
            context.put("multiLingualSupportToggle", this.settings.getMultiLingualSupportToggle());
            Boolean enableRememberMeDevice = BooleanUtils.toBoolean((Boolean)this.settings.getEnableRememberMeDevice()) && !BooleanUtils.toBoolean((Boolean)this.isInternetExplorer(request));
            context.put("enableRememberMeDevice", enableRememberMeDevice);
            MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
            List<String> configuredMethodList = twoFactorUserClass.getConfigured2FAMethodsByUser();
            configuredMethodList.removeAll(Collections.singleton("OtpOverEmail"));
            Boolean shouldShowLinkToListMethod = Boolean.FALSE;
            if (configuredMethodList.size() >= 1) {
                shouldShowLinkToListMethod = Boolean.TRUE;
                context.put("validate2faMethodListUrl", this.pluginConfiguration.getBaseUrl().concat("/plugins/servlet/twofactor/validate_2famethodlist"));
            }
            context.put("shouldShowLinkToValidateListMethod", shouldShowLinkToListMethod);
            String template = this.pluginSettings.getValidateOtpOverEmailTemplate();
            if (StringUtils.isNotBlank((CharSequence)template)) {
                String result = this.renderer.renderFragment(template, context);
                response.setContentType("text/html;charset=utf-8");
                response.getWriter().write(result);
                return;
            }
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(VM_PATH, context, (Writer)response.getWriter());
            return;
        }
        this.pluginHandler.redirectToValidUrl(request, response);
    }

    private Boolean isInternetExplorer(HttpServletRequest request) {
        String userAgent = request.getHeader("user-agent");
        if (StringUtils.indexOfIgnoreCase((CharSequence)userAgent, (CharSequence)"MSIE") > 0 || StringUtils.indexOfIgnoreCase((CharSequence)userAgent, (CharSequence)"Trident/") > 0) {
            LOGGER.debug("Browser is IE");
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public TemplateRenderer getRenderer() {
        return this.renderer;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }
}

