/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.dto.MoTwoFactorCommonUserSettings;
import com.miniorange.twofactor.common.exception.MoTwoFactorCommonPluginException;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorSettingsAction
extends BaseAction {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorSettingsAction.class);
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private String xsrfToken;
    private Boolean enableTwoFactor;
    private String setQR;
    private String[] backupMethodForUser;
    private List<String> backupMethodForUserList;
    private Boolean displayEndUserReconfigurationPage;
    private String[] twoFactorMethodForUser;
    private List<String> twoFactorMethodForUserList;
    private String qrcode;
    private String secretKey;
    private Integer total2faEnabledUsers;
    private String currentLoggedInUser;
    private Boolean smtpConfigured;
    private Boolean isSslSetup;
    private Boolean smsGatewayConfigured;
    private HttpServletRequest request;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private Boolean shareSecretKey;
    private Boolean showWelcomePrompt;
    private String showWelcomePromptString;
    private Boolean duoPushNotificationSettingsConfigured;
    private String duoPushNotificationEnrollPortalUrl;
    private List<String> pagesAccessibleToUser;
    private Boolean isAdmin;
    private String pageAccessType;
    private Boolean multiLingualSupportToggle;
    private Boolean twoFactorForMobileAuthn;
    private Boolean twoFactorForsecurityQuestion;
    private Boolean twoFactorForDuopush;
    private Boolean twoFactorForYubikey;
    private Boolean twoFactorForWebAuthn;
    private Boolean twoFactorForOtpOverEmail;
    private Boolean twoFactorForOtpOverSms;
    private Boolean twoFactorForBackup;
    private String appLabel;
    private Boolean showSupportedAppPopup;
    private Boolean enableShareSecretKey;
    private String duoPushNotificationIntegrationKey;
    private String duoPushNotificationSecretKey;
    private String duoPushNotificationHostName;
    private String attestationType;
    private String authenticatorType;
    private String userVerification;
    private String residentKey;
    private String emailTemplate;
    private String otpValidityDuration;
    private String otpLength;
    private String emailSubject;
    private String smsGateway;
    private ArrayList smsGatewayOptions;
    private String customerKey;
    private String apiKey;
    private String smsGatewayUrl;
    private String smsTemplate;
    private Boolean otpOverSmsSettingsSubmitted;
    private Boolean enable2FAForAllUsers;
    private String adminEmail;

    public MoTwoFactorSettingsAction(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    public void doValidate() {
        LOGGER.debug("Configure Action doValidate");
    }

    public String execute() throws Exception {
        LOGGER.debug("execute is called from MoTwoFactorSettingsAction");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.pagesAccessibleToUser = this.pluginHandler.getUserAccessiblePages();
        if (this.pagesAccessibleToUser.contains("Basic_Configuration_readwrite")) {
            this.pageAccessType = "readwrite";
        } else if (this.pagesAccessibleToUser.contains("Basic_Configuration_read")) {
            this.pageAccessType = "read";
        } else {
            response.sendRedirect(this.pluginConfiguration.getDashboardUrl());
            return null;
        }
        if (user != null) {
            try {
                if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                    LOGGER.debug("Customer is not registered");
                    this.settings.setEnableTwoFactor(Boolean.FALSE);
                    return "register";
                }
                if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                    this.settings.setEnableTwoFactor(Boolean.FALSE);
                    return "verify";
                }
                if (this.pageAccessType.equals("readwrite") && BooleanUtils.toBoolean((Boolean)this.otpOverSmsSettingsSubmitted)) {
                    LOGGER.debug("smsGateway " + this.smsGateway);
                    LOGGER.debug("customerKey" + this.customerKey);
                    LOGGER.debug("apiKey" + this.apiKey);
                    LOGGER.debug("smsGatewayUrl" + this.smsGatewayUrl);
                    LOGGER.debug("smsTemplate" + this.smsTemplate);
                    this.settings.setSmsGateway(this.smsGateway);
                    this.settings.setCustomerKey(this.customerKey);
                    this.settings.setApiKey(this.apiKey);
                    this.settings.setSmsGatewayUrl(this.smsGatewayUrl);
                    this.settings.setSmsTemplate(this.smsTemplate);
                    LOGGER.info("Successfully save configuration");
                    this.addActionMessage("Two Factor Settings updated");
                }
                this.initializeConfig();
                return "success";
            }
            catch (MoTwoFactorCommonPluginException e) {
                LOGGER.error("Error " + e);
                this.addActionError(e.getMessage());
                return "upm";
            }
            catch (Exception e) {
                LOGGER.error("Error " + e);
                this.addActionError("An error occurred.");
                return "upm";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private void initializeConfig() {
        LOGGER.debug("inside initializeConfig...");
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        MoTwoFactorCommonUserSettings twoFactorUserClass = this.settings.getUserSettings(username);
        this.initializeQrCode(twoFactorUserClass);
        this.enableTwoFactor = this.settings.getEnableTwoFactor();
        this.backupMethodForUserList = this.settings.getBackupMethodForUserList();
        this.twoFactorMethodForUserList = this.settings.get2FAMethodForUserList();
        this.duoPushNotificationSettingsConfigured = this.pluginHandler.isDuoPushNotificationSettingsConfigured();
        this.smtpConfigured = this.pluginHandler.isSmtpConfigured();
        this.smsGatewayConfigured = this.pluginHandler.isSmsGatewayConfigured();
        this.isSslSetup = StringUtils.contains((CharSequence)this.pluginConfiguration.getBaseUrl(), (CharSequence)"https");
        this.currentLoggedInUser = this.pluginConfiguration.getCurrentLoggedInUser();
        this.displayEndUserReconfigurationPage = Boolean.FALSE;
        this.crowdBaseUrl = this.pluginSettings.getBaseUrl();
        this.attestationType = this.settings.getAttestationType();
        this.authenticatorType = this.settings.getAuthenticatorType();
        this.userVerification = this.settings.getUserVerification();
        this.residentKey = this.settings.getResidentKey();
        this.shareSecretKey = this.settings.getEnableShareSecretKey();
        this.licenseType = this.pluginSettings.getLicenseType();
        this.licenseExpireDate = this.pluginSettings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.pluginSettings.isNoOfUserExceed();
        this.showWelcomePrompt = this.settings.getShowWelcomePrompt();
        this.showWelcomePromptString = this.convertBooleanToString(this.showWelcomePrompt);
        if (this.showWelcomePrompt.booleanValue()) {
            this.settings.setShowWelcomePrompt(Boolean.FALSE);
        }
        this.isAdmin = this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey());
        this.multiLingualSupportToggle = this.settings.getMultiLingualSupportToggle();
        if (StringUtils.startsWithIgnoreCase((CharSequence)this.pluginConfiguration.getBaseUrl().trim(), (CharSequence)"https://")) {
            this.twoFactorForYubikey = this.settings.getTwoFactorForYubikey();
            this.twoFactorForWebAuthn = this.settings.getTwoFactorForWebAuthn();
        } else {
            this.twoFactorForYubikey = Boolean.FALSE;
            this.twoFactorForWebAuthn = Boolean.FALSE;
            this.twoFactorMethodForUserList.remove("WebAuthn");
            this.backupMethodForUserList.remove("WebAuthn");
            this.twoFactorMethodForUserList.remove("YubikeyHardwareTokenAsU2F");
            this.backupMethodForUserList.remove("YubikeyHardwareTokenAsU2F");
            this.settings.set2FAMethodForUserList(this.twoFactorMethodForUserList);
            this.settings.setBackupMethodForUserList(this.backupMethodForUserList);
            this.settings.setTwoFactorForWebAuthn(Boolean.FALSE);
            this.settings.setTwoFactorForYubikey(Boolean.FALSE);
        }
        if (this.pluginHandler.isSmsGatewayConfigured().booleanValue()) {
            this.twoFactorForOtpOverSms = this.settings.getTwoFactorForOtpOverSms();
        } else {
            this.twoFactorForOtpOverSms = Boolean.FALSE;
            this.twoFactorMethodForUserList.remove("OtpOverSms");
            this.backupMethodForUserList.remove("OtpOverSms");
            if (this.twoFactorMethodForUserList.isEmpty()) {
                this.twoFactorMethodForUserList.add("GoogleAuthenticator");
                this.settings.setTwoFactorForMobileAuthn(Boolean.TRUE);
            }
            this.settings.set2FAMethodForUserList(this.twoFactorMethodForUserList);
            this.settings.setBackupMethodForUserList(this.backupMethodForUserList);
            this.settings.setTwoFactorForOtpOverSms(Boolean.FALSE);
        }
        if (this.pluginHandler.isSmtpConfigured().booleanValue()) {
            this.twoFactorForOtpOverEmail = this.settings.getTwoFactorForOtpOverEmail();
        } else {
            this.twoFactorForOtpOverEmail = Boolean.FALSE;
            this.twoFactorMethodForUserList.remove("OtpOverEmail");
            this.backupMethodForUserList.remove("OtpOverEmail");
            if (this.twoFactorMethodForUserList.isEmpty()) {
                this.twoFactorMethodForUserList.add("GoogleAuthenticator");
                this.settings.setTwoFactorForMobileAuthn(Boolean.TRUE);
            }
            this.settings.set2FAMethodForUserList(this.twoFactorMethodForUserList);
            this.settings.setBackupMethodForUserList(this.backupMethodForUserList);
            this.settings.setTwoFactorForOtpOverEmail(Boolean.FALSE);
        }
        if (this.duoPushNotificationSettingsConfigured.booleanValue()) {
            this.twoFactorForDuopush = this.settings.getTwoFactorForDuopush();
        } else {
            this.twoFactorForDuopush = Boolean.FALSE;
            this.twoFactorMethodForUserList.remove("DuoPushNotification");
            this.backupMethodForUserList.remove("DuoPushNotification");
            if (this.twoFactorMethodForUserList.isEmpty()) {
                this.twoFactorMethodForUserList.add("GoogleAuthenticator");
                this.settings.setTwoFactorForMobileAuthn(Boolean.TRUE);
            }
            this.settings.set2FAMethodForUserList(this.twoFactorMethodForUserList);
            this.settings.setBackupMethodForUserList(this.backupMethodForUserList);
            this.settings.setTwoFactorForDuopush(Boolean.FALSE);
        }
        this.twoFactorForMobileAuthn = this.settings.getTwoFactorForMobileAuthn();
        this.twoFactorForsecurityQuestion = this.settings.getTwoFactorForSecurityQuestion();
        this.twoFactorForBackup = this.settings.getTwoFactorForBackup();
        this.appLabel = this.settings.getAppLabel("Crowd");
        this.showSupportedAppPopup = this.settings.getShowSupportedAppPopup();
        this.enableShareSecretKey = this.settings.getEnableShareSecretKey();
        this.duoPushNotificationIntegrationKey = this.settings.getDuoPushNotificationIntegrationKey();
        this.duoPushNotificationSecretKey = this.settings.getDuoPushNotificationSecretKey();
        this.duoPushNotificationHostName = this.settings.getDuoPushNotificationHostName();
        this.emailTemplate = this.settings.getEmailTemplate();
        this.emailSubject = this.settings.getEmailSubject();
        this.otpValidityDuration = this.settings.getOtpValidityDuration().toString();
        this.otpLength = this.settings.getOtpLength().toString();
        this.smsGateway = this.settings.getSmsGateway();
        this.customerKey = this.settings.getCustomerKey();
        this.apiKey = this.settings.getApiKey();
        this.smsGatewayUrl = this.settings.getSmsGatewayUrl();
        this.smsTemplate = this.settings.getSmsTemplate();
        this.enable2FAForAllUsers = this.settings.getEnable2FAForAllUsers();
        UserProfile userProfile = this.userManager.getUserProfile(username);
        this.adminEmail = userProfile.getEmail();
    }

    private boolean isValidJson(String jsonString) {
        try {
            new JSONObject(jsonString);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private Map<String, String> generateWebAuthCredMap(JSONObject credObject) {
        HashMap<String, String> credMap = new HashMap<String, String>();
        Iterator<String> keys = credObject.keys();
        while (keys.hasNext()) {
            String key = keys.next();
            if (!(credObject.get(key) instanceof String)) continue;
            String rId = credObject.getString(key);
            credMap.put(key, rId);
        }
        return credMap;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public Boolean getEnableTwoFactor() {
        return this.enableTwoFactor;
    }

    public void setEnableTwoFactor(Boolean enableTwoFactor) {
        this.enableTwoFactor = enableTwoFactor;
    }

    public String getSetQR() {
        return this.setQR;
    }

    public void setSetQR(String setQR) {
        this.setQR = setQR;
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public String[] getBackupMethodForUser() {
        return this.backupMethodForUser;
    }

    public void setBackupMethodForUser(String[] backupMethodForUser) {
        this.backupMethodForUser = backupMethodForUser;
    }

    public List<String> getBackupMethodForUserList() {
        return this.backupMethodForUserList;
    }

    public void setBackupMethodForUserList(List<String> backupMethodForUserList) {
        this.backupMethodForUserList = backupMethodForUserList;
    }

    public String getQrcode() {
        return this.qrcode;
    }

    public void setQrcode(String qrcode) {
        this.qrcode = qrcode;
    }

    public List<String> getSecurityQuestionNumber() {
        int securityQuestionCount = MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_QUESTION_COUNT - MoTwoFactorCommonPluginConstants.MO2FA_SECURITY_CUSTOM_QUESTION_COUNT;
        ArrayList<String> securityQuestionNumber = new ArrayList<String>();
        for (int i = 1; i <= securityQuestionCount; ++i) {
            securityQuestionNumber.add("Question " + i);
        }
        return securityQuestionNumber;
    }

    public String getXsrfToken() {
        return this.xsrfToken;
    }

    public void setXsrfToken(String xsrfToken) {
        this.xsrfToken = xsrfToken;
    }

    public Integer getTotal2faEnabledUsers() {
        return this.total2faEnabledUsers;
    }

    public void setTotal2faEnabledUsers(Integer total2faEnabledUsers) {
        this.total2faEnabledUsers = total2faEnabledUsers;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    private void initializeQrCode(MoTwoFactorCommonUserSettings twoFactorUserClass) {
        String crowdInstanceKeyValue;
        String username = this.pluginConfiguration.getCurrentLoggedInUser();
        this.secretKey = MoTwoFactorUtility.generateKey();
        HttpSession session = ServletActionContext.getRequest().getSession();
        if (session.getAttribute("2fa_secret") == null || StringUtils.isBlank((CharSequence)((String)session.getAttribute("2fa_secret")))) {
            session.setAttribute("2fa_secret", (Object)this.secretKey);
        } else {
            this.secretKey = (String)session.getAttribute("2fa_secret");
        }
        this.qrcode = MoTwoFactorUtility.generateQrCode(this.secretKey, username, this.settings.getAppLabel("Crowd"));
        session.setAttribute("2fa_qrcode", (Object)this.qrcode);
        if (StringUtils.isBlank((CharSequence)twoFactorUserClass.getUserSalt())) {
            String userSpecific_salt_key = MoTwoFactorUtility.generateRandomString(10);
            twoFactorUserClass.setUserSalt(userSpecific_salt_key);
        }
        if (StringUtils.isEmpty((CharSequence)(crowdInstanceKeyValue = this.settings.getEncryptionKey()))) {
            String crowd_instance_key = MoTwoFactorUtility.generateRandomString(10);
            this.settings.setEncryptionKey(crowd_instance_key);
        }
        this.settings.setUserSettings(username, twoFactorUserClass);
        session.setAttribute("2fa_verification", (Object)true);
    }

    public Boolean getShouldShowDuoPushNotification() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowSecurityQuestion() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowOtpOverSms() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowBackupCode() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowOtpOverEmail() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowGoogleAuthenticator() {
        return Boolean.TRUE;
    }

    private String convertBooleanToString(Boolean booleanValue) {
        if (BooleanUtils.toBoolean((Boolean)booleanValue)) {
            return "true";
        }
        return "false";
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String[] getTwoFactorMethodForUser() {
        return this.twoFactorMethodForUser;
    }

    public void setTwoFactorMethodForUser(String[] twoFactorMethodForUser) {
        this.twoFactorMethodForUser = twoFactorMethodForUser;
    }

    public List<String> getTwoFactorMethodForUserList() {
        return this.twoFactorMethodForUserList;
    }

    public void setTwoFactorMethodForUserList(List<String> twoFactorMethodForUserList) {
        this.twoFactorMethodForUserList = twoFactorMethodForUserList;
    }

    public Boolean getSmtpConfigured() {
        return this.smtpConfigured;
    }

    public void setSmtpConfigured(Boolean smtpConfigured) {
        this.smtpConfigured = smtpConfigured;
    }

    public Boolean getSmsGatewayConfigured() {
        return this.smsGatewayConfigured;
    }

    public void setSmsGatewayConfigured(Boolean smsGatewayConfigured) {
        this.smsGatewayConfigured = smsGatewayConfigured;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public Boolean getShareSecretKey() {
        return this.shareSecretKey;
    }

    public void setShareSecretKey(Boolean shareSecretKey) {
        this.shareSecretKey = shareSecretKey;
    }

    public Boolean getShowWelcomePrompt() {
        return this.showWelcomePrompt;
    }

    public void setShowWelcomePrompt(Boolean showWelcomePrompt) {
        this.showWelcomePrompt = showWelcomePrompt;
    }

    public String getShowWelcomePromptString() {
        return this.showWelcomePromptString;
    }

    public void setShowWelcomePromptString(String showWelcomePromptString) {
        this.showWelcomePromptString = showWelcomePromptString;
    }

    public Boolean getDuoPushNotificationSettingsConfigured() {
        return this.duoPushNotificationSettingsConfigured;
    }

    public void setDuoPushNotificationSettingsConfigured(Boolean duoPushNotificationSettingsConfigured) {
        this.duoPushNotificationSettingsConfigured = duoPushNotificationSettingsConfigured;
    }

    public String getDuoPushNotificationEnrollPortalUrl() {
        return this.duoPushNotificationEnrollPortalUrl;
    }

    public void setDuoPushNotificationEnrollPortalUrl(String duoPushNotificationEnrollPortalUrl) {
        this.duoPushNotificationEnrollPortalUrl = duoPushNotificationEnrollPortalUrl;
    }

    public List<String> getPagesAccessibleToUser() {
        return this.pagesAccessibleToUser;
    }

    public Boolean getDisplayEndUserReconfigurationPage() {
        return this.displayEndUserReconfigurationPage;
    }

    public void setDisplayEndUserReconfigurationPage(Boolean displayEndUserReconfigurationPage) {
        this.displayEndUserReconfigurationPage = displayEndUserReconfigurationPage;
    }

    public Boolean getIsSslSetup() {
        return this.isSslSetup;
    }

    public void setIsSslSetup(Boolean sslSetup) {
        this.isSslSetup = sslSetup;
    }

    public String getAttestationType() {
        return this.attestationType;
    }

    public void setAttestationType(String attestationType) {
        this.attestationType = attestationType;
    }

    public String getAuthenticatorType() {
        return this.authenticatorType;
    }

    public void setAuthenticatorType(String authenticatorType) {
        this.authenticatorType = authenticatorType;
    }

    public String getUserVerification() {
        return this.userVerification;
    }

    public void setUserVerification(String userVerification) {
        this.userVerification = userVerification;
    }

    public String getResidentKey() {
        return this.residentKey;
    }

    public void setResidentKey(String residentKey) {
        this.residentKey = residentKey;
    }

    public Boolean getShouldShowU2FHardwareToken() {
        return Boolean.TRUE;
    }

    public Boolean getShouldShowWebAuthn() {
        return Boolean.TRUE;
    }

    public String getCurrentLoggedInUser() {
        return this.currentLoggedInUser;
    }

    public void setCurrentLoggedInUser(String currentLoggedInUser) {
        this.currentLoggedInUser = currentLoggedInUser;
    }

    public void setPagesAccessibleToUser(List<String> pagesAccessibleToUser) {
        this.pagesAccessibleToUser = pagesAccessibleToUser;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(Boolean admin) {
        this.isAdmin = admin;
    }

    public String getPageAccessType() {
        return this.pageAccessType;
    }

    public void setPageAccessType(String pageAccessType) {
        this.pageAccessType = pageAccessType;
    }

    public Boolean getMultiLingualSupportToggle() {
        return this.multiLingualSupportToggle;
    }

    public void setMultiLingualSupportToggle(Boolean multiLingualSupportToggle) {
        this.multiLingualSupportToggle = multiLingualSupportToggle;
    }

    public Boolean getTwoFactorForMobileAuthn() {
        return this.twoFactorForMobileAuthn;
    }

    public void setTwoFactorForMobileAuthn(Boolean twoFactorForMobileAuthn) {
        this.twoFactorForMobileAuthn = twoFactorForMobileAuthn;
    }

    public Boolean getTwoFactorForsecurityQuestion() {
        return this.twoFactorForsecurityQuestion;
    }

    public void setTwoFactorForsecurityQuestion(Boolean twoFactorForsecurityQuestion) {
        this.twoFactorForsecurityQuestion = twoFactorForsecurityQuestion;
    }

    public Boolean getTwoFactorForYubikey() {
        return this.twoFactorForYubikey;
    }

    public void setTwoFactorForYubikey(Boolean twoFactorForYubikey) {
        this.twoFactorForYubikey = twoFactorForYubikey;
    }

    public Boolean getTwoFactorForDuopush() {
        return this.twoFactorForDuopush;
    }

    public void setTwoFactorForDuopush(Boolean twoFactorForDuopush) {
        this.twoFactorForDuopush = twoFactorForDuopush;
    }

    public Boolean getTwoFactorForOtpOverEmail() {
        return this.twoFactorForOtpOverEmail;
    }

    public void setTwoFactorForOtpOverEmail(Boolean twoFactorForOtpOverEmail) {
        this.twoFactorForOtpOverEmail = twoFactorForOtpOverEmail;
    }

    public Boolean getTwoFactorForOtpOverSms() {
        return this.twoFactorForOtpOverSms;
    }

    public void setTwoFactorForOtpOverSms(Boolean twoFactorForOtpOverSms) {
        this.twoFactorForOtpOverSms = twoFactorForOtpOverSms;
    }

    public Boolean getTwoFactorForWebAuthn() {
        return this.twoFactorForWebAuthn;
    }

    public void setTwoFactorForWebAuthn(Boolean twoFactorForWebAuthn) {
        this.twoFactorForWebAuthn = twoFactorForWebAuthn;
    }

    public Boolean getTwoFactorForBackup() {
        return this.twoFactorForBackup;
    }

    public void setTwoFactorForBackup(Boolean twoFactorForBackup) {
        this.twoFactorForBackup = twoFactorForBackup;
    }

    public String getAppLabel() {
        return this.appLabel;
    }

    public void setAppLabel(String appLabel) {
        this.appLabel = appLabel;
    }

    public Boolean getShowSupportedAppPopup() {
        return this.showSupportedAppPopup;
    }

    public void setShowSupportedAppPopup(Boolean showSupportedAppPopup) {
        this.showSupportedAppPopup = showSupportedAppPopup;
    }

    public Boolean getEnableShareSecretKey() {
        return this.enableShareSecretKey;
    }

    public void setEnableShareSecretKey(Boolean enableShareSecretKey) {
        this.enableShareSecretKey = enableShareSecretKey;
    }

    public String getDuoPushNotificationIntegrationKey() {
        return this.duoPushNotificationIntegrationKey;
    }

    public void setDuoPushNotificationIntegrationKey(String duoPushNotificationIntegrationKey) {
        this.duoPushNotificationIntegrationKey = duoPushNotificationIntegrationKey;
    }

    public String getDuoPushNotificationSecretKey() {
        return this.duoPushNotificationSecretKey;
    }

    public void setDuoPushNotificationSecretKey(String duoPushNotificationSecretKey) {
        this.duoPushNotificationSecretKey = duoPushNotificationSecretKey;
    }

    public String getDuoPushNotificationHostName() {
        return this.duoPushNotificationHostName;
    }

    public void setDuoPushNotificationHostName(String duoPushNotificationHostName) {
        this.duoPushNotificationHostName = duoPushNotificationHostName;
    }

    public String getEmailTemplate() {
        return this.emailTemplate;
    }

    public void setEmailTemplate(String emailTemplate) {
        this.emailTemplate = emailTemplate;
    }

    public String getOtpValidityDuration() {
        return this.otpValidityDuration;
    }

    public void setOtpValidityDuration(String otpValidityDuration) {
        this.otpValidityDuration = otpValidityDuration;
    }

    public String getOtpLength() {
        return this.otpLength;
    }

    public void setOtpLength(String otpLength) {
        this.otpLength = otpLength;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public String getSmsGateway() {
        return this.smsGateway;
    }

    public void setSmsGateway(String smsGateway) {
        this.smsGateway = smsGateway;
    }

    public ArrayList getSmsGatewayOptions() {
        this.smsGatewayOptions = new ArrayList();
        this.smsGatewayOptions.add("miniOrange Gateway");
        this.smsGatewayOptions.add("Custom Gateway");
        return this.smsGatewayOptions;
    }

    public void setSmsGatewayOptions(ArrayList smsGatewayOptions) {
        this.smsGatewayOptions = smsGatewayOptions;
    }

    public String getCustomerKey() {
        return this.customerKey;
    }

    public void setCustomerKey(String customerKey) {
        this.customerKey = customerKey;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public String getSmsGatewayUrl() {
        return this.smsGatewayUrl;
    }

    public void setSmsGatewayUrl(String smsGatewayUrl) {
        this.smsGatewayUrl = smsGatewayUrl;
    }

    public String getSmsTemplate() {
        return this.smsTemplate;
    }

    public void setSmsTemplate(String smsTemplate) {
        this.smsTemplate = smsTemplate;
    }

    public Boolean getOtpOverSmsSettingsSubmitted() {
        return this.otpOverSmsSettingsSubmitted;
    }

    public void setOtpOverSmsSettingsSubmitted(Boolean otpOverSmsSettingsSubmitted) {
        this.otpOverSmsSettingsSubmitted = otpOverSmsSettingsSubmitted;
    }

    public Boolean getEnable2FAForAllUsers() {
        return this.enable2FAForAllUsers;
    }

    public void setEnable2FAForAllUsers(Boolean enable2FAForAllUsers) {
        this.enable2FAForAllUsers = enable2FAForAllUsers;
    }

    public String getAdminEmail() {
        return this.adminEmail;
    }

    public void setAdminEmail(String adminEmail) {
        this.adminEmail = adminEmail;
    }
}

