/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.twofactor.crowd.action;

import com.atlassian.crowd.console.action.BaseAction;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginConstants;
import com.miniorange.twofactor.common.MoTwoFactorCommonPluginSettings;
import com.miniorange.twofactor.common.exception.MoTwoFactorCommonPluginException;
import com.miniorange.twofactor.crowd.MoTwoFactorCrowdPluginSettings;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginConfiguration;
import com.miniorange.twofactor.crowd.MoTwoFactorPluginHandler;
import com.miniorange.twofactor.crowd.utility.MoTwoFactorUtility;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.validator.routines.InetAddressValidator;
import org.apache.struts2.ServletActionContext;

public class MoTwoFactorAdaptiveAuthenticationAction
extends BaseAction {
    private static final Log LOGGER = LogFactory.getLog(MoTwoFactorAdaptiveAuthenticationAction.class);
    private MoTwoFactorCommonPluginSettings settings;
    private MoTwoFactorPluginHandler pluginHandler;
    private MoTwoFactorPluginConfiguration pluginConfiguration;
    private MoTwoFactorCrowdPluginSettings pluginSettings;
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private Boolean whiteListIpForm;
    private Boolean blackListIpForm;
    private String ipAddress;
    private String ipAddressMessage;
    private Boolean whiteListIpFormSubmitted;
    private String whiteListIpSearchKeyword;
    private Map<String, String> whitelistIpAddressWithMessagesMap;
    private Map<String, String> currentPageWhiteListIpAddressWithMessagesMap;
    private Boolean blackListIpFormSubmitted;
    private String blackListIpSearchKeyword;
    private Map<String, String> blacklistIpAddressWithMessagesMap;
    private Map<String, String> currentPageBlackListIpAddressWithMessagesMap;
    private String ipManagementSelectedAction;
    private Integer selectedPage;
    private Integer startIndex;
    private Integer endIndex;
    private Integer numberOfPages;
    private Integer numberOfRecordsPerPage;
    private List<String> numberOfPagesList;
    private HttpServletRequest request;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private String clientIpRequestHeader;
    private Map<String, String> displayRequestHeader;
    private String currentIPAddress;
    private List<String> pagesAccessibleToUser;
    private Boolean isAdmin;
    private String pageAccessType;
    private Boolean multiLingualSupportToggle;

    public MoTwoFactorAdaptiveAuthenticationAction(MoTwoFactorCommonPluginSettings settings, MoTwoFactorPluginHandler pluginHandler, MoTwoFactorPluginConfiguration pluginConfiguration, MoTwoFactorCrowdPluginSettings pluginSettings, UserManager userManager, LoginUriProvider loginUriProvider) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.pluginConfiguration = pluginConfiguration;
        this.pluginSettings = pluginSettings;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
    }

    private Boolean validateIpAddress(String ipAddress) {
        try {
            if (StringUtils.isBlank((CharSequence)ipAddress) || StringUtils.isEmpty((CharSequence)ipAddress)) {
                return Boolean.FALSE;
            }
            ipAddress = ipAddress.trim();
            if (StringUtils.startsWithIgnoreCase((CharSequence)(ipAddress = MoTwoFactorUtility.sanitizeText(ipAddress)), (CharSequence)".") || StringUtils.endsWithIgnoreCase((CharSequence)ipAddress, (CharSequence)".")) {
                return Boolean.FALSE;
            }
            String[] segment = ipAddress.split("/");
            if (segment.length == 2) {
                InetAddressValidator validator = InetAddressValidator.getInstance();
                if (validator.isValidInet4Address(segment[0])) {
                    if (Integer.parseInt(segment[1]) <= 32 && Integer.parseInt(segment[1]) >= 1) {
                        return Boolean.TRUE;
                    }
                    return Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
            String[] parts = ipAddress.split("\\.");
            if (parts.length < 1 || parts.length > 4) {
                return Boolean.FALSE;
            }
            for (String part : parts) {
                int i = Integer.parseInt(part);
                if (i >= 0 && i <= 255 && part.length() <= 3) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        catch (Exception e) {
            return Boolean.FALSE;
        }
    }

    public String execute() throws Exception {
        LOGGER.debug("MoTwoFactorAdaptiveAuthenticationAction doExecute called");
        UserProfile user = this.userManager.getRemoteUser();
        this.request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        this.pagesAccessibleToUser = this.pluginHandler.getUserAccessiblePages();
        if (this.pagesAccessibleToUser.contains("IP_Restriction_readwrite")) {
            this.pageAccessType = "readwrite";
        } else if (this.pagesAccessibleToUser.contains("IP_Restriction_read")) {
            this.pageAccessType = "read";
        } else {
            response.sendRedirect(this.pluginConfiguration.getDashboardUrl());
            return null;
        }
        if (user != null) {
            try {
                if (!this.pluginSettings.isCustomerRegistered().booleanValue()) {
                    LOGGER.debug("Customer is not registered");
                    this.settings.setEnableTwoFactor(Boolean.FALSE);
                    return "register";
                }
                if (!this.pluginSettings.getLicenseVerified().booleanValue() || this.pluginSettings.getLicenseVerified().booleanValue() && this.pluginSettings.isTrialLicense().booleanValue() && this.pluginSettings.isLicenseExpired().booleanValue()) {
                    this.settings.setEnableTwoFactor(Boolean.FALSE);
                    return "verify";
                }
                this.ipAddressMessage = MoTwoFactorUtility.sanitizeText(this.ipAddressMessage);
                String startIndexAsString = "";
                String endIndexAsString = "";
                if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getIpManagementSelectedAction(), (CharSequence)"WhitelistIpAction")) {
                    Object searchKeyword;
                    if (this.pageAccessType.equals("readwrite") && BooleanUtils.toBoolean((Boolean)this.whiteListIpFormSubmitted)) {
                        if (StringUtils.isNotBlank((CharSequence)this.ipAddress)) {
                            this.ipAddress = MoTwoFactorUtility.sanitizeText(this.ipAddress);
                            if (BooleanUtils.toBoolean((Boolean)this.validateIpAddress(this.ipAddress))) {
                                String validIpAddress;
                                if (StringUtils.isNotBlank((CharSequence)this.ipAddressMessage)) {
                                    validIpAddress = this.pluginHandler.getValidIpAddress(this.ipAddress);
                                    this.pluginHandler.saveWhitelistIpAddressAndMessagesInMap(validIpAddress, this.ipAddressMessage);
                                } else {
                                    validIpAddress = this.pluginHandler.getValidIpAddress(this.ipAddress);
                                    this.pluginHandler.saveWhitelistIpAddressAndMessagesInMap(validIpAddress, "-");
                                }
                                this.ipAddress = "";
                                this.ipAddressMessage = "";
                                LOGGER.info("Successfully Added Whitelist IP Address");
                                this.addActionMessage("Successfully added Whitelist IP address.");
                            } else {
                                LOGGER.error("Invalid IP Address added");
                                this.addActionError("Invalid IP Address.. Please add the valid one.");
                            }
                        } else {
                            LOGGER.error("IP Address is empty. Please add the valid one.");
                            this.addActionError("IP Address is empty. Please add the valid one..");
                        }
                        this.whiteListIpSearchKeyword = "";
                        startIndexAsString = "";
                        endIndexAsString = "";
                    } else {
                        if (StringUtils.isBlank((CharSequence)this.whiteListIpSearchKeyword)) {
                            this.whiteListIpSearchKeyword = "";
                        }
                        if ((searchKeyword = MoTwoFactorUtility.sanitizeText(this.request.getParameter("whiteListIpSearchKeywordUrl"))) != null) {
                            this.whiteListIpSearchKeyword = searchKeyword.trim();
                        }
                        startIndexAsString = MoTwoFactorUtility.sanitizeText(this.request.getParameter("startIndex"));
                        endIndexAsString = MoTwoFactorUtility.sanitizeText(this.request.getParameter("endIndex"));
                    }
                    this.numberOfRecordsPerPage = MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                    if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                        this.selectedPage = 1;
                        this.startIndex = 1;
                        this.endIndex = this.numberOfRecordsPerPage;
                    } else {
                        this.startIndex = Integer.parseInt(startIndexAsString);
                        this.endIndex = Integer.parseInt(endIndexAsString);
                        this.selectedPage = this.endIndex / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                    }
                    LOGGER.info("Searching for Whitelist IP using " + this.whiteListIpSearchKeyword);
                    this.whiteListIpSearchKeyword = MoTwoFactorUtility.sanitizeText(this.whiteListIpSearchKeyword);
                    this.whitelistIpAddressWithMessagesMap = this.pluginHandler.getStoredIpAddressWithMessage(this.settings.getWhitelistIpAddressWithMessages(), this.whiteListIpSearchKeyword.trim(), 100);
                    this.currentPageWhiteListIpAddressWithMessagesMap = this.pluginHandler.getSelectedDetailsForPaginationForIpAddress(this.whitelistIpAddressWithMessagesMap, this.startIndex - 1, this.endIndex - 1);
                    this.numberOfPages = this.whitelistIpAddressWithMessagesMap.size() / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                    if (this.whitelistIpAddressWithMessagesMap.size() > this.numberOfPages * MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE) {
                        searchKeyword = this;
                        Integer n = ((MoTwoFactorAdaptiveAuthenticationAction)((Object)searchKeyword)).numberOfPages;
                        Integer n2 = ((MoTwoFactorAdaptiveAuthenticationAction)((Object)searchKeyword)).numberOfPages = Integer.valueOf(((MoTwoFactorAdaptiveAuthenticationAction)((Object)searchKeyword)).numberOfPages + 1);
                    }
                } else {
                    if (this.pageAccessType.equals("readwrite") && BooleanUtils.toBoolean((Boolean)this.blackListIpFormSubmitted)) {
                        if (StringUtils.isNotBlank((CharSequence)this.ipAddress)) {
                            this.ipAddress = MoTwoFactorUtility.sanitizeText(this.ipAddress);
                            if (BooleanUtils.toBoolean((Boolean)this.validateIpAddress(this.ipAddress))) {
                                String validIpAddress;
                                if (StringUtils.isNotBlank((CharSequence)this.ipAddressMessage)) {
                                    validIpAddress = this.pluginHandler.getValidIpAddress(this.ipAddress);
                                    this.pluginHandler.saveBlacklistIpAddressAndMessagesInMap(validIpAddress, this.ipAddressMessage);
                                } else {
                                    validIpAddress = this.pluginHandler.getValidIpAddress(this.ipAddress);
                                    this.pluginHandler.saveBlacklistIpAddressAndMessagesInMap(validIpAddress, "-");
                                }
                                this.ipAddress = "";
                                this.ipAddressMessage = "";
                                LOGGER.info("Successfully save configuration");
                                this.addActionMessage("Successfully added Blacklist IP address");
                            } else {
                                LOGGER.error("Invalid IP Address added");
                                this.addActionError("Invalid IP Address. Please add the valid one.");
                            }
                        } else {
                            LOGGER.error("IP Address is empty. Please add the valid one.");
                            this.addActionError("IP Address is empty. Please add the valid one.");
                        }
                        this.blackListIpSearchKeyword = "";
                        startIndexAsString = "";
                        endIndexAsString = "";
                    } else {
                        if (StringUtils.isBlank((CharSequence)this.blackListIpSearchKeyword)) {
                            this.blackListIpSearchKeyword = "";
                        }
                        if (BooleanUtils.toBoolean((Boolean)this.blackListIpFormSubmitted)) {
                            startIndexAsString = "";
                            endIndexAsString = "";
                        } else {
                            String searchKeyword = MoTwoFactorUtility.sanitizeText(this.request.getParameter("blackListIpSearchKeywordUrl"));
                            if (searchKeyword != null) {
                                this.blackListIpSearchKeyword = searchKeyword.trim();
                            }
                            startIndexAsString = MoTwoFactorUtility.sanitizeText(this.request.getParameter("startIndex"));
                            endIndexAsString = MoTwoFactorUtility.sanitizeText(this.request.getParameter("endIndex"));
                        }
                    }
                    this.numberOfRecordsPerPage = MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                    if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                        this.selectedPage = 1;
                        this.startIndex = 1;
                        this.endIndex = this.numberOfRecordsPerPage;
                    } else {
                        this.startIndex = Integer.parseInt(startIndexAsString);
                        this.endIndex = Integer.parseInt(endIndexAsString);
                        this.selectedPage = this.endIndex / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                    }
                    LOGGER.info("Searching for Blacklist IP using " + this.blackListIpSearchKeyword);
                    this.blackListIpSearchKeyword = MoTwoFactorUtility.sanitizeText(this.blackListIpSearchKeyword);
                    this.blacklistIpAddressWithMessagesMap = this.pluginHandler.getStoredIpAddressWithMessage(this.settings.getBlacklistIpAddressWithMessages(), this.blackListIpSearchKeyword.trim(), 100);
                    this.currentPageBlackListIpAddressWithMessagesMap = this.pluginHandler.getSelectedDetailsForPaginationForIpAddress(this.blacklistIpAddressWithMessagesMap, this.startIndex - 1, this.endIndex - 1);
                    this.numberOfPages = this.blacklistIpAddressWithMessagesMap.size() / MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE;
                    if (this.blacklistIpAddressWithMessagesMap.size() > this.numberOfPages * MoTwoFactorCommonPluginConstants.MO2FA_NUMBER_OF_USER_PER_PAGE) {
                        MoTwoFactorAdaptiveAuthenticationAction moTwoFactorAdaptiveAuthenticationAction = this;
                        Integer n = moTwoFactorAdaptiveAuthenticationAction.numberOfPages;
                        Integer n3 = moTwoFactorAdaptiveAuthenticationAction.numberOfPages = Integer.valueOf(moTwoFactorAdaptiveAuthenticationAction.numberOfPages + 1);
                    }
                }
                if (BooleanUtils.toBoolean((String)this.request.getParameter("ClientRequestedIPHeaderSubmitted"))) {
                    this.settings.setClientIpRequestHeader(this.clientIpRequestHeader);
                }
                this.initializeAdaptiveAuthentication();
                return "success";
            }
            catch (MoTwoFactorCommonPluginException e) {
                LOGGER.error("Error " + e);
                this.addActionError(e.getMessage());
                return "upm";
            }
            catch (Exception e) {
                LOGGER.error("Error " + e);
                this.addActionError("An error occurred.");
                return "upm";
            }
        }
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(this.request)).toASCIIString());
        return null;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private void initializeAdaptiveAuthentication() {
        LOGGER.debug("inside initializeAdaptiveAuthentication...");
        this.ipManagementSelectedAction = this.settings.getIpManagementSelectedAction();
        this.crowdBaseUrl = this.pluginSettings.getBaseUrl();
        this.licenseType = this.pluginSettings.getLicenseType();
        this.licenseExpireDate = this.pluginSettings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.pluginSettings.isNoOfUserExceed();
        this.clientIpRequestHeader = this.settings.getClientIpRequestHeader();
        this.displayRequestHeader = this.settings.getRequestInfo(ServletActionContext.getRequest());
        this.currentIPAddress = MoTwoFactorUtility.getCurrentIpAddress(this.getHttpRequest(), this.settings);
        this.isAdmin = this.userManager.isAdmin(this.userManager.getRemoteUser().getUserKey());
        this.multiLingualSupportToggle = this.settings.getMultiLingualSupportToggle();
    }

    public MoTwoFactorCommonPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(MoTwoFactorCommonPluginSettings settings) {
        this.settings = settings;
    }

    public MoTwoFactorPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    public void setPluginHandler(MoTwoFactorPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    public MoTwoFactorPluginConfiguration getPluginConfiguration() {
        return this.pluginConfiguration;
    }

    public void setPluginConfiguration(MoTwoFactorPluginConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public Map<String, String> getWhitelistIpAddressWithMessagesMap() {
        return this.whitelistIpAddressWithMessagesMap;
    }

    public void setWhitelistIpAddressWithMessagesMap(Map<String, String> whitelistIpAddressWithMessagesMap) {
        this.whitelistIpAddressWithMessagesMap = whitelistIpAddressWithMessagesMap;
    }

    public Map<String, String> getCurrentPageWhiteListIpAddressWithMessagesMap() {
        return this.currentPageWhiteListIpAddressWithMessagesMap;
    }

    public void setCurrentPageWhiteListIpAddressWithMessagesMap(Map<String, String> currentPageWhiteListIpAddressWithMessagesMap) {
        this.currentPageWhiteListIpAddressWithMessagesMap = currentPageWhiteListIpAddressWithMessagesMap;
    }

    public Map<String, String> getBlacklistIpAddressWithMessagesMap() {
        return this.blacklistIpAddressWithMessagesMap;
    }

    public void setBlacklistIpAddressWithMessagesMap(Map<String, String> blacklistIpAddressWithMessagesMap) {
        this.blacklistIpAddressWithMessagesMap = blacklistIpAddressWithMessagesMap;
    }

    public Map<String, String> getCurrentPageBlackListIpAddressWithMessagesMap() {
        return this.currentPageBlackListIpAddressWithMessagesMap;
    }

    public void setCurrentPageBlackListIpAddressWithMessagesMap(Map<String, String> currentPageBlackListIpAddressWithMessagesMap) {
        this.currentPageBlackListIpAddressWithMessagesMap = currentPageBlackListIpAddressWithMessagesMap;
    }

    public String getIpAddressMessage() {
        return this.ipAddressMessage;
    }

    public void setIpAddressMessage(String ipAddressMessage) {
        this.ipAddressMessage = ipAddressMessage;
    }

    public Boolean getWhiteListIpForm() {
        return this.whiteListIpForm;
    }

    public void setWhiteListIpForm(Boolean whiteListIpForm) {
        this.whiteListIpForm = whiteListIpForm;
    }

    public Boolean getBlackListIpForm() {
        return this.blackListIpForm;
    }

    public void setBlackListIpForm(Boolean blackListIpForm) {
        this.blackListIpForm = blackListIpForm;
    }

    public Boolean getWhiteListIpFormSubmitted() {
        return this.whiteListIpFormSubmitted;
    }

    public void setWhiteListIpFormSubmitted(Boolean whiteListIpFormSubmitted) {
        this.whiteListIpFormSubmitted = whiteListIpFormSubmitted;
    }

    public String getWhiteListIpSearchKeyword() {
        return this.whiteListIpSearchKeyword;
    }

    public void setWhiteListIpSearchKeyword(String whiteListIpSearchKeyword) {
        this.whiteListIpSearchKeyword = whiteListIpSearchKeyword;
    }

    public Boolean getBlackListIpFormSubmitted() {
        return this.blackListIpFormSubmitted;
    }

    public void setBlackListIpFormSubmitted(Boolean blackListIpFormSubmitted) {
        this.blackListIpFormSubmitted = blackListIpFormSubmitted;
    }

    public String getBlackListIpSearchKeyword() {
        return this.blackListIpSearchKeyword;
    }

    public void setBlackListIpSearchKeyword(String blackListIpSearchKeyword) {
        this.blackListIpSearchKeyword = blackListIpSearchKeyword;
    }

    public String getIpManagementSelectedAction() {
        return this.ipManagementSelectedAction;
    }

    public void setIpManagementSelectedAction(String ipManagementSelectedAction) {
        this.ipManagementSelectedAction = ipManagementSelectedAction;
    }

    public String getIpAddress() {
        return "";
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public Integer getSelectedPage() {
        return this.selectedPage;
    }

    public void setSelectedPage(Integer selectedPage) {
        this.selectedPage = selectedPage;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(Integer endIndex) {
        this.endIndex = endIndex;
    }

    public Integer getNumberOfPages() {
        return this.numberOfPages;
    }

    public void setNumberOfPages(Integer numberOfPages) {
        this.numberOfPages = numberOfPages;
    }

    public Integer getNumberOfRecordsPerPage() {
        return this.numberOfRecordsPerPage;
    }

    public void setNumberOfRecordsPerPage(Integer numberOfRecordsPerPage) {
        this.numberOfRecordsPerPage = numberOfRecordsPerPage;
    }

    public List<String> getNumberOfPagesList() {
        this.numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfPages; ++i) {
            this.numberOfPagesList.add("" + i);
        }
        return this.numberOfPagesList;
    }

    public void setNumberOfPagesList(List<String> numberOfPagesList) {
        this.numberOfPagesList = numberOfPagesList;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public LoginUriProvider getLoginUriProvider() {
        return this.loginUriProvider;
    }

    public void setLoginUriProvider(LoginUriProvider loginUriProvider) {
        this.loginUriProvider = loginUriProvider;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public MoTwoFactorCrowdPluginSettings getPluginSettings() {
        return this.pluginSettings;
    }

    public void setPluginSettings(MoTwoFactorCrowdPluginSettings pluginSettings) {
        this.pluginSettings = pluginSettings;
    }

    public String getCrowdBaseUrl() {
        return this.crowdBaseUrl;
    }

    public void setCrowdBaseUrl(String crowdBaseUrl) {
        this.crowdBaseUrl = crowdBaseUrl;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public void setLicenseType(String licenseType) {
        this.licenseType = licenseType;
    }

    public String getLicenseExpireDate() {
        return this.licenseExpireDate;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        this.licenseExpireDate = licenseExpireDate;
    }

    public Boolean getIsNoOfUserExceed() {
        return this.isNoOfUserExceed;
    }

    public void setIsNoOfUserExceed(Boolean isNoOfUserExceed) {
        this.isNoOfUserExceed = isNoOfUserExceed;
    }

    public String getClientIpRequestHeader() {
        return this.clientIpRequestHeader;
    }

    public void setClientIpRequestHeader(String clientIpRequestHeader) {
        this.clientIpRequestHeader = clientIpRequestHeader;
    }

    public Map<String, String> getDisplayRequestHeader() {
        return this.displayRequestHeader;
    }

    public void setDisplayRequestHeader(Map<String, String> displayRequestHeader) {
        this.displayRequestHeader = displayRequestHeader;
    }

    public String getCurrentIPAddress() {
        return this.currentIPAddress;
    }

    public void setCurrentIPAddress(String currentIPAddress) {
        this.currentIPAddress = currentIPAddress;
    }

    public List<String> getPagesAccessibleToUser() {
        return this.pagesAccessibleToUser;
    }

    public void setPagesAccessibleToUser(List<String> pagesAccessibleToUser) {
        this.pagesAccessibleToUser = pagesAccessibleToUser;
    }

    public Boolean getIsAdmin() {
        return this.isAdmin;
    }

    public void setIsAdmin(Boolean admin) {
        this.isAdmin = admin;
    }

    public String getPageAccessType() {
        return this.pageAccessType;
    }

    public void setPageAccessType(String pageAccessType) {
        this.pageAccessType = pageAccessType;
    }

    public Boolean getMultiLingualSupportToggle() {
        return this.multiLingualSupportToggle;
    }

    public void setMultiLingualSupportToggle(Boolean multiLingualSupportToggle) {
        this.multiLingualSupportToggle = multiLingualSupportToggle;
    }
}

