/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.memory;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.DefaultGroup;
import com.atlassian.user.impl.DuplicateEntityException;
import com.atlassian.user.impl.memory.provider.MemoryProvider;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.Pager;
import java.util.HashMap;

public class MemoryGroupManager
implements GroupManager {
    private MemoryProvider provider;
    private Repository repository;

    public MemoryGroupManager() {
    }

    public MemoryGroupManager(Repository repository, MemoryProvider provider) {
        this.provider = provider;
        this.repository = repository;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.provider = (MemoryProvider)args.get("provider");
        this.repository = (Repository)args.get("repository");
        InitializationCheck.validateArgs(args, new String[]{"repository", "provider"}, this);
    }

    public Group createGroup(String groupName) throws EntityException {
        if (this.getGroup(groupName) != null) {
            throw new DuplicateEntityException("The group [" + groupName + "] already exists.");
        }
        DefaultGroup group = new DefaultGroup(groupName);
        this.provider.addGroup(group);
        return group;
    }

    public void removeGroup(Group group) throws EntityException {
        this.provider.removeGroup(group);
    }

    public void importGroup(Group group) throws EntityException {
        if (group == null) {
            throw new EntityException("Will not save null group!");
        }
        if (this.getGroup(group.getName()) != null) {
            throw new EntityException("Group [" + group.getName() + "] already exists");
        }
        this.provider.addGroup(group);
        Pager users = this.getMemberNames(group);
        if (users == null) {
            return;
        }
    }

    public void addMembership(Group group, User user) {
        this.provider.addMembership(group, user);
    }

    public boolean hasMembership(Group group, User user) {
        return this.provider.hasMembership(group, user);
    }

    public void saveGroup(Group group) throws EntityException {
    }

    public Pager getGroups() throws EntityException {
        return this.provider.getGroups();
    }

    public Group getGroup(String groupName) {
        return this.provider.getGroup(groupName);
    }

    public Pager getGroups(User user) throws EntityException {
        return this.provider.getGroups(user);
    }

    public Repository getConfiguration() {
        return this.repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Repository getRepository(Entity entity) throws EntityException {
        if (this.getGroup(entity.getName()) != null) {
            return this.repository;
        }
        return null;
    }

    public String getApplicationKey() {
        return null;
    }

    public boolean isCreative() {
        return true;
    }

    public void removeMembership(Group group, User user) {
        this.provider.removeMembership(group, user);
    }

    public Pager getMemberNames(Group group) {
        return this.provider.getMemberNames(group);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        return this.provider.getLocalMembers(group);
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        return this.provider.getExternalMembers(group);
    }

    public boolean isReadOnly(Group group) throws EntityException {
        return false;
    }

    public boolean supportsExternalMembership() throws EntityException {
        return true;
    }
}

