/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.atlassian.user.configuration.ConfigurationException;
import com.atlassian.user.configuration.util.InitializationCheck;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.repository.Repository;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class DelegatingListGroupManager
implements GroupManager {
    private static final Logger log = Logger.getLogger(DelegatingListGroupManager.class);
    private List groupManagers;

    public DelegatingListGroupManager(List groupManagers) {
        this.groupManagers = groupManagers;
    }

    public void init(HashMap args) throws ConfigurationException {
        this.groupManagers = (List)args.get("groupManagers");
        InitializationCheck.validateArgs(args, new String[]{"groupNames"}, this);
    }

    protected GroupManager getMatchingGroupManager(Group group) throws EntityException {
        GroupManager groupManager2 = null;
        for (GroupManager groupManager2 : this.groupManagers) {
            Group foundGroup = groupManager2.getGroup(group.getName());
            if (foundGroup == null) continue;
            return groupManager2;
        }
        return groupManager2;
    }

    public Pager getGroups() throws EntityException {
        ArrayList<Pager> groups = new ArrayList<Pager>();
        for (GroupManager groupManager : this.groupManagers) {
            groups.add(groupManager.getGroups());
        }
        return PagerFactory.getPager(groups);
    }

    public Pager getGroups(User user) throws EntityException {
        Pager result = null;
        Iterator iter = this.groupManagers.iterator();
        LinkedList<Pager> pagers = new LinkedList<Pager>();
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            result = groupManager.getGroups(user);
            pagers.add(result);
        }
        return PagerFactory.getPager(pagers);
    }

    public Pager getMemberNames(Group group) throws EntityException {
        Object result = null;
        GroupManager groupManager = this.getManagerForGroup(group);
        if (groupManager == null) {
            return new DefaultPager();
        }
        return groupManager.getMemberNames(group);
    }

    public Pager getLocalMemberNames(Group group) throws EntityException {
        GroupManager groupManager;
        Pager result = null;
        Iterator iter = this.groupManagers.iterator();
        while (iter.hasNext() && (result = (groupManager = (GroupManager)iter.next()).getLocalMemberNames(group)) == null) {
        }
        return result;
    }

    public Pager getExternalMemberNames(Group group) throws EntityException {
        Pager result = null;
        for (GroupManager groupManager : this.groupManagers) {
            if (groupManager.supportsExternalMembership()) {
                result = groupManager.getExternalMemberNames(group);
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    public Group getGroup(String groupName) throws EntityException {
        Iterator iter = this.groupManagers.iterator();
        Group foundGroup = null;
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            foundGroup = groupManager.getGroup(groupName);
            if (foundGroup == null) continue;
            return foundGroup;
        }
        return null;
    }

    public Group createGroup(String groupName) throws EntityException {
        Iterator iter = this.groupManagers.iterator();
        Group createdGroup = null;
        while (iter.hasNext()) {
            GroupManager groupManager = (GroupManager)iter.next();
            if (groupManager.isCreative()) {
                createdGroup = groupManager.createGroup(groupName);
            }
            if (createdGroup == null) continue;
            return createdGroup;
        }
        return null;
    }

    public void removeGroup(Group group) throws EntityException {
        for (GroupManager groupManager : this.groupManagers) {
            if (groupManager.isReadOnly(group) || groupManager.getGroup(group.getName()) == null) continue;
            groupManager.removeGroup(group);
            break;
        }
    }

    public void addMembership(Group group, User user) throws EntityException {
        GroupManager groupManager = this.getMatchingGroupManager(group);
        groupManager.addMembership(group, user);
    }

    public boolean hasMembership(Group group, User user) throws EntityException {
        GroupManager groupManager = this.getMatchingGroupManager(group);
        return groupManager.hasMembership(group, user);
    }

    public void removeMembership(Group group, User user) throws EntityException {
        GroupManager groupManager = this.getMatchingGroupManager(group);
        groupManager.removeMembership(group, user);
    }

    public boolean supportsExternalMembership() throws EntityException {
        for (GroupManager groupManager : this.groupManagers) {
            if (!groupManager.supportsExternalMembership()) continue;
            return true;
        }
        return false;
    }

    public boolean isReadOnly(Group group) throws EntityException {
        for (GroupManager groupManager : this.groupManagers) {
            if (groupManager.getGroup(group.getName()) == null) continue;
            return groupManager.isReadOnly(group);
        }
        return false;
    }

    public Repository getRepository() {
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (GroupManager groupManager : this.groupManagers) {
            Repository repo = groupManager.getRepository();
            repositories.add(repo);
        }
        return new DelegatingRepository(repositories);
    }

    public Repository getRepository(Entity entity) throws EntityException {
        if (!(entity instanceof Group)) {
            return null;
        }
        GroupManager groupManager = this.getMatchingGroupManager((Group)entity);
        return groupManager.getRepository();
    }

    public boolean isCreative() {
        for (GroupManager groupManager : this.groupManagers) {
            if (!groupManager.isCreative()) continue;
            return true;
        }
        return false;
    }

    private GroupManager getManagerForGroup(Group group) throws EntityException {
        for (GroupManager groupManager : this.groupManagers) {
            if (groupManager.getGroup(group.getName()) == null) continue;
            return groupManager;
        }
        return null;
    }
}

