<html>
<head>
    <title>Two Factor Configuration</title>
    <meta name="decorator" content="atl.general">

    <script>
        <#include "*/js/configure.js">;
    </script>

    <style>
        <#include "*/css/configure.css">;
    </style>
</head>

<body>
<#include "*/header.ftl" parse=true>
<#include "*/mobileAuthenticator.ftl" parse=true>
<#include "*/otpOverSmsSettings.ftl" parse=true>
<#include "*/otpOverEmailSettings.ftl" parse=true>
<#include "*/duoPushNotificationSettings.ftl" parse=true>
<#include "*/webAuthnSettings.ftl" parse=true>

<#assign backupCode =  pluginConfiguration.getBaseUrl() + "/download/resources/com.miniorange.twofactor.crowd-twofactor:crowd-twofactor-img-resource/BackupCode.png">
<#assign googleAuthenticator =  pluginConfiguration.getBaseUrl() + "/download/resources/com.miniorange.twofactor.crowd-twofactor:crowd-twofactor-img-resource/googleAuthenticator.png">
<#assign hardwareToken =  pluginConfiguration.getBaseUrl() + "/download/resources/com.miniorange.twofactor.crowd-twofactor:crowd-twofactor-img-resource/HardwareToken.png">
<#assign otpOverEmail =  pluginConfiguration.getBaseUrl() + "/download/resources/com.miniorange.twofactor.crowd-twofactor:crowd-twofactor-img-resource/OtpOverEmail.png">
<#assign otpOverSms =  pluginConfiguration.getBaseUrl() + "/download/resources/com.miniorange.twofactor.crowd-twofactor:crowd-twofactor-img-resource/OtpOverSms.png">
<#assign pushNotification =  pluginConfiguration.getBaseUrl() + "/download/resources/com.miniorange.twofactor.crowd-twofactor:crowd-twofactor-img-resource/PushNotification.png">
<#assign securityQuestion =  pluginConfiguration.getBaseUrl() + "/download/resources/com.miniorange.twofactor.crowd-twofactor:crowd-twofactor-img-resource/SecurityQuestion.png">
<#assign webAuthentication =  pluginConfiguration.getBaseUrl() + "/download/resources/com.miniorange.twofactor.crowd-twofactor:crowd-twofactor-img-resource/webAuthentication.png">


<div class="tabs-pane active-pane mo-aui-page-panel-content" id="settings"  role="tabpanel" >
    <#if pageAccessType.equals("read")>
        <div class="aui-message aui-message-warning" style="margin-top: 8px;">
            <p class="title">
                <strong>Warning!</strong>
            </p>
            <p>You only have read access of this page, no configuration will be saved!</p>
        </div>
    </#if>
    <h2>
        Basic Configurations
    </h2>
    <hr class="header"/>
    <br>
    <div class="field-group" style="padding-left: 145px;">
        <#include "*/welcomePrompt.ftl" parse=true>
    </div>

    <input type="hidden" id="isSslSetup" <#if (isSslSetup == true)> value="true" <#else> value="false" </#if>>
    <div>
        <h2 class="subsection_title">Step 1: Choose 2FA methods for end users</h2>
        <br>
        <div class="description" >
            In this step, you can choose which 2FA methods are available to all your end users and which methods they can setup as backup methods.<br>
            To explore the advanced settings related to the 2FA methods, click on the settings <span class="aui-icon aui-icon-small aui-iconfont-settings"></span> option available at the top right corner of the card of that specific method.
        </div>
        <br>
    </div>
    <div class="cards_row_1">

        <section class="auth_card">
            <div class="top_sec">
                <h2 id="GoogleAuthenticatorHeading">Mobile Authenticator
                </h2>
                <span id="mobileAuthenticatorId" class="aui-icon aui-icon-large aui-iconfont-settings" onclick="displaySettings('mobileAuthenticatorDivId')" style="float:right; cursor: pointer;">
                    </span>
            </div>
            <span class="desc_sec">
                    <div class="card_icon">
                          <img src="${googleAuthenticator}" id="imgGoogleAuthenticator" width="90px">
                    </div>
                    <div class="card_desc">User needs to enter 6 digit passcode generated by Mobile Authenticator app.

                    </div>
                </span>

            <div class="bottom_sec">
                <div class="main-toggle-div">
                    <input class="input-checkbox" type="checkbox" id="idGoogleAuthenticator" value="true" name="idGoogleAuthenticator" label="Enable GoogleAuthenticator"
                           onchange="saveToggleButton(this.id)" ${(twoFactorForMobileAuthn == true)?then('checked="true"', '')}  />
                    <label for="idGoogleAuthenticator" class="toggle">
                        <div class="checkmark"></div>
                        <div class="cross-div"><div class="cross cross-left"></div><div class="cross cross-right"></div></div>
                    </label>
                </div>
                <div class="radio_buttons">
                    <input class="radio" type="radio" name="mobileAuthnFilter" id="idGoogleAuthenticatorMain"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForMobileAuthn != true)?then('disabled','')}
                            ${(twoFactorMethodForUserList.contains("GoogleAuthenticator"))?then('checked="true"', '')}
                           value="main" resolved="" style="box-shadow: none;"> 2FA Method
                    <input class="radio" type="radio" name="mobileAuthnFilter" id="idGoogleAuthenticatorBackup"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForMobileAuthn != true)?then('disabled','')}
                            ${(backupMethodForUserList.contains("GoogleAuthenticator"))?then('checked="true"', '')}
                           value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                </div>
            </div>

        </section>
        <section class="auth_card">
            <div class="top_sec">
                <h2 id="YubikeyHardwareTokenAsU2FHeading">Yubikey Hardware Token
                </h2>
            </div>
            <span class="desc_sec">
                    <div class="card_icon">
                       <img src="${hardwareToken}" id="imgHardwareToken" width="90px">
                    </div>
                    <div class="card_desc">User needs to insert a security key & touch it.

                    </div>
                </span>

            <div class="bottom_sec">
                <div id="yubikeytoggleParentId" <#if (isSslSetup == false)> class="for-toolTip"  data-tooltip="SSL is not setup on your Crowd instance.
                        So you will not be able to setup Yubikey Hardware Token." </#if>>
                    <div class="main-toggle-div">
                        <input class="input-checkbox" type="checkbox" id="idYubikeyHardwareTokenAsU2F" value="true" label="Enable YubikeyHardwareTokenAsU2F"
                               onchange="saveToggleButton(this.id)" name="twoFactorForYubikey"
                                ${(isSslSetup == false || twoFactorForWebAuthn == true )?then('disabled', '')}
                                ${(twoFactorForYubikey == true)?then('checked="true"', '')}>
                        <label for="idYubikeyHardwareTokenAsU2F" class="toggle">
                            <div class="checkmark"></div>
                            <div class="cross-div"><div class="cross cross-left"></div><div class="cross cross-right"></div></div>
                        </label>
                    </div>
                </div>
                <div class="radio_buttons">
                    <input class="radio" type="radio" name="HardwareTokenFilter" id="idYubikeyHardwareTokenAsU2FMain"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForYubikey != true)?then('disabled', '')}
                            ${(twoFactorMethodForUserList.contains("YubikeyHardwareTokenAsU2F"))?then('checked="true"', '')}
                           value="main" resolved="" style="box-shadow: none;"> 2FA Method
                    <input class="radio" type="radio" name="HardwareTokenFilter" id="idYubikeyHardwareTokenAsU2FBackup"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForYubikey != true)?then('disabled', '')}
                            ${(backupMethodForUserList.contains("YubikeyHardwareTokenAsU2F"))?then('checked="true"', '')}
                           value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                </div>
            </div>

        </section>
        <section class="auth_card">
            <div class="top_sec">
                <h2 id="DuoPushNotificationHeading">Duo Push Notification
                </h2>
                <span id="DuoPushNotificationIcon" class="aui-icon aui-icon-large aui-iconfont-settings" style="float:right;cursor: pointer;"
                      onclick="displaySettings('duoPushNotificationDivId')">
                    </span>
            </div>
            <span class="desc_sec">
                    <div class="card_icon">
                          <img src="${pushNotification}" id="imgPushNotification" width="90px">
                    </div>
                    <div class="card_desc"> User will receive a notification on his/her mobile which they can APPROVE or DENY.
                    </div>
                </span>

            <div class="bottom_sec">
                <div <#if (duoPushNotificationSettingsConfigured == false)> class="for-toolTip"  data-tooltip="Push Notification configuration details are not yet configured." </#if>>
                    <div class="main-toggle-div">
                        <input class="input-checkbox" type="checkbox" id="idDuoPushNotification" value="true" label="Enable DuoPushNotification" onchange="saveToggleButton(this.id)"
                                ${(duoPushNotificationSettingsConfigured == false)?then('disabled', '')}
                               name="twoFactorForDuopush"
                                ${(twoFactorForDuopush == true)?then('checked="true"', '')}  >
                        <label for="idDuoPushNotification" class="toggle" id="DuoPushNotification" <#if (duoPushNotificationSettingsConfigured == false)> onmouseover="hoverIn(this.id)" onmouseout="hoverOut(this.id)" </#if>>
                            <div class="checkmark"></div>
                            <div class="cross-div"><div class="cross cross-left"></div><div class="cross cross-right"></div></div>
                        </label>
                    </div>
                </div>
                <div class="radio_buttons">
                    <input class="radio" type="radio"  name="PushNotificationFilter" id="idDuoPushNotificationMain"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForDuopush != true)?then('disabled', '')}
                            ${(twoFactorMethodForUserList.contains("DuoPushNotification"))?then('checked="true"', '')}
                           value="main" resolved="" style="box-shadow: none;"> 2FA Method
                    <input class="radio" type="radio" name="PushNotificationFilter" id="idDuoPushNotificationBackup"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForDuopush != true)?then('disabled', '')}
                            ${(backupMethodForUserList.contains("DuoPushNotification"))?then('checked="true"', '')}
                           value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                </div>
            </div>

        </section>
    </div>
    <div class="cards_row_1">

        <section class="auth_card">
            <div class="top_sec">
                <h2 id="WebAuthnHeading">Web Authentication
                </h2>
                <span id="idWebAuthnIcon" class="aui-icon aui-icon-large aui-iconfont-settings" style="float:right;cursor: pointer;"
                      onclick="displaySettings('webAuthnSettingsDivId')">
                    </span>
            </div>
            <span class="desc_sec">
                    <div class="card_icon">
                          <img src="${webAuthentication}" id="imgWebAuthn" width="90px">
                    </div>
                    <div class="card_desc">User can use the system's built-in authentication methods.

                    </div>
                </span>

            <div class="bottom_sec">
                <div id="webAuthntoggleParentId" <#if (isSslSetup == false)> class="for-toolTip"  data-tooltip="SSL is not setup on your crowd instance. So you will not be able to setup Web Authentication." </#if>>
                    <div class="main-toggle-div">
                        <input class="input-checkbox" type="checkbox" id="idWebAuthn" value="true" label="Enable WebAuthn" onchange="saveToggleButton(this.id)"
                                ${(isSslSetup == false || twoFactorForYubikey == true )?then('disabled', '')}
                               name="twoFactorForWebAuthn"
                                ${(twoFactorForWebAuthn == true)?then('checked="true"', '')}>
                        <label for="idWebAuthn" class="toggle">
                            <div class="checkmark"></div>
                            <div class="cross-div"><div class="cross cross-left"></div><div class="cross cross-right"></div></div>
                        </label>
                    </div>
                </div>
                <div class="radio_buttons">
                    <input class="radio" type="radio" name="WebAuthnFilter" id="idWebAuthnMain"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForWebAuthn != true)?then('disabled', '')}
                            ${(twoFactorMethodForUserList.contains("WebAuthn"))?then('checked="true"', '')}
                           value="main" resolved="" style="box-shadow: none;"> 2FA Method
                    <input class="radio" type="radio" name="WebAuthnFilter" id="idWebAuthnBackup"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForWebAuthn != true)?then('disabled', '')}
                            ${(backupMethodForUserList.contains("WebAuthn"))?then('checked="true"', '')}
                           value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                </div>
            </div>

        </section>
        <section class="auth_card">
            <div class="top_sec">
                <h2 id="OtpOverEmailHeading">OTP Over Email
                </h2>
                <span id="OtpOverEmailIcon" class="aui-icon aui-icon-large aui-iconfont-settings" style="float:right;cursor: pointer;"
                      onclick="displaySettings('otpOverEmailSettingsDivId')" >
                    </span>
            </div>
            <span class="desc_sec">
                <div class="card_icon">
                   <img src="${otpOverEmail}" id="imgOtpOverEmail" width="90px">
                </div>
                <div class="card_desc">User needs to enter the OTP received on the email.

                </div>
            </span>

            <div class="bottom_sec">
                <div <#if (smtpConfigured == false)> class="for-toolTip"  data-tooltip=" As Crowd's mail server is not configured yet. So won't be able to enable OTP Over Email as a 2FA method." </#if>>
                    <div class="main-toggle-div">
                        <input class="input-checkbox" type="checkbox" id="idOtpOverEmail" value="true" label="Enable OtpOverEmail" onchange="saveToggleButton(this.id)"
                                <#if (smtpConfigured == false)> disabled </#if>
                               name="twoFactorForOtpOverEmail" <#if (twoFactorForOtpOverEmail == true)> checked="true" </#if>>
                        <label for="idOtpOverEmail" class="toggle" id="OtpOverEmail" <#if (smtpConfigured == false)> onmouseover="hoverIn(this.id)" onmouseout="hoverOut(this.id)" </#if>>
                            <div class="checkmark"></div>
                            <div class="cross-div"><div class="cross cross-left"></div><div class="cross cross-right"></div></div>
                        </label>
                    </div>
                </div>
                <div class="radio_buttons">
                    <input class="radio" type="radio" name="OtpOverEmailFilter" id="idOtpOverEmailMain"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForOtpOverEmail != true)?then('disabled', '')}
                            ${(twoFactorMethodForUserList.contains("OtpOverEmail"))?then('checked="true"', '')}
                           value="main" resolved="" style="box-shadow: none;"> 2FA Method
                    <input class="radio" type="radio" name="OtpOverEmailFilter" id="idOtpOverEmailBackup"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForOtpOverEmail != true)?then('disabled', '')}
                            ${(backupMethodForUserList.contains("OtpOverEmail"))?then('checked="true"', '')}
                           value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                </div>
            </div>

        </section>
        <section class="auth_card">
            <div class="top_sec">
                <h2 id="OtpOverSmsHeading">OTP Over SMS
                </h2>
                <span id="OtpOverSmsIcon" class="aui-icon aui-icon-large aui-iconfont-settings" style="float:right;cursor: pointer;"
                      onclick="displaySettings('otpOverSmsSettingsDivId')">
                    </span>
            </div>
            <span class="desc_sec">
                <div class="card_icon">
                      <img src="${otpOverSms}" id="imgOtpOverSms" width="90px">
                </div>
                <div class="card_desc">User needs to enter the OTP received via SMS on his/her mobile.
                </div>
            </span>

            <div class="bottom_sec">
                <div <#if (smsGatewayConfigured == false)> class="for-toolTip"  data-tooltip="SMS Gateway is not configured yet. So you won't be able to enable OTP Over SMS as 2FA method." </#if>>
                    <div class="main-toggle-div">
                        <input class="input-checkbox" type="checkbox" id="idOtpOverSms" value="true" label="Enable OtpOverSms" name="twoFactorForOtpOverSms" onchange="saveToggleButton(this.id)"
                                ${(smsGatewayConfigured == false)?then('disabled', '')}
                                ${(twoFactorForOtpOverSms == true)?then('checked="true"', '')}>
                        <label for="idOtpOverSms" class="toggle" id="OtpOverSms" <#if (smsGatewayConfigured == false)> onmouseover="hoverIn(this.id)" onmouseout="hoverOut(this.id)" </#if>>
                            <div class="checkmark"></div>
                            <div class="cross-div"><div class="cross cross-left"></div><div class="cross cross-right"></div></div>
                        </label>
                    </div>
                </div>
                <div class="radio_buttons">
                    <input class="radio" type="radio" name="OtpOverSmsFilter" id="idOtpOverSmsMain"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForOtpOverSms != true)?then('disabled', '')}
                            ${(twoFactorMethodForUserList.contains("OtpOverSms"))?then('checked="true"', '')}
                           value="main" resolved="" style="box-shadow: none;"> 2FA Method
                    <input class="radio" type="radio" name="OtpOverSmsFilter" id="idOtpOverSmsBackup"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForOtpOverSms != true)?then('disabled', '')}
                            ${(backupMethodForUserList.contains("OtpOverSms"))?then('checked="true"', '')}
                           value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                </div>
            </div>

        </section>
    </div>

    <div class="cards_row_1">

        <section class="auth_card">
            <div class="top_sec">
                <h2 id="SecurityQuestionHeading">Security Question
                </h2>
                <#if (isAdmin)>
                    <span class="aui-icon aui-icon-large aui-iconfont-settings" style="float:right; cursor: pointer;" onclick="redirectTo('securityQuestionTemplateDiv')"></span>
                </#if>
            </div>
            <span class="desc_sec">
                <div class="card_icon">
                      <img src="${securityQuestion}" id="imgSecurityQuestion" width="90px">
                </div>
                <div class="card_desc">User needs to answer the security questions to access Crowd.

                </div>
            </span>

            <div class="bottom_sec">
                <div class="main-toggle-div">
                    <input class="input-checkbox" type="checkbox" id="idSecurityQuestion" value="true" label="Enable SecurityQuestion" onchange="saveToggleButton(this.id)" name="twoFactorForsecurityQuestion" <#if (twoFactorForsecurityQuestion == true)> checked="true" </#if>>
                    <label for="idSecurityQuestion" class="toggle">
                        <div class="checkmark"></div>
                        <div class="cross-div"><div class="cross cross-left"></div><div class="cross cross-right"></div></div>
                    </label>
                </div>
                <div class="radio_buttons">
                    <input class="radio" type="radio" name="securityQuestionFilter" id="idSecurityQuestionMain"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForsecurityQuestion != true)?then('disabled','')}
                            ${(twoFactorMethodForUserList.contains("SecurityQuestion"))?then('checked="true"', 'false')}
                           value="main" resolved="" style="box-shadow: none;"> 2FA Method
                    <input class="radio" type="radio" name="securityQuestionFilter" id="idSecurityQuestionBackup"
                           onclick="saveRadioButton(this.id)"
                            ${(twoFactorForsecurityQuestion != true)?then('disabled','')}
                            ${(backupMethodForUserList.contains("SecurityQuestion"))?then('checked="true"', 'false')}
                           value="Backup" resolved="" style="box-shadow: none;"> Backup Method
                </div>
            </div>
        </section>
        <section class="auth_card">
            <div class="top_sec">
                <h2 id="BackupCodeHeading">Backup Code
                </h2>
            </div>
            <span class="desc_sec">
                <div class="card_icon">
                   <img src="${backupCode}" id="imgBackupCode" width="90px">
                </div>
                <div class="card_desc">User needs to provide the Backup Code to access Crowd.

                </div>
            </span>

            <div class="bottom_sec">
                <div class="main-toggle-div">
                    <input class="input-checkbox" type="checkbox" id="idBackupCode" value="true" label="Backup Code" name="twoFactorForBackup" onchange="saveToggleButton(this.id)" <#if (twoFactorForBackup==true)> checked="true" </#if>>
                    <label for="idBackupCode" class="toggle">
                        <div class="checkmark"></div>
                        <div class="cross-div"><div class="cross cross-left"></div><div class="cross cross-right"></div></div>
                    </label>
                </div>
                <div class="radio_buttons">
                    <input class="radio" type="radio" name="BackupCodeFilter" id="idBackupCodeBackup"
                            ${(twoFactorForBackup != true)?then('disabled', '')}
                            ${(backupMethodForUserList.contains("BackupCode"))?then('checked="true"', '')}
                           value="Backup" resolved="" style="box-shadow: none;"> Backup Method

                </div>
            </div>

        </section>
    </div>

    <br><br>
    <div id="methodsForUser">
        <div>
            <h2 class="subsection_title">Step 2: Select users to enforce 2FA</h2>
            <div class="description" style="margin-top:5px;">
                In this step, you can choose the users who will be asked to verify 2FA after they login.
            </div>
        </div>
        <br>
        <div class="field-group" >
            <div class="main-toggle-div">
                <input class="input-checkbox" type="checkbox" id="enable2FAForAllUsers" value="true" label="Enable 2FA For All Users" onclick="confirmEnableOrDisable2FAForAllUsers()" name="enable2FAForAllUsers"
                        ${(enable2FAForAllUsers==true)?then('checked="true"', '')}>
                <#--                <span style="height:16px; width: 16px">&nbsp;-->
                <label for="enable2FAForAllUsers" class="toggle">
                    <div class="checkmark"></div>
                    <div class="cross-div"><div class="cross cross-left"></div><div class="cross cross-right"></div></div>
                </label>
            </div>
            &nbsp;
            <b>2FA/MFA for All users (Existing + Newly created)</b>
            <#--            </span>-->
            <div class="description" style="padding-left: 74px;margin-top:5px;">
                You can use this option to enable 2FA for all the existing users.
                <br>If this option is enabled then 2FA will get automatically enabled for all newly created users as well.
            </div>
        </div>
        <br>
        <div class="field-group" >

            <div class="aui-message aui-message-info" style="background-color: #deebff; border-color: #deebff">
                <input id="infoForCommonConfigurations" type="checkbox" class="panel">
                <label for="infoForCommonConfigurations" style="margin-top: -11px;" class="panel-title" onclick="openCloseElemenet('openclosearrorw')">
                    <div class="arrow" id="openclosearrorw" name="arrow_rotate" style="margin-top: 3px; left: 40px;">➕</div>
                    Not sure how to set up? <b>Click here</b> to check out our commonly used configurations.
                </label>
                <div class="panel-content">
                    <p>
                        Here are some of the commonly used user configurations.
                    </p>
                    <div id="valid-configuration-recommendation" style="margin-top:10px;">
                        <ol>
                            <li>
                                If you want to enforce 2FA for all the users in your organization then just enable the above toggle button.
                            </li>
                            <li>
                                If you want that 2FA should only be asked to some specific users or users of some specific groups then use the settings provided in <#if (isAdmin == true)>  <a onclick="redirectTo('usermanagement')"  style="cursor: pointer;"><b>User Management tab</b></a> <#else> <b>User Management tab</b> </#if>  .
                                <br>You can enable/disable 2FA for users/groups both individually and in bulk.
                            </li>
                            <li>
                                If you want to enforce 2FA verification to all users except some users (for eg: admins) then,
                                <br>enable the above toggle and then add the admin group(s) to <#if (isAdmin == true)> <a onclick="redirectTo('excludeGroups')" style="cursor: pointer;"><b>Skip 2FA for Groups</b></a>  <#else> <b>Skip 2FA for Groups</b> </#if> feature in User Management tab.
                            </li>
                            <li>
                                If you want to skip 2FA verification of users coming from some trusted IPs then use IP whitelisting feature in <#if (isAdmin == true)> <a onclick="redirectTo('IpRestriction')" style="cursor: pointer;"><b>IP Restrictions</b></a> <#else> <b>IP Restrictions</b> </#if>.
                            </li>
                            <li>
                                If you have multiple Atlassian applications connected via Crowd and want your users to perform 2FA only once on any one application and skip it on the rest then enable <#if (isAdmin == true)> <a onclick="redirectTo('oneTime2FAInCrowdAuthenticationSetup')" style="cursor: pointer;"><b>One-time 2FA validation in Crowd authentication setups</b></a> <#else> <b>One-time 2FA validation in Crowd authentication setups</b> </#if> feature.
                            </li>
                        </ol>
                        <p>
                            If you have some other requirement then please reach out to us <a href="https://miniorange.atlassian.net/servicedesk/customer/portal/2/group/6" target="_blank"><b>here</b></a> and we can assist you in configuring the plugin.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <br><br>
    <div id="enableTwoFactorForDiv">
        <div>
            <h2 class="subsection_title">Step 3: Enable 2FA</h2>
        </div>
        <br>
        <div class="field-group" >
            <table style="width: 100%;">
                <tbody>
                <tr>
                    <td>
                        <div class="main-toggle-div">
                            <input class="input-checkbox" type="checkbox" id="enableTwoFactor" value="true" label="Enable 2fa for Crowd" name="enableTwoFactor" onclick="confirmEnableOrDisable2FAForSoftware()"
                                    ${(enableTwoFactor==true)?then('checked="true"', '')}>
                            <label for="enableTwoFactor" class="toggle">
                                <div class="checkmark"></div>
                                <div class="cross-div"><div class="cross cross-left"></div><div class="cross cross-right"></div></div>
                            </label>
                        </div>
                        <span style="height:16px; width: 16px">&nbsp;
                                    2FA for Crowd
                                </span>
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </div>
    <br><br>
    <div class="setupForMe">
        <h2>Setup 2FA for my account</h2>
        <div class="description" style="margin-top:5px;">
            You can try configuring different 2FA methods for your own account (${adminEmail}) from <a onclick="redirectTo('twofactor/configure2fabyuser')" style="cursor: pointer;"><b>here</b></a>.
        </div>
    </div>

</div>
</div>
</section>
</div>
</div>
</body>
</html>