<html>
    <head>
        <title>Two Factor Configuration</title>
        <meta name="decorator" content="atl.general">

        <script>
            <#include "*/js/adaptiveauthentication.js">;
            function showIPAddress() {
                require('aui/flag')({
                    title: 'Two Factor Authentication',
                    type: 'info',
                    body: '<p>Your Current IP Address is <strong>${currentIPAddress}</strong></p>'
                });
            }
        </script>

        <style>
            <#include "*/css/adaptiveauthentication.css">;
        </style>
	</head>

	<body>
    <#include "*/header.ftl" parse=true>
    <div class="tabs-pane active-pane mo-aui-page-panel-content" id="settings"  role="tabpanel" >
        <#if pageAccessType.equals("read")>
            <div class="aui-message aui-message-warning" style="margin-top: 8px;">
                <p class="title">
                    <strong>Warning!</strong>
                </p>
                <p>You only have read access of this page, no configuration will be saved!</p>
            </div>
        </#if>
        <h2>IP Restrictions</h2>
        <div id="configuration">
            <nav class="aui-navgroup aui-navgroup-horizontal" id="min_topmenu">
                <div class="aui-navgroup-inner">
                    <div id="navbar" class="aui-navgroup-primary">
                        <div class="tab tab-config">
                            <ul class="aui-nav">
                                <li>
                                    <#if ipManagementSelectedAction == "WhitelistIpAction">
                                        <a class="tablinks active" onclick="performActionChange('WhitelistIpAction')">IP Whitelisting</a>
                                    <#else>
                                        <a class="tablinks" onclick="performActionChange('WhitelistIpAction')">IP Whitelisting</a>
                                    </#if>
                                </li>
                                <li>
                                    <#if ipManagementSelectedAction == "BlacklistIpAction">
                                    <a class="tablinks active" onclick="performActionChange('BlacklistIpAction')">IP Blocking</a>
                                    <#else>
                                        <a class="tablinks" onclick="performActionChange('BlacklistIpAction')">IP Blocking</a>
                                    </#if>
                                </li>
                            </ul>
                        </div>
                        <div style="position: absolute; right: 0;">
                            <input type="button" value='My IP Address' class="aui-button aui-button-primary" onclick='showIPAddress()'>
                        </div>
                    </div>
                </div>
            </nav>
            <br>

            <#if (ipManagementSelectedAction == "WhitelistIpAction") >
                <div id="ipWhitelistingDiv">
                    <div class="aui-message aui-message-info" style="background:rgb(222,235,255); border-color:rgb(222,235,255);">
                        <p id="whitelist-action-main-inst" >
                            IP whitelisting is a security feature that is often only used for trusted users who can directly log into Crowd without asking for 2FA.</br>
                            If the request comes from the configured IP address then the plugin will consider the user as a Trusted user & it will not ask for the 2FA for that user.
                        </p>
                        <p>
                            <a id="valid-ip-recommendation-link" data-replace-text="Read less" onclick="toggleIpRecommendations()" style="cursor: pointer">Click here to find out which IP address is considered a valid IP address.</a>
                            <a id="read-less" data-replace-text="Read less" onclick="toggleIpRecommendations()" style="cursor: pointer" hidden>Read less</a>
                        </p>
                        <div id="valid-ip-recommendation" hidden>

                            <ol>
                                <li>
                                    It accepts only IPv4 addresses.
                                </li>
                                <li>
                                    You can enter the initials of IP address such as 172.16 or 172.16.254 or 172.16.254.2
                                    So that it allows All IP Addresses which start with 172.16 or 172.16.254
                                </li>
                                <li>
                                    IP address can be entered in CIDR Notation such as 172.16.254.2/24
                                    This will allow All IP Addressess which start with 172.16.254.0 to 172.16.254.255
                                </li>
                                <li>
                                    If you enter other than above format then that IP will be considered as an Invalid Address.
                                </li>
                            </ol>
                        </div>
                    </div>
                    <#if pageAccessType != "" && pageAccessType == "readwrite">
                    <form id="ip-whitelisting-form" class="aui long-label" action="" method="POST">
                        <input type="hidden" name="whiteListIpFormSubmitted" value="true"/>
                        <div class="field-group">
                            <label for="ipAddress">Whitelist IP Address :</label>
                            <input type="text" id="ipAddress" name="ipAddress" value="" placeholder="Enter IP Address" class="text long-field" style="width: 200px">&nbsp;
                            <input type="text" id="ipAddressMessage" name="ipAddressMessage" value="" placeholder="Enter a description" class="text long-field" style="width: 200px">&nbsp;
                            <input type="submit" value="Add" class="aui-button aui-button-primary" resolved="">&nbsp;
                        </div>
                        </br>
                    </form>
                    <form id="RequestedHeader" class="aui long-label" action="" method="POST" Style="margin-top:-2px; margin-bottom:40px">
                        <input type="Hidden" name="ClientRequestedIPHeaderSubmitted" value="true"/>
                        <div class="field-group">
                            <label for="clientIpRequestHeader"> HTTP Request Header Name: </label>

                             <select class="select" id="clientIpRequestHeader" name="clientIpRequestHeader" style="width: 200px">
                                <#foreach iterator in displayRequestHeader.keySet()>
                                    <#if clientIpRequestHeader.equals(iterator)>
                                        <option value="${iterator}"  selected>${iterator}</option>
                                    <#else>
                                        <option value="${iterator}">${iterator}</option>
                                    </#if>
                                </#foreach>
                             </select>
                             &nbsp;
                             <input type="Submit" value="Save" class="aui-button aui-button-primary"/>
                             <span class="aui-icon aui-icon-small aui-iconfont-info-circle" title="This feature will allow you to perform IP restrictions on those IPs using Proxy Servers to access Crowd." style="cursor: pointer;"></span>
                        </div>
                        <div class="description" style="margin-left: 250px;">Enter the name of the header parameter in which the client IP is received in the HTTP Request. </br>
                             Unsure about the header parameter name?
                             <a data-aui-trigger aria-controls="more-details" href="#more-details">
                             Click here
                             </a>
                             <aui-inline-dialog id="more-details" aria-label="dialog" style="width:350px; height:350px; overflow-y:scroll; overflow-x:hidden; overflow-wrap: anywhere;">
                                  <div class="aui-inline-dialog-contents" style="box-shadow: none;">
                                  <#foreach iterator in displayRequestHeader.keySet()>
                                      <p><b>${iterator} :</b> &nbsp; ${displayRequestHeader.get(iterator)}</p>
                                  </#foreach>
                                  </div>
                              </aui-inline-dialog>
                             to view the request.
                        </div>
                    </form>
                    </#if>
                    <form id="ip-blacklisting-form" class="aui long-label" action="" method="POST">
                        <input type="hidden" name="whiteListIpFormSubmitted" value="false"/>
                        <div class ="field-group" style="padding-left: 20px;">
                            <p>
                                <#if pageAccessType != "" && pageAccessType == "readwrite">
                                    Bulk IP Action :&nbsp;
                                    <select class="select" name="bulkIpAction" id="bulkIpAction" class="bulkIpAction" style="width: 155px;">
                                        <option value="">Select Bulk Action</option>
                                        <optgroup label="Selected IPs">
                                            <option value="Delete Selected Whitelist IPs">Delete IPs</option>
                                        </optgroup>
                                        <optgroup label="All IPs">
                                            <option value="Delete All Whitelist IPs">Delete IPs</option>
                                        </optgroup>
                                    </select>&nbsp;
                                    <input type='button' value='Apply' id='perform-action-button' class="aui-button aui-button-primary" onclick="return performBulkIpAction()"/>&nbsp;
                                    <button type="submit" style="height:30px; border:aliceblue; float:right; width:30px;"> <span class="aui-icon aui-icon-small aui-iconfont-search"></span></button>
                                    <input type="text"  id="whiteListIpSearchKeyword" name="whiteListIpSearchKeyword" value="${whiteListIpSearchKeyword}"
                                     placeholder="Search IP Address" class="text long-field" style="width: 200px; float:right;"/>&nbsp;&nbsp;
                                <#else>
                                    <button type="submit" style="height:30px; border:aliceblue; float:right; width:30px; margin-top: -10px;"> <span class="aui-icon aui-icon-small aui-iconfont-search"></span></button>
                                    <input type="text"  id="whiteListIpSearchKeyword" name="whiteListIpSearchKeyword" value="${whiteListIpSearchKeyword}"
                                     placeholder="Search IP Address" class="text long-field" style="width: 200px; float:right;margin-top: -10px;"/>&nbsp;&nbsp;
                                </#if>
                            </p>
                            <#if (currentPageWhiteListIpAddressWithMessagesMap.size() > 0)>
                                <hr class="header"/>
                                <table class="aui">
                                    <thead>
                                        <tr>
                                            <th id="number">
                                                <input type="checkbox" value="true" name="selectAllWhitelistIps" id="selectAllWhitelistIps" onclick="return toggleAllWhitelistIps()"/> &nbsp;
                                                #
                                            </th>
                                            <th id="whitelistIpAddress">IP Address</th>
                                            <th id="whitelistIpAddressComment">IP Comment</th>
                                            <#if pageAccessType != "" && pageAccessType == "readwrite">
                                                <th id="action">Action</th>
                                            </#if>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <input type="hidden" value="${startIndex}" id="startIndex"/>
                                        <#assign loopCount = startIndex>
                                        <#foreach whitelistIp in currentPageWhiteListIpAddressWithMessagesMap.keySet()>
                                            <#assign trId = "trwhitelist"+loopCount>
                                            <tr id="${trId}">
                                                <td headers="number">
                                                    <#assign selectedWhitelistIp = "selectedWhitelistIp"+loopCount>
                                                    <input type="checkbox" value="${whitelistIp}" name="selectedWhitelistIp" id="${selectedWhitelistIp}"/> &nbsp;
                                                    ${loopCount}
                                                </td>

                                                <td headers="whitelistIpAddress">${whitelistIp}</td>
                                                 <td headers="whiteListIpComment">${currentPageWhiteListIpAddressWithMessagesMap.get(whitelistIp)}</td>
                                                 <#if pageAccessType != "" && pageAccessType == "readwrite">
                                                    <td headers="action">
                                                        <p>
                                                            <span>
                                                                <a onclick="return removeWhitelistIp('${whitelistIp}')">Remove</a>
                                                            </span>
                                                        </p>
                                                    </td>
                                                </#if>
                                            </tr>
                                            <#assign loopCount = loopCount + 1>
                                        </#foreach>
                                        <input type="hidden" value="${loopCount}" id="endIndex"/>
                                    </tbody>
                                </table>
                                </br>
                                <table style="width:100%">
                                    <tr>
                                        <td style="width: 78%;">
                                            <p>Displaying IPs <strong>${startIndex}</strong> to
                                            <#if (whitelistIpAddressWithMessagesMap.size() < endIndex)>
                                                <strong>${whitelistIpAddressWithMessagesMap.size()}</strong>
                                            <#else>
                                                <strong>${endIndex}</strong>
                                            </#if>
                                            of <strong>${whitelistIpAddressWithMessagesMap.size()}</strong>.</p>
                                        </td>
                                        <td>
                                            <#if (whitelistIpAddressWithMessagesMap.size() > numberOfRecordsPerPage)>
                                                <ol class="aui-nav aui-nav-pagination">
                                                    <#if (selectedPage != 1)>
                                                        <#assign prevStartIndex = startIndex - numberOfRecordsPerPage>
                                                        <#assign prevEndIndex = endIndex - numberOfRecordsPerPage>
                                                        <li class="aui-nav-previous"><a href="adaptiveauthentication.action?startIndex=${prevStartIndex}&endIndex=${prevEndIndex}&whiteListIpSearchKeywordUrl=${whiteListIpSearchKeyword}">&lt;&lt; Prev</a></li>
                                                    </#if>

                                                    <#assign loopCount = 1>

                                                    <#foreach currentPage in numberOfPagesList>
                                                        <#assign currentPageEndIndex = loopCount * numberOfRecordsPerPage>
                                                        <#assign currentPageStartIndex = currentPageEndIndex - numberOfRecordsPerPage + 1>
                                                        <#if (selectedPage == loopCount)>
                                                            <li class="aui-nav-selected">${loopCount}</li>
                                                        <#else>
                                                            <li><a href="adaptiveauthentication.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&whiteListIpSearchKeywordUrl=${whiteListIpSearchKeyword}">${loopCount}</a></li>
                                                        </#if>
                                                        <#assign loopCount = loopCount + 1>
                                                    </#foreach>

                                                    <#if (selectedPage != numberOfPagesList.size())>
                                                        <#assign nextStartIndex = startIndex + numberOfRecordsPerPage>
                                                        <#assign nextEndIndex = endIndex + numberOfRecordsPerPage>
                                                        <li class="aui-nav-next"><a href="adaptiveauthentication.action?startIndex=${nextStartIndex}&endIndex=${nextEndIndex}&whiteListIpSearchKeywordUrl=${whiteListIpSearchKeyword}">Next &gt;&gt;</a></li>
                                                    </#if>
                                                </ol>
                                            </#if>
                                        </td>
                                    </tr>
                                </table>
                            <#else>
                            <div class ="field-group" style="padding-left: 0px;">
                                <hr class="header"/>
                                <table class="aui">
                                    <thead>
                                        <tr>
                                            <th id="number">#</th>
                                            <th id="whitelistIpAddress">IP Address</th>
                                            <th id="whiteListIpComment">IP Comment</th>
                                            <th id="action">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td colspan="4">
                                                <p style="width:100%" align="center">
                                                    No Whitelisted IPs found.
                                                </p>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                            </#if>
                        </div>
                    </form>
                </div> <!--End of Whitelist IP Details Div -->
            <#else>
                <div id="ipBlacklistingDiv">
                    <div class="aui-message aui-message-info" style="background:rgb(222,235,255); border-color:rgb(222,235,255);">
                        <p id="blacklist-action-main-inst" >
                            An IP blacklist or block-list is a basic access control mechanism which blocks access to Crowd Application based on the IP address. It will deny access for those IPs which are listed here.</br>
                            If the request comes from the configured IP address then the plugin will consider the IP as a spam & it will never give access to Crowd.
                        </p>
                        <p>
                            <a id="valid-ip-recommendation-link" onclick="toggleIpRecommendations()" style="cursor: pointer">Click here to find out which IP address is considered a valid IP address.</a>
                            <a id="read-less" data-replace-text="Read less" onclick="toggleIpRecommendations()" style="cursor: pointer" hidden>Read less</a>
                        </p>
                        <div id="valid-ip-recommendation" hidden>

                            <ol>
                                <li>
                                    It accepts only IPv4 addresses.
                                </li>
                                <li>
                                    You can enter the initials of IP address such as 172.16 or 172.16.254 or 172.16.254.2<br>
                                    So that it blocks All IP Addresses which start with 172.16 or 172.16.254
                                </li>
                                <li>
                                    IP address can be entered in CIDR Notation such as 172.16.254.2/24<br>
                                    This will allow All IP Addressess which start with 172.16.254.0 to 172.16.254.255
                                </li>
                                <li>
                                    If you enter other than above format then that IP will be considered as an Invalid Address.
                                </li>
                            </ol>
                        </div>
                    </div>
                    <#if pageAccessType != "" && pageAccessType == "readwrite">
                        <form id="ip-blacklisting-form" class="aui long-label" action="" method="POST">
                            <input type="hidden" name="blackListIpFormSubmitted" value="true"/>
                            <div class="field-group">
                                <label for="ipAddress">Blacklist IP Address :</label>
                                <input type="text" id="ipAddress" name="ipAddress" value="" placeholder="Enter IP Address" class="text long-field" style="width: 200px">&nbsp;
                                <input type="text" id="ipAddressMessage" name="ipAddressMessage" value="" placeholder="Enter a description" class="text long-field" style="width: 200px">&nbsp;
                                <input type="submit" value="Block" class="aui-button aui-button-primary" resolved="">&nbsp;
                            </div>
                            </br>
                        </form>
                        <form id="RequestedHeader" class="aui long-label" action="" method="POST" Style="margin-top:-2px; margin-bottom:40px">
                            <input type="Hidden" name="ClientRequestedIPHeaderSubmitted" value="true"/>
                            <div class="field-group">
                            <label for="clientIpRequestHeader"> HTTP Request Header Name: </label>
                                 <select class="select" id="clientIpRequestHeader" name="clientIpRequestHeader" style="width: 200px">
                                    <#foreach iterator in displayRequestHeader.keySet()>
                                        <#if clientIpRequestHeader.equals(iterator)>
                                            <option value="${iterator}"  selected>${iterator}</option>
                                        <#else>
                                            <option value="${iterator}">${iterator}</option>
                                        </#if>

                                    </#foreach>
                                 </select>&nbsp;
                                 <input type="Submit" value="Save" class="aui-button aui-button-primary"/>
                                 <span class="aui-icon aui-icon-small aui-iconfont-info-circle" title="This feature will allow you to perform IP restrictions on those IPs using Proxy Servers to access Crowd." style="cursor: pointer;"></span>
                            </div>
                            <div class="description" style="margin-left: 250px;">Enter the name of the header parameter in which the client IP is received in the HTTP Request. </br>
                                Unsure about the header parameter name?
                                <a data-aui-trigger aria-controls="more-details" href="#more-details">
                                    Click here
                                </a>
                                <aui-inline-dialog id="more-details" aria-label="dialog" style="width:350px; height:350px; overflow-y:scroll; overflow-x:hidden; overflow-wrap: anywhere;">
                                     <div class="aui-inline-dialog-contents" style="box-shadow: none;">
                                     <#foreach iterator in displayRequestHeader.keySet()>
                                         <p><b>${iterator} :</b> &nbsp; ${displayRequestHeader.get(iterator)}</p>
                                     </#foreach>
                                     </div>
                                </aui-inline-dialog>
                                to view the request.
                            </div>
                        </form>
                    </#if>
                    <form id="ip-blacklisting-form" class="aui long-label" action="" method="POST">
                        <input type="hidden" name="blackListIpFormSubmitted" value="false"/>
                        <div class ="field-group" style="padding-left: 20px;">
                            <p>
                                <#if pageAccessType != "" && pageAccessType == "readwrite">
                                    <label>Bulk IP Action :&nbsp;</label>
                                    <select class="select" name="bulkIpAction" id="bulkIpAction" class="bulkIpAction" style="width: 155px;">
                                        <option value="">Select Bulk Action</option>
                                        <optgroup label="Selected IPs">
                                            <option value="Delete Selected Blacklist IPs">Delete IPs</option>
                                        </optgroup>
                                        <optgroup label="All IPs">
                                            <option value="Delete All Blacklist IPs">Delete IPs</option>
                                        </optgroup>
                                    </select>&nbsp;
                                    <input type='button' value='Apply' id='perform-action-button' class="aui-button aui-button-primary" onclick="return performBulkIpAction()"/>&nbsp;
                                    <button type="submit" style="height:30px; border:aliceblue; float:right; width:30px;"> <span class="aui-icon aui-icon-small aui-iconfont-search"></span></button>
                                    <input type="text"  id="blackListIpSearchKeyword" name="blackListIpSearchKeyword" value="${blackListIpSearchKeyword}"
                                           placeholder="Search IP Address" class="text long-field" style="width: 200px; float:right"/>&nbsp;&nbsp;
                                <#else>
                                    <button type="submit" style="height:30px; border:aliceblue; float:right; width:30px; margin-top: -10px;"> <span class="aui-icon aui-icon-small aui-iconfont-search"></span></button>
                                    <input type="text"  id="blackListIpSearchKeyword" name="blackListIpSearchKeyword" value="${blackListIpSearchKeyword}"
                                           placeholder="Search IP Address" class="text long-field" style="width: 200px; float:right margin-top: -10px;"/>&nbsp;&nbsp;
                                </#if>
                            </p>
                            <#if (currentPageBlackListIpAddressWithMessagesMap.size() > 0)>
                                <hr class="header"/>
                                <table class="aui">
                                    <thead>
                                        <tr>
                                            <th id="number">
                                                <input type="checkbox" value="true" name="selectAllBlacklistIps" id="selectAllBlacklistIps" onclick="return toggleAllBlacklistIps()"/> &nbsp;
                                                #
                                            </th>
                                            <th id="blacklistIpAddress">IP Address</th>
                                            <th id="blackListIpComment">IP Comment</th>
                                            <#if pageAccessType != "" && pageAccessType == "readwrite">
                                                <th id="action">Action</th>
                                            </#if>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <input type="hidden" value="${startIndex}" id="startIndex"/>
                                        <#assign loopCount = startIndex>
                                        <#foreach blacklistIp in currentPageBlackListIpAddressWithMessagesMap.keySet()>
                                            <#assign trId = "trbacklist"+loopCount>
                                            <tr id="${trId}">
                                                <td headers="number">
                                                    <#assign selectedBlacklistIp = "selectedBlacklistIp"+loopCount>
                                                    <input type="checkbox" value="${blacklistIp}" name="selectedBlacklistIp" id="${selectedBlacklistIp}"/> &nbsp;
                                                    ${loopCount}
                                                </td>
                                                <td headers="blacklistIpAddress">${blacklistIp}</td>
                                                <th id="blackListIpComment">${currentPageBlackListIpAddressWithMessagesMap.get(blacklistIp)}</th>
                                                <#if pageAccessType != "" && pageAccessType == "readwrite">
                                                <td headers="action">
                                                    <p>
                                                        <span>
                                                            <a onclick="return removeBlacklistIp('${blacklistIp}')">Remove</a>
                                                        </span>
                                                    </p>
                                                </td>
                                                </#if>
                                            </tr>
                                            <#assign loopCount = loopCount + 1>
                                        </#foreach>
                                        <input type="hidden" value="${loopCount}" id="endIndex"/>
                                    </tbody>
                                </table>
                                </br>
                                <table style="width:100%">
                                    <tr>
                                        <td style="width: 78%;">
                                            <p>Displaying IPs <strong>${startIndex}</strong> to
                                            <#if (blacklistIpAddressWithMessagesMap.size() < endIndex)>
                                                <strong>${blacklistIpAddressWithMessagesMap.size()}</strong>
                                            <#else>
                                                <strong>${endIndex}</strong>
                                            </#if>
                                            of <strong>${blacklistIpAddressWithMessagesMap.size()}</strong>.</p>
                                        </td>
                                        <td>
                                            <#if (blacklistIpAddressWithMessagesMap.size() > numberOfRecordsPerPage)>
                                                <ol class="aui-nav aui-nav-pagination">
                                                    <#if (selectedPage != 1)>
                                                        <#assign prevStartIndex = startIndex - numberOfRecordsPerPage>
                                                        <#assign prevEndIndex = endIndex - numberOfRecordsPerPage>
                                                        <li class="aui-nav-previous"><a href="adaptiveauthentication.action?startIndex=${prevStartIndex}&endIndex=${prevEndIndex}&blackListIpSearchKeywordUrl=${blackListIpSearchKeyword}">&lt;&lt; Prev</a></li>
                                                    </#if>

                                                    <#assign loopCount = 1>

                                                    <#foreach currentPage in numberOfPagesList>
                                                        <#assign currentPageEndIndex = loopCount * numberOfRecordsPerPage>
                                                        <#assign currentPageStartIndex = currentPageEndIndex - numberOfRecordsPerPage + 1>
                                                        <#if (selectedPage == loopCount)>
                                                            <li class="aui-nav-selected">${loopCount}</li>
                                                        <#else>
                                                            <li><a href="adaptiveauthentication.action?startIndex=${currentPageStartIndex}&endIndex=${currentPageEndIndex}&blackListIpSearchKeywordUrl=${blackListIpSearchKeyword}">${loopCount}</a></li>
                                                        </#if>
                                                        <#assign loopCount = loopCount + 1>
                                                    </#foreach>

                                                    <#if (selectedPage != numberOfPagesList.size())>
                                                        <#assign nextStartIndex = startIndex + numberOfRecordsPerPage>
                                                        <#assign nextEndIndex = endIndex + numberOfRecordsPerPage>
                                                        <li class="aui-nav-next"><a href="adaptiveauthentication.action?startIndex=${nextStartIndex}&endIndex=${nextEndIndex}&blackListIpSearchKeywordUrl=${blackListIpSearchKeyword}">Next &gt;&gt;</a></li>
                                                    </#if>
                                                </ol>
                                            </#if>
                                        </td>
                                    </tr>
                                </table>

                            <#else>
                                <div class ="field-group" style="padding-left: 0px;">
                                    <hr class="header"/>
                                    <table class="aui">
                                        <thead>
                                            <tr>
                                                <th id="number">#</th>
                                                <th id="blacklistIpAddress">IP Address</th>
                                                <th id="blackListIpComment">IP Comment</th>
                                                <th id="action">Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr>
                                                <td colspan="4">
                                                    <p style="width:100%" align="center">
                                                        No Blacklisted IPs found.
                                                    </p>
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </#if>
                        </div>
                    </form>
                </div> <!--End of Blacklist IP Details Div -->
            </#if>
        </div>
    </div>
    </div>
    </section>
    </div>
    </div>
</body>
</html>