/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.x509;

import java.security.NoSuchAlgorithmException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.util.List;
import java.util.Set;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.BasicKeyInfoGeneratorFactory;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoGenerator;
import org.opensaml.xml.security.keyinfo.KeyInfoHelper;
import org.opensaml.xml.security.x509.InternalX500DNHandler;
import org.opensaml.xml.security.x509.X500DNHandler;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.security.x509.X509Util;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.signature.X509Digest;
import org.opensaml.xml.signature.X509SKI;
import org.opensaml.xml.signature.impl.KeyInfoBuilder;
import org.opensaml.xml.signature.impl.X509DataBuilder;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.util.LazySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509KeyInfoGeneratorFactory
extends BasicKeyInfoGeneratorFactory {
    private X509Options options = (X509Options)super.getOptions();

    @Override
    public Class<? extends Credential> getCredentialType() {
        return X509Credential.class;
    }

    @Override
    public boolean handles(Credential credential) {
        return credential instanceof X509Credential;
    }

    @Override
    public KeyInfoGenerator newInstance() {
        X509Options newOptions = this.options.clone();
        return new X509KeyInfoGenerator(newOptions);
    }

    public boolean emitCRLs() {
        return this.options.emitCRLs;
    }

    public void setEmitCRLs(boolean newValue) {
        this.options.emitCRLs = newValue;
    }

    public boolean emitEntityCertificate() {
        return this.options.emitEntityCertificate;
    }

    public void setEmitEntityCertificate(boolean newValue) {
        this.options.emitEntityCertificate = newValue;
    }

    public boolean emitEntityCertificateChain() {
        return this.options.emitEntityCertificateChain;
    }

    public void setEmitEntityCertificateChain(boolean newValue) {
        this.options.emitEntityCertificateChain = newValue;
    }

    public boolean emitSubjectAltNamesAsKeyNames() {
        return this.options.emitSubjectAltNamesAsKeyNames;
    }

    public void setEmitSubjectAltNamesAsKeyNames(boolean newValue) {
        this.options.emitSubjectAltNamesAsKeyNames = newValue;
    }

    public boolean emitSubjectCNAsKeyName() {
        return this.options.emitSubjectCNAsKeyName;
    }

    public void setEmitSubjectCNAsKeyName(boolean newValue) {
        this.options.emitSubjectCNAsKeyName = newValue;
    }

    public boolean emitSubjectDNAsKeyName() {
        return this.options.emitSubjectDNAsKeyName;
    }

    public void setEmitSubjectDNAsKeyName(boolean newValue) {
        this.options.emitSubjectDNAsKeyName = newValue;
    }

    public boolean emitX509IssuerSerial() {
        return this.options.emitX509IssuerSerial;
    }

    public void setEmitX509IssuerSerial(boolean newValue) {
        this.options.emitX509IssuerSerial = newValue;
    }

    public boolean emitX509SKI() {
        return this.options.emitX509SKI;
    }

    public void setEmitX509SKI(boolean newValue) {
        this.options.emitX509SKI = newValue;
    }

    public boolean emitX509Digest() {
        return this.options.emitX509Digest;
    }

    public void setEmitX509Digest(boolean newValue) {
        this.options.emitX509Digest = newValue;
    }

    public String getX509DigestAlgorithmURI() {
        return this.options.x509DigestAlgorithmURI;
    }

    public void setX509DigestAlgorithmURI(String alg) {
        this.options.x509DigestAlgorithmURI = alg;
    }

    public boolean emitX509SubjectName() {
        return this.options.emitX509SubjectName;
    }

    public void setEmitX509SubjectName(boolean newValue) {
        this.options.emitX509SubjectName = newValue;
    }

    public Set<Integer> getSubjectAltNames() {
        return this.options.subjectAltNames;
    }

    public X500DNHandler getX500DNHandler() {
        return this.options.x500DNHandler;
    }

    public void setX500DNHandler(X500DNHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("X500DNHandler may not be null");
        }
        this.options.x500DNHandler = handler;
    }

    public String getX500SubjectDNFormat() {
        return this.options.x500SubjectDNFormat;
    }

    public void setX500SubjectDNFormat(String format) {
        this.options.x500SubjectDNFormat = format;
    }

    public String getX500IssuerDNFormat() {
        return this.options.x500IssuerDNFormat;
    }

    public void setX500IssuerDNFormat(String format) {
        this.options.x500IssuerDNFormat = format;
    }

    @Override
    protected X509Options getOptions() {
        return this.options;
    }

    @Override
    protected X509Options newOptions() {
        return new X509Options();
    }

    protected class X509Options
    extends BasicKeyInfoGeneratorFactory.BasicOptions {
        private boolean emitEntityCertificate;
        private boolean emitEntityCertificateChain;
        private boolean emitCRLs;
        private boolean emitX509SubjectName;
        private boolean emitX509IssuerSerial;
        private boolean emitX509SKI;
        private boolean emitX509Digest;
        private String x509DigestAlgorithmURI = "http://www.w3.org/2001/04/xmlenc#sha256";
        private boolean emitSubjectDNAsKeyName;
        private boolean emitSubjectCNAsKeyName;
        private boolean emitSubjectAltNamesAsKeyNames;
        private Set<Integer> subjectAltNames = new LazySet<Integer>();
        private X500DNHandler x500DNHandler = new InternalX500DNHandler();
        private String x500SubjectDNFormat = "RFC2253";
        private String x500IssuerDNFormat = "RFC2253";

        protected X509Options() {
        }

        @Override
        protected X509Options clone() {
            X509Options clonedOptions = (X509Options)super.clone();
            clonedOptions.subjectAltNames = new LazySet<Integer>();
            clonedOptions.subjectAltNames.addAll(this.subjectAltNames);
            clonedOptions.x500DNHandler = this.x500DNHandler.clone();
            return clonedOptions;
        }
    }

    public class X509KeyInfoGenerator
    extends BasicKeyInfoGeneratorFactory.BasicKeyInfoGenerator {
        private final Logger log;
        private X509Options options;
        private KeyInfoBuilder keyInfoBuilder;
        private X509DataBuilder x509DataBuilder;

        protected X509KeyInfoGenerator(X509Options newOptions) {
            super(newOptions);
            this.log = LoggerFactory.getLogger(X509KeyInfoGenerator.class);
            this.options = newOptions;
            this.keyInfoBuilder = (KeyInfoBuilder)Configuration.getBuilderFactory().getBuilder(KeyInfo.DEFAULT_ELEMENT_NAME);
            this.x509DataBuilder = (X509DataBuilder)Configuration.getBuilderFactory().getBuilder(X509Data.DEFAULT_ELEMENT_NAME);
        }

        @Override
        public KeyInfo generate(Credential credential) throws SecurityException {
            List<XMLObject> keyInfoChildren;
            if (!(credential instanceof X509Credential)) {
                this.log.warn("X509KeyInfoGenerator was passed a credential that was not an instance of X509Credential: {}", (Object)credential.getClass().getName());
                return null;
            }
            X509Credential x509Credential = (X509Credential)credential;
            KeyInfo keyInfo = super.generate(credential);
            if (keyInfo == null) {
                keyInfo = this.keyInfoBuilder.buildObject();
            }
            X509Data x509Data = this.x509DataBuilder.buildObject();
            this.processEntityCertificate(keyInfo, x509Data, x509Credential);
            this.processEntityCertificateChain(keyInfo, x509Data, x509Credential);
            this.processCRLs(keyInfo, x509Data, x509Credential);
            List<XMLObject> x509DataChildren = x509Data.getOrderedChildren();
            if (x509DataChildren != null && x509DataChildren.size() > 0) {
                keyInfo.getX509Datas().add(x509Data);
            }
            if ((keyInfoChildren = keyInfo.getOrderedChildren()) != null && keyInfoChildren.size() > 0) {
                return keyInfo;
            }
            return null;
        }

        protected void processEntityCertificate(KeyInfo keyInfo, X509Data x509Data, X509Credential credential) throws SecurityException {
            if (credential.getEntityCertificate() == null) {
                return;
            }
            java.security.cert.X509Certificate javaCert = credential.getEntityCertificate();
            this.processCertX509DataOptions(x509Data, javaCert);
            this.processCertKeyNameOptions(keyInfo, javaCert);
            if (this.options.emitEntityCertificate && !this.options.emitEntityCertificateChain) {
                try {
                    X509Certificate xmlCert = KeyInfoHelper.buildX509Certificate(javaCert);
                    x509Data.getX509Certificates().add(xmlCert);
                }
                catch (CertificateEncodingException e) {
                    throw new SecurityException("Error generating X509Certificate element from credential's end-entity certificate", e);
                }
            }
        }

        protected void processCertX509DataOptions(X509Data x509Data, java.security.cert.X509Certificate cert) {
            this.processCertX509SubjectName(x509Data, cert);
            this.processCertX509IssuerSerial(x509Data, cert);
            this.processCertX509SKI(x509Data, cert);
            this.processCertX509Digest(x509Data, cert);
        }

        protected void processCertKeyNameOptions(KeyInfo keyInfo, java.security.cert.X509Certificate cert) {
            this.processSubjectDNKeyName(keyInfo, cert);
            this.processSubjectCNKeyName(keyInfo, cert);
            this.processSubjectAltNameKeyNames(keyInfo, cert);
        }

        protected void processCertX509SubjectName(X509Data x509Data, java.security.cert.X509Certificate cert) {
            String subjectNameValue;
            if (this.options.emitX509SubjectName && !DatatypeHelper.isEmpty(subjectNameValue = this.getSubjectName(cert))) {
                x509Data.getX509SubjectNames().add(KeyInfoHelper.buildX509SubjectName(subjectNameValue));
            }
        }

        protected void processCertX509IssuerSerial(X509Data x509Data, java.security.cert.X509Certificate cert) {
            String issuerNameValue;
            if (this.options.emitX509IssuerSerial && !DatatypeHelper.isEmpty(issuerNameValue = this.getIssuerName(cert))) {
                x509Data.getX509IssuerSerials().add(KeyInfoHelper.buildX509IssuerSerial(issuerNameValue, cert.getSerialNumber()));
            }
        }

        protected void processCertX509SKI(X509Data x509Data, java.security.cert.X509Certificate cert) {
            X509SKI xmlSKI;
            if (this.options.emitX509SKI && (xmlSKI = KeyInfoHelper.buildX509SKI(cert)) != null) {
                x509Data.getX509SKIs().add(xmlSKI);
            }
        }

        protected void processCertX509Digest(X509Data x509Data, java.security.cert.X509Certificate cert) {
            if (this.options.emitX509Digest) {
                try {
                    X509Digest xmlDigest = KeyInfoHelper.buildX509Digest(cert, this.options.x509DigestAlgorithmURI);
                    if (xmlDigest != null) {
                        x509Data.getXMLObjects(X509Digest.DEFAULT_ELEMENT_NAME).add(xmlDigest);
                    }
                }
                catch (CertificateEncodingException e) {
                    this.log.error("Can't digest certificate, certificate encoding error", e);
                }
                catch (NoSuchAlgorithmException e) {
                    this.log.error("Can't digest certificate, unsupported digest algorithm", e);
                }
            }
        }

        protected String getSubjectName(java.security.cert.X509Certificate cert) {
            if (cert == null) {
                return null;
            }
            if (!DatatypeHelper.isEmpty(this.options.x500SubjectDNFormat)) {
                return this.options.x500DNHandler.getName(cert.getSubjectX500Principal(), this.options.x500SubjectDNFormat);
            }
            return this.options.x500DNHandler.getName(cert.getSubjectX500Principal());
        }

        protected String getIssuerName(java.security.cert.X509Certificate cert) {
            if (cert == null) {
                return null;
            }
            if (!DatatypeHelper.isEmpty(this.options.x500IssuerDNFormat)) {
                return this.options.x500DNHandler.getName(cert.getIssuerX500Principal(), this.options.x500IssuerDNFormat);
            }
            return this.options.x500DNHandler.getName(cert.getIssuerX500Principal());
        }

        protected void processSubjectDNKeyName(KeyInfo keyInfo, java.security.cert.X509Certificate cert) {
            String subjectNameValue;
            if (this.options.emitSubjectDNAsKeyName && !DatatypeHelper.isEmpty(subjectNameValue = this.getSubjectName(cert))) {
                KeyInfoHelper.addKeyName(keyInfo, subjectNameValue);
            }
        }

        protected void processSubjectCNKeyName(KeyInfo keyInfo, java.security.cert.X509Certificate cert) {
            if (this.options.emitSubjectCNAsKeyName) {
                for (String name : X509Util.getCommonNames(cert.getSubjectX500Principal())) {
                    if (DatatypeHelper.isEmpty(name)) continue;
                    KeyInfoHelper.addKeyName(keyInfo, name);
                }
            }
        }

        protected void processSubjectAltNameKeyNames(KeyInfo keyInfo, java.security.cert.X509Certificate cert) {
            if (this.options.emitSubjectAltNamesAsKeyNames && this.options.subjectAltNames.size() > 0) {
                Integer[] nameTypes = new Integer[this.options.subjectAltNames.size()];
                this.options.subjectAltNames.toArray(nameTypes);
                for (Object altNameValue : X509Util.getAltNames(cert, nameTypes)) {
                    if (altNameValue instanceof String) {
                        KeyInfoHelper.addKeyName(keyInfo, (String)altNameValue);
                        continue;
                    }
                    if (altNameValue instanceof byte[]) {
                        this.log.warn("Certificate contained an alt name value as a DER-encoded byte[] (not supported)");
                        continue;
                    }
                    this.log.warn("Certificate contained an alt name value with an unexpected type: {}", (Object)altNameValue.getClass().getName());
                }
            }
        }

        protected void processEntityCertificateChain(KeyInfo keyInfo, X509Data x509Data, X509Credential credential) throws SecurityException {
            if (this.options.emitEntityCertificateChain && credential.getEntityCertificateChain() != null) {
                for (java.security.cert.X509Certificate javaCert : credential.getEntityCertificateChain()) {
                    try {
                        X509Certificate xmlCert = KeyInfoHelper.buildX509Certificate(javaCert);
                        x509Data.getX509Certificates().add(xmlCert);
                    }
                    catch (CertificateEncodingException e) {
                        throw new SecurityException("Error generating X509Certificate element from a certificate in credential's certificate chain", e);
                    }
                }
            }
        }

        protected void processCRLs(KeyInfo keyInfo, X509Data x509Data, X509Credential credential) throws SecurityException {
            if (this.options.emitCRLs && credential.getCRLs() != null) {
                for (X509CRL javaCRL : credential.getCRLs()) {
                    try {
                        org.opensaml.xml.signature.X509CRL xmlCRL = KeyInfoHelper.buildX509CRL(javaCRL);
                        x509Data.getX509CRLs().add(xmlCRL);
                    }
                    catch (CRLException e) {
                        throw new SecurityException("Error generating X509CRL element from a CRL in credential's CRL list", e);
                    }
                }
            }
        }
    }
}

