/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security.credential.criteria;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.security.Criteria;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.criteria.EvaluableCredentialCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EvaluableCredentialCriteriaRegistry {
    public static final String DEFAULT_MAPPINGS_FILE = "/credential-criteria-registry.properties";
    private static Map<Class<? extends Criteria>, Class<? extends EvaluableCredentialCriteria>> registry;
    private static boolean initialized;

    private EvaluableCredentialCriteriaRegistry() {
    }

    public static EvaluableCredentialCriteria getEvaluator(Criteria criteria) throws SecurityException {
        Logger log = EvaluableCredentialCriteriaRegistry.getLogger();
        Class<? extends EvaluableCredentialCriteria> clazz = EvaluableCredentialCriteriaRegistry.lookup(criteria.getClass());
        if (clazz != null) {
            log.debug("Registry located evaluable criteria class {} for criteria class {}", (Object)clazz.getName(), (Object)criteria.getClass().getName());
            try {
                Constructor<? extends EvaluableCredentialCriteria> constructor = clazz.getConstructor(criteria.getClass());
                return constructor.newInstance(criteria);
            }
            catch (java.lang.SecurityException e) {
                log.error("Error instantiating new EvaluableCredentialCriteria instance", e);
                throw new SecurityException("Could not create new EvaluableCredentialCriteria", e);
            }
            catch (NoSuchMethodException e) {
                log.error("Error instantiating new EvaluableCredentialCriteria instance", e);
                throw new SecurityException("Could not create new EvaluableCredentialCriteria", e);
            }
            catch (IllegalArgumentException e) {
                log.error("Error instantiating new EvaluableCredentialCriteria instance", e);
                throw new SecurityException("Could not create new EvaluableCredentialCriteria", e);
            }
            catch (InstantiationException e) {
                log.error("Error instantiating new EvaluableCredentialCriteria instance", e);
                throw new SecurityException("Could not create new EvaluableCredentialCriteria", e);
            }
            catch (IllegalAccessException e) {
                log.error("Error instantiating new EvaluableCredentialCriteria instance", e);
                throw new SecurityException("Could not create new EvaluableCredentialCriteria", e);
            }
            catch (InvocationTargetException e) {
                log.error("Error instantiating new EvaluableCredentialCriteria instance", e);
                throw new SecurityException("Could not create new EvaluableCredentialCriteria", e);
            }
        }
        log.debug("Registry could not locate evaluable criteria for criteria class {}", (Object)criteria.getClass().getName());
        return null;
    }

    public static synchronized Class<? extends EvaluableCredentialCriteria> lookup(Class<? extends Criteria> clazz) {
        return registry.get(clazz);
    }

    public static synchronized void register(Class<? extends Criteria> criteriaClass, Class<? extends EvaluableCredentialCriteria> evaluableClass) {
        Logger log = EvaluableCredentialCriteriaRegistry.getLogger();
        log.debug("Registering class {} as evaluator for class {}", (Object)evaluableClass.getName(), (Object)criteriaClass.getName());
        registry.put(criteriaClass, evaluableClass);
    }

    public static synchronized void deregister(Class<? extends Criteria> criteriaClass) {
        Logger log = EvaluableCredentialCriteriaRegistry.getLogger();
        log.debug("Deregistering evaluator for class {}", (Object)criteriaClass.getName());
        registry.remove(criteriaClass);
    }

    public static synchronized void clearRegistry() {
        Logger log = EvaluableCredentialCriteriaRegistry.getLogger();
        log.debug("Clearing evaluable criteria registry");
        registry.clear();
    }

    public static synchronized boolean isInitialized() {
        return initialized;
    }

    public static synchronized void init() {
        if (EvaluableCredentialCriteriaRegistry.isInitialized()) {
            return;
        }
        registry = new HashMap<Class<? extends Criteria>, Class<? extends EvaluableCredentialCriteria>>();
        EvaluableCredentialCriteriaRegistry.loadDefaultMappings();
        initialized = true;
    }

    public static synchronized void loadDefaultMappings() {
        Logger log = EvaluableCredentialCriteriaRegistry.getLogger();
        log.debug("Loading default evaluable credential criteria mappings");
        InputStream inStream = EvaluableCredentialCriteriaRegistry.class.getResourceAsStream(DEFAULT_MAPPINGS_FILE);
        if (inStream == null) {
            log.error(String.format("Could not open resource stream from default mappings file '%s'", DEFAULT_MAPPINGS_FILE));
            return;
        }
        Properties defaultMappings = new Properties();
        try {
            defaultMappings.load(inStream);
        }
        catch (IOException e) {
            log.error("Error loading properties file from resource stream", e);
            return;
        }
        EvaluableCredentialCriteriaRegistry.loadMappings(defaultMappings);
    }

    public static synchronized void loadMappings(Properties mappings) {
        Logger log = EvaluableCredentialCriteriaRegistry.getLogger();
        for (Object key : mappings.keySet()) {
            if (!(key instanceof String)) {
                log.error(String.format("Properties key was not an instance of String, was '%s', skipping...", key.getClass().getName()));
                continue;
            }
            String criteriaName = (String)key;
            String evaluatorName = mappings.getProperty(criteriaName);
            ClassLoader classLoader = Configuration.class.getClassLoader();
            Class<?> criteriaClass = null;
            try {
                criteriaClass = classLoader.loadClass(criteriaName);
            }
            catch (ClassNotFoundException e) {
                log.error(String.format("Could not find criteria class name '%s', skipping registration", criteriaName), e);
                return;
            }
            Class<?> evaluableClass = null;
            try {
                evaluableClass = classLoader.loadClass(evaluatorName);
            }
            catch (ClassNotFoundException e) {
                log.error(String.format("Could not find evaluator class name '%s', skipping registration", criteriaName), e);
                return;
            }
            EvaluableCredentialCriteriaRegistry.register(criteriaClass, evaluableClass);
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(EvaluableCredentialCriteriaRegistry.class);
    }

    static {
        EvaluableCredentialCriteriaRegistry.init();
    }
}

